/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.actions.ProjectManagementFileFolders;
import com.zeroio.iteam.base.FileFolderHierarchy;
import com.zeroio.iteam.base.FileFolderList;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;

public final class AccountsDocuments
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        String folderId;
        if (!this.hasPermission(context, "accounts-accounts-documents-view")) {
            return "PermissionError";
        }
        String orgId = context.getRequest().getParameter("orgId");
        if (orgId == null && !"".equals(orgId)) {
            orgId = (String)context.getRequest().getAttribute("orgId");
        }
        if ((folderId = context.getRequest().getParameter("folderId")) == null) {
            folderId = (String)context.getRequest().getAttribute("folderId");
        }
        Exception errorMessage = null;
        Connection db = null;
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            if (!AccountsDocuments.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                return string;
            }
            thisOrg = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrg);
            FileFolderList folders = new FileFolderList();
            if (folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId)) {
                folders.setTopLevelOnly(true);
            } else {
                folders.setParentId(Integer.parseInt(folderId));
                ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
            }
            folders.setLinkModuleId(1);
            folders.setLinkItemId(thisOrg.getOrgId());
            folders.setBuildItemCount(true);
            folders.buildList(db);
            FileItemList files = new FileItemList();
            if (folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId)) {
                files.setTopLevelOnly(true);
            } else {
                files.setFolderId(Integer.parseInt(folderId));
            }
            files.setBuildPortalRecords(AccountsDocuments.isPortalUser(context) ? 1 : -1);
            files.setLinkModuleId(1);
            files.setLinkItemId(thisOrg.getOrgId());
            files.buildList(db);
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrg);
            context.getRequest().setAttribute("fileItemList", (Object)files);
            context.getRequest().setAttribute("fileFolderList", (Object)folders);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "View Documents");
        if (errorMessage == null) {
            String accountfolders = context.getRequest().getParameter("accountfolders");
            if (accountfolders != null && "true".equals(accountfolders)) {
                return "ViewAccountFolderPopupOK";
            }
            return AccountsDocuments.getReturn(context, "View");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-documents-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            thisOrg = this.addOrganization(context, db);
            if (!AccountsDocuments.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrg);
            String folderId = context.getRequest().getParameter("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Upload Document");
        if (errorMessage == null) {
            return AccountsDocuments.getReturn(context, "Add");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpload(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-documents-add")) {
            return "PermissionError";
        }
        Connection db = null;
        Organization thisOrg = null;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            String filePath = this.getPath(context, "accounts");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String id = (String)parts.get("id");
            String subject = (String)parts.get("subject");
            String folderId = (String)parts.get("folderId");
            String actionStepWork = (String)parts.get("actionStepWork");
            String allowPortalAccess = (String)parts.get("allowPortalAccess");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            if (actionStepWork != null) {
                context.getRequest().setAttribute("actionStepWork", (Object)actionStepWork);
            }
            if (!AccountsDocuments.isRecordAccessPermitted(context, db = this.getConnection(context), (thisOrg = this.addOrganization(context, db, id)).getOrgId())) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (parts.get("id" + (String)parts.get("id")) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(1);
                thisItem.setLinkItemId(thisOrg.getOrgId());
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setFolderId(Integer.parseInt(folderId));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(1.0);
                thisItem.setSize(newFileInfo.getSize());
                thisItem.setAllowPortalAccess(allowPortalAccess);
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insert(db);
                }
                if (recordInserted) {
                    this.processInsertHook(context, thisItem);
                    context.getRequest().setAttribute("fileItem", (Object)thisItem);
                    context.getRequest().setAttribute("subject", (Object)"");
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                if (subject != null && "".equals(subject.trim())) {
                    errors.put("subjectError", systemStatus.getLabel("object.validation.required"));
                }
                this.processErrors(context, errors);
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "UploadOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddVersion(ActionContext context) {
        String folderId;
        if (!this.hasPermission(context, "accounts-accounts-documents-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Organization thisOrg = null;
        String itemId = context.getRequest().getParameter("fid");
        if (itemId == null) {
            itemId = (String)context.getRequest().getAttribute("fid");
        }
        if ((folderId = context.getParameter("folderId")) == null) {
            folderId = (String)context.getRequest().getAttribute("folderId");
        }
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisOrg = this.addOrganization(context, db);
            if (!AccountsDocuments.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisFile = new FileItem(db, Integer.parseInt(itemId), thisOrg.getOrgId(), 1);
            context.getRequest().setAttribute("FileItem", (Object)thisFile);
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Upload New Document Version");
        if (errorMessage == null) {
            return AccountsDocuments.getReturn(context, "AddVersion");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUploadVersion(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-documents-add")) {
            return "PermissionError";
        }
        Connection db = null;
        Organization thisOrg = null;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            String filePath = this.getPath(context, "accounts");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String id = (String)parts.get("id");
            String itemId = (String)parts.get("fid");
            String subject = (String)parts.get("subject");
            String versionId = (String)parts.get("versionId");
            String folderId = (String)parts.get("folderId");
            String allowPortalAccess = (String)parts.get("allowPortalAccess");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            if (!AccountsDocuments.isRecordAccessPermitted(context, db = this.getConnection(context), (thisOrg = this.addOrganization(context, db, id)).getOrgId())) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (parts.get("id" + (String)parts.get("id")) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
                FileItem previousItem = null;
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(1);
                thisItem.setLinkItemId(thisOrg.getOrgId());
                thisItem.setId(Integer.parseInt(itemId));
                previousItem = new FileItem(db, Integer.parseInt(itemId), thisItem.getLinkItemId(), thisItem.getLinkModuleId());
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(Double.parseDouble(versionId));
                thisItem.setSize(newFileInfo.getSize());
                thisItem.setAllowPortalAccess(allowPortalAccess);
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insertVersion(db);
                }
                if (recordInserted) {
                    this.processUpdateHook(context, previousItem, thisItem);
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                if (subject != null && "".equals(subject.trim())) {
                    errors.put("subjectError", systemStatus.getLabel("object.validation.required"));
                }
                this.processErrors(context, errors);
            }
            context.getRequest().setAttribute("fid", (Object)itemId);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "UploadOK";
        }
        return this.executeCommandAddVersion(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-documents-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        String folderId = context.getRequest().getParameter("folderId");
        String itemId = context.getRequest().getParameter("fid");
        try {
            db = this.getConnection(context);
            Organization thisOrg = this.addOrganization(context, db);
            if (!AccountsDocuments.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisOrg.getOrgId(), 1);
            thisItem.buildVersionList(db, AccountsDocuments.isPortalUser(context));
            if (folderId == null) {
                folderId = "" + thisItem.getFolderId();
            }
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (!(folderId == null || "-1".equals(folderId) || "0".equals(folderId) || "".equals(folderId.trim()))) {
                ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
            }
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Document Details");
        if (errorMessage == null) {
            return AccountsDocuments.getReturn(context, "Details");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        Exception errorMessage;
        block29: {
            if (!this.hasPermission(context, "accounts-accounts-documents-view")) {
                return "PermissionError";
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            errorMessage = null;
            String itemId = context.getRequest().getParameter("fid");
            String version = context.getRequest().getParameter("ver");
            String view = context.getRequest().getParameter("view");
            FileItem thisItem = null;
            Connection db = null;
            Organization thisOrg = null;
            try {
                db = this.getConnection(context);
                thisOrg = this.addOrganization(context, db);
                if (!AccountsDocuments.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                    String string = "PermissionError";
                    return string;
                }
                thisItem = new FileItem(db, Integer.parseInt(itemId), thisOrg.getOrgId(), 1);
                if (version != null) {
                    thisItem.buildVersionList(db);
                }
            }
            catch (Exception e) {
                errorMessage = e;
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                if (version == null) {
                    FileItem itemToDownload = thisItem;
                    itemToDownload.setEnteredBy(this.getUserId(context));
                    String filePath = this.getPath(context, "accounts") + AccountsDocuments.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(itemToDownload.getClientFilename());
                    if (fileDownload.fileExists()) {
                        if (view != null && "true".equals(view)) {
                            fileDownload.setFileTimestamp(thisItem.getModificationDate().getTime());
                            fileDownload.streamContent(context);
                        } else {
                            fileDownload.sendFile(context);
                        }
                    } else {
                        db = null;
                        System.err.println("LeadsDocuments-> Trying to send a file that does not exist");
                        context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                        String string = this.executeCommandView(context);
                        return string;
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block29;
                }
                FileItemVersion itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "accounts") + AccountsDocuments.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    if (view != null && "true".equals(view)) {
                        fileDownload.setFileTimestamp(itemToDownload.getModificationDate().getTime());
                        fileDownload.streamContent(context);
                    } else {
                        fileDownload.sendFile(context);
                    }
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block29;
                }
                db = null;
                System.err.println("LeadsDocuments-> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.downloadDoesNotExist"));
                String string = this.executeCommandView(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                errorMessage = e;
                System.out.println(e.toString());
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        this.addModuleBean(context, "View Accounts", "");
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-documents-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String itemId = context.getRequest().getParameter("fid");
        String folderId = context.getRequest().getParameter("folderId");
        if (folderId != null) {
            context.getRequest().setAttribute("folderId", (Object)folderId);
        }
        Connection db = null;
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            thisOrg = this.addOrganization(context, db);
            if (!AccountsDocuments.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisOrg.getOrgId(), 1);
            thisItem.buildVersionList(db);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Modify Document Information");
        if (errorMessage == null) {
            return AccountsDocuments.getReturn(context, "Modify");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-documents-edit")) {
            return "PermissionError";
        }
        boolean recordInserted = false;
        boolean isValid = false;
        String itemId = context.getRequest().getParameter("fid");
        String subject = context.getRequest().getParameter("subject");
        String filename = context.getRequest().getParameter("clientFilename");
        String allowPortalAccess = context.getRequest().getParameter("allowPortalAccess");
        Connection db = null;
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            thisOrg = this.addOrganization(context, db);
            if (!AccountsDocuments.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisOrg.getOrgId(), 1);
            FileItem previousItem = new FileItem(db, Integer.parseInt(itemId), thisOrg.getOrgId(), 1);
            thisItem.setClientFilename(filename);
            thisItem.setSubject(subject);
            thisItem.setAllowPortalAccess(allowPortalAccess);
            isValid = this.validateObject(context, db, thisItem);
            if (isValid) {
                recordInserted = thisItem.update(db);
            }
            if (recordInserted) {
                this.processUpdateHook(context, previousItem, thisItem);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "");
        if (recordInserted && isValid) {
            return "UpdateOK";
        }
        context.getRequest().setAttribute("fid", (Object)itemId);
        return this.executeCommandModify(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-documents-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            thisOrg = this.addOrganization(context, db);
            if (!AccountsDocuments.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisOrg.getOrgId(), 1);
            recordDeleted = thisItem.delete(db, this.getPath(context, "accounts"));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Delete Document");
        if (errorMessage == null) {
            if (recordDeleted) {
                return "DeleteOK";
            }
            return "DeleteERROR";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    private Organization addOrganization(ActionContext context, Connection db) throws SQLException {
        String organizationId = context.getRequest().getParameter("orgId");
        if (organizationId == null) {
            organizationId = (String)context.getRequest().getAttribute("orgId");
        }
        return this.addOrganization(context, db, organizationId);
    }

    private Organization addOrganization(ActionContext context, Connection db, String organizationId) throws SQLException {
        context.getRequest().setAttribute("orgId", (Object)organizationId);
        Organization thisOrganization = new Organization(db, Integer.parseInt(organizationId));
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return thisOrganization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-documents-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String itemId = context.getRequest().getParameter("fid");
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            thisOrg = this.addOrganization(context, db);
            if (!AccountsDocuments.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisOrg.getOrgId(), 1);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            FileFolderHierarchy hierarchy = new FileFolderHierarchy();
            hierarchy.setLinkModuleId(1);
            hierarchy.setLinkItemId(thisOrg.getOrgId());
            hierarchy.build(db);
            context.getRequest().setAttribute("folderHierarchy", (Object)hierarchy);
            String string = "MoveOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveMove(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-documents-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String newFolderId = context.getRequest().getParameter("folderId");
        String itemId = context.getRequest().getParameter("fid");
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            thisOrg = this.addOrganization(context, db);
            if (!AccountsDocuments.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), thisOrg.getOrgId(), 1);
            thisItem.updateFolderId(db, Integer.parseInt(newFolderId));
            String string = "PopupCloseOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }
}

