/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.actions.ProjectManagementFileFolders;
import com.zeroio.iteam.base.FileFolder;
import com.zeroio.iteam.base.FileFolderHierarchy;
import java.sql.Connection;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;

public final class AccountsDocumentsFolders
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        Exception errorMessage = null;
        String orgId = context.getRequest().getParameter("orgId");
        Connection db = null;
        try {
            FileFolder thisFolder = (FileFolder)context.getFormBean();
            thisFolder.setParentId(context.getRequest().getParameter("parentId"));
            db = this.getConnection(context);
            if (!AccountsDocumentsFolders.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            Organization orgDetails = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
            context.getRequest().setAttribute("fileFolder", (Object)thisFolder);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return AccountsDocumentsFolders.getReturn(context, "Add");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        Connection db = null;
        int resultCount = 0;
        boolean recordInserted = false;
        boolean isValid = false;
        String orgId = context.getRequest().getParameter("orgId");
        Organization orgDetails = null;
        try {
            boolean newFolder;
            db = this.getConnection(context);
            if (!AccountsDocumentsFolders.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                return string;
            }
            orgDetails = new Organization(db, Integer.parseInt(orgId));
            FileFolder thisFolder = (FileFolder)context.getFormBean();
            boolean bl = newFolder = thisFolder.getId() == -1;
            if (newFolder) {
                thisFolder.setEnteredBy(this.getUserId(context));
            }
            thisFolder.setModifiedBy(this.getUserId(context));
            thisFolder.setLinkModuleId(1);
            thisFolder.setLinkItemId(orgDetails.getId());
            isValid = this.validateObject(context, db, thisFolder);
            if (newFolder) {
                if (isValid) {
                    recordInserted = thisFolder.insert(db);
                }
            } else if (isValid) {
                resultCount = thisFolder.update(db);
            }
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "InsertOK";
        }
        if (resultCount == 1) {
            return "UpdateOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String orgId = context.getRequest().getParameter("orgId");
        String itemId = context.getRequest().getParameter("id");
        String folderId = context.getRequest().getParameter("folderId");
        Organization orgDetails = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (!AccountsDocumentsFolders.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                return string;
            }
            orgDetails = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
            FileFolder thisFolder = new FileFolder(db, Integer.parseInt(itemId));
            recordDeleted = thisFolder.delete(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                return "DeleteOK";
            }
            return "DeleteERROR";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String orgId = context.getRequest().getParameter("orgId");
        String itemId = context.getRequest().getParameter("id");
        String folderId = context.getRequest().getParameter("folderId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (!AccountsDocumentsFolders.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                return string;
            }
            FileFolder thisFolder = (FileFolder)context.getFormBean();
            thisFolder.setId(Integer.parseInt(itemId));
            thisFolder.queryRecord(db, Integer.parseInt(itemId));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return this.executeCommandAdd(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        String orgId = context.getRequest().getParameter("orgId");
        String itemId = context.getRequest().getParameter("id");
        Organization orgDetails = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (!AccountsDocumentsFolders.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                return string;
            }
            orgDetails = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
            FileFolder thisFolder = new FileFolder(db, Integer.parseInt(itemId));
            context.getRequest().setAttribute("FileFolder", (Object)thisFolder);
            FileFolderHierarchy hierarchy = new FileFolderHierarchy();
            hierarchy.setLinkModuleId(1);
            hierarchy.setLinkItemId(orgDetails.getId());
            hierarchy.build(db);
            context.getRequest().setAttribute("folderHierarchy", (Object)hierarchy);
            String string = "MoveOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveMove(ActionContext context) {
        String orgId = context.getRequest().getParameter("orgId");
        String newFolderId = context.getRequest().getParameter("folderId");
        String itemId = context.getRequest().getParameter("id");
        Organization orgDetails = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (!AccountsDocumentsFolders.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                return string;
            }
            orgDetails = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
            FileFolder thisFolder = new FileFolder(db, Integer.parseInt(itemId));
            int folderId = Integer.parseInt(newFolderId);
            if (folderId != 0 && folderId != -1) {
                FileFolder newParent = new FileFolder(db, folderId);
                FileFolderHierarchy thisHierarchy = new FileFolderHierarchy();
                thisHierarchy.setLinkModuleId(1);
                thisHierarchy.setLinkItemId(orgDetails.getOrgId());
                thisHierarchy.build(db, thisFolder.getId());
                if (thisHierarchy.getHierarchy().hasFolder(Integer.parseInt(newFolderId))) {
                    thisFolder.buildSubFolders(db);
                    for (FileFolder childFolder : thisFolder.getSubFolders()) {
                        childFolder.updateParentId(db, thisFolder.getParentId());
                    }
                }
            }
            thisFolder.updateParentId(db, folderId);
            String string = "PopupCloseOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }
}

