/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationHistory;
import org.aspcfs.modules.accounts.base.OrganizationHistoryList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.utils.web.PagedListInfo;

public final class AccountsHistory
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-history-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "AccountsHistory", "View History");
        String source = context.getRequest().getParameter("source");
        Organization newOrg = null;
        String orgid = context.getRequest().getParameter("orgId");
        if (orgid == null) {
            orgid = (String)context.getRequest().getAttribute("orgId");
        }
        String isPopup = context.getRequest().getParameter("popup");
        PagedListInfo historyListInfo = this.getPagedListInfo(context, "orgHistoryListInfo");
        historyListInfo.setLink("AccountsHistory.do?command=View&orgId=" + orgid + (isPopup != null && "true".equals(isPopup) ? "&popup=true" : ""));
        OrganizationHistoryList historyList = new OrganizationHistoryList();
        historyList.setPagedListInfo(historyListInfo);
        historyListInfo.setSearchCriteria(historyList, context);
        ContactList contacts = new ContactList();
        Connection db = null;
        try {
            db = this.getConnection(context);
            newOrg = new Organization(db, Integer.parseInt(orgid));
            if (!AccountsHistory.isRecordAccessPermitted(context, db, newOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
            contacts.setOrgId(orgid);
            contacts.setShowTrashedAndNormal(true);
            contacts.setIncludeEnabled(-1);
            if (historyListInfo.getSavedCriteria().size() == 0) {
                this.setDefaultFilters(context, historyList);
            }
            contacts.buildList(db);
            context.getRequest().setAttribute("contacts", (Object)contacts.getHashMapOfContacts());
            historyList.setOrgId(newOrg.getOrgId());
            historyList.buildList(db);
            context.getRequest().setAttribute("historyList", (Object)historyList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountsHistory.getReturn(context, "List");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddNote(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-history-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Account History", "View History");
        String source = context.getRequest().getParameter("source");
        Organization newOrg = null;
        OrganizationHistory history = null;
        String orgId = context.getRequest().getParameter("orgId");
        if (orgId == null) {
            orgId = (String)context.getRequest().getAttribute("orgId");
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            newOrg = new Organization(db, Integer.parseInt(orgId));
            if (!AccountsHistory.isRecordAccessPermitted(context, db, newOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
            history = new OrganizationHistory();
            context.getRequest().setAttribute("history", (Object)history);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddNoteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveNote(ActionContext context) {
        OrganizationHistory history;
        String source = context.getRequest().getParameter("source");
        Organization newOrg = null;
        String orgId = context.getRequest().getParameter("orgId");
        if (orgId == null) {
            orgId = (String)context.getRequest().getAttribute("orgId");
        }
        if ((history = (OrganizationHistory)((Object)context.getFormBean())).getId() != -1 ? !this.hasPermission(context, "accounts-accounts-history-edit") : !this.hasPermission(context, "accounts-accounts-history-add")) {
            return "PermissionError";
        }
        boolean isValid = false;
        boolean recordInserted = false;
        int resultCount = -1;
        Connection db = null;
        try {
            db = this.getConnection(context);
            newOrg = new Organization(db, Integer.parseInt(orgId));
            if (!AccountsHistory.isRecordAccessPermitted(context, db, newOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            history.setEnteredBy(this.getUserId(context));
            history.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)history);
            if (isValid) {
                if (history.getId() != -1) {
                    resultCount = history.update(db);
                } else {
                    recordInserted = history.insert(db);
                }
            }
            if (!recordInserted && resultCount == -1) {
                context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
                context.getRequest().setAttribute("history", (Object)history);
                String string = "AddNoteOK";
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SaveNoteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyNote(ActionContext context) {
        String id;
        if (!this.hasPermission(context, "accounts-accounts-history-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Organization History", "View History");
        String source = context.getRequest().getParameter("source");
        Organization newOrg = null;
        OrganizationHistory history = null;
        String orgId = context.getRequest().getParameter("orgId");
        if (orgId == null) {
            orgId = (String)context.getRequest().getAttribute("orgId");
        }
        if ((id = context.getRequest().getParameter("id")) == null) {
            id = (String)context.getRequest().getAttribute("id");
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            newOrg = new Organization(db, Integer.parseInt(orgId));
            if (!AccountsHistory.isRecordAccessPermitted(context, db, newOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
            history = new OrganizationHistory(db, Integer.parseInt(id));
            context.getRequest().setAttribute("history", (Object)history);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddNoteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteNote(ActionContext context) {
        String id;
        if (!this.hasPermission(context, "accounts-accounts-history-delete")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Organization History", "View History");
        String source = context.getRequest().getParameter("source");
        Organization newOrg = null;
        OrganizationHistory history = null;
        String orgId = context.getRequest().getParameter("orgId");
        if (orgId == null) {
            orgId = (String)context.getRequest().getAttribute("orgId");
        }
        if ((id = context.getRequest().getParameter("id")) == null) {
            id = (String)context.getRequest().getAttribute("id");
        }
        boolean result = false;
        Connection db = null;
        try {
            db = this.getConnection(context);
            newOrg = new Organization(db, Integer.parseInt(orgId));
            if (!AccountsHistory.isRecordAccessPermitted(context, db, newOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
            history = new OrganizationHistory(db, Integer.parseInt(id));
            result = history.delete(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandView(context);
    }

    private void setDefaultFilters(ActionContext context, OrganizationHistoryList list) {
        if (this.hasPermission(context, "accounts-accounts-view")) {
            list.setNotes(true);
        }
        if (this.hasPermission(context, "accounts-accounts-contacts-calls-edit") || this.hasPermission(context, "accounts-accounts-contacts-calls-view")) {
            list.setActivities(true);
        }
        if (this.hasPermission(context, "myhomepage-inbox-view") || this.hasPermission(context, "accounts-accounts-contacts-messages-view")) {
            list.setEmail(true);
        }
        if (this.hasPermission(context, "accounts-accounts-documents-view") || this.hasPermission(context, "accounts-accounts-documents-edit")) {
            list.setDocuments(true);
        }
        if (this.hasPermission(context, "accounts-quotes-view") || this.hasPermission(context, "accounts-quotes-edit")) {
            list.setQuotes(true);
        }
        if (this.hasPermission(context, "accounts-accounts-opportunities-view") || this.hasPermission(context, "accounts-accounts-opportunities-edit")) {
            list.setOpportunities(true);
        }
        if (this.hasPermission(context, "accounts-service-contracts-view") || this.hasPermission(context, "accounts-service-contracts-edit")) {
            list.setServiceContracts(true);
        }
        if (this.hasPermission(context, "accounts-accounts-tickets-edit") || this.hasPermission(context, "accounts-accounts-tickets-view")) {
            list.setTickets(true);
        }
        if (this.hasPermission(context, "myhomepage-tasks-view") || this.hasPermission(context, "myhomepage-tasks-edit")) {
            list.setTasks(true);
        }
        if (this.hasPermission(context, "accounts-accounts-relationships-view")) {
            list.setRelationships(true);
        }
        if (this.hasPermission(context, "accounts-assets-edit") || this.hasPermission(context, "accounts-assets-view")) {
            list.setAssets(true);
        }
    }
}

