/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.isavvix.tools.FileInfo;
import com.isavvix.tools.HttpMultiPartParser;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.base.FileItemVersion;
import com.zeroio.webutils.FileDownload;
import java.io.File;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.orders.base.Order;
import org.aspcfs.modules.orders.base.OrderProduct;
import org.aspcfs.modules.products.base.CustomerProduct;
import org.aspcfs.modules.products.base.CustomerProductHistory;
import org.aspcfs.modules.products.base.CustomerProductList;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.utils.SVGUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class AccountsProducts
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            thisOrg = this.addOrganization(context, db);
            CustomerProductList customerProductList = new CustomerProductList();
            PagedListInfo searchListInfo = this.getPagedListInfo(context, "SearchCustomerProductListInfo");
            searchListInfo.setLink("AccountsProducts.do?command=List&orgId=" + thisOrg.getOrgId());
            customerProductList.setPagedListInfo(searchListInfo);
            customerProductList.setOrgId(thisOrg.getOrgId());
            customerProductList.setBuildFileList(true);
            customerProductList.setBuildProductCatalog(true);
            customerProductList.buildList(db);
            context.getRequest().setAttribute("CustomerProductList", (Object)customerProductList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "View Products");
        if (errorMessage == null) {
            return "ListOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Organization thisOrg = null;
        try {
            String orderItemId;
            db = this.getConnection(context);
            thisOrg = this.addOrganization(context, db);
            String folderId = context.getRequest().getParameter("folderId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if ((orderItemId = context.getRequest().getParameter("orderItemId")) != null && !"".equals(orderItemId)) {
                OrderProduct orderProduct = new OrderProduct();
                orderProduct.setBuildProductOptions(true);
                orderProduct.setBuildProductStatus(true);
                orderProduct.setBuildProduct(true);
                orderProduct.queryRecord(db, Integer.parseInt(orderItemId));
                context.getRequest().setAttribute("orderProduct", (Object)orderProduct);
                Order order = new Order();
                order.setBuildProducts(true);
                order.queryRecord(db, orderProduct.getOrderId());
                Quote quote = new Quote(db, order.getQuoteId());
                ProductCatalog product = new ProductCatalog();
                product.setBuildOptions(true);
                product.queryRecord(db, quote.getProductId());
                context.getRequest().setAttribute("Product", (Object)product);
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Upload Products");
        if (errorMessage == null) {
            return "AddOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSVGDetails(ActionContext context) {
        Object errorMessage = null;
        Connection db = null;
        Organization thisOrg = null;
        try {
            String stritemid;
            db = this.getConnection(context);
            thisOrg = this.addOrganization(context, db);
            String stradId = context.getRequest().getParameter("adId");
            if (stradId == null) {
                stradId = (String)context.getRequest().getAttribute("adId");
            }
            if ((stritemid = context.getRequest().getParameter("fid")) == null) {
                stritemid = (String)context.getRequest().getAttribute("fid");
            }
            int adId = Integer.parseInt(stradId);
            int itemId = Integer.parseInt(stritemid);
            CustomerProduct customerProduct = new CustomerProduct(db, adId);
            context.getRequest().setAttribute("CustomerProduct", (Object)customerProduct);
            FileItem thisItem = new FileItem(db, itemId, customerProduct.getId(), 423200418);
            thisItem.buildVersionList(db);
            FileItemVersion svgVersion = thisItem.getVersion(Double.parseDouble("1.0"));
            String filePath = this.getPath(context, "accounts") + AccountsProducts.getDatePath(svgVersion.getModified()) + svgVersion.getFilename();
            File svgFile = new File(filePath);
            SVGUtils svg = new SVGUtils(svgFile.toURL().toString());
            Vector textItems = svg.getTextValues();
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            context.getRequest().setAttribute("textItems", (Object)textItems);
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SVGDetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpload(ActionContext context) {
        Order thisOrder = null;
        OrderProduct thisProduct = null;
        Connection db = null;
        boolean isValid = false;
        Organization thisOrg = null;
        boolean recordInserted = false;
        boolean isSvgFile = false;
        try {
            String filePath = this.getPath(context, "accounts");
            HttpMultiPartParser multiPart = new HttpMultiPartParser();
            multiPart.setUsePathParam(false);
            multiPart.setUseUniqueName(true);
            multiPart.setUseDateForFolder(true);
            multiPart.setExtensionId(this.getUserId(context));
            HashMap parts = multiPart.parseData(context.getRequest(), filePath);
            String id = (String)parts.get("id");
            String subject = (String)parts.get("subject");
            String description = (String)parts.get("description");
            String folderId = (String)parts.get("folderId");
            String strproductid = (String)parts.get("productId");
            String orderItemId = (String)parts.get("orderItemId");
            if (folderId != null) {
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            if (subject != null) {
                context.getRequest().setAttribute("subject", (Object)subject);
            }
            db = this.getConnection(context);
            thisOrg = this.addOrganization(context, db, id);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_order_status");
            int productId = Integer.parseInt(strproductid);
            if (orderItemId == null || "".equals(orderItemId)) {
                thisOrder = new Order();
                thisOrder.setOrgId(thisOrg.getOrgId());
                thisOrder.setSalesId(this.getUserId(context));
                thisOrder.setDescription("Adding a new Customer Product");
                thisOrder.setStatusId(list.getIdFromValue("Closed"));
                thisOrder.setEnteredBy(this.getUserId(context));
                thisOrder.setModifiedBy(this.getUserId(context));
                thisOrder.insert(db);
                thisProduct = new OrderProduct();
                thisProduct.setEnteredBy(this.getUserId(context));
                thisProduct.setModifiedBy(this.getUserId(context));
                thisProduct.setOrderId(thisOrder.getId());
                thisProduct.setStatusId(thisOrder.getStatusId());
                thisProduct.setStatusDate(thisOrder.getModified());
                thisProduct.setProductId(productId);
                thisProduct.insert(db);
            } else {
                thisProduct = new OrderProduct();
                thisProduct.setBuildProductOptions(true);
                thisProduct.setBuildProductStatus(true);
                thisProduct.queryRecord(db, Integer.parseInt(orderItemId));
                thisOrder = new Order();
                thisOrder.setBuildProducts(true);
                thisOrder.queryRecord(db, thisProduct.getOrderId());
            }
            CustomerProduct customerProduct = new CustomerProduct();
            customerProduct.setOrgId(thisOrg.getOrgId());
            customerProduct.setOrderId(thisOrder.getId());
            customerProduct.setOrderItemId(thisProduct.getId());
            customerProduct.setDescription(description);
            customerProduct.setEnteredBy(this.getUserId(context));
            customerProduct.setModifiedBy(this.getUserId(context));
            customerProduct.insert(db);
            CustomerProductHistory history = new CustomerProductHistory();
            history.setCustomerProductId(customerProduct.getId());
            history.setOrgId(thisOrg.getOrgId());
            history.setOrderId(thisOrder.getId());
            history.setOrderItemId(thisProduct.getId());
            history.setEnteredBy(this.getUserId(context));
            history.setModifiedBy(this.getUserId(context));
            history.insert(db);
            if (parts.get("id" + (String)parts.get("id")) instanceof FileInfo) {
                FileInfo newFileInfo = (FileInfo)parts.get("id" + id);
                FileItem thisItem = new FileItem();
                thisItem.setLinkModuleId(423200418);
                thisItem.setLinkItemId(customerProduct.getId());
                thisItem.setEnteredBy(this.getUserId(context));
                thisItem.setModifiedBy(this.getUserId(context));
                thisItem.setSubject(subject);
                thisItem.setClientFilename(newFileInfo.getClientFileName());
                thisItem.setFilename(newFileInfo.getRealFilename());
                thisItem.setVersion(1.0);
                thisItem.setSize(newFileInfo.getSize());
                isValid = this.validateObject(context, db, thisItem);
                if (isValid) {
                    recordInserted = thisItem.insert(db);
                }
                if (recordInserted) {
                    if (".svg".equals(thisItem.getExtension())) {
                        isSvgFile = true;
                        File svgFile = new File(newFileInfo.getLocalFile().getPath());
                        File imageFile = new File(newFileInfo.getLocalFile().getPath() + "FS");
                        File thumbnailFile = new File(newFileInfo.getLocalFile().getPath() + "TH");
                        SVGUtils svg = new SVGUtils(svgFile.toURL().toString());
                        if (svg.processSvgFile(svgFile)) {
                            svg = new SVGUtils(svgFile.toURL().toString());
                        }
                        svg.saveAsJPEG(imageFile);
                        String filename = newFileInfo.getClientFileName();
                        filename = filename.substring(0, filename.indexOf(thisItem.getExtension()));
                        filename = filename + ".jpeg";
                        thisItem.setClientFilename(filename);
                        thisItem.setFilename(newFileInfo.getRealFilename() + "FS");
                        thisItem.setVersion(1.1);
                        thisItem.setSize((int)imageFile.length());
                        recordInserted = thisItem.insertVersion(db);
                        svg.saveAsJPEG(imageFile, thumbnailFile, 100.0f, 0.0f);
                        thisItem.setClientFilename(newFileInfo.getClientFileName());
                        thisItem.setFilename(newFileInfo.getRealFilename() + "TH");
                        thisItem.setVersion(1.2);
                        thisItem.setSize((int)thumbnailFile.length());
                        recordInserted = thisItem.insertVersion(db);
                        context.getRequest().setAttribute("uploadMsg", (Object)"You have successfully uploaded the following svg");
                    }
                    context.getRequest().setAttribute("orgId", (Object)Integer.toString(thisOrg.getOrgId()));
                    context.getRequest().setAttribute("adId", (Object)Integer.toString(customerProduct.getId()));
                    context.getRequest().setAttribute("fid", (Object)Integer.toString(thisItem.getId()));
                }
            } else {
                recordInserted = false;
                HashMap<String, String> errors = new HashMap<String, String>();
                errors.put("actionError", systemStatus.getLabel("object.validation.incorrectFileName"));
                this.processErrors(context, errors);
                context.getRequest().setAttribute("subject", (Object)subject);
                context.getRequest().setAttribute("folderId", (Object)folderId);
            }
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = this.executeCommandAdd(context);
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            if (isSvgFile) {
                return this.executeCommandSVGDetails(context);
            }
            return this.executeCommandDetails(context);
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandOnlineTool(ActionContext context) {
        Connection db = null;
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            int id = Integer.parseInt(context.getRequest().getParameter("orgId"));
            int adId = Integer.parseInt(context.getRequest().getParameter("adId"));
            thisOrg = new Organization(db, id);
            CustomerProduct customerProduct = new CustomerProduct();
            customerProduct.setBuildFileList(true);
            customerProduct.queryRecord(db, adId);
            Iterator i = customerProduct.getFileItemList().iterator();
            FileItem targetFile = null;
            while (i.hasNext() && !".svg".equals((targetFile = (FileItem)i.next()).getExtension())) {
            }
            FileItemVersion svgVersion = targetFile.getVersion(Double.parseDouble("1.0"));
            String svgFilePath = this.getPath(context, "accounts") + AccountsProducts.getDatePath(svgVersion.getModified()) + svgVersion.getFilename();
            File svgFile = new File(svgFilePath);
            SVGUtils svg = new SVGUtils(svgFile.toURL().toString());
            Vector textItems = svg.getTextValues();
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrg);
            context.getRequest().setAttribute("FileItem", (Object)targetFile);
            context.getRequest().setAttribute("textItems", (Object)textItems);
            context.getRequest().setAttribute("CustomerProduct", (Object)customerProduct);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "OnlineToolOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandStreamAdImage(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            int adId = Integer.parseInt(context.getRequest().getParameter("adId"));
            CustomerProduct customerProduct = new CustomerProduct();
            customerProduct.setBuildFileList(true);
            customerProduct.queryRecord(db, adId);
            if (AccountsProducts.isPortalUser(context)) {
                User user = this.getUser(context, this.getUserId(context));
                int userOrgId = user.getContact().getOrgId();
                if (customerProduct.getOrgId() != userOrgId) {
                    Exception error = new Exception("Unauthorized Access");
                    context.getRequest().setAttribute("Error", (Object)error);
                    String string = "SystemError";
                    return string;
                }
            }
            Iterator i = customerProduct.getFileItemList().iterator();
            FileItem targetFile = null;
            while (i.hasNext() && !".svg".equals((targetFile = (FileItem)i.next()).getExtension())) {
            }
            FileItemVersion svgVersion = targetFile.getVersion(Double.parseDouble("1.0"));
            String svgFilePath = this.getPath(context, "accounts") + AccountsProducts.getDatePath(svgVersion.getModified()) + svgVersion.getFilename();
            File svgFile = new File(svgFilePath);
            SVGUtils svg = new SVGUtils(svgFile.toURL().toString());
            Enumeration e = context.getRequest().getParameterNames();
            Vector<String> replaceValues = new Vector<String>();
            int k = 1;
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                if (!param.startsWith("text")) continue;
                String value = context.getRequest().getParameter("text" + k);
                if (value == null) {
                    value = "";
                }
                replaceValues.add(value);
                ++k;
            }
            svg.setAllTextElements(replaceValues);
            svg.saveAsJPEG(context);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("fid");
        String adId = context.getRequest().getParameter("adId");
        Connection db = null;
        Exception errorMessage = null;
        Organization thisOrg = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        try {
            db = this.getConnection(context);
            thisOrg = this.addOrganization(context, db);
            CustomerProduct customerProduct = new CustomerProduct();
            customerProduct.setBuildHistoryList(true);
            customerProduct.queryRecord(db, Integer.parseInt(adId));
            htmlDialog.setTitle("Adsjet : Account Management");
            DependencyList dependencies = customerProduct.processDependencies(db);
            if (dependencies.canDelete()) {
                htmlDialog.addMessage(dependencies.getHtmlString());
                htmlDialog.setHeader("This object has the following dependencies within Dark Horse CRM:");
                htmlDialog.addButton("Delete All", "javascript:window.location.href='AccountsProducts.do?command=Delete&orgId=" + thisOrg.getOrgId() + "&adId=" + customerProduct.getId() + "&fid=" + itemId + "'");
            }
            htmlDialog.addButton("Cancel", "javascript:parent.window.close()");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("fid");
        String adId = context.getRequest().getParameter("adId");
        Connection db = null;
        Organization thisOrg = null;
        CustomerProduct customerProduct = null;
        try {
            db = this.getConnection(context);
            thisOrg = this.addOrganization(context, db);
            customerProduct = new CustomerProduct(db, Integer.parseInt(adId));
            recordDeleted = customerProduct.delete(db, Integer.parseInt(itemId), this.getPath(context, "accounts"));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordDeleted) {
            context.getRequest().setAttribute("refreshUrl", (Object)("AccountsProducts.do?command=List&orgId=" + thisOrg.getOrgId()));
            return "DeleteOK";
        }
        this.processErrors(context, customerProduct.getErrors());
        context.getRequest().setAttribute("actionError", (Object)"Account Products could not be deleted because of referential integrity .");
        context.getRequest().setAttribute("refreshUrl", (Object)("AccountsProducts.do?command=List&orgId=" + thisOrg.getOrgId()));
        return "DeleteError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        String adId = context.getRequest().getParameter("adId");
        if (adId == null) {
            adId = (String)context.getRequest().getAttribute("adId");
        }
        try {
            db = this.getConnection(context);
            Organization thisOrg = this.addOrganization(context, db);
            CustomerProduct customerProduct = new CustomerProduct(db, Integer.parseInt(adId));
            FileItemList documents = new FileItemList();
            documents.setLinkModuleId(423200418);
            documents.setLinkItemId(customerProduct.getId());
            PagedListInfo docListInfo = this.getPagedListInfo(context, "DocListInfo");
            docListInfo.setLink("AccountsProducts.do?command=List&orgId=" + thisOrg.getOrgId());
            documents.setPagedListInfo(docListInfo);
            documents.buildList(db);
            context.getRequest().setAttribute("CustomerProduct", (Object)customerProduct);
            context.getRequest().setAttribute("FileItemList", (Object)documents);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "DetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownload(ActionContext context) {
        Exception errorMessage;
        block21: {
            errorMessage = null;
            String itemId = context.getRequest().getParameter("fid");
            String version = context.getRequest().getParameter("ver");
            String adId = context.getRequest().getParameter("adId");
            FileItem thisItem = null;
            Connection db = null;
            Organization thisOrg = null;
            try {
                db = this.getConnection(context);
                thisOrg = this.addOrganization(context, db);
                thisItem = new FileItem(db, Integer.parseInt(itemId), Integer.parseInt(adId), 423200418);
                if (version != null) {
                    thisItem.buildVersionList(db);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            finally {
                this.freeConnection(context, db);
            }
            try {
                if (version == null) {
                    FileItem itemToDownload = thisItem;
                    itemToDownload.setEnteredBy(this.getUserId(context));
                    String filePath = this.getPath(context, "accounts") + AccountsProducts.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(itemToDownload.getClientFilename());
                    if (!fileDownload.fileExists()) {
                        db = null;
                        System.err.println("AccountProducts -> Trying to send a file that does not exist");
                        context.getRequest().setAttribute("actionError", (Object)"The requested download no longer exists on the system");
                        String string = this.executeCommandSVGDetails(context);
                        return string;
                    }
                    fileDownload.sendFile(context);
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block21;
                }
                FileItemVersion itemToDownload = thisItem.getVersion(Double.parseDouble(version));
                itemToDownload.setEnteredBy(this.getUserId(context));
                String filePath = this.getPath(context, "accounts") + AccountsProducts.getDatePath(itemToDownload.getModified()) + itemToDownload.getFilename();
                FileDownload fileDownload = new FileDownload();
                fileDownload.setFullPath(filePath);
                fileDownload.setDisplayName(itemToDownload.getClientFilename());
                if (fileDownload.fileExists()) {
                    fileDownload.sendFile(context);
                    db = this.getConnection(context);
                    itemToDownload.updateCounter(db);
                    break block21;
                }
                db = null;
                System.err.println("AccountsProducts -> Trying to send a file that does not exist");
                context.getRequest().setAttribute("actionError", (Object)"The requested download no longer exists on the system");
                String string = this.executeCommandSVGDetails(context);
                return string;
            }
            catch (SocketException se) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println(se.toString());
                }
            }
            catch (Exception e) {
                errorMessage = e;
                System.out.println(e.toString());
            }
            finally {
                if (db != null) {
                    this.freeConnection(context, db);
                }
            }
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        this.addModuleBean(context, "View Accounts", "");
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewProduct(ActionContext context) {
        Connection db = null;
        int adId = Integer.parseInt(context.getRequest().getParameter("adId"));
        CustomerProduct customerProduct = null;
        try {
            db = this.getConnection(context);
            customerProduct = new CustomerProduct();
            customerProduct.setBuildFileList(true);
            customerProduct.queryRecord(db, adId);
            context.getRequest().setAttribute("customerProduct", (Object)customerProduct);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewProductOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandVersionDetails(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        String itemId = context.getRequest().getParameter("fid");
        String adId = context.getRequest().getParameter("adId");
        try {
            db = this.getConnection(context);
            Organization thisOrg = this.addOrganization(context, db);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), Integer.parseInt(adId), 423200418);
            thisItem.buildVersionList(db);
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrg);
            context.getRequest().setAttribute("FileItem", (Object)thisItem);
            context.getRequest().setAttribute("adId", (Object)adId);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "VersionDetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    private Organization addOrganization(ActionContext context, Connection db) throws SQLException {
        String organizationId = context.getRequest().getParameter("orgId");
        if (organizationId == null) {
            organizationId = (String)context.getRequest().getAttribute("orgId");
        }
        return this.addOrganization(context, db, organizationId);
    }

    private Organization addOrganization(ActionContext context, Connection db, String organizationId) throws SQLException {
        context.getRequest().setAttribute("orgId", (Object)organizationId);
        Organization thisOrganization = new Organization(db, Integer.parseInt(organizationId));
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return thisOrganization;
    }
}

