/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.Project;
import com.zeroio.iteam.base.ProjectList;
import com.zeroio.iteam.base.TeamMemberList;
import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public class AccountsProjects
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (this.getUserId(context) < 0) {
            return "PermissionError";
        }
        if (!this.hasPermission(context, "accounts-projects-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            Organization thisOrganization = AccountsProjects.setOrganization(context, db);
            if (!AccountsProjects.isRecordAccessPermitted(context, db, thisOrganization.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            ProjectList projects = new ProjectList();
            PagedListInfo projectListInfo = this.getPagedListInfo(context, "AccountProjectInfo");
            projectListInfo.setLink("AccountsProjects.do?command=List&orgId=" + thisOrganization.getId() + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType"));
            projectListInfo.setItemsPerPage(0);
            projects.setPagedListInfo(projectListInfo);
            projects.setGroupId(-1);
            projects.setProjectsForOrgId(thisOrganization.getId());
            projects.setIncludeGuestProjects(true);
            projects.setPortalState(0);
            projects.setBuildOverallProgress(true);
            projects.buildList(db);
            for (Project thisProject : projects) {
                thisProject.setHasAccess(TeamMemberList.isOnTeam((Connection)db, (int)thisProject.getId(), (int)this.getUserId(context)));
            }
            context.getRequest().setAttribute("projectList", (Object)projects);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountsProjects.getReturn(context, "AccountsProjectsList");
    }

    private static Organization setOrganization(ActionContext context, Connection db) throws SQLException {
        Organization thisOrganization = null;
        String orgId = context.getRequest().getParameter("orgId");
        thisOrganization = new Organization(db, Integer.parseInt(orgId));
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return thisOrganization;
    }
}

