/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.servicecontracts.base.ServiceContract;
import org.aspcfs.modules.servicecontracts.base.ServiceContractHours;
import org.aspcfs.modules.servicecontracts.base.ServiceContractHoursList;
import org.aspcfs.modules.servicecontracts.base.ServiceContractList;
import org.aspcfs.modules.servicecontracts.base.ServiceContractProduct;
import org.aspcfs.modules.servicecontracts.base.ServiceContractProductList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public class AccountsServiceContracts
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return "OK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "accounts-service-contracts-view")) {
            return "PermissionError";
        }
        ServiceContractList serviceContractList = new ServiceContractList();
        String orgId = context.getRequest().getParameter("orgId");
        PagedListInfo serviceContractListInfo = this.getPagedListInfo(context, "ServiceContractListInfo");
        serviceContractListInfo.setLink("AccountsServiceContracts.do?command=List&orgId=" + orgId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType"));
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (!AccountsServiceContracts.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                return string;
            }
            this.setOrganization(context, db);
            serviceContractList.setPagedListInfo(serviceContractListInfo);
            serviceContractList.setOrgId(Integer.parseInt(orgId));
            Organization tmpOrganization = (Organization)((Object)context.getRequest().getAttribute("OrgDetails"));
            if (tmpOrganization.isTrashed()) {
                serviceContractList.setIncludeOnlyTrashed(true);
            }
            serviceContractList.buildList(db);
            context.getRequest().setAttribute("serviceContractList", (Object)serviceContractList);
            this.buildFormElements(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountsServiceContracts.getReturn(context, "AccountsServiceContractsList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "accounts-service-contracts-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.setOrganization(context, db);
            ServiceContract thisContract = (ServiceContract)((Object)context.getFormBean());
            this.buildFormElements(context, db);
            ContactList contactList = new ContactList();
            contactList.setOrgId(Integer.parseInt(context.getRequest().getParameter("orgId")));
            contactList.buildList(db);
            contactList.setEmptyHtmlSelectRecord(this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("contactList", (Object)contactList);
            thisContract.setServiceContractProductList(new ServiceContractProductList());
            ServiceContractHoursList schHistory = new ServiceContractHoursList();
            context.getRequest().setAttribute("serviceContractHoursHistory", (Object)schHistory);
            if (thisContract.getEnteredBy() != -1) {
                thisContract.setProductList(context.getRequest().getParameterValues("selectedList"));
                ServiceContractProductList scpl = new ServiceContractProductList();
                thisContract.setServiceContractProductList(scpl);
                Iterator itr = thisContract.getProductList().iterator();
                while (itr.hasNext()) {
                    int productId = Integer.parseInt((String)itr.next());
                    ProductCatalog pc = new ProductCatalog(db, productId);
                    ServiceContractProduct spc = new ServiceContractProduct();
                    spc.setProductId(pc.getId());
                    spc.setContractId(thisContract.getId());
                    spc.setProductName(pc.getName());
                    spc.setProductSku(pc.getSku());
                    thisContract.getServiceContractProductList().add(spc);
                }
            }
            context.getRequest().setAttribute("serviceContract", (Object)thisContract);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountsServiceContracts.getReturn(context, "AccountsServiceContractsAdd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "accounts-service-contracts-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean inserted = false;
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            this.setOrganization(context, db);
            ServiceContract thisContract = (ServiceContract)((Object)context.getFormBean());
            if (!AccountsServiceContracts.isRecordAccessPermitted(context, db, thisContract.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            thisContract.setProductList(context.getRequest().getParameterValues("selectedList"));
            thisContract.setEnteredBy(this.getUserId(context));
            thisContract.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)thisContract);
            if (isValid) {
                inserted = thisContract.insert(db);
            }
            if (inserted) {
                this.processInsertHook(context, (Object)thisContract);
                String tmpHours = context.getRequest().getParameter("totalHoursRemaining");
                if (tmpHours != null && !"".equals(tmpHours = tmpHours.trim())) {
                    ServiceContractHours scHours = new ServiceContractHours();
                    scHours.setServiceContractId(thisContract.getId());
                    scHours.setAdjustmentHours(tmpHours);
                    scHours.setAdjustmentReason(context.getRequest().getParameter("adjustmentReason"));
                    scHours.setAdjustmentNotes(context.getRequest().getParameter("adjustmentNotes"));
                    scHours.setEnteredBy(this.getUserId(context));
                    scHours.setModifiedBy(this.getUserId(context));
                    scHours.insert(db);
                }
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (inserted) {
            return this.executeCommandList(context);
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "accounts-service-contracts-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = -1;
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            this.setOrganization(context, db);
            ServiceContract thisContract = (ServiceContract)((Object)context.getFormBean());
            if (!AccountsServiceContracts.isRecordAccessPermitted(context, db, thisContract.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            ServiceContract previousContract = new ServiceContract(db, thisContract.getId());
            thisContract.setProductList(context.getRequest().getParameterValues("selectedList"));
            double newHoursRemaining = thisContract.getTotalHoursRemaining();
            String tmpHours = context.getRequest().getParameter("adjustmentHours");
            if (tmpHours != null && !"".equals(tmpHours = tmpHours.trim())) {
                newHoursRemaining += Double.parseDouble(tmpHours);
            }
            thisContract.setTotalHoursRemaining(newHoursRemaining);
            thisContract.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)thisContract);
            if (isValid) {
                resultCount = thisContract.update(db);
            }
            if (resultCount == 1) {
                this.processUpdateHook(context, (Object)previousContract, (Object)thisContract);
                if (!"".equals(tmpHours) && Double.parseDouble(tmpHours) != 0.0) {
                    ServiceContractHours scHours = new ServiceContractHours();
                    scHours.setServiceContractId(thisContract.getId());
                    scHours.setAdjustmentHours(tmpHours);
                    scHours.setAdjustmentReason(context.getRequest().getParameter("adjustmentReason"));
                    scHours.setAdjustmentNotes(context.getRequest().getParameter("adjustmentNotes"));
                    scHours.setEnteredBy(this.getUserId(context));
                    scHours.setModifiedBy(this.getUserId(context));
                    scHours.insert(db);
                }
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == 1) {
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandList(context);
            }
            return this.executeCommandView(context);
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandModify(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-service-contracts-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = context.getRequest().getParameter("id");
        String orgId = context.getRequest().getParameter("orgId");
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            ServiceContract thisContract = new ServiceContract(db, id);
            if (!AccountsServiceContracts.isRecordAccessPermitted(context, db, thisContract.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = thisContract.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='AccountsServiceContracts.do?command=Trash&action=delete&orgId=" + orgId + "&id=" + id + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            errorMessage = e;
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrash(ActionContext context) {
        boolean inline;
        if (!this.hasPermission(context, "accounts-service-contracts-delete")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        boolean recordDeleted = false;
        Connection db = null;
        ServiceContract thisContract = null;
        try {
            db = this.getConnection(context);
            this.setOrganization(context, db);
            int id = Integer.parseInt(context.getRequest().getParameter("id"));
            thisContract = new ServiceContract(db, id);
            if (!AccountsServiceContracts.isRecordAccessPermitted(context, db, thisContract.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisContract.updateStatus(db, true, this.getUserId(context));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        boolean bl = inline = context.getRequest().getParameter("popupType") != null && "inline".equals(context.getRequest().getParameter("popupType"));
        if (recordDeleted) {
            context.getRequest().setAttribute("refreshUrl", (Object)("AccountsServiceContracts.do?command=List&orgId=" + context.getRequest().getParameter("orgId") + (inline ? "&popup=true" : "")));
            return "DeleteOK";
        }
        this.processErrors(context, thisContract.getErrors());
        context.getRequest().setAttribute("refreshUrl", (Object)("AccountsServiceContracts.do?command=View&orgId=" + context.getRequest().getParameter("orgId") + "&id=" + context.getRequest().getParameter("id") + (inline ? "&popup=true" : "")));
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-service-contracts-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        boolean recordDeleted = false;
        Connection db = null;
        ServiceContract thisContract = null;
        try {
            db = this.getConnection(context);
            this.setOrganization(context, db);
            int id = Integer.parseInt(context.getRequest().getParameter("id"));
            thisContract = new ServiceContract(db, id);
            if (!AccountsServiceContracts.isRecordAccessPermitted(context, db, thisContract.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisContract.delete(db, AccountsServiceContracts.getDbNamePath(context));
        }
        catch (Exception e) {
            errorMessage = e;
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordDeleted) {
            context.getRequest().setAttribute("refreshUrl", (Object)("AccountsServiceContracts.do?command=List&orgId=" + context.getRequest().getParameter("orgId")));
            return AccountsServiceContracts.getReturn(context, "Delete");
        }
        this.processErrors(context, thisContract.getErrors());
        context.getRequest().setAttribute("refreshUrl", (Object)("AccountsServiceContracts.do?command=View&orgId=" + context.getRequest().getParameter("orgId") + "&id=" + context.getRequest().getParameter("id")));
        return AccountsServiceContracts.getReturn(context, "Delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "accounts-service-contracts-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        Organization thisOrg = null;
        boolean fromBean = true;
        try {
            db = this.getConnection(context);
            this.setOrganization(context, db);
            thisOrg = (Organization)((Object)context.getRequest().getAttribute("OrgDetails"));
            int contractId = Integer.parseInt(context.getRequest().getParameter("id"));
            ServiceContract thisContract = (ServiceContract)((Object)context.getFormBean());
            if (thisContract.getId() == -1) {
                fromBean = false;
                thisContract.queryRecord(db, contractId);
            }
            if (!AccountsServiceContracts.isRecordAccessPermitted(context, db, thisContract.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            this.buildFormElements(context, db);
            ContactList contactList = new ContactList();
            contactList.setOrgId(thisOrg.getOrgId());
            contactList.setDefaultContactId(thisContract.getContactId());
            contactList.buildList(db);
            contactList.setEmptyHtmlSelectRecord(this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("contactList", (Object)contactList);
            ServiceContractHoursList schHistory = new ServiceContractHoursList();
            schHistory.setContractId(thisContract.getId());
            schHistory.buildList(db);
            context.getRequest().setAttribute("serviceContractHoursHistory", (Object)schHistory);
            if (fromBean) {
                thisContract.setProductList(context.getRequest().getParameterValues("selectedList"));
                ServiceContractProductList scpl = new ServiceContractProductList();
                thisContract.setServiceContractProductList(scpl);
                Iterator itr = thisContract.getProductList().iterator();
                while (itr.hasNext()) {
                    int productId = Integer.parseInt((String)itr.next());
                    ProductCatalog pc = new ProductCatalog(db, productId);
                    ServiceContractProduct spc = new ServiceContractProduct();
                    spc.setProductId(pc.getId());
                    spc.setContractId(thisContract.getId());
                    spc.setProductName(pc.getName());
                    spc.setProductSku(pc.getSku());
                    thisContract.getServiceContractProductList().add(spc);
                }
                double newHoursRemaining = thisContract.getTotalHoursRemaining();
                String tmpHours = context.getRequest().getParameter("adjustmentHours");
                if (tmpHours != null && !"".equals(tmpHours = tmpHours.trim())) {
                    newHoursRemaining -= Double.parseDouble(tmpHours);
                }
                thisContract.setTotalHoursRemaining(newHoursRemaining);
            }
            context.getRequest().setAttribute("serviceContract", (Object)thisContract);
            context.getRequest().setAttribute("return", (Object)context.getRequest().getParameter("return"));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountsServiceContracts.getReturn(context, "AccountsServiceContractsModify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "accounts-service-contracts-view")) {
            return "PermissionError";
        }
        Organization thisOrg = null;
        Connection db = null;
        String id = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            this.setOrganization(context, db);
            thisOrg = (Organization)((Object)context.getRequest().getAttribute("OrgDetails"));
            int orgId = thisOrg.getOrgId();
            ServiceContract thisContract = new ServiceContract(db, id);
            if (!AccountsServiceContracts.isRecordAccessPermitted(context, db, thisContract.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            if (!AccountsServiceContracts.isRecordAccessPermitted(context, db, thisContract.getOrgId()) || !AccountsServiceContracts.isRecordAccessPermitted(context, db, orgId)) {
                String string = "PermissionError";
                return string;
            }
            if (thisContract.getContactId() > -1) {
                Contact thisContact = new Contact();
                thisContact.queryRecord(db, thisContract.getContactId());
                context.getRequest().setAttribute("serviceContractContact", (Object)thisContact);
            }
            ServiceContractHoursList schHistory = new ServiceContractHoursList();
            schHistory.setContractId(id);
            schHistory.buildList(db);
            context.getRequest().setAttribute("serviceContractHoursHistory", (Object)schHistory);
            ServiceContractProductList scpl = new ServiceContractProductList();
            scpl.setContractId(thisContract.getId());
            scpl.buildList(db);
            context.getRequest().setAttribute("serviceContractProductList", (Object)scpl);
            this.buildFormElements(context, db);
            context.getRequest().setAttribute("serviceContract", (Object)thisContract);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountsServiceContracts.getReturn(context, "AccountsServiceContractsView");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandHoursHistory(ActionContext context) {
        Connection db = null;
        String id = context.getRequest().getParameter("id");
        ServiceContractHoursList schHistory = new ServiceContractHoursList();
        PagedListInfo serviceContractHoursHistoryInfo = this.getPagedListInfo(context, "serviceContractHoursHistoryInfo");
        serviceContractHoursHistoryInfo.setLink("AccountsServiceContracts.do?command=HoursHistory&id=" + id);
        try {
            db = this.getConnection(context);
            ServiceContract thisContract = new ServiceContract(db, id);
            if (!AccountsServiceContracts.isRecordAccessPermitted(context, db, thisContract.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            LookupList serviceContractHoursReasonList = new LookupList(db, "lookup_hours_reason");
            serviceContractHoursReasonList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("serviceContractHoursReasonList", (Object)serviceContractHoursReasonList);
            schHistory.setPagedListInfo(serviceContractHoursHistoryInfo);
            schHistory.setContractId(id);
            schHistory.buildList(db);
            context.getRequest().setAttribute("serviceContractHoursHistory", (Object)schHistory);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AccountsServiceContractsHoursOK";
    }

    public void buildFormElements(ActionContext context, Connection db) throws SQLException {
        SystemStatus thisSystem = this.getSystemStatus(context);
        LookupList serviceContractCategoryList = new LookupList(db, "lookup_sc_category");
        serviceContractCategoryList.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("serviceContractCategoryList", (Object)serviceContractCategoryList);
        LookupList serviceContractTypeList = new LookupList(db, "lookup_sc_type");
        serviceContractTypeList.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("serviceContractTypeList", (Object)serviceContractTypeList);
        LookupList responseModelList = new LookupList(db, "lookup_response_model");
        responseModelList.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("responseModelList", (Object)responseModelList);
        LookupList phoneModelList = new LookupList(db, "lookup_phone_model");
        phoneModelList.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("phoneModelList", (Object)phoneModelList);
        LookupList onsiteModelList = new LookupList(db, "lookup_onsite_model");
        onsiteModelList.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("onsiteModelList", (Object)onsiteModelList);
        LookupList emailModelList = new LookupList(db, "lookup_email_model");
        emailModelList.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("emailModelList", (Object)emailModelList);
        LookupList hoursReasonList = new LookupList(db, "lookup_hours_reason");
        hoursReasonList.addItem(-1, thisSystem.getLabel("accounts.servicecontracts.noAdjustment"));
        context.getRequest().setAttribute("hoursReasonList", (Object)hoursReasonList);
    }

    public void setOrganization(ActionContext context, Connection db) throws SQLException {
        String contactId;
        Organization thisOrganization = null;
        String orgId = context.getRequest().getParameter("orgId");
        if ((orgId == null || "".equals(orgId)) && (contactId = context.getRequest().getParameter("contactId")) != null) {
            Contact contact = new Contact(db, Integer.parseInt(contactId));
            orgId = "" + contact.getOrgId();
        }
        thisOrganization = new Organization(db, Integer.parseInt(orgId));
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
    }
}

