/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.documents.base.AccountDocumentList;
import org.aspcfs.utils.web.PagedListInfo;

public class AccountsSharedDocuments
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (this.getUserId(context) < 0) {
            return "PermissionError";
        }
        if (!this.hasPermission(context, "accounts-accounts-shareddocuments-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            Organization thisOrganization = AccountsSharedDocuments.setOrganization(context, db);
            if (!AccountsSharedDocuments.isRecordAccessPermitted(context, db, thisOrganization.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            AccountDocumentList accountDocumentList = new AccountDocumentList();
            PagedListInfo accountDocumentListInfo = this.getPagedListInfo(context, "accountsSharedDocumentsInfo");
            accountDocumentListInfo.setLink("AccountsSharedDocuments.do?command=List&orgId=" + thisOrganization.getId());
            accountDocumentListInfo.setItemsPerPage(0);
            accountDocumentList.setPagedListInfo(accountDocumentListInfo);
            accountDocumentList.setOrgId(thisOrganization.getId());
            accountDocumentList.setBuildPortalRecords(AccountsSharedDocuments.isPortalUser(context) ? 1 : -1);
            accountDocumentList.setUserId(this.getUserId(context));
            accountDocumentList.buildList(db);
            context.getRequest().setAttribute("accountDocumentList", (Object)accountDocumentList);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountsSharedDocuments.getReturn(context, "List");
    }

    private static Organization setOrganization(ActionContext context, Connection db) throws SQLException {
        Organization thisOrganization = null;
        String orgId = context.getRequest().getParameter("orgId");
        thisOrganization = new Organization(db, Integer.parseInt(orgId));
        context.getRequest().setAttribute("orgDetails", (Object)thisOrganization);
        return thisOrganization;
    }
}

