/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldCategoryList;
import org.aspcfs.modules.base.CustomFieldGroup;
import org.aspcfs.modules.base.CustomFieldRecord;
import org.aspcfs.modules.base.CustomFieldRecordList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.modules.communications.base.CampaignList;
import org.aspcfs.modules.communications.base.CommunicationsPreference;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.contacts.base.ContactTypeList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class Contacts
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrepare(ActionContext context) {
        Connection db = null;
        Contact thisContact = (Contact)((Object)context.getFormBean());
        Organization thisOrganization = (Organization)((Object)context.getRequest().getAttribute("OrgDetails"));
        String orgId = context.getRequest().getParameter("orgId");
        if (orgId == null && thisOrganization != null) {
            orgId = String.valueOf(thisOrganization.getId());
            thisContact.setNotes(null);
        }
        if (thisContact.getId() == -1) {
            if (!this.hasPermission(context, "accounts-accounts-contacts-add")) {
                return "PermissionError";
            }
            this.addModuleBean(context, "View Accounts", "Add Contact to Account");
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            if (!Contacts.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                return string;
            }
            if (thisOrganization == null) {
                thisOrganization = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            }
            LookupList salutationList = new LookupList(db, "lookup_title");
            salutationList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SalutationList", (Object)salutationList);
            ContactTypeList ctl = new ContactTypeList();
            ctl.setIncludeDefinedByUser(this.getUserId(context));
            ctl.setCategory(1);
            ctl.buildList(db);
            ctl.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ContactTypeList", (Object)ctl);
            if ("add_contact".equals(context.getRequest().getParameter("target")) && "true".equals(context.getRequest().getParameter("copyAddress"))) {
                thisContact.setRequestItems(context);
            }
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "PrepareOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandClone(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "Clone Account Contact");
        Connection db = null;
        String contactId = context.getRequest().getParameter("id");
        Contact cloneContact = null;
        try {
            db = this.getConnection(context);
            cloneContact = new Contact(db, contactId);
            if (!Contacts.isRecordAccessPermitted(context, db, cloneContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            cloneContact.resetBaseInfo();
            context.getRequest().setAttribute("ContactDetails", (Object)cloneContact);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        boolean recordInserted = false;
        int resultCount = 0;
        boolean isValid = false;
        String permission = "accounts-accounts-contacts-add";
        Contact thisContact = (Contact)((Object)context.getFormBean());
        if (thisContact.getId() > 0) {
            permission = "accounts-accounts-contacts-edit";
        }
        if (!this.hasPermission(context, permission)) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "Save Contact to Account");
        Organization thisOrganization = null;
        Contact oldContact = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            boolean newContact = thisContact.getId() == -1;
            thisContact.setRequestItems(context);
            thisContact.setTypeList(context.getRequest().getParameterValues("selectedList"));
            thisContact.setModifiedBy(this.getUserId(context));
            thisContact.setEnteredBy(this.getUserId(context));
            AccessTypeList accessTypes = this.getSystemStatus(context).getAccessTypeList(db, 626030331);
            thisContact.setAccessType(accessTypes.getDefaultItem());
            if (context.getRequest().getParameter("primaryContact") != null && "true".equals(context.getRequest().getParameter("primaryContact"))) {
                thisContact.setPrimaryContact(true);
            }
            isValid = this.validateObject(context, db, (Object)thisContact);
            if (newContact) {
                thisContact.setOwner(this.getUserId(context));
                if (isValid) {
                    recordInserted = thisContact.insert(db);
                }
            } else if (isValid) {
                oldContact = new Contact(db, thisContact.getId());
                resultCount = thisContact.update(db, context);
            }
            if (recordInserted || resultCount == 1) {
                if (recordInserted) {
                    this.processInsertHook(context, (Object)thisContact);
                } else if (resultCount == 1) {
                    this.processUpdateHook(context, (Object)oldContact, (Object)thisContact);
                }
                thisContact = new Contact(db, thisContact.getId());
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
                if (resultCount == 1) {
                    thisContact.checkUserAccount(db);
                    this.updateUserContact(db, context, thisContact.getUserId());
                }
                thisOrganization = new Organization(db, thisContact.getOrgId());
                context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
                context.getRequest().setAttribute("id", (Object)String.valueOf(thisContact.getId()));
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("orgId", (Object)("" + thisContact.getOrgId()));
        if (recordInserted) {
            this.addRecentItem(context, (Object)thisContact);
            if ("true".equals(context.getRequest().getParameter("saveAndClone"))) {
                thisContact.resetBaseInfo();
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
                return this.executeCommandPrepare(context);
            }
            String hiddensource = context.getParameter("hiddensource");
            if (context.getRequest().getParameter("popup") != null && hiddensource != null && !"".equals(hiddensource.trim())) {
                return "CloseAddPopup";
            }
            if ("true".equals(context.getRequest().getParameter("providePortalAccess"))) {
                return "AddPortalOK";
            }
            return Contacts.getReturn(context, "Details");
        }
        if (resultCount == 1) {
            String source = context.getRequest().getParameter("source");
            if (context.getRequest().getParameter("popup") != null && source != null && "attachplan".equals(source.trim())) {
                return "CloseAddPopup";
            }
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                return this.executeCommandView(context);
            }
            return "UpdateOK";
        }
        context.getRequest().setAttribute("TypeList", (Object)thisContact.getTypeList());
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        Connection db = null;
        Contact thisContact = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = null;
        String orgId = null;
        if (!this.hasPermission(context, "accounts-accounts-contacts-delete")) {
            return "PermissionError";
        }
        if (context.getRequest().getParameter("id") != null) {
            id = context.getRequest().getParameter("id");
        }
        if (context.getRequest().getParameter("orgId") != null) {
            orgId = context.getRequest().getParameter("orgId");
        }
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisContact = new Contact(db, id);
            if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            thisContact.checkUserAccount(db);
            DependencyList dependencies = thisContact.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (thisContact.getPrimaryContact()) {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.contactIndividualAccountHeader"));
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            }
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            htmlDialog.addButton(systemStatus.getLabel("button.delete"), "javascript:window.location.href='Contacts.do?command=Trash&orgId=" + orgId + "&id=" + id + RequestUtils.addLinkParams(context.getRequest(), "popup|accountpopup") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "View Contact Details");
        String contactId = context.getRequest().getParameter("id");
        if (contactId == null) {
            contactId = (String)context.getRequest().getAttribute("id");
        }
        Connection db = null;
        Contact newContact = null;
        Organization thisOrganization = null;
        try {
            db = this.getConnection(context);
            newContact = new Contact(db, contactId);
            thisOrganization = new Organization(db, newContact.getOrgId());
            if (!Contacts.isRecordAccessPermitted(context, db, newContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            this.addFormElements(context, db, systemStatus, newContact);
            this.addRecentItem(context, (Object)newContact);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("ContactDetails", (Object)newContact);
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return Contacts.getReturn(context, "Details");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        boolean accountpopup = false;
        if (context.getRequest().getParameter("accountpopup") != null && "true".equals(context.getRequest().getParameter("accountpopup"))) {
            accountpopup = true;
        }
        Contact thisContact = null;
        Organization thisOrganization = null;
        String orgId = null;
        if (context.getRequest().getParameter("orgId") != null) {
            orgId = context.getRequest().getParameter("orgId");
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, context.getRequest().getParameter("id"));
            if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisContact.delete(db, Contacts.getDbNamePath(context));
            this.processErrors(context, thisContact.getErrors());
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Delete Contact");
        context.getRequest().setAttribute("orgId", (Object)orgId);
        if (recordDeleted) {
            context.getRequest().setAttribute("refreshUrl", (Object)("Contacts.do?command=View&orgId=" + orgId + (accountpopup ? "&popup=true" : "")));
            this.deleteRecentItem(context, (Object)thisContact);
            return "DeleteOK";
        }
        this.processErrors(context, thisContact.getErrors());
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrash(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-delete")) {
            return "PermissionError";
        }
        boolean recordUpdated = false;
        Contact thisContact = null;
        Organization thisOrganization = null;
        String orgId = null;
        if (context.getRequest().getParameter("orgId") != null) {
            orgId = context.getRequest().getParameter("orgId");
        }
        boolean accountpopup = false;
        if (context.getRequest().getParameter("accountpopup") != null && "true".equals(context.getRequest().getParameter("accountpopup"))) {
            accountpopup = true;
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, context.getRequest().getParameter("id"));
            if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            recordUpdated = thisContact.updateStatus(db, context, true, this.getUserId(context));
            this.invalidateUserData(context, this.getUserId(context));
            this.invalidateUserData(context, thisContact.getOwner());
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Delete Contact");
        context.getRequest().setAttribute("orgId", (Object)orgId);
        if (recordUpdated) {
            context.getRequest().setAttribute("refreshUrl", (Object)("Contacts.do?command=View&orgId=" + orgId + (accountpopup ? "&popup=true" : "")));
            this.deleteRecentItem(context, (Object)thisContact);
        }
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRestore(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-delete")) {
            return "PermissionError";
        }
        boolean recordUpdated = false;
        Contact thisContact = null;
        Organization thisOrganization = null;
        String orgId = null;
        if (context.getRequest().getParameter("orgId") != null) {
            orgId = context.getRequest().getParameter("orgId");
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, context.getRequest().getParameter("id"));
            if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            recordUpdated = thisContact.updateStatus(db, context, false, this.getUserId(context));
            this.invalidateUserData(context, this.getUserId(context));
            this.invalidateUserData(context, thisContact.getOwner());
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            context.getRequest().setAttribute("orgId", (Object)orgId);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordUpdated && context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
            return this.executeCommandView(context);
        }
        return "UpdateOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "Modify Contact");
        String passedId = context.getRequest().getParameter("id");
        Connection db = null;
        Contact newContact = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            newContact = (Contact)((Object)context.getFormBean());
            newContact.queryRecord(db, Integer.parseInt(passedId));
            if (!Contacts.isRecordAccessPermitted(context, db, newContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        block11: {
            if (!this.hasPermission(context, "accounts-accounts-contacts-edit")) {
                return "PermissionError";
            }
            Connection db = null;
            Contact thisContact = null;
            HtmlDialog htmlDialog = new HtmlDialog();
            int contactId = Integer.parseInt(context.getRequest().getParameter("id"));
            SystemStatus systemStatus = this.getSystemStatus(context);
            try {
                db = this.getConnection(context);
                thisContact = new Contact(db, contactId);
                if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                    String string = "PermissionError";
                    return string;
                }
                thisContact.checkUserAccount(db);
                if (thisContact.getPrimaryContact()) {
                    DependencyList dependencies = thisContact.processDependencies(db);
                    dependencies.setSystemStatus(systemStatus);
                    htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
                    htmlDialog.setHeader(systemStatus.getLabel("accounts.contacts.contactIndividualAccountHeader"));
                    htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
                    context.getSession().setAttribute("Dialog", (Object)htmlDialog);
                    String string = "ConfirmDeleteOK";
                    return string;
                }
                if (thisContact.getOrgId() > 0) {
                    int orgId = Integer.parseInt(context.getRequest().getParameter("neworgId"));
                    Organization organization = new Organization(db, orgId);
                    Contact.move(db, contactId, orgId, organization.getName(), this.getUserId(context));
                    break block11;
                }
                String orgId = "PermissionError";
                return orgId;
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                String string = "SystemError";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        return "MoveOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "View Contact Details");
        String orgid = context.getRequest().getParameter("orgId");
        if (orgid == null) {
            orgid = (String)context.getRequest().getAttribute("orgId");
        }
        String isPopup = context.getRequest().getParameter("popup");
        PagedListInfo companyDirectoryInfo = this.getPagedListInfo(context, "ContactListInfo");
        companyDirectoryInfo.setLink("Contacts.do?command=View&orgId=" + orgid + (isPopup != null && "true".equals(isPopup.trim()) ? "&popup=true" : ""));
        Connection db = null;
        ContactList contactList = new ContactList();
        Organization thisOrganization = null;
        this.resetPagedListInfo(context);
        try {
            db = this.getConnection(context);
            if (!Contacts.isRecordAccessPermitted(context, db, Integer.parseInt(orgid))) {
                String string = "PermissionError";
                return string;
            }
            thisOrganization = new Organization(db, Integer.parseInt(orgid));
            contactList.setPagedListInfo(companyDirectoryInfo);
            contactList.setOrgId(Integer.parseInt(orgid));
            contactList.setBuildDetails(true);
            contactList.setBuildTypes(false);
            if (thisOrganization.getTrashedDate() != null) {
                contactList.setIncludeOnlyTrashed(true);
            }
            contactList.buildList(db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("ContactList", (Object)contactList);
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return Contacts.getReturn(context, "List");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMessageDetails(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-messages-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "View Contact Details");
        Connection db = null;
        Organization thisOrganization = null;
        Contact thisContact = null;
        Campaign campaign = null;
        String campaignId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            String contactId = context.getRequest().getParameter("contactId");
            thisContact = new Contact(db, contactId);
            campaign = new Campaign(db, campaignId);
            context.getRequest().setAttribute("Campaign", (Object)campaign);
            if (!this.hasAuthority(context, campaign.getEnteredBy()) && !this.hasCampaignUserGroupAccess(db, campaign.getId(), this.getUserId(context))) {
                String string = "PermissionError";
                return string;
            }
            thisOrganization = new Organization(db, thisContact.getOrgId());
            if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return Contacts.getReturn(context, "MessageDetails");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewMessages(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-messages-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Organization thisOrganization = null;
        Contact thisContact = null;
        String contactId = context.getRequest().getParameter("contactId");
        if ("true".equals(context.getRequest().getParameter("contactId"))) {
            context.getSession().removeAttribute("AccountContactMessageListInfo");
        }
        String popup = context.getRequest().getParameter("popup");
        PagedListInfo pagedListInfo = this.getPagedListInfo(context, "AccountContactMessageListInfo");
        pagedListInfo.setLink("Contacts.do?command=ViewMessages&contactId=" + contactId + (popup != null && "true".equals(popup.trim()) ? "&popup=true" : ""));
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CampaignList campaignList = new CampaignList();
            campaignList.setPagedListInfo(pagedListInfo);
            campaignList.setCompleteOnly(true);
            campaignList.setContactId(Integer.parseInt(contactId));
            if ("all".equals(pagedListInfo.getListView())) {
                campaignList.setOwnerIdRange(this.getUserRange(context));
                campaignList.setUserGroupUserId(this.getUserId(context));
            } else {
                campaignList.setOwner(this.getUserId(context));
            }
            campaignList.buildList(db);
            context.getRequest().setAttribute("CampaignList", (Object)campaignList);
            thisOrganization = new Organization(db, thisContact.getOrgId());
            if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "View Contact Details");
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return Contacts.getReturn(context, "ViewMessages");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddCommunicationsPreference(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-messages-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Organization thisOrganization = null;
        Contact thisContact = null;
        String contactId = context.getRequest().getParameter("contactId");
        if ("true".equals(context.getRequest().getParameter("contactId"))) {
            context.getSession().removeAttribute("AccountContactMessageListInfo");
        }
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_communication_type");
            context.getRequest().setAttribute("typeSelect", (Object)list);
            context.getRequest().setAttribute("User", (Object)this.getUser(context, this.getUserId(context)));
            thisOrganization = new Organization(db, thisContact.getOrgId());
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Add Contact Communication Preference");
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        return "AddCommunicationsPreferenceOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveCommunicationsPreference(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-messages-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Organization thisOrganization = null;
        Contact thisContact = null;
        String contactId = context.getRequest().getParameter("contactId");
        if ("true".equals(context.getRequest().getParameter("contactId"))) {
            context.getSession().removeAttribute("AccountContactMessageListInfo");
        }
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            SystemStatus systemStatus = this.getSystemStatus(context);
            systemStatus.getLookupList(db, "lookup_communication_type");
            thisOrganization = new Organization(db, thisContact.getOrgId());
            CommunicationsPreference commPref = new CommunicationsPreference();
            commPref.setStartDay(context.getRequest().getParameter("startDay"));
            commPref.setEndDay(context.getRequest().getParameter("endDay"));
            commPref.setStartTimeHour(context.getRequest().getParameter("startTimeHour"), context.getRequest().getParameter("startTimeAMPM"));
            commPref.setEndTimeHour(context.getRequest().getParameter("endTimeHour"), context.getRequest().getParameter("endTimeAMPM"));
            commPref.setStartTimeMinute(context.getRequest().getParameter("startTimeMinute"));
            commPref.setEndTimeMinute(context.getRequest().getParameter("endTimeMinute"));
            commPref.setTimeZone(context.getRequest().getParameter("timeZone"));
            commPref.setTypeId(context.getRequest().getParameter("typeId"));
            commPref.setLevel(context.getRequest().getParameter("level"));
            commPref.setContactId(contactId);
            commPref.setEnteredBy(this.getUserId(context));
            commPref.setModifiedBy(this.getUserId(context));
            commPref.insert(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Add Contact Communication Preference");
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return "SaveCommunicationsPreferenceOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteCommunicationsPreference(ActionContext context) {
        String preferenceId;
        if (!this.hasPermission(context, "accounts-accounts-contacts-messages-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Organization thisOrganization = null;
        Contact thisContact = null;
        String contactId = context.getRequest().getParameter("contactId");
        if ("true".equals(context.getRequest().getParameter("contactId"))) {
            context.getSession().removeAttribute("AccountContactMessageListInfo");
        }
        if ((preferenceId = context.getRequest().getParameter("preferenceId")) == null) {
            preferenceId = (String)context.getRequest().getAttribute("preferenceId");
        }
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            SystemStatus systemStatus = this.getSystemStatus(context);
            systemStatus.getLookupList(db, "lookup_communication_type");
            thisOrganization = new Organization(db, thisContact.getOrgId());
            CommunicationsPreference commPref = new CommunicationsPreference();
            commPref.queryRecord(db, Integer.parseInt(preferenceId));
            commPref.delete(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Add Contact Communication Preference");
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return "DeleteCommunicationsPreferenceOK";
    }

    private void resetPagedListInfo(ActionContext context) {
        this.deletePagedListInfo(context, "AccountContactCallsListInfo");
        this.deletePagedListInfo(context, "AccountContactOppsPagedListInfo");
        this.deletePagedListInfo(context, "AccountContactMessageListInfo");
        this.deletePagedListInfo(context, "AccountContactCommunicationsListInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMoveToAccount(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-move-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Contact thisContact = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        HtmlDialog htmlDialog = new HtmlDialog();
        int contactId = Integer.parseInt(context.getRequest().getParameter("id"));
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            thisContact.checkUserAccount(db);
            DependencyList dependencies = thisContact.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + thisContact.getHtmlString(dependencies, systemStatus));
            if (thisContact.getPrimaryContact()) {
                htmlDialog.setHeader(systemStatus.getLabel("accounts.contacts.contactIndividualAccount.title"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
                context.getSession().setAttribute("Dialog", (Object)htmlDialog);
                String string = "ConfirmDeleteOK";
                return string;
            }
            if (!thisContact.canMoveContact(dependencies)) {
                htmlDialog.setHeader(systemStatus.getLabel("accounts.contacts.unableToMoveHeader"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
                context.getSession().setAttribute("Dialog", (Object)htmlDialog);
                String string = "ConfirmDeleteOK";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            context.getRequest().setAttribute("dependencies", (Object)dependencies);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "MoveToAccountOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMoveContact(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-move-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Contact thisContact = null;
        Object organization = null;
        int contactId = Integer.parseInt(context.getRequest().getParameter("id"));
        int moveOpportunities = Integer.parseInt(context.getRequest().getParameter("moveOpportunities"));
        int moveFolders = Integer.parseInt(context.getRequest().getParameter("moveFolders"));
        int moveActivities = Integer.parseInt(context.getRequest().getParameter("moveActivities"));
        int orgId = Integer.parseInt(context.getRequest().getParameter("neworgId"));
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            thisContact.setModifiedBy(this.getUserId(context));
            thisContact.moveContact(db, context, Contacts.getDbNamePath(context), orgId, moveOpportunities, moveFolders, moveActivities);
            thisContact.queryRecord(db, contactId);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "MoveContactOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrepareMessage(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-messages-view")) {
            return "PermissionError";
        }
        String contactId = context.getRequest().getParameter("contactId");
        Contact contact = null;
        Organization orgDetails = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            contact = new Contact(db, Integer.parseInt(contactId));
            if (!Contacts.isRecordAccessPermitted(context, db, contact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            orgDetails = new Organization(db, contact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "CreateMessageOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSendMessage(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-messages-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Contact recipient = null;
        Organization orgDetails = null;
        String contactId = context.getRequest().getParameter("contactId");
        try {
            db = this.getConnection(context);
            recipient = new Contact(db, Integer.parseInt(contactId));
            if (!Contacts.isRecordAccessPermitted(context, db, recipient.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)recipient);
            orgDetails = new Organization(db, recipient.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SendMessageOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddFolderRecord(ActionContext context) {
        Organization thisOrganization;
        Contact thisContact;
        Connection db;
        block7: {
            block6: {
                db = null;
                thisContact = null;
                thisOrganization = null;
                SystemStatus systemStatus = this.getSystemStatus(context);
                context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
                String contactId = context.getRequest().getParameter("contactId");
                db = this.getConnection(context);
                thisContact = new Contact(db, contactId);
                if (this.hasPermission(context, "accounts-accounts-contacts-folders-add") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-edit"))) break block6;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) break block7;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            String selectedCatId = context.getRequest().getParameter("catId");
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(2);
            thisCategory.setLinkItemId(thisContact.getId());
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            context.getRequest().setAttribute("Category", (Object)thisCategory);
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "External Contacts", "Add Folder Record");
        return Contacts.getReturn(context, "AddFolderRecord");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandFolderList(ActionContext context) {
        Organization thisOrganization;
        Contact thisContact;
        Connection db;
        block6: {
            if (!this.hasPermission(context, "accounts-accounts-contacts-folders-view")) {
                return "PermissionError";
            }
            db = null;
            thisContact = null;
            thisOrganization = null;
            String contactId = context.getRequest().getParameter("contactId");
            db = this.getConnection(context);
            thisContact = new Contact(db, Integer.parseInt(contactId));
            if (Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) break block6;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(2);
            thisList.setLinkItemId(thisContact.getId());
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.setBuildTotalNumOfRecords(true);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "Contacts", "Custom Fields Details");
        return Contacts.getReturn(context, "FolderList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandFields(ActionContext context) {
        String contactId;
        Organization thisOrganization;
        String selectedCatId;
        boolean showRecords;
        String recordId;
        Contact thisContact;
        Connection db;
        block20: {
            block19: {
                block18: {
                    db = null;
                    thisContact = null;
                    recordId = null;
                    showRecords = true;
                    selectedCatId = null;
                    thisOrganization = null;
                    contactId = context.getRequest().getParameter("contactId");
                    db = this.getConnection(context);
                    thisContact = new Contact(db, contactId);
                    if (this.hasPermission(context, "accounts-accounts-contacts-folders-view") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-view"))) break block18;
                    String string = "PermissionError";
                    this.freeConnection(context, db);
                    return string;
                }
                if (this.hasAuthority(db, context, (Object)thisContact)) break block19;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) break block20;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(2);
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
            selectedCatId = context.getRequest().getParameter("catId");
            if (selectedCatId == null) {
                selectedCatId = (String)context.getRequest().getAttribute("catId");
            }
            if (selectedCatId == null) {
                selectedCatId = String.valueOf(thisList.getDefaultCategoryId());
            }
            context.getRequest().setAttribute("catId", (Object)selectedCatId);
            if (Integer.parseInt(selectedCatId) > 0) {
                recordId = context.getRequest().getParameter("recId");
                String recordDeleted = (String)context.getRequest().getAttribute("recordDeleted");
                if (recordDeleted != null) {
                    recordId = null;
                }
                CustomFieldCategory thisCategory = thisList.getCategory(Integer.parseInt(selectedCatId));
                if (recordId == null && thisCategory.getAllowMultipleRecords()) {
                    PagedListInfo folderListInfo = this.getPagedListInfo(context, "ContactFolderInfo");
                    folderListInfo.setLink("ExternalContacts.do?command=Fields&contactId=" + contactId + "&catId=" + selectedCatId);
                    CustomFieldRecordList recordList = new CustomFieldRecordList();
                    recordList.setLinkModuleId(2);
                    recordList.setLinkItemId(thisContact.getId());
                    recordList.setCategoryId(thisCategory.getId());
                    recordList.buildList(db);
                    recordList.buildRecordColumns(db, thisCategory);
                    context.getRequest().setAttribute("Records", (Object)recordList);
                } else {
                    thisCategory.setLinkModuleId(2);
                    thisCategory.setLinkItemId(thisContact.getId());
                    if (recordId != null) {
                        thisCategory.setRecordId(Integer.parseInt(recordId));
                    } else {
                        thisCategory.buildRecordId(db);
                        recordId = String.valueOf(thisCategory.getRecordId());
                    }
                    thisCategory.setIncludeEnabled(1);
                    thisCategory.setIncludeScheduled(1);
                    thisCategory.setBuildResources(true);
                    thisCategory.buildResources(db);
                    showRecords = false;
                    if (thisCategory.getRecordId() > -1) {
                        CustomFieldRecord thisRecord = new CustomFieldRecord(db, thisCategory.getRecordId());
                        context.getRequest().setAttribute("Record", (Object)thisRecord);
                    }
                }
                context.getRequest().setAttribute("Category", (Object)thisCategory);
            }
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "External Contacts", "Custom Fields Details");
        if (Integer.parseInt(selectedCatId) <= 0) {
            return Contacts.getReturn(context, "FieldsEmpty");
        }
        if (recordId == null && showRecords) {
            return Contacts.getReturn(context, "FieldRecordList");
        }
        return Contacts.getReturn(context, "Fields");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyFields(ActionContext context) {
        String recordId;
        String selectedCatId;
        Organization thisOrganization;
        Contact thisContact;
        Connection db;
        block10: {
            block9: {
                block8: {
                    db = null;
                    thisContact = null;
                    thisOrganization = null;
                    selectedCatId = context.getRequest().getParameter("catId");
                    recordId = context.getRequest().getParameter("recId");
                    SystemStatus systemStatus = this.getSystemStatus(context);
                    context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
                    String contactId = context.getRequest().getParameter("contactId");
                    db = this.getConnection(context);
                    thisContact = new Contact(db, contactId);
                    if (this.hasPermission(context, "accounts-accounts-contacts-folders-edit") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-edit"))) break block8;
                    String string = "PermissionError";
                    this.freeConnection(context, db);
                    return string;
                }
                if (this.hasAuthority(db, context, (Object)thisContact)) break block9;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) break block10;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(2);
            thisCategory.setLinkItemId(thisContact.getId());
            thisCategory.setRecordId(Integer.parseInt(recordId));
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            context.getRequest().setAttribute("Category", (Object)thisCategory);
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "External Contacts", "Modify Custom Fields");
        if (recordId.equals("-1")) {
            return Contacts.getReturn(context, "AddFolderRecord");
        }
        return Contacts.getReturn(context, "ModifyFields");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateFields(ActionContext context) {
        int resultCount;
        Connection db;
        block18: {
            String string;
            boolean isValid;
            Organization thisOrganization;
            Contact thisContact;
            block17: {
                block16: {
                    block15: {
                        db = null;
                        thisContact = null;
                        thisOrganization = null;
                        resultCount = 0;
                        SystemStatus systemStatus = this.getSystemStatus(context);
                        context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
                        isValid = false;
                        String contactId = context.getRequest().getParameter("contactId");
                        db = this.getConnection(context);
                        thisContact = new Contact(db, contactId);
                        if (this.hasPermission(context, "accounts-accounts-contacts-folders-edit") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-edit"))) break block15;
                        String string2 = "PermissionError";
                        this.freeConnection(context, db);
                        return string2;
                    }
                    if (this.hasAuthority(db, context, (Object)thisContact)) break block16;
                    String string3 = "PermissionError";
                    this.freeConnection(context, db);
                    return string3;
                }
                if (Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) break block17;
                String string4 = "PermissionError";
                this.freeConnection(context, db);
                return string4;
            }
            try {
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
                CustomFieldCategoryList thisList = new CustomFieldCategoryList();
                thisList.setLinkModuleId(2);
                thisList.setIncludeEnabled(1);
                thisList.setIncludeScheduled(1);
                thisList.setBuildResources(false);
                thisList.buildList(db);
                context.getRequest().setAttribute("CategoryList", (Object)thisList);
                String selectedCatId = context.getRequest().getParameter("catId");
                String recordId = context.getRequest().getParameter("recId");
                context.getRequest().setAttribute("catId", (Object)selectedCatId);
                CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
                thisCategory.setLinkModuleId(2);
                thisCategory.setLinkItemId(thisContact.getId());
                thisCategory.setRecordId(Integer.parseInt(recordId));
                thisCategory.setIncludeEnabled(1);
                thisCategory.setIncludeScheduled(1);
                thisCategory.setBuildResources(true);
                thisCategory.buildResources(db);
                thisCategory.setParameters(context);
                thisCategory.setModifiedBy(this.getUserId(context));
                if (!thisCategory.getReadOnly()) {
                    thisCategory.setCanNotContinue(true);
                    isValid = this.validateObject(context, db, thisCategory);
                    if (isValid) {
                        for (CustomFieldGroup group : thisCategory) {
                            for (CustomField field : group) {
                                field.setValidateData(true);
                                field.setRecordId(thisCategory.getRecordId());
                                isValid = this.validateObject(context, db, field) && isValid;
                            }
                        }
                    }
                    if (isValid && resultCount != -1) {
                        thisCategory.setCanNotContinue(true);
                        resultCount = thisCategory.update(db);
                        thisCategory.setCanNotContinue(false);
                        resultCount = thisCategory.insertGroup(db, thisCategory.getRecordId());
                    }
                }
                context.getRequest().setAttribute("Category", (Object)thisCategory);
                thisOrganization = new Organization(db, thisContact.getOrgId());
                context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
                if (resultCount != -1 && isValid) {
                    thisCategory.buildResources(db);
                    CustomFieldRecord thisRecord = new CustomFieldRecord(db, thisCategory.getRecordId());
                    context.getRequest().setAttribute("Record", (Object)thisRecord);
                    break block18;
                }
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Contacts-> ModifyField validation error");
                }
                context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
                string = Contacts.getReturn(context, "ModifyFields");
            }
            catch (Exception errorMessage) {
                String string5;
                try {
                    context.getRequest().setAttribute("Error", (Object)errorMessage);
                    string5 = "SystemError";
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
                return string5;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (resultCount == 1) {
            return Contacts.getReturn(context, "UpdateFields");
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertFields(ActionContext context) {
        Organization thisOrganization;
        Contact thisContact;
        int resultCode;
        Connection db;
        block19: {
            boolean isValid;
            block18: {
                block17: {
                    db = null;
                    resultCode = -1;
                    thisContact = null;
                    thisOrganization = null;
                    SystemStatus systemStatus = this.getSystemStatus(context);
                    context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
                    isValid = false;
                    String contactId = context.getRequest().getParameter("contactId");
                    db = this.getConnection(context);
                    thisContact = new Contact(db, contactId);
                    if (this.hasPermission(context, "accounts-accounts-contacts-folders-add") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-edit"))) break block17;
                    String string = "PermissionError";
                    this.freeConnection(context, db);
                    return string;
                }
                if (Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) break block18;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(2);
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
            String selectedCatId = context.getRequest().getParameter("catId");
            context.getRequest().setAttribute("catId", (Object)selectedCatId);
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(2);
            thisCategory.setLinkItemId(thisContact.getId());
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            thisCategory.setParameters(context);
            thisCategory.setEnteredBy(this.getUserId(context));
            thisCategory.setModifiedBy(this.getUserId(context));
            if (!thisCategory.getReadOnly()) {
                thisCategory.setCanNotContinue(true);
                isValid = this.validateObject(context, db, thisCategory);
                if (isValid) {
                    resultCode = thisCategory.insert(db);
                    for (CustomFieldGroup group : thisCategory) {
                        for (CustomField field : group) {
                            field.setValidateData(true);
                            field.setRecordId(thisCategory.getRecordId());
                            isValid = this.validateObject(context, db, field) && isValid;
                        }
                    }
                }
                thisCategory.setCanNotContinue(false);
                if (isValid && resultCode != -1) {
                    resultCode = thisCategory.insertGroup(db, thisCategory.getRecordId());
                }
            }
            if (resultCode == -1 && System.getProperty("DEBUG") != null) {
                System.out.println("Contacts-> InsertField validation error");
            }
            context.getRequest().setAttribute("Category", (Object)thisCategory);
            if (resultCode != -1 && isValid) {
                this.processInsertHook(context, thisCategory);
                break block19;
            }
            if (thisCategory.getRecordId() != -1) {
                CustomFieldRecord record = new CustomFieldRecord(db, thisCategory.getRecordId());
                record.delete(db);
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Contacts-> InsertField validation error");
            }
            context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
            String string = Contacts.getReturn(context, "AddFolderRecord");
            this.freeConnection(context, db);
            return string;
        }
        try {
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (resultCode == -1) {
            return Contacts.getReturn(context, "AddFolderRecord");
        }
        return this.executeCommandFields(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteFields(ActionContext context) {
        Connection db = null;
        boolean recordDeleted = false;
        Organization thisOrganization = null;
        try {
            db = this.getConnection(context);
            String selectedCatId = context.getRequest().getParameter("catId");
            String recordId = context.getRequest().getParameter("recId");
            String contactId = context.getRequest().getParameter("contactId");
            Contact thisContact = new Contact(db, Integer.parseInt(contactId));
            if (!this.hasPermission(context, "accounts-accounts-contacts-folders-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-edit")) {
                String string = "PermissionError";
                return string;
            }
            if (!Contacts.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            CustomFieldRecord thisRecord = new CustomFieldRecord(db, Integer.parseInt(recordId));
            thisRecord.setLinkModuleId(2);
            thisRecord.setLinkItemId(Integer.parseInt(contactId));
            thisRecord.setCategoryId(Integer.parseInt(selectedCatId));
            if (!thisCategory.getReadOnly()) {
                recordDeleted = thisRecord.delete(db);
            }
            context.getRequest().setAttribute("recordDeleted", (Object)"true");
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DeleteFieldsOK";
    }

    private void addFormElements(ActionContext context, Connection db, SystemStatus systemStatus, Contact tmpContact) throws Exception {
        LookupList siteid = new LookupList(db, "lookup_site_id");
        siteid.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SiteIdList", (Object)siteid);
        LookupList contactTypeList = new LookupList(db, "lookup_contact_types");
        contactTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("ContactTypeList2", (Object)contactTypeList);
        LookupList contactSourceList = new LookupList(db, "lookup_contact_source");
        context.getRequest().setAttribute("ContactSourceList", (Object)contactSourceList);
        LookupList salutationList = new LookupList(db, "lookup_title");
        salutationList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SalutationList", (Object)salutationList);
        Organization thisOrganization = null;
        thisOrganization = new Organization(db, tmpContact.getOrgId());
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
    }
}

