/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.RoleList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactEmailAddress;
import org.aspcfs.modules.contacts.base.ContactEmailAddressList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;

public final class ContactsPortal
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "portal-user-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            String id = context.getRequest().getParameter("contactId");
            thisContact = new Contact(db, id);
            if (!ContactsPortal.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            User thisPortalUser = new User();
            if (thisContact.getUserId() > -1) {
                thisPortalUser.buildRecord(db, thisContact.getUserId());
            }
            this.setOrganization(context, db, thisContact.getOrgId());
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            context.getRequest().setAttribute("portalUserDetails", (Object)thisPortalUser);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ContactsPortal.getReturn(context, "ViewContactPortal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "portal-user-add")) {
            return "PermissionError";
        }
        Connection db = null;
        Contact thisContact = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            String id = context.getRequest().getParameter("contactId");
            thisContact = id != null ? new Contact(db, id) : (Contact)((Object)context.getFormBean());
            if (!ContactsPortal.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            this.setOrganization(context, db, thisContact.getOrgId());
            ContactEmailAddressList emailList = thisContact.getEmailAddressList();
            if (emailList.size() == 0) {
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
                String string = "ContactPortalError";
                return string;
            }
            RoleList roleList = new RoleList();
            roleList.setExcludeRoleType(0);
            roleList.setEnabledState(1);
            roleList.buildList(db);
            roleList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("roleList", (Object)roleList);
            thisContact.getEmailAddressList().setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ContactsPortal.getReturn(context, "AddContactPortal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "portal-user-add")) {
            return "PermissionError";
        }
        Connection db = null;
        Contact thisContact = null;
        boolean inserted = false;
        try {
            db = this.getConnection(context);
            String id = context.getRequest().getParameter("contactId");
            thisContact = new Contact(db, id);
            if (!ContactsPortal.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            inserted = this.insertUser(context, db, thisContact);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (inserted) {
            return this.executeCommandView(context);
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "portal-user-edit")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        Contact thisContact = null;
        User thisPortalUser = null;
        try {
            db = this.getConnection(context);
            String id = context.getRequest().getParameter("contactId");
            thisContact = new Contact(db, id);
            if (!ContactsPortal.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            this.setOrganization(context, db, thisContact.getOrgId());
            ContactEmailAddressList emailList = thisContact.getEmailAddressList();
            if (emailList.size() == 0) {
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
                String string = "ContactPortalError";
                return string;
            }
            thisPortalUser = (User)((Object)context.getRequest().getAttribute("portalUserDetails"));
            if (thisPortalUser == null) {
                thisPortalUser = new User();
                thisPortalUser.buildRecord(db, thisContact.getUserId());
            }
            RoleList roleList = new RoleList();
            roleList.setExcludeRoleType(0);
            roleList.setEnabledState(1);
            roleList.buildList(db);
            roleList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("roleList", (Object)roleList);
            thisContact.getEmailAddressList().setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            context.getRequest().setAttribute("portalUserDetails", (Object)thisPortalUser);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ContactsPortal.getReturn(context, "ModifyContactPortal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "portal-user-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        Contact oldContactInfo = null;
        User oldUserInfo = null;
        int resultCount = -1;
        try {
            db = this.getConnection(context);
            String id = context.getRequest().getParameter("contactId");
            oldContactInfo = new Contact(db, id);
            if (!ContactsPortal.isRecordAccessPermitted(context, db, oldContactInfo.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            oldUserInfo = new User();
            oldUserInfo.buildRecord(db, oldContactInfo.getUserId());
            resultCount = this.updateUser(context, db, oldContactInfo, oldUserInfo);
            this.setOrganization(context, db, oldContactInfo.getOrgId());
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == 1) {
            return this.executeCommandView(context);
        }
        return this.executeCommandModify(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "portal-user-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return ContactsPortal.getReturn(context, "DeleteContactPortal");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDisable(ActionContext context) {
        if (!this.hasPermission(context, "portal-user-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        User thisUser = null;
        Contact thisContact = null;
        boolean recordCount = false;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            String id = context.getRequest().getParameter("contactId");
            thisContact = new Contact(db, id);
            if (!ContactsPortal.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            this.setOrganization(context, db, thisContact.getOrgId());
            ContactEmailAddressList emailList = thisContact.getEmailAddressList();
            if (emailList.size() == 0) {
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
                String string = "ContactPortalError";
                return string;
            }
            thisUser = new User(db, context.getRequest().getParameter("userId"));
            recordCount = thisUser.disable(db);
            if (recordCount) {
                ContactEmailAddress emailAddress = this.getAddressToEmail(thisContact);
                SMTPMessage mail = new SMTPMessage();
                mail.setHost(ApplicationPrefs.getPref(context.getServletContext(), "MAILSERVER"));
                mail.setFrom(ApplicationPrefs.getPref(context.getServletContext(), "EMAILADDRESS"));
                mail.setType("text/html");
                mail.setTo(emailAddress.getEmail());
                mail.setSubject(systemStatus.getLabel("mail.subject.loginInformation"));
                mail.setBody(systemStatus.getLabel("mail.body.accountDisabled"));
                if (mail.send() == 2) {
                    System.err.println(mail.getErrorMsg());
                }
            } else {
                thisUser.getErrors().put("actionError", systemStatus.getLabel("object.validation.actionError.userNotDisabled"));
                this.processErrors(context, thisUser.getErrors());
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandEnable(ActionContext context) {
        if (!this.hasPermission(context, "portal-user-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        User thisUser = null;
        Contact thisContact = null;
        boolean recordCount = false;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            String id = context.getRequest().getParameter("contactId");
            thisContact = new Contact(db, id);
            if (!ContactsPortal.isRecordAccessPermitted(context, db, thisContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            ContactEmailAddressList emailList = thisContact.getEmailAddressList();
            if (emailList.size() == 0) {
                context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
                String string = "ContactPortalError";
                return string;
            }
            thisUser = new User(db, context.getRequest().getParameter("userId"));
            recordCount = thisUser.enable(db);
            if (recordCount) {
                ContactEmailAddress emailAddress = this.getAddressToEmail(thisContact);
                SMTPMessage mail = new SMTPMessage();
                mail.setHost(ApplicationPrefs.getPref(context.getServletContext(), "MAILSERVER"));
                mail.setFrom(ApplicationPrefs.getPref(context.getServletContext(), "EMAILADDRESS"));
                mail.setType("text/html");
                mail.setTo(emailAddress.getEmail());
                mail.setSubject(systemStatus.getLabel("mail.subject.loginInformation"));
                mail.setBody(systemStatus.getLabel("mail.body.accountEnabled"));
                if (mail.send() == 2) {
                    System.err.println(mail.getErrorMsg());
                }
            } else {
                thisUser.getErrors().put("actionError", systemStatus.getLabel("object.validation.actionError.userNotEnabled"));
                this.processErrors(context, thisUser.getErrors());
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandView(context);
    }

    private void setOrganization(ActionContext context, Connection db, int tmpOrgId) throws SQLException {
        Organization thisOrganization = null;
        thisOrganization = new Organization(db, tmpOrgId);
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
    }

    private ContactEmailAddress getAddressToEmail(Contact thisContact) {
        ContactEmailAddressList emailList = thisContact.getEmailAddressList();
        Iterator itr = emailList.iterator();
        ContactEmailAddress emailAddress = null;
        while (itr.hasNext() && !(emailAddress = (ContactEmailAddress)((Object)itr.next())).getPrimaryEmail()) {
        }
        return emailAddress;
    }

    private boolean insertUser(ActionContext context, Connection db, Contact thisContact) throws Exception {
        boolean recordInserted = false;
        SystemStatus systemStatus = this.getSystemStatus(context);
        User newUser = new User();
        newUser.setContactId(thisContact.getId());
        newUser.setRoleId(context.getRequest().getParameter("roleId"));
        String username = thisContact.getNameLast().toLowerCase();
        int n = User.getNumberOfSimilarUsernames(db, username);
        newUser.setUsername(username + String.valueOf(n + 1));
        String password = thisContact.getNameLast().toLowerCase() + String.valueOf(StringUtils.rand(1, 9999));
        newUser.setPassword1(password);
        newUser.setPassword2(password);
        newUser.setTimeZoneForDateFields(context.getRequest(), context.getRequest().getParameter("expires"), "expires");
        newUser.setEnteredBy(this.getUserId(context));
        newUser.setModifiedBy(this.getUserId(context));
        newUser.setTimeZone(ContactsPortal.getPref(context, "SYSTEM.TIMEZONE"));
        newUser.setCurrency(ContactsPortal.getPref(context, "SYSTEM.CURRENCY"));
        newUser.setSiteId(thisContact.getSiteId());
        newUser.setLanguage(ContactsPortal.getPref(context, systemStatus.getLanguage()));
        recordInserted = newUser.insert(db, context);
        if (recordInserted) {
            int emailAddressId = Integer.parseInt(context.getRequest().getParameter("emailAddressId"));
            ContactEmailAddress emailAddress = null;
            emailAddress = emailAddressId != -1 ? new ContactEmailAddress(db, emailAddressId) : this.getAddressToEmail(thisContact);
            context.getRequest().setAttribute("UserRecord", (Object)newUser);
            this.updateSystemHierarchyCheck(db, context);
            SMTPMessage mail = new SMTPMessage();
            mail.setHost(ApplicationPrefs.getPref(context.getServletContext(), "MAILSERVER"));
            mail.setFrom(ApplicationPrefs.getPref(context.getServletContext(), "EMAILADDRESS"));
            mail.setType("text/html");
            mail.setTo(emailAddress.getEmail());
            mail.setSubject(systemStatus.getLabel("mail.subject.loginInformation"));
            String message = systemStatus.getLabel("mail.body.userAccountCreationMessage");
            if (message != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("${user.username}", newUser.getUsername());
                map.put("${password}", password);
                map.put("${url}", "<a href=\"" + systemStatus.getUrl() + "\">");
                map.put("${endUrl}", "</a>");
                Template template = new Template(message);
                template.setParseElements(map);
                mail.setBody(template.getParsedText());
            } else {
                mail.setBody("A self-service account has been created for you.<br /><br />Your account username is: " + newUser.getUsername() + "<br />" + "Your password is: " + password + "<br /><br />" + "Click <a href=\"" + systemStatus.getUrl() + "\">here</a> to visit the site");
            }
            if (mail.send() == 2) {
                System.err.println(mail.getErrorMsg());
            }
        } else {
            this.processErrors(context, newUser.getErrors());
            context.getRequest().setAttribute("portalUserDetails", (Object)newUser);
            return false;
        }
        return true;
    }

    private int updateUser(ActionContext context, Connection db, Contact thisContact, User thisUser) throws Exception {
        boolean roleChanged = false;
        boolean expirationDateChanged = false;
        boolean newPassword = false;
        User newUser = new User();
        SystemStatus systemStatus = this.getSystemStatus(context);
        int newRoleId = Integer.parseInt(context.getRequest().getParameter("roleId"));
        if (thisUser.getRoleId() != newRoleId) {
            roleChanged = true;
            newUser.setRoleId(newRoleId);
        } else {
            newUser.setRoleId(thisUser.getRoleId());
        }
        String tmpExpires = context.getRequest().getParameter("expires");
        if (thisUser.getExpires() == null && !"".equals(tmpExpires)) {
            expirationDateChanged = true;
            newUser.setTimeZoneForDateFields(context.getRequest(), tmpExpires, "expires");
        } else if (thisUser.getExpires() != null && "".equals(tmpExpires)) {
            expirationDateChanged = true;
        } else if (thisUser.getExpires() != null && !"".equals(tmpExpires)) {
            newUser.setTimeZoneForDateFields(context.getRequest(), tmpExpires, "expires");
            if (!thisUser.getExpires().equals(newUser.getExpires())) {
                expirationDateChanged = true;
            }
        }
        String password = null;
        if (DatabaseUtils.parseBoolean(context.getRequest().getParameter("autoGenerate"))) {
            newPassword = true;
            password = thisContact.getNameLast().toLowerCase() + String.valueOf(StringUtils.rand(1, 9999));
            newUser.setPassword1(password);
            newUser.setPassword2(password);
        }
        roleChanged = false;
        if (false) {
            expirationDateChanged = false;
            if (false) {
                newPassword = false;
                if (false) {
                    return 1;
                }
            }
        }
        newUser.setModifiedBy(this.getUserId(context));
        newUser.setModified(context.getRequest().getParameter("modified"));
        newUser.setUsername(thisUser.getUsername());
        newUser.setId(Integer.parseInt(context.getRequest().getParameter("userId")));
        int resultCount = -1;
        resultCount = newUser.updatePortalUser(db);
        if (resultCount == 1) {
            String url;
            Template template;
            HashMap<String, String> map;
            String message;
            newUser = new User(db, newUser.getId());
            int emailAddressId = Integer.parseInt(context.getRequest().getParameter("emailAddressId"));
            ContactEmailAddress emailAddress = null;
            emailAddress = emailAddressId != -1 ? new ContactEmailAddress(db, emailAddressId) : this.getAddressToEmail(thisContact);
            context.getRequest().setAttribute("UserRecord", (Object)newUser);
            this.updateSystemHierarchyCheck(db, context);
            SMTPMessage mail = new SMTPMessage();
            mail.setHost(ApplicationPrefs.getPref(context.getServletContext(), "MAILSERVER"));
            mail.setFrom(ApplicationPrefs.getPref(context.getServletContext(), "EMAILADDRESS"));
            mail.setType("text/html");
            mail.setTo(emailAddress.getEmail());
            String mailBody = "";
            mail.setSubject(systemStatus.getLabel("mail.subject.loginInformation"));
            mailBody = mailBody + systemStatus.getLabel("mail.body.loginInformationChanged");
            if (roleChanged) {
                mailBody = mailBody + systemStatus.getLabel("mail.body.accountLoginUpdated");
            }
            if (expirationDateChanged) {
                if ("".equals(tmpExpires.trim())) {
                    mailBody = mailBody + systemStatus.getLabel("mail.body.expirationRemoved");
                } else {
                    message = systemStatus.getLabel("mail.body.accountExpiresOn");
                    map = new HashMap();
                    map.put("${expiration}", tmpExpires);
                    template = new Template(message);
                    template.setParseElements(map);
                    mailBody = mailBody + template.getParsedText();
                }
            }
            if (newPassword) {
                message = systemStatus.getLabel("mail.body.newPasswordIs");
                map = new HashMap<String, String>();
                map.put("${password}", password);
                template = new Template(message);
                template.setParseElements(map);
                mailBody = mailBody + template.getParsedText();
            }
            if ((url = systemStatus.getLabel("mail.body.thisIsTheURL")) != null && !"".equals(url)) {
                map = new HashMap();
                map.put("${url}", "<a href=\"" + systemStatus.getUrl() + "\">");
                map.put("${endUrl}", "</a>");
                template = new Template(url);
                template.setParseElements(map);
                mailBody = mailBody + template.getParsedText();
            } else {
                mailBody = mailBody + "Click <a href=\"" + systemStatus.getUrl() + "\">here</a> to visit the site.<br />";
            }
            mail.setBody(mailBody);
            if (mail.send() == 2) {
                System.err.println(mail.getErrorMsg());
            }
        } else {
            this.processErrors(context, newUser.getErrors());
            context.getRequest().setAttribute("portalUserDetails", (Object)newUser);
        }
        return resultCount;
    }
}

