/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityComponentList;
import org.aspcfs.modules.pipeline.base.OpportunityComponentLog;
import org.aspcfs.modules.pipeline.base.OpportunityComponentLogList;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.pipeline.base.OpportunityHeaderList;
import org.aspcfs.modules.pipeline.beans.OpportunityBean;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class Opportunities
extends CFSModule {
    public String executeCommandHome(ActionContext context) {
        this.addModuleBean(context, "Opportunities", "Opportunities Home");
        return "HomeOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-opportunities-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String orgId = context.getRequest().getParameter("orgId");
        this.addModuleBean(context, "View Accounts", "View Opportunity Details");
        boolean isPopup = context.getRequest().getParameter("popup") != null && "true".equals(context.getRequest().getParameter("popup"));
        PagedListInfo oppPagedInfo = this.getPagedListInfo(context, "OpportunityPagedInfo");
        oppPagedInfo.setLink("Opportunities.do?command=View&orgId=" + orgId + (isPopup ? "&popup=true" : ""));
        Connection db = null;
        OpportunityHeaderList oppList = new OpportunityHeaderList();
        Organization thisOrganization = null;
        try {
            db = this.getConnection(context);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            oppList.setPagedListInfo(oppPagedInfo);
            oppList.setAllowMultipleComponents(this.allowMultiple(context));
            oppList.setOrgId(orgId);
            oppList.setBuildTotalValues(true);
            if (thisOrganization.isTrashed()) {
                oppList.setIncludeOnlyTrashed(true);
            }
            if ("".equals(oppPagedInfo.getListView()) || oppPagedInfo.getListView() == null) {
                oppPagedInfo.setListView("all");
            }
            if ("my".equals(oppPagedInfo.getListView())) {
                oppList.setControlledHierarchyOnly(-1);
                oppList.setOwner(this.getUserId(context));
                oppList.setQueryOpenOnly(true);
            } else if ("closed".equals(oppPagedInfo.getListView())) {
                if (!this.excludeHierarchy(context)) {
                    oppList.setControlledHierarchy(0, this.getUserRange(context));
                }
                oppList.setAccessType(accessTypeList.getCode(626030334));
                oppList.setQueryClosedOnly(true);
            } else {
                if (!this.excludeHierarchy(context)) {
                    oppList.setControlledHierarchy(0, this.getUserRange(context));
                }
                oppList.setAccessType(accessTypeList.getCode(626030334));
                oppList.setQueryOpenOnly(true);
            }
            oppList.buildList(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("OpportunityHeaderList", (Object)oppList);
            return Opportunities.getReturn(context, "List");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveComponent(ActionContext context) {
        boolean recordInserted = false;
        boolean isValid = false;
        int resultCount = 0;
        Organization thisOrg = null;
        String orgId = null;
        String permission = "accounts-accounts-opportunities-add";
        Connection db = null;
        OpportunityBean bean = new OpportunityBean();
        OpportunityComponent newComponent = (OpportunityComponent)((Object)context.getFormBean());
        OpportunityHeader header = null;
        String action = newComponent.getId() == -1 ? "insert" : "modify";
        SystemStatus systemStatus = this.getSystemStatus(context);
        if (context.getRequest().getParameter("orgId") != null) {
            orgId = context.getRequest().getParameter("orgId");
        }
        if ("modify".equals(action)) {
            permission = "accounts-accounts-opportunities-edit";
        }
        if (!this.hasPermission(context, permission)) {
            return "PermissionError";
        }
        if (!systemStatus.hasField("opportunity.componentTypes")) {
            newComponent.setTypeList(context.getRequest().getParameterValues("selectedList"));
        }
        newComponent.setEnteredBy(this.getUserId(context));
        newComponent.setModifiedBy(this.getUserId(context));
        try {
            db = this.getConnection(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            header = new OpportunityHeader(db, newComponent.getHeaderId());
            bean.setHeader(header);
            newComponent.setContactId(header.getContactLink());
            newComponent.setOrgId(header.getAccountLink());
            if ("insert".equals(action)) {
                if (!this.hasAuthority(context, header.getManager())) {
                    String string = "PermissionError";
                    return string;
                }
                bean.setComponent(newComponent);
                isValid = this.validateObject(context, db, (Object)bean);
                boolean bl = isValid = this.validateObject(context, db, (Object)newComponent) && isValid;
                if (isValid) {
                    recordInserted = newComponent.insert(db, context);
                }
                if (recordInserted) {
                    this.processInsertHook(context, (Object)newComponent);
                    this.addRecentItem(context, (Object)newComponent);
                }
            } else {
                OpportunityComponent oldComponent = new OpportunityComponent(db, newComponent.getId());
                if (!this.hasAuthority(context, oldComponent.getOwner()) && !this.hasAuthority(context, header.getManager())) {
                    String string = "PermissionError";
                    return string;
                }
                newComponent.setModifiedBy(this.getUserId(context));
                bean.setComponent(newComponent);
                isValid = this.validateObject(context, db, (Object)bean);
                boolean bl = isValid = this.validateObject(context, db, (Object)newComponent) && isValid;
                if (isValid) {
                    resultCount = newComponent.update(db, context);
                }
                if (resultCount == 1) {
                    newComponent.queryRecord(db, newComponent.getId());
                    this.processUpdateHook(context, (Object)oldComponent, (Object)newComponent);
                }
            }
            if ("insert".equals(action) && !recordInserted || "modify".equals(action) && resultCount == -1) {
                LookupList typeSelect = new LookupList(db, "lookup_opportunity_types");
                context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
                context.getRequest().setAttribute("TypeList", (Object)newComponent.getTypeList());
            }
            thisOrg = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrg);
            context.getRequest().setAttribute("ComponentDetails", (Object)newComponent);
            if (resultCount == 1 || recordInserted) {
                OpportunityHeader oppHeader = new OpportunityHeader(db, newComponent.getHeaderId());
                context.getRequest().setAttribute("OpportunityHeader", (Object)oppHeader);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if ("insert".equals(action)) {
            if (recordInserted) {
                return this.executeCommandDetails(context);
            }
            return this.executeCommandPrepare(context);
        }
        if (resultCount == 1) {
            boolean isAccountPopup;
            boolean bl = isAccountPopup = context.getRequest().getParameter("popupType") != null && "inline".equals(context.getRequest().getParameter("popupType"));
            if (context.getRequest().getParameter("popup") != null && !isAccountPopup) {
                return "CloseAddPopup";
            }
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                return this.executeCommandDetails(context);
            }
            return Opportunities.getReturn(context, "DetailsComponent");
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandPrepare(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-opportunities-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "Add Opportunity");
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrepare(ActionContext context) {
        String orgId = context.getRequest().getParameter("orgId");
        String headerId = context.getRequest().getParameter("headerId");
        String permission = "accounts-accounts-opportunities-add";
        Organization thisOrganization = null;
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        if (headerId != null && !"-1".equals(headerId)) {
            permission = "accounts-accounts-opportunities-edit";
        }
        if (!this.hasPermission(context, permission)) {
            return "PermissionError";
        }
        if (context.getRequest().getParameter("UserList") == null) {
            UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
            User thisRec = thisUser.getUserRecord();
            UserList shortChildList = thisRec.getShortChildList();
            UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
            userList.setMyId(this.getUserId(context));
            userList.setMyValue(thisUser.getContact().getNameLastFirst());
            userList.setIncludeMe(true);
            userList.setExcludeDisabledIfUnselected(true);
            userList.setExcludeExpiredIfUnselected(true);
            context.getRequest().setAttribute("UserList", (Object)userList);
        }
        try {
            db = this.getConnection(context);
            if (orgId == null || "".equals(orgId)) {
                String contactId = context.getRequest().getParameter("contactId");
                Contact contact = new Contact(db, contactId);
                orgId = String.valueOf(contact.getOrgId());
            }
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            if (context.getRequest().getParameter("OrgDetails") == null) {
                thisOrganization = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            }
            if (headerId != null && !"-1".equals(headerId)) {
                OpportunityHeader oppHeader = new OpportunityHeader(db, headerId);
                context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "PrepareOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        boolean recordInserted = false;
        boolean isValid = false;
        int resultCount = 0;
        String headerId = context.getRequest().getParameter("headerId");
        String permission = "accounts-accounts-opportunities-add";
        OpportunityBean newOpp = (OpportunityBean)((Object)context.getRequest().getAttribute("OppDetails"));
        Organization thisOrganization = null;
        String orgId = context.getRequest().getParameter("orgId");
        String action = newOpp.getHeader().getId() == -1 ? "insert" : "modify";
        SystemStatus systemStatus = this.getSystemStatus(context);
        if ("modify".equals(action)) {
            permission = "accounts-accounts-opportunities-edit";
        }
        if (!this.hasPermission(context, permission)) {
            return "PermissionError";
        }
        if ("insert".equals(action)) {
            if (!systemStatus.hasField("opportunity.componentTypes")) {
                newOpp.getComponent().setTypeList(context.getRequest().getParameterValues("selectedList"));
            }
            newOpp.getComponent().setEnteredBy(this.getUserId(context));
            newOpp.getComponent().setModifiedBy(this.getUserId(context));
            newOpp.getHeader().setEnteredBy(this.getUserId(context));
            newOpp.getHeader().setModifiedBy(this.getUserId(context));
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            if ("insert".equals(action)) {
                isValid = this.validateObject(context, db, (Object)newOpp);
                isValid = this.validateObject(context, db, (Object)newOpp.getHeader()) && isValid;
                boolean bl = isValid = this.validateObject(context, db, (Object)newOpp.getComponent()) && isValid;
                if (isValid) {
                    recordInserted = newOpp.insert(db, context);
                }
                if (recordInserted) {
                    newOpp.getComponent().setContactId(newOpp.getHeader().getContactLink());
                    newOpp.getComponent().setOrgId(newOpp.getHeader().getAccountLink());
                    this.processInsertHook(context, (Object)newOpp.getComponent());
                } else {
                    LookupList typeSelect = new LookupList(db, "lookup_opportunity_types");
                    context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
                    context.getRequest().setAttribute("TypeList", (Object)newOpp.getComponent().getTypeList());
                }
            } else {
                OpportunityHeader oppHeader = new OpportunityHeader(db, headerId);
                OpportunityHeader oldHeader = new OpportunityHeader(db, headerId);
                if (!this.hasAuthority(context, oppHeader.getManager())) {
                    String string = "PermissionError";
                    return string;
                }
                oppHeader.setModifiedBy(this.getUserId(context));
                oppHeader.setDescription(context.getRequest().getParameter("description"));
                isValid = this.validateObject(context, db, (Object)oppHeader);
                if (isValid) {
                    resultCount = oppHeader.update(db);
                }
                if (resultCount == 1) {
                    this.processUpdateHook(context, (Object)oldHeader, (Object)oppHeader);
                }
            }
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if ("insert".equals(action)) {
            if (recordInserted) {
                boolean isAccountPopup;
                this.addRecentItem(context, (Object)newOpp.getHeader());
                boolean bl = isAccountPopup = context.getRequest().getParameter("popupType") != null && "inline".equals(context.getRequest().getParameter("popupType"));
                if (context.getRequest().getParameter("popup") != null && !isAccountPopup) {
                    return "CloseAddPopup";
                }
                context.getRequest().setAttribute("headerId", (Object)String.valueOf(newOpp.getHeader().getId()));
                return this.executeCommandDetails(context);
            }
            return this.executeCommandPrepare(context);
        }
        if (resultCount == 1) {
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                return this.executeCommandView(context);
            }
            return this.executeCommandDetails(context);
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandModify(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetailsComponent(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-opportunities-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "View Opportunity Component Details");
        OpportunityComponent thisComponent = null;
        Connection db = null;
        String componentId = context.getRequest().getParameter("id");
        String orgId = context.getRequest().getParameter("orgId");
        String contactId = null;
        try {
            db = this.getConnection(context);
            if (orgId == null || "".equals(orgId)) {
                contactId = context.getRequest().getParameter("contactId");
                Contact contact = new Contact(db, contactId);
                orgId = String.valueOf(contact.getOrgId());
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            Organization thisOrg = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrg);
            thisComponent = new OpportunityComponent(db, Integer.parseInt(componentId));
            thisComponent.checkEnabledOwnerAccount(db);
            OpportunityHeader oppHeader = new OpportunityHeader(db, thisComponent.getHeaderId());
            context.getRequest().setAttribute("OpportunityHeader", (Object)oppHeader);
            if (!(this.hasAuthority(context, oppHeader.getManager()) || this.hasAuthority(context, thisComponent.getOwner()) || accessTypeList.getCode(626030334) == oppHeader.getAccessType() || this.excludeHierarchy(context))) {
                String string = "PermissionError";
                return string;
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("OppComponentDetails", (Object)thisComponent);
        this.addRecentItem(context, (Object)thisComponent);
        return Opportunities.getReturn(context, "DetailsComponent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        boolean isPopup;
        if (!this.hasPermission(context, "accounts-accounts-opportunities-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        int headerId = -1;
        this.addModuleBean(context, "View Accounts", "View Opportunity Details");
        headerId = context.getRequest().getParameter("headerId") != null ? Integer.parseInt(context.getRequest().getParameter("headerId")) : Integer.parseInt((String)context.getRequest().getAttribute("headerId"));
        String orgId = context.getRequest().getParameter("orgId");
        Connection db = null;
        Organization thisOrganization = null;
        OpportunityHeader thisHeader = null;
        OpportunityComponentList componentList = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        boolean bl = isPopup = context.getRequest().getParameter("popupType") != null && "inline".equals(context.getRequest().getParameter("popupType"));
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("AccountsComponentListInfo");
        }
        PagedListInfo oppPagedInfo = this.getPagedListInfo(context, "OpportunityPagedInfo", false);
        PagedListInfo componentListInfo = this.getPagedListInfo(context, "AccountsComponentListInfo");
        componentListInfo.setLink("Opportunities.do?command=Details&headerId=" + headerId + "&orgId=" + orgId + (isPopup ? "&popup=true&popupType=inline" : ""));
        try {
            db = this.getConnection(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            thisHeader = new OpportunityHeader();
            thisHeader.setBuildComponentCount(true);
            thisHeader.queryRecord(db, headerId);
            if (!this.excludeHierarchy(context) && !this.hasAuthority(context, thisHeader.getManager()) && accessTypeList.getCode(626030334) != thisHeader.getAccessType()) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("OpportunityHeader", (Object)thisHeader);
            componentList = new OpportunityComponentList();
            componentList.setPagedListInfo(componentListInfo);
            componentList.setAccessType(thisHeader.getAccessType());
            if (oppPagedInfo.getListView() != null && "my".equals(oppPagedInfo.getListView())) {
                componentList.setControlledHierarchyOnly(-1);
                componentList.setOwner(this.getUserId(context));
                componentList.setQueryOpenOnly(true);
            } else if (!this.excludeHierarchy(context)) {
                componentList.setControlledHierarchy(0, this.getUserRange(context));
            }
            componentList.setHeaderId(thisHeader.getId());
            if (thisHeader.isTrashed()) {
                componentList.setIncludeOnlyTrashed(true);
            }
            componentList.buildList(db);
            context.getRequest().setAttribute("ComponentList", (Object)componentList);
            if (!this.allowMultiple(context) && componentList.size() > 0) {
                OpportunityComponent thisComponent = (OpportunityComponent)((Object)componentList.get(0));
                context.getRequest().setAttribute("OppComponentDetails", (Object)thisComponent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addRecentItem(context, (Object)thisHeader);
        if (!this.allowMultiple(context) && componentList.size() > 0) {
            return Opportunities.getReturn(context, "DetailsComponent");
        }
        return Opportunities.getReturn(context, "Details");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-opportunities-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String orgId = context.getRequest().getParameter("orgId");
        OpportunityHeader newOpp = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            newOpp = new OpportunityHeader(db, context.getRequest().getParameter("id"));
            if (!this.hasAuthority(context, newOpp.getManager())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = newOpp.delete(db, context, Opportunities.getDbNamePath(context));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                context.getRequest().setAttribute("orgId", (Object)orgId);
                boolean inline = context.getRequest().getParameter("popupType") != null && "inline".equals(context.getRequest().getParameter("popupType"));
                context.getRequest().setAttribute("refreshUrl", (Object)("Opportunities.do?command=View&orgId=" + orgId + (inline ? "&popup=true&popupType=inline" : "")));
                this.deleteRecentItem(context, (Object)newOpp);
                return "DeleteOK";
            }
            this.processErrors(context, newOpp.getErrors());
            return this.executeCommandView(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmComponentDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-opportunities-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        OpportunityComponent thisComponent = null;
        OpportunityHeader header = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = context.getRequest().getParameter("id");
        String orgId = context.getRequest().getParameter("orgId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            thisComponent = new OpportunityComponent(db, id);
            header = new OpportunityHeader(db, thisComponent.getHeaderId());
            if (!this.hasAuthority(context, thisComponent.getOwner()) && !this.hasAuthority(context, header.getManager())) {
                String string = "PermissionError";
                return string;
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.account.opps.delete"));
            htmlDialog.setShowAndConfirm(false);
            htmlDialog.setDeleteUrl("javascript:window.location.href='OpportunitiesComponents.do?command=DeleteComponent&orgId=" + orgId + "&id=" + id + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteComponent(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-opportunities-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordDeleted = false;
        OpportunityComponent component = null;
        OpportunityHeader header = null;
        String orgId = context.getRequest().getParameter("orgId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            component = new OpportunityComponent(db, context.getRequest().getParameter("id"));
            header = new OpportunityHeader(db, component.getHeaderId());
            if (!this.hasAuthority(context, component.getOwner()) && !this.hasAuthority(context, header.getManager())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = component.delete(db, context);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                context.getRequest().setAttribute("refreshUrl", (Object)("Opportunities.do?command=Details&headerId=" + component.getHeaderId() + "&orgId=" + orgId));
                this.deleteRecentItem(context, (Object)component);
                return "ComponentDeleteOK";
            }
            this.processErrors(context, component.getErrors());
            return this.executeCommandView(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-opportunities-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "Modify an Opportunity");
        int headerId = Integer.parseInt(context.getRequest().getParameter("headerId"));
        String orgId = context.getRequest().getParameter("orgId");
        Connection db = null;
        OpportunityHeader thisHeader = null;
        SystemStatus systemStatus = null;
        ContactList contacts = null;
        Organization thisOrganization = null;
        try {
            db = this.getConnection(context);
            thisHeader = new OpportunityHeader();
            thisHeader.setBuildComponentCount(true);
            thisHeader.queryRecord(db, headerId);
            if (!this.hasAuthority(context, thisHeader.getManager())) {
                String string = "PermissionError";
                return string;
            }
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            systemStatus = this.getSystemStatus(context);
            contacts = new ContactList();
            contacts.setOrgId(thisHeader.getAccountLink());
            if (thisHeader.getAccountLink() == -1) {
                contacts.setSiteId(thisOrganization.getSiteId());
                contacts.setExclusiveToSite(true);
            }
            contacts.addIgnoreTypeId(1);
            contacts.addIgnoreTypeId(2);
            contacts.setEmployeesOnly(0);
            contacts.setEmptyHtmlSelectRecord(systemStatus.getLabel("accounts.accounts_add.NoneSelected"));
            contacts.setDefaultContactId(thisHeader.getContactLink());
            contacts.buildList(db);
            context.getRequest().setAttribute("contacts", (Object)contacts);
            QuoteList quotes = new QuoteList();
            quotes.setHeaderId(thisHeader.getId());
            quotes.buildList(db);
            context.getRequest().setAttribute("hasQuotes", (Object)("" + (quotes.size() > 0)));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("opportunityHeader", (Object)thisHeader);
        this.addRecentItem(context, (Object)thisHeader);
        return Opportunities.getReturn(context, "PrepareModifyOpp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-opportunities-delete")) {
            return "PermissionError";
        }
        HtmlDialog htmlDialog = new HtmlDialog();
        String headerId = context.getRequest().getParameter("headerId");
        String orgId = context.getRequest().getParameter("orgId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            OpportunityHeader thisOpp = new OpportunityHeader(db, headerId);
            if (!this.hasAuthority(context, thisOpp.getManager())) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = thisOpp.processDependencies(db, this.allowMultiple(context));
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='Opportunities.do?command=Delete&orgId=" + orgId + "&id=" + headerId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyComponent(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-opportunities-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        OpportunityComponent component = null;
        OpportunityHeader oppHeader = null;
        this.addModuleBean(context, "View Accounts", "Modify a Component");
        String componentId = context.getRequest().getParameter("id");
        String headerId = context.getRequest().getParameter("headerId");
        try {
            db = this.getConnection(context);
            if (componentId != null && !"".equals(componentId.trim()) && Integer.parseInt(componentId) > -1) {
                component = new OpportunityComponent(db, componentId);
                oppHeader = new OpportunityHeader(db, component.getHeaderId());
            }
            context.getRequest().setAttribute("ComponentDetails", component);
            context.getRequest().setAttribute("opportunityHeader", oppHeader);
            SystemStatus systemStatus = this.getSystemStatus(context);
            AccessTypeList accessTypeList = systemStatus.getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            if (!this.hasAuthority(context, component.getOwner()) && !this.hasAuthority(context, oppHeader.getManager())) {
                String string = "PermissionError";
                return string;
            }
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addRecentItem(context, (Object)component);
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-opportunities-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = 0;
        boolean isValid = false;
        String headerId = context.getRequest().getParameter("headerId");
        String type = context.getRequest().getParameter("type");
        try {
            db = this.getConnection(context);
            OpportunityHeader oppHeader = new OpportunityHeader(db, headerId);
            OpportunityHeader oldHeader = new OpportunityHeader(db, headerId);
            if (!this.hasAuthority(context, oppHeader.getManager())) {
                String string = "PermissionError";
                return string;
            }
            oppHeader.setModifiedBy(this.getUserId(context));
            oppHeader.setDescription(context.getRequest().getParameter("description"));
            if (type.equals("contact")) {
                oppHeader.setContactLink(context.getRequest().getParameter("contactLink"));
                oppHeader.setAccountLink(-1);
            } else if (type.equals("org")) {
                oppHeader.setAccountLink(context.getRequest().getParameter("accountLink"));
                oppHeader.setContactLink(-1);
            }
            isValid = this.validateObject(context, db, (Object)oppHeader);
            if (isValid) {
                resultCount = oppHeader.update(db);
            }
            if (resultCount == 1) {
                oppHeader.checkResetActionStepAttachment(db, oldHeader);
                this.processUpdateHook(context, (Object)oldHeader, (Object)oppHeader);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == 1) {
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                return this.executeCommandView(context);
            }
            return this.executeCommandDetails(context);
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandModify(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandComponentHistory(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-opportunities-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        int headerId = -1;
        int componentId = -1;
        this.addModuleBean(context, "View Accounts", "View Opportunity Details");
        componentId = context.getRequest().getParameter("id") != null ? Integer.parseInt(context.getRequest().getParameter("id")) : Integer.parseInt((String)context.getRequest().getAttribute("id"));
        String orgId = context.getRequest().getParameter("orgId");
        Connection db = null;
        Organization thisOrganization = null;
        OpportunityComponent thisComponent = null;
        OpportunityHeader thisHeader = null;
        OpportunityComponentLogList componentLogList = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("componentHistoryListInfo");
        }
        PagedListInfo oppPagedInfo = this.getPagedListInfo(context, "opportunityPagedInfo");
        PagedListInfo componentHistoryListInfo = this.getPagedListInfo(context, "componentHistoryListInfo");
        componentHistoryListInfo.setLink("OpportunitiesComponents.do?command=ComponentHistory&orgId=" + orgId + "&id=" + componentId + RequestUtils.addLinkParams(context.getRequest(), "viewSource|popup|popupType"));
        try {
            db = this.getConnection(context);
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("orgDetails", (Object)thisOrganization);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            thisComponent = new OpportunityComponent();
            thisComponent.queryRecord(db, componentId);
            context.getRequest().setAttribute("opportunityComponent", (Object)thisComponent);
            thisHeader = new OpportunityHeader();
            thisHeader.setBuildComponentCount(true);
            thisHeader.queryRecord(db, thisComponent.getHeaderId());
            context.getRequest().setAttribute("opportunityHeader", (Object)thisHeader);
            componentLogList = new OpportunityComponentLogList();
            componentLogList.setPagedListInfo(componentHistoryListInfo);
            componentLogList.setHeaderId(thisHeader.getId());
            componentLogList.setComponentId(componentId);
            componentLogList.buildList(db);
            context.getRequest().setAttribute("componentHistoryList", (Object)componentLogList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Opportunities.getReturn(context, "ComponentHistory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandComponentHistoryDetails(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-opportunities-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Opportunities", "Component Details");
        String historyId = context.getRequest().getParameter("id");
        String orgId = context.getRequest().getParameter("orgId");
        Organization thisOrganization = null;
        OpportunityComponentLog thisComponentLog = null;
        OpportunityComponent component = null;
        OpportunityHeader header = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("orgDetails", (Object)thisOrganization);
            thisComponentLog = new OpportunityComponentLog(db, Integer.parseInt(historyId));
            component = new OpportunityComponent(db, thisComponentLog.getComponentId());
            context.getRequest().setAttribute("opportunityComponent", (Object)component);
            header = new OpportunityHeader(db, component.getHeaderId());
            context.getRequest().setAttribute("opportunityHeader", (Object)header);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("accountsComponentDetails", (Object)thisComponentLog);
        return Opportunities.getReturn(context, "ComponentHistoryDetails");
    }

    private boolean allowMultiple(ActionContext context) {
        String multiple = this.getSystemPref(context, OpportunityComponent.MULTPLE_CONFIG_NAME, "multiple");
        return OpportunityComponent.allowMultiple(multiple);
    }

    private boolean excludeHierarchy(ActionContext context) {
        String exclude = this.getSystemPref(context, OpportunityComponent.MULTPLE_CONFIG_NAME, "excludeHierarchy");
        if (exclude != null && !"".equals(exclude)) {
            return DatabaseUtils.parseBoolean(exclude);
        }
        return false;
    }
}

