/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.accounts.base.OrganizationYTDComparator;
import org.aspcfs.modules.accounts.base.Revenue;
import org.aspcfs.modules.accounts.base.RevenueList;
import org.aspcfs.modules.accounts.base.RevenueTypeList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.GraphSummaryList;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class RevenueManager
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDashboard(ActionContext context) {
        String revenueType;
        if (!this.hasPermission(context, "accounts-accounts-revenue-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Revenue", "Revenue");
        String errorMessage = null;
        int idToUse = 0;
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        User thisRec = null;
        int overrideId = StringUtils.parseInt(context.getRequest().getParameter("oid"), -1);
        if (context.getRequest().getParameter("reset") != null) {
            overrideId = -1;
            context.getSession().removeAttribute("revenueoverride");
            context.getSession().removeAttribute("revenueothername");
            context.getSession().removeAttribute("revenuepreviousId");
        }
        if (overrideId > -1) {
            if (overrideId == this.getUserId(context)) {
                context.getSession().removeAttribute("revenueoverride");
                context.getSession().removeAttribute("revenueothername");
                context.getSession().removeAttribute("revenuepreviousId");
            }
        } else {
            overrideId = context.getSession().getAttribute("revenueoverride") != null ? StringUtils.parseInt((String)context.getSession().getAttribute("revenueoverride"), -1) : thisUser.getUserId();
        }
        idToUse = this.hasAuthority(context, overrideId) ? overrideId : thisUser.getUserId();
        thisRec = this.getUser(context, idToUse);
        if (idToUse > -1 && idToUse != this.getUserId(context)) {
            context.getSession().setAttribute("revenueoverride", (Object)String.valueOf(overrideId));
            context.getSession().setAttribute("revenueothername", (Object)thisRec.getContact().getNameFull());
            context.getSession().setAttribute("revenuepreviousId", (Object)String.valueOf(thisRec.getManagerId()));
        }
        thisRec.setRevenueIsValid(false, true);
        String checkFileName = null;
        if (thisRec.getRevenueIsValid()) {
            checkFileName = thisRec.getRevenue().getLastFileName();
        }
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        String yearParam = context.getRequest().getParameter("year");
        if (yearParam == null) {
            yearParam = (String)context.getSession().getAttribute("revenueyear");
        }
        if (yearParam != null) {
            year = Integer.parseInt(yearParam);
            cal.set(1, year);
            context.getSession().setAttribute("revenueyear", (Object)yearParam);
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("RevenueManager-> YEAR: " + year);
        }
        if ((revenueType = context.getRequest().getParameter("type")) == null) {
            revenueType = (String)context.getSession().getAttribute("revenuetype");
        }
        UserList fullChildList = new UserList();
        UserList shortChildList = new UserList();
        shortChildList = thisRec.getShortChildList();
        shortChildList.setRevenueYear(year);
        RevenueList realFullRevList = new RevenueList();
        Connection db = null;
        Locale locale = this.getUser(context, this.getUserId(context)).getLocale();
        try {
            db = this.getConnection(context);
            this.buildFormElements(context, db);
            RevenueTypeList rtl = new RevenueTypeList(db);
            rtl.addItem(0, "All Types");
            rtl.setJsEvent("onChange=\"document.Dashboard.submit();\"");
            context.getRequest().setAttribute("RevenueTypeList", (Object)rtl);
            PagedListInfo revenueInfo = this.getPagedListInfo(context, "DBRevenueListInfo");
            revenueInfo.setLink("RevenueManager.do?command=Dashboard");
            OrganizationList displayList = new OrganizationList();
            if (revenueType != null) {
                shortChildList.setRevenueType(Integer.parseInt(revenueType));
                realFullRevList.setType(Integer.parseInt(revenueType));
                displayList.setRevenueType(Integer.parseInt(revenueType));
                context.getSession().setAttribute("revenuetype", (Object)revenueType);
            }
            displayList.setRevenueYear(year);
            displayList.setBuildRevenueYTD(true);
            displayList.setRevenueOwnerId(idToUse);
            displayList.buildList(db);
            OrganizationYTDComparator comparator = new OrganizationYTDComparator();
            Collections.sort(displayList, comparator);
            context.getRequest().setAttribute("MyRevList", (Object)displayList);
            if (checkFileName == null) {
                fullChildList = thisRec.getFullChildList(shortChildList, new UserList());
                String range = fullChildList.getUserListIds(idToUse);
                realFullRevList.setYear(year);
                realFullRevList.setOwnerIdRange(range);
                realFullRevList.buildList(db);
            }
            shortChildList.buildRevenueYTD(db);
        }
        catch (Exception e) {
            errorMessage = e.toString();
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        if (checkFileName != null) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("RevenueManager-> Using cached chart");
            }
            context.getRequest().setAttribute("GraphFileName", (Object)checkFileName);
        } else {
            XYItemRenderer renderer;
            if (System.getProperty("DEBUG") != null) {
                System.out.println("RevenueManager-> Preparing the chart");
            }
            RevenueList tempRevList = new RevenueList();
            for (Revenue tempRev : realFullRevList) {
                if (tempRev.getOwner() != idToUse) continue;
                tempRevList.addElement(tempRev);
            }
            UserList tempUserList = new UserList();
            for (User thisRecord : fullChildList) {
                thisRecord.setRevenueIsValid(false, true);
                tempUserList = this.prepareLines(thisRecord, realFullRevList, tempUserList, year);
            }
            UserList linesToDraw = new UserList();
            linesToDraw = this.calculateLine(tempUserList, linesToDraw, year);
            tempUserList = this.prepareLines(thisRec, tempRevList, tempUserList, year);
            linesToDraw = this.calculateLine(thisRec, linesToDraw, year);
            XYSeriesCollection categoryData = this.createCategoryDataset(linesToDraw, year);
            JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"", (String)"", (String)"", (XYDataset)categoryData, (boolean)false, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            SimpleDateFormat sdf = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale);
            XYPlot plot = chart.getXYPlot();
            ValueAxis yAxis = plot.getRangeAxis();
            yAxis.setTickMarksVisible(true);
            yAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits((Locale)locale));
            DateAxis axis = (DateAxis)plot.getDomainAxis();
            axis.setDateFormatOverride((DateFormat)sdf);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Leads-> Drawing the chart");
            }
            if ((renderer = plot.getRenderer()) instanceof StandardXYItemRenderer) {
                StandardXYItemRenderer rr = (StandardXYItemRenderer)renderer;
                rr.setPlotShapes(true);
                rr.setShapesFilled(false);
                rr.setItemLabelsVisible(true);
                StandardXYToolTipGenerator ttg = new StandardXYToolTipGenerator("{2} ({1})", (DateFormat)sdf, NumberFormat.getInstance(locale));
                rr.setToolTipGenerator((XYToolTipGenerator)ttg);
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("RevenueManager-> Drawing the chart");
            }
            int width = 275;
            int height = 200;
            try {
                String realPath = context.getServletContext().getRealPath("/");
                String filePath = realPath + "graphs" + fs;
                Date testDate = new Date();
                String fileName = String.valueOf(idToUse) + String.valueOf(testDate.getTime()) + String.valueOf(context.getSession().getCreationTime());
                ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
                File imageFile = new File(filePath + fileName + ".jpg");
                ChartUtilities.saveChartAsJPEG((File)imageFile, (float)1.0f, (JFreeChart)chart, (int)width, (int)height, (ChartRenderingInfo)info);
                PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(filePath + fileName + ".map")));
                ChartUtilities.writeImageMap((PrintWriter)pw, (String)fileName, (ChartRenderingInfo)info, (boolean)false);
                pw.flush();
                pw.close();
                thisRec.getRevenue().setLastFileName(fileName);
                context.getRequest().setAttribute("GraphFileName", (Object)fileName);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("ShortChildList", (Object)shortChildList);
            return "DashboardOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-revenue-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "Add Revenue to Account");
        Exception errorMessage = null;
        Connection db = null;
        String orgId = context.getRequest().getParameter("orgId");
        Organization thisOrganization = null;
        try {
            db = this.getConnection(context);
            this.buildFormElements(context, db);
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "AddOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-revenue-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "View Revenue List");
        Exception errorMessage = null;
        String orgid = context.getRequest().getParameter("orgId");
        PagedListInfo revenueInfo = this.getPagedListInfo(context, "RevenueListInfo");
        revenueInfo.setLink("RevenueManager.do?command=View&orgId=" + orgid);
        Connection db = null;
        RevenueList revenueList = new RevenueList();
        Organization thisOrganization = null;
        try {
            db = this.getConnection(context);
            revenueList.setPagedListInfo(revenueInfo);
            revenueList.setOrgId(Integer.parseInt(orgid));
            if ("all".equals(revenueInfo.getListView())) {
                revenueList.setOwnerIdRange(this.getUserRange(context));
            } else {
                revenueList.setOwner(this.getUserId(context));
            }
            revenueList.buildList(db);
            thisOrganization = new Organization(db, Integer.parseInt(orgid));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("RevenueList", (Object)revenueList);
            context.getRequest().setAttribute("OrgDetails", thisOrganization);
            return "ViewOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-revenue-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        boolean recordDeleted = false;
        Revenue thisRevenue = null;
        Organization thisOrganization = null;
        String orgId = context.getRequest().getParameter("orgId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisRevenue = new Revenue(db, context.getRequest().getParameter("id"));
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            if (!this.hasAuthority(context, thisRevenue.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisRevenue.delete(db, context);
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Delete Revenue");
        if (errorMessage == null) {
            if (recordDeleted) {
                return "DeleteOK";
            }
            this.processErrors(context, thisRevenue.getErrors());
            return this.executeCommandView(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-revenue-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "Insert Revenue");
        boolean recordInserted = false;
        boolean isValid = false;
        Connection db = null;
        Revenue thisRevenue = null;
        Revenue newRevenue = null;
        thisRevenue = (Revenue)((Object)context.getFormBean());
        thisRevenue.setEnteredBy(this.getUserId(context));
        thisRevenue.setModifiedBy(this.getUserId(context));
        thisRevenue.setOwner(this.getUserId(context));
        try {
            db = this.getConnection(context);
            isValid = this.validateObject(context, db, (Object)thisRevenue);
            if (isValid) {
                recordInserted = thisRevenue.insert(db, context);
            }
            if (recordInserted) {
                newRevenue = new Revenue(db, String.valueOf(thisRevenue.getId()));
                context.getRequest().setAttribute("Revenue", (Object)newRevenue);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "InsertOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-revenue-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "Modify Revenue");
        Exception errorMessage = null;
        String orgid = context.getRequest().getParameter("orgId");
        String passedId = context.getRequest().getParameter("id");
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        User thisRec = thisUser.getUserRecord();
        UserList shortChildList = thisRec.getShortChildList();
        UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
        userList.setMyId(this.getUserId(context));
        userList.setMyValue(thisUser.getContact().getNameLastFirst());
        userList.setIncludeMe(true);
        userList.setExcludeDisabledIfUnselected(true);
        userList.setExcludeExpiredIfUnselected(true);
        context.getRequest().setAttribute("UserList", (Object)userList);
        Connection db = null;
        Revenue thisRevenue = null;
        Organization thisOrganization = null;
        try {
            db = this.getConnection(context);
            thisRevenue = new Revenue(db, "" + passedId);
            thisOrganization = new Organization(db, Integer.parseInt(orgid));
            this.buildFormElements(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (!this.hasAuthority(context, thisRevenue.getOwner())) {
                return "PermissionError";
            }
            context.getRequest().setAttribute("Revenue", (Object)thisRevenue);
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            return "ModifyOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-revenue-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "View Revenue Details");
        Exception errorMessage = null;
        String revenueId = context.getRequest().getParameter("id");
        Connection db = null;
        Revenue newRevenue = null;
        Organization thisOrganization = null;
        try {
            db = this.getConnection(context);
            newRevenue = new Revenue(db, revenueId);
            newRevenue.checkEnabledOwnerAccount(db);
            thisOrganization = new Organization(db, newRevenue.getOrgId());
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (!this.hasAuthority(context, newRevenue.getOwner())) {
                return "PermissionError";
            }
            context.getRequest().setAttribute("Revenue", (Object)newRevenue);
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            return "DetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-revenue-edit")) {
            return "PermissionError";
        }
        Revenue newRevenue = (Revenue)((Object)context.getFormBean());
        boolean isValid = false;
        Organization thisOrganization = null;
        String orgid = context.getRequest().getParameter("orgId");
        Connection db = null;
        int resultCount = 0;
        try {
            db = this.getConnection(context);
            newRevenue.setModifiedBy(this.getUserId(context));
            if (!this.hasAuthority(context, newRevenue.getOwner())) {
                String string = "PermissionError";
                return string;
            }
            isValid = this.validateObject(context, db, (Object)newRevenue);
            if (isValid) {
                resultCount = newRevenue.update(db, context);
            }
            if (resultCount == -1 || !isValid) {
                this.buildFormElements(context, db);
                thisOrganization = new Organization(db, Integer.parseInt(orgid));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == -1 || !isValid) {
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            return this.executeCommandModify(context);
        }
        if (resultCount == 1) {
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                return this.executeCommandView(context);
            }
            return "UpdateOK";
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    public static Date createDate(int y, int m, int d) {
        GregorianCalendar calendar = new GregorianCalendar(y, m, d, 0, 0, 0);
        return calendar.getTime();
    }

    protected void buildFormElements(ActionContext context, Connection db) throws SQLException {
        RevenueTypeList rtl = new RevenueTypeList(db);
        SystemStatus systemStatus = this.getSystemStatus(context);
        rtl.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("RevenueTypeList", (Object)rtl);
        HtmlSelect monthList = new HtmlSelect();
        monthList.setTypeUSMonths();
        monthList.setSelectName("month");
        context.getRequest().setAttribute("MonthList", (Object)monthList);
        HtmlSelect yearList = new HtmlSelect();
        yearList.setTypeYears(1990);
        yearList.setSelectName("year");
        context.getRequest().setAttribute("YearList", (Object)yearList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserList prepareLines(User pertainsTo, RevenueList revList, UserList usersToGraph, int year) {
        if (!pertainsTo.getRevenueIsValid()) {
            pertainsTo.doRevenueLock();
            if (!pertainsTo.getRevenueIsValid()) {
                try {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("RevenueManager-> (RE)BUILDING REVENUE DATA FOR " + pertainsTo.getId());
                    }
                    pertainsTo.setRevenue(new GraphSummaryList());
                    for (Revenue tempRev : revList) {
                        int passedYear;
                        if (tempRev.getOwner() != pertainsTo.getId() || (passedYear = tempRev.getYear()) != year) continue;
                        int passedMonth = tempRev.getMonth() - 1;
                        String valKey = String.valueOf(passedYear) + String.valueOf(passedMonth);
                        Double revenueAddTerm = new Double(tempRev.getAmount());
                        pertainsTo.setRevenueGraphValues(valKey, revenueAddTerm);
                    }
                    pertainsTo.setRevenueIsValid(true, true);
                }
                catch (Exception e) {
                    System.err.println("Revenue Manager-> Unwanted exception occurred: " + e.toString());
                }
            }
            pertainsTo.doRevenueUnlock();
        }
        usersToGraph.addElement(pertainsTo);
        if (revList.size() == 0) {
            return new UserList();
        }
        return usersToGraph;
    }

    private UserList calculateLine(User primaryNode, UserList currentLines, int year) {
        if (currentLines.size() == 0) {
            currentLines.addElement(primaryNode);
            return currentLines;
        }
        User thisLine = new User();
        String[] valKeys = thisLine.getRevenue().getYearRange(12, year);
        Iterator x = currentLines.iterator();
        User addToMe = (User)((Object)x.next());
        for (int count = 0; count < 12; ++count) {
            thisLine.getRevenue().setValue(valKeys[count], new Double(primaryNode.getRevenue().getValue(valKeys[count]) + addToMe.getRevenue().getValue(valKeys[count])));
        }
        currentLines.addElement(thisLine);
        return currentLines;
    }

    private UserList calculateLine(UserList toRollUp, UserList currentLines, int year) {
        if (toRollUp.size() == 0) {
            return new UserList();
        }
        User thisLine = new User();
        String[] valKeys = thisLine.getRevenue().getYearRange(12, year);
        for (User thisUser : toRollUp) {
            for (int count = 0; count < 12; ++count) {
                thisLine.getRevenue().setValue(valKeys[count], thisUser.getRevenue().getValue(valKeys[count]));
            }
        }
        currentLines.addElement(thisLine);
        return currentLines;
    }

    private XYSeriesCollection createCategoryDataset(UserList linesToDraw, int year) {
        XYSeriesCollection xyDataset = new XYSeriesCollection();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("RevenueManager-> Lines to draw: " + linesToDraw.size());
        }
        if (linesToDraw.size() == 0) {
            return xyDataset;
        }
        Calendar iteratorDate = Calendar.getInstance();
        iteratorDate.set(1, year);
        for (User thisUser : linesToDraw) {
            XYSeries dataSeries = new XYSeries(null);
            String[] valKeys = thisUser.getRevenue().getYearRange(12, year);
            for (int count = 0; count < 12; ++count) {
                Date dateValue = RevenueManager.createDate(iteratorDate.get(1), count, 1);
                Double itemValue = thisUser.getRevenue().getValue(valKeys[count]);
                dataSeries.add((double)dateValue.getTime(), (Number)itemValue);
            }
            xyDataset.addSeries(dataSeries);
        }
        return xyDataset;
    }
}

