/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class AccountTypeLevel {
    int orgId = -1;
    int typeId = -1;
    int level = -1;
    Timestamp entered = null;
    Timestamp modified = null;

    public AccountTypeLevel() {
    }

    public AccountTypeLevel(Connection db, String id) throws SQLException {
        this.queryRecord(db, Integer.parseInt(id));
    }

    public AccountTypeLevel(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public AccountTypeLevel(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public int getOrgId() {
        return this.orgId;
    }

    public void setOrgId(int orgId) {
        this.orgId = orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = Integer.parseInt(orgId);
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getLevel() {
        return this.level;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Account Type Level entry not found.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT a.* FROM account_type_levels a WHERE a.org_id = ? and a.type_id = ? ");
        pst.setInt(1, this.orgId);
        pst.setInt(2, this.typeId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.typeId == -1) {
            throw new SQLException("Account Type Level entry not found.");
        }
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            sql.append("INSERT INTO account_type_levels (org_id, type_id, ");
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("" + DatabaseUtils.addQuotes(db, "level") + ") ");
            sql.append("VALUES (?, ?, ");
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.orgId > -1) {
                pst.setInt(++i, this.getOrgId());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.typeId > -1) {
                pst.setInt(++i, this.getTypeId());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.getLevel());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.orgId = rs.getInt("org_id");
        if (rs.wasNull()) {
            this.orgId = -1;
        }
        this.typeId = rs.getInt("type_id");
        if (rs.wasNull()) {
            this.typeId = -1;
        }
        this.level = rs.getInt("level");
        this.entered = rs.getTimestamp("entered");
        this.modified = rs.getTimestamp("modified");
    }

    public static ArrayList recordList(Connection db) throws SQLException {
        ArrayList<AccountTypeLevel> records = new ArrayList<AccountTypeLevel>();
        PreparedStatement pst = db.prepareStatement("SELECT * FROM account_type_levels ");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            AccountTypeLevel atl = new AccountTypeLevel(rs);
            records.add(atl);
        }
        rs.close();
        pst.close();
        return records;
    }
}

