/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import java.util.TimeZone;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.ScheduledActions;
import org.aspcfs.modules.mycfs.base.CalendarEventList;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.CalendarView;

public class AccountsListScheduledActions
extends OrganizationList
implements ScheduledActions {
    private ActionContext context = null;
    private CFSModule module = null;
    private int userId = -1;

    public void setModule(CFSModule tmp) {
        this.module = tmp;
    }

    public void setContext(ActionContext tmp) {
        this.context = tmp;
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public ActionContext getContext() {
        return this.context;
    }

    public CFSModule getModule() {
        return this.module;
    }

    public int getUserId() {
        return this.userId;
    }

    public void buildAlerts(CalendarView companyCalendar, Connection db) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("AccountsListScheduledActions --> Building Account Alerts ");
        }
        try {
            String alertType = companyCalendar.getCalendarInfo().getCalendarDetailsView();
            this.setOwnerId(this.userId);
            if (alertType.equalsIgnoreCase("AccountsAlertDates")) {
                this.addAlertDates(companyCalendar, db);
            } else if (alertType.equalsIgnoreCase("AccountsContractEndDates")) {
                this.addContractEndDates(companyCalendar, db);
            } else {
                this.addAlertDates(companyCalendar, db);
                this.clear();
                this.addContractEndDates(companyCalendar, db);
            }
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void addAlertDates(CalendarView companyCalendar, Connection db) throws SQLException {
        TimeZone timeZone = companyCalendar.getCalendarInfo().getTimeZone();
        this.setHasExpireDate(false);
        this.setHasAlertDate(true);
        this.buildShortList(db);
        for (Organization thisOrg : this) {
            String alertDate = DateUtils.getServerToUserDateString(timeZone, 3, thisOrg.getAlertDate());
            companyCalendar.addEvent(alertDate, CalendarEventList.EVENT_TYPES[3], (Object)thisOrg);
        }
    }

    public void addContractEndDates(CalendarView companyCalendar, Connection db) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("AccountsListScheduledActions --> Building Account Contract End Dates ");
        }
        TimeZone timeZone = companyCalendar.getCalendarInfo().getTimeZone();
        this.setHasAlertDate(false);
        this.setHasExpireDate(true);
        this.buildShortList(db);
        for (Organization thisOrg : this) {
            String endDate = DateUtils.getServerToUserDateString(timeZone, 3, thisOrg.getContractEndDate());
            companyCalendar.addEvent(endDate, CalendarEventList.EVENT_TYPES[3], (Object)thisOrg);
        }
    }

    public void buildAlertCount(CalendarView companyCalendar, Connection db) throws SQLException {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("AccountsListScheduledActions --> Building Alert Date Count ");
        }
        String alertType = companyCalendar.getCalendarInfo().getCalendarDetailsView();
        boolean anyAlert = false;
        TimeZone timeZone = companyCalendar.getCalendarInfo().getTimeZone();
        this.setOwnerId(this.userId);
        if ("AccountsAlertDates".equals(alertType)) {
            this.setHasExpireDate(false);
            this.setHasAlertDate(true);
        } else if ("AccountsContractEndDates".equals(alertType)) {
            this.setHasExpireDate(true);
            this.setHasAlertDate(false);
        } else {
            this.setHasExpireDate(true);
            this.setHasAlertDate(false);
            anyAlert = true;
        }
        HashMap dayEvents = this.queryRecordCount(db, timeZone, new HashMap());
        if (anyAlert) {
            this.setHasExpireDate(false);
            this.setHasAlertDate(true);
            dayEvents = this.queryRecordCount(db, timeZone, dayEvents);
        }
        Set s = dayEvents.keySet();
        for (String thisDay : s) {
            companyCalendar.addEventCount(thisDay, CalendarEventList.EVENT_TYPES[3], dayEvents.get(thisDay));
        }
    }
}

