/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public class NewsArticle
extends GenericBean {
    protected String errorMessage = "";
    protected int recId = -1;
    protected int orgId = -1;
    protected String base = "";
    protected String headline = "";
    protected String dateEntered = "";
    protected String dateCreated = "";
    protected String url = "";
    protected SimpleDateFormat shortDateFormat = new SimpleDateFormat("M/d/yyyy");
    protected SimpleDateFormat shortTimeFormat = new SimpleDateFormat("h:mm a");
    protected SimpleDateFormat shortDateTimeFormat = new SimpleDateFormat("M/d/yyyy h:mm a");
    protected SimpleDateFormat longDateTimeFormat = new SimpleDateFormat("MMMMM d, yyyy hh:mm a");
    protected SimpleDateFormat longDateFormat = new SimpleDateFormat("MMMMM d, yyyy");
    protected SimpleDateFormat longTimeFormat = new SimpleDateFormat("hh:mm a");

    public NewsArticle() {
    }

    public NewsArticle(Connection db, String newsId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(newsId));
    }

    public NewsArticle(Connection db, int newsId) throws SQLException {
        this.queryRecord(db, newsId);
    }

    public NewsArticle(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    private void queryRecord(Connection db, int newsId) throws SQLException {
        if (newsId < 0) {
            throw new SQLException("News ID not specified.");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT n.* FROM news n LEFT JOIN organization o ON (n.org_id = o.org_id) WHERE n.rec_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(1, newsId);
        ResultSet rs = pst.executeQuery();
        if (!rs.next()) {
            rs.close();
            pst.close();
            throw new SQLException("News record not found.");
        }
        this.buildRecord(rs);
        rs.close();
        pst.close();
    }

    public void setErrorMessage(String tmp) {
        this.errorMessage = tmp;
    }

    public void setUrl(String tmp) {
        this.url = tmp;
    }

    public void setBase(String tmp) {
        this.base = tmp;
    }

    public void setRecId(int tmp) {
        this.recId = tmp;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setHeadline(String tmp) {
        this.headline = tmp;
    }

    public void setDateEntered(String tmp) {
        this.dateEntered = tmp;
    }

    public void setDateCreated(String tmp) {
        this.dateCreated = tmp;
    }

    public int getRecId() {
        return this.recId;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getBase() {
        return this.base;
    }

    public String getHeadline() {
        return this.headline;
    }

    public String getDateEntered() {
        return this.dateEntered;
    }

    public String getDateCreated() {
        return this.dateCreated;
    }

    public String getUrl() {
        return this.url;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.recId = rs.getInt("rec_id");
        this.orgId = rs.getInt("org_id");
        this.url = rs.getString("url");
        this.base = rs.getString("base");
        this.headline = rs.getString("headline");
        this.dateEntered = rs.getString("dateentered");
        Timestamp tmpDateCreated = rs.getTimestamp("created");
        this.dateEntered = tmpDateCreated != null ? this.shortDateTimeFormat.format(tmpDateCreated) : "";
    }
}

