/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import org.aspcfs.modules.accounts.base.NewsArticle;
import org.aspcfs.utils.web.PagedListInfo;

public class NewsArticleList
extends Vector {
    public static final String tableName = "news";
    public static final String uniqueField = "rec_id";
    protected Timestamp lastAnchor = null;
    protected Timestamp nextAnchor = null;
    protected int syncType = -1;
    protected PagedListInfo pagedListInfo = null;
    protected boolean minerOnly = true;
    protected int enteredBy = -1;
    protected int industryCode = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public boolean getMinerOnly() {
        return this.minerOnly;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getIndustryCode() {
        return this.industryCode;
    }

    public void setMinerOnly(boolean tmp) {
        this.minerOnly = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setIndustryCode(int tmp) {
        this.industryCode = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setIndustryCode(String tmp) {
        this.industryCode = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM news n LEFT JOIN organization o ON (n.org_id = o.org_id) WHERE n.rec_id >= 0 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("n.dateentered DESC ", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY n.dateentered DESC ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("n.* FROM news n LEFT JOIN organization o ON (n.org_id = o.org_id) WHERE o.org_id >= 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            NewsArticle thisArticle = new NewsArticle(rs);
            this.addElement(thisArticle);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.enteredBy > -1) {
            sqlFilter.append("AND o.enteredby = ? ");
        }
        if (this.industryCode > -1) {
            sqlFilter.append("AND o.industry_temp_code = ? ");
        }
        if (this.minerOnly) {
            sqlFilter.append("AND o.miner_only = ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enteredBy > -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.industryCode > -1) {
            pst.setInt(++i, this.industryCode);
        }
        if (this.minerOnly) {
            pst.setBoolean(++i, this.minerOnly);
        }
        return i;
    }
}

