/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.iteam.utils.ProjectUtils;
import com.zeroio.webdav.utils.ICalendar;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TimeZone;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.aspcfs.controller.ObjectValidator;
import org.aspcfs.modules.accounts.base.OrganizationAddress;
import org.aspcfs.modules.accounts.base.OrganizationAddressList;
import org.aspcfs.modules.accounts.base.OrganizationEmailAddress;
import org.aspcfs.modules.accounts.base.OrganizationEmailAddressList;
import org.aspcfs.modules.accounts.base.OrganizationHistoryList;
import org.aspcfs.modules.accounts.base.OrganizationPhoneNumber;
import org.aspcfs.modules.accounts.base.OrganizationPhoneNumberList;
import org.aspcfs.modules.accounts.base.RevenueList;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.assets.base.AssetList;
import org.aspcfs.modules.base.Address;
import org.aspcfs.modules.base.CustomFieldRecordList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.RecipientList;
import org.aspcfs.modules.contacts.base.CallList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.pipeline.base.OpportunityHeaderList;
import org.aspcfs.modules.pipeline.base.OpportunityList;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.modules.relationships.base.RelationshipList;
import org.aspcfs.modules.servicecontracts.base.ServiceContractList;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.LookupElement;
import org.aspcfs.utils.web.LookupList;

public class Organization
extends GenericBean {
    private static Logger log = Logger.getLogger(Organization.class);
    protected double YTD = 0.0;
    private String errorMessage = "";
    private int orgId = -1;
    private String name = "";
    private String url = "";
    private String lastModified = "";
    private String notes = "";
    private int industry = 0;
    private int accountSize = -1;
    private boolean directBill = false;
    private String accountSizeName = null;
    private int listSalutation = -1;
    private int segmentList = -1;
    private int siteId = -1;
    private int stageId = -1;
    private String stageName = null;
    private String siteClient = null;
    public int segmentId = -1;
    private int subSegmentId = -1;
    private String industryName = null;
    private boolean minerOnly = false;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private Timestamp contractEndDate = null;
    private Timestamp alertDate = null;
    private String alertText = "";
    private int modifiedBy = -1;
    private boolean enabled = true;
    private int employees = 0;
    private double revenue = 0.0;
    private String ticker = "";
    private String accountNumber = "";
    private int owner = -1;
    private int duplicateId = -1;
    private int importId = -1;
    private int statusId = -1;
    private Timestamp trashedDate = null;
    private String alertDateTimeZone = null;
    private String contractEndDateTimeZone = null;
    private int source = -1;
    private int rating = -1;
    private double potential = 0.0;
    private int primaryContactId = -1;
    private String city = null;
    private String state = null;
    private String postalCode = null;
    private String county = null;
    private OrganizationAddressList addressList = new OrganizationAddressList();
    private OrganizationPhoneNumberList phoneNumberList = new OrganizationPhoneNumberList();
    private OrganizationEmailAddressList emailAddressList = new OrganizationEmailAddressList();
    private String ownerName = "";
    private String enteredByName = "";
    private String modifiedByName = "";
    private LookupList types = new LookupList();
    private ArrayList typeList = null;
    private boolean contactDelete = false;
    private boolean revenueDelete = false;
    private boolean documentDelete = false;
    private boolean insertPrimaryContact = true;
    private boolean hasEnabledOwnerAccount = true;
    private String nameSalutation = null;
    private String nameFirst = null;
    private String nameMiddle = null;
    private String nameLast = null;
    private String nameSuffix = null;
    private Contact primaryContact = null;
    private boolean hasOpportunities = false;
    private boolean hasPortalUsers = false;
    private boolean isIndividual = false;
    private boolean forceDelete = false;
    private String dunsType = null;
    private String dunsNumber = null;
    private String businessNameTwo = null;
    private int sicCode = -1;
    private int yearStarted = -1;
    private String sicDescription = null;

    public Organization() {
    }

    public Organization(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Organization(Connection db, int org_id) throws SQLException {
        if (org_id == -1) {
            throw new SQLException("Invalid Account");
        }
        PreparedStatement pst = db.prepareStatement("SELECT o.*, ct_owner.namelast AS o_namelast, ct_owner.namefirst AS o_namefirst, ct_eb.namelast AS eb_namelast, ct_eb.namefirst AS eb_namefirst, ct_mb.namelast AS mb_namelast, ct_mb.namefirst AS mb_namefirst, i.description AS industry_name, a.description AS account_size_name, oa.city as o_city, oa.state as o_state, oa.postalcode as o_postalcode, oa.county as o_county, ast.description as stage_name FROM organization o LEFT JOIN contact ct_owner ON (o.owner = ct_owner.user_id) LEFT JOIN contact ct_eb ON (o.enteredby = ct_eb.user_id) LEFT JOIN contact ct_mb ON (o.modifiedby = ct_mb.user_id) LEFT JOIN lookup_industry i ON (o.industry_temp_code = i.code) LEFT JOIN lookup_account_size a ON (o.account_size = a.code) LEFT JOIN organization_address oa ON (o.org_id = oa.org_id) LEFT JOIN lookup_account_stage ast ON (o.stage_id = ast.code) WHERE o.org_id = ?  AND (oa.address_id IS NULL OR oa.address_id IN ( SELECT ora.address_id FROM organization_address ora WHERE ora.org_id = o.org_id AND ora.primary_address = ?) OR oa.address_id IN (SELECT MIN(ctodd.address_id) FROM organization_address ctodd WHERE ctodd.org_id = o.org_id AND  ctodd.org_id NOT IN (SELECT org_id FROM organization_address WHERE organization_address.primary_address = ?)))");
        pst.setInt(1, org_id);
        pst.setBoolean(2, true);
        pst.setBoolean(3, true);
        ResultSet rs = DatabaseUtils.executeQuery(db, pst, log);
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.orgId == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        this.buildTypes(db);
        if (this.getNameLast() != null) {
            this.populatePrimaryContact(db);
        }
        this.phoneNumberList.setOrgId(this.getOrgId());
        this.phoneNumberList.buildList(db);
        this.addressList.setOrgId(this.getOrgId());
        this.addressList.buildList(db);
        this.emailAddressList.setOrgId(this.getOrgId());
        this.emailAddressList.buildList(db);
    }

    public void setTypeList(ArrayList typeList) {
        this.typeList = typeList;
    }

    public void setTypeList(String[] criteriaString) {
        if (criteriaString != null) {
            String[] params = criteriaString;
            this.typeList = new ArrayList<String>(Arrays.asList(params));
        } else {
            this.typeList = new ArrayList();
        }
    }

    public void setContactDelete(boolean tmp) {
        this.contactDelete = tmp;
    }

    public boolean getInsertPrimaryContact() {
        return this.insertPrimaryContact;
    }

    public void setInsertPrimaryContact(boolean tmp) {
        this.insertPrimaryContact = tmp;
    }

    public void setInsertPrimaryContact(String tmp) {
        this.insertPrimaryContact = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean isApproved() {
        return this.statusId != 6;
    }

    public void setRevenueDelete(boolean tmp) {
        this.revenueDelete = tmp;
    }

    public void setDocumentDelete(boolean tmp) {
        this.documentDelete = tmp;
    }

    public void setEnteredByName(String enteredByName) {
        this.enteredByName = enteredByName;
    }

    public void setModifiedByName(String modifiedByName) {
        this.modifiedByName = modifiedByName;
    }

    public void setHasEnabledOwnerAccount(boolean hasEnabledOwnerAccount) {
        this.hasEnabledOwnerAccount = hasEnabledOwnerAccount;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setAlertDateTimeZone(String tmp) {
        this.alertDateTimeZone = tmp;
    }

    public void setContractEndDateTimeZone(String tmp) {
        this.contractEndDateTimeZone = tmp;
    }

    public void setSource(int tmp) {
        this.source = tmp;
    }

    public void setSource(String tmp) {
        this.source = Integer.parseInt(tmp);
    }

    public void setRating(int tmp) {
        this.rating = tmp;
    }

    public void setRating(String tmp) {
        this.rating = Integer.parseInt(tmp);
    }

    public void setPotential(double tmp) {
        this.potential = tmp;
    }

    public String getAlertDateTimeZone() {
        return this.alertDateTimeZone;
    }

    public String getContractEndDateTimeZone() {
        return this.contractEndDateTimeZone;
    }

    public int getSource() {
        return this.source;
    }

    public int getRating() {
        return this.rating;
    }

    public double getPotential() {
        return this.potential;
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public boolean getHasEnabledOwnerAccount() {
        return this.hasEnabledOwnerAccount;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void checkEnabledOwnerAccount(Connection db) throws SQLException {
        if (this.getOwner() == -1) {
            throw new SQLException("ID not specified for lookup.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE user_id = ? AND enabled = ? ");
        pst.setInt(1, this.getOwner());
        pst.setBoolean(2, true);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.setHasEnabledOwnerAccount(true);
        } else {
            this.setHasEnabledOwnerAccount(false);
        }
        rs.close();
        pst.close();
    }

    public void setErrorMessage(String tmp) {
        this.errorMessage = tmp;
    }

    public void setTypes(LookupList types) {
        this.types = types;
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public void setImportId(int tmp) {
        this.importId = tmp;
    }

    public void setImportId(String tmp) {
        this.importId = Integer.parseInt(tmp);
    }

    public int getImportId() {
        return this.importId;
    }

    public Contact getPrimaryContact() {
        return this.primaryContact;
    }

    public void setPrimaryContact(Contact primaryContact) {
        this.primaryContact = primaryContact;
    }

    public void setOwnerId(int owner) {
        this.owner = owner;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setAlertDate(Timestamp tmp) {
        this.alertDate = tmp;
    }

    public void setAlertText(String tmp) {
        this.alertText = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public void setOwner(String owner) {
        this.owner = Integer.parseInt(owner);
    }

    public void setOwnerId(String owner) {
        this.owner = Integer.parseInt(owner);
    }

    public void setContractEndDate(Timestamp contractEndDate) {
        this.contractEndDate = contractEndDate;
    }

    public void setYTD(double YTD) {
        this.YTD = YTD;
    }

    public void setContractEndDate(String tmp) {
        this.contractEndDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setAlertDate(String tmp) {
        this.alertDate = DatabaseUtils.parseDateToTimestamp(tmp);
    }

    public void setEmployees(String employees) {
        try {
            this.employees = Integer.parseInt(employees);
        }
        catch (Exception e) {
            this.employees = 0;
        }
    }

    public void setDuplicateId(int duplicateId) {
        this.duplicateId = duplicateId;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
        this.addressList.setOrgId(tmp);
        this.phoneNumberList.setOrgId(tmp);
        this.emailAddressList.setOrgId(tmp);
    }

    public void setModifiedBy(int modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = Integer.parseInt(modifiedBy);
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public void setOrgId(String tmp) {
        this.setOrgId(Integer.parseInt(tmp));
    }

    public void setRevenue(String revenue) {
        this.revenue = Double.parseDouble(revenue);
    }

    public void setRevenue(double tmp) {
        this.revenue = tmp;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setUrl(String tmp) {
        this.url = tmp;
    }

    public void setTicker(String ticker) {
        this.ticker = ticker;
    }

    public void setLastModified(String tmp) {
        this.lastModified = tmp;
    }

    public void setNotes(String tmp) {
        this.notes = tmp;
    }

    public void setIndustry(String tmp) {
        this.industry = Integer.parseInt(tmp);
    }

    public void setAccountSize(String tmp) {
        this.accountSize = Integer.parseInt(tmp);
    }

    public void setListSalutation(int tmp) {
        this.listSalutation = tmp;
    }

    public void setListSalutation(String tmp) {
        this.listSalutation = Integer.parseInt(tmp);
    }

    public void setSegmentList(int segmentList) {
        this.segmentList = segmentList;
    }

    public void setSiteId(int siteId) {
        this.siteId = siteId;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setStageId(int stageId) {
        this.stageId = stageId;
    }

    public void setStageId(String tmp) {
        this.stageId = Integer.parseInt(tmp);
    }

    public int getStageId() {
        return this.stageId;
    }

    public String getStageName() {
        return this.stageName;
    }

    public void setSegmentList(String tmp) {
        this.segmentList = Integer.parseInt(tmp);
    }

    public void setSiteClient(String siteClient) {
        this.siteClient = siteClient;
    }

    public String getSiteClient() {
        return this.siteClient;
    }

    public void setSegmentId(int segmentId) {
        this.segmentId = segmentId;
    }

    public int getSegmentId() {
        return this.segmentId;
    }

    public void setSegmentId(String tmp) {
        this.segmentId = Integer.parseInt(tmp);
    }

    public void setSubSegmentId(String tmp) {
        this.subSegmentId = Integer.parseInt(tmp);
    }

    public void setSubSegmentId(int SubSegmentId) {
        this.subSegmentId = SubSegmentId;
    }

    public int getSubSegmentId() {
        return this.subSegmentId;
    }

    public int getSegmentList() {
        return this.segmentList;
    }

    public int getListSalutation() {
        return this.listSalutation;
    }

    public void setIndustry(int tmp) {
        this.industry = tmp;
    }

    public void setDirectBill(boolean tmp) {
        this.directBill = tmp;
    }

    public void setDirectBill(String tmp) {
        this.directBill = DatabaseUtils.parseBoolean(tmp);
    }

    public void setMiner_only(String tmp) {
        this.minerOnly = "true".equalsIgnoreCase(tmp) || "on".equalsIgnoreCase(tmp);
    }

    public void setMinerOnly(boolean tmp) {
        this.minerOnly = tmp;
    }

    public void setMinerOnly(String tmp) {
        this.minerOnly = "true".equalsIgnoreCase(tmp) || "on".equalsIgnoreCase(tmp);
    }

    public void setAddressList(OrganizationAddressList tmp) {
        this.addressList = tmp;
    }

    public void setPhoneNumberList(OrganizationPhoneNumberList tmp) {
        this.phoneNumberList = tmp;
    }

    public void setEmailAddressList(OrganizationEmailAddressList tmp) {
        this.emailAddressList = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setRequestItems(ActionContext context) {
        this.phoneNumberList = new OrganizationPhoneNumberList(context);
        this.addressList = new OrganizationAddressList(context.getRequest());
        this.emailAddressList = new OrganizationEmailAddressList(context.getRequest());
    }

    public boolean getContactDelete() {
        return this.contactDelete;
    }

    public boolean getRevenueDelete() {
        return this.revenueDelete;
    }

    public boolean getHasOpportunities() {
        return this.hasOpportunities;
    }

    public void setHasOpportunities(boolean hasOpportunities) {
        this.hasOpportunities = hasOpportunities;
    }

    public void setHasPortalUsers(boolean tmp) {
        this.hasPortalUsers = tmp;
    }

    public boolean getHasPortalUsers() {
        return this.hasPortalUsers;
    }

    public boolean getDocumentDelete() {
        return this.documentDelete;
    }

    public double getYTD() {
        return this.YTD;
    }

    public String getYTDValue() {
        double value_2dp = (double)Math.round(this.YTD * 100.0) / 100.0;
        String toReturn = String.valueOf(value_2dp);
        if (toReturn.endsWith(".0")) {
            toReturn = toReturn.substring(0, toReturn.length() - 2);
        }
        if (Integer.parseInt(toReturn) == 0) {
            toReturn = "";
        }
        return toReturn;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public ArrayList getTypeList() {
        return this.typeList;
    }

    public LookupList getTypes() {
        return this.types;
    }

    public Timestamp getAlertDate() {
        return this.alertDate;
    }

    public String getAlertText() {
        return this.alertText;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public String getModifiedString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateTimeInstance(3, 1).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getNameSalutation() {
        return this.nameSalutation;
    }

    public String getNameFirst() {
        return this.nameFirst;
    }

    public String getNameMiddle() {
        return this.nameMiddle;
    }

    public String getNameLast() {
        return this.nameLast;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNameSalutation(String tmp) {
        this.nameSalutation = tmp;
    }

    public void setNameFirst(String tmp) {
        this.nameFirst = tmp;
    }

    public void setNameMiddle(String tmp) {
        this.nameMiddle = tmp;
    }

    public void setNameLast(String tmp) {
        this.nameLast = tmp;
    }

    public void setNameSuffix(String tmp) {
        this.nameSuffix = tmp;
    }

    public Timestamp getContractEndDate() {
        return this.contractEndDate;
    }

    public String getContractEndDateString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.contractEndDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getContractEndDateBufferedString() {
        String tmp = "None";
        try {
            return DateFormat.getDateInstance(3).format(this.contractEndDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String[] getAsValuesArray() {
        String[] temp = new String[]{this.getName(), this.getUrl(), this.getOwnerName(), this.getEnteredByName(), this.getModifiedByName()};
        return temp;
    }

    public String getAlertDateString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.alertDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public String getAlertDetails() {
        StringBuffer out = new StringBuffer();
        if (this.alertDate == null) {
            return out.toString();
        }
        out.append(this.getAlertText() + " - " + this.getAlertDateString());
        return out.toString().trim();
    }

    public int getDuplicateId() {
        return this.duplicateId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getEnteredByName() {
        return this.enteredByName;
    }

    public String getModifiedByName() {
        return this.modifiedByName;
    }

    public int getOwner() {
        return this.owner;
    }

    public int getOwnerId() {
        return this.owner;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public String getTicker() {
        return this.ticker;
    }

    public double getRevenue() {
        return this.revenue;
    }

    public int getEmployees() {
        return this.employees;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getId() {
        return this.orgId;
    }

    public String getName() {
        if (this.name != null && this.name.trim().length() > 0) {
            return this.name;
        }
        return this.getNameLastFirstMiddle();
    }

    public String getAccountNameOnly() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUrlString() {
        if (this.url != null && this.url.indexOf("://") == -1) {
            return "http://" + this.url;
        }
        return this.url;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public String getNotes() {
        return this.notes;
    }

    public int getIndustry() {
        return this.industry;
    }

    public int getAccountSize() {
        return this.accountSize;
    }

    public String getIndustryName() {
        return this.industryName;
    }

    public String getAccountSizeName() {
        return this.accountSizeName;
    }

    public String getPhoneNumber(String thisType) {
        return this.phoneNumberList.getPhoneNumber(thisType);
    }

    public String getEmailAddress(String thisType) {
        return this.emailAddressList.getEmailAddress(thisType);
    }

    public Address getAddress(String thisType) {
        return this.getAddressList().getAddress(thisType);
    }

    public String getPrimaryEmailAddress() {
        return this.emailAddressList.getPrimaryEmailAddress();
    }

    public String getPrimaryPhoneNumber() {
        return this.phoneNumberList.getPrimaryPhoneNumber();
    }

    public Address getPrimaryAddress() {
        return this.getAddressList().getPrimaryAddress();
    }

    public int getEnteredby() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getMiner_only() {
        return this.minerOnly;
    }

    public boolean getMinerOnly() {
        return this.minerOnly;
    }

    public boolean getDirectBill() {
        return this.directBill;
    }

    public void setForceDelete(boolean tmp) {
        this.forceDelete = tmp;
    }

    public void setForceDelete(String tmp) {
        this.forceDelete = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getForceDelete() {
        return this.forceDelete;
    }

    public int getPrimaryContactId() {
        return this.primaryContactId;
    }

    public void setPrimaryContactId(int tmp) {
        this.primaryContactId = tmp;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String tmp) {
        this.city = tmp;
    }

    public void setState(String tmp) {
        this.state = tmp;
    }

    public void setPostalCode(String tmp) {
        this.postalCode = tmp;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setCounty(String tmp) {
        this.county = tmp;
    }

    public String getState() {
        return this.state;
    }

    public String getCounty() {
        return this.county;
    }

    public void setPrimaryContactId(String tmp) {
        this.primaryContactId = Integer.parseInt(tmp);
    }

    public boolean isTrashed() {
        return this.trashedDate != null;
    }

    public OrganizationAddressList getAddressList() {
        return this.addressList;
    }

    public OrganizationPhoneNumberList getPhoneNumberList() {
        return this.phoneNumberList;
    }

    public OrganizationEmailAddressList getEmailAddressList() {
        return this.emailAddressList;
    }

    public boolean getIsIndividual() {
        return this.isIndividual;
    }

    public void setIsIndividual(boolean tmp) {
        this.isIndividual = tmp;
    }

    public void setIsIndividual(String tmp) {
        this.isIndividual = DatabaseUtils.parseBoolean(tmp);
    }

    public String getBusinessNameTwo() {
        return this.businessNameTwo;
    }

    public String getDunsNumber() {
        return this.dunsNumber;
    }

    public String getDunsType() {
        return this.dunsType;
    }

    public int getSicCode() {
        return this.sicCode;
    }

    public String getSicDescription() {
        return this.sicDescription;
    }

    public int getYearStarted() {
        return this.yearStarted;
    }

    public void setBusinessNameTwo(String businessNameTwo) {
        this.businessNameTwo = businessNameTwo;
    }

    public void setDunsNumber(String dunsNumber) {
        this.dunsNumber = dunsNumber;
    }

    public void setDunsType(String dunsType) {
        this.dunsType = dunsType;
    }

    public void setEmployees(int employees) {
        this.employees = employees;
    }

    public void setSicCode(int sicCode) {
        this.sicCode = sicCode;
    }

    public void setSicCode(String sicCode) {
        this.sicCode = Integer.parseInt(sicCode);
    }

    public void setSicDescription(String tmp) {
        this.sicDescription = tmp;
    }

    public void setYearStarted(int yearStarted) {
        this.yearStarted = yearStarted;
    }

    public void setYearStarted(String yearStarted) {
        this.yearStarted = Integer.parseInt(yearStarted);
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        DependencyList dependencyList = new DependencyList();
        try {
            Dependency contactDependency = new Dependency();
            contactDependency.setName("contacts");
            contactDependency.setCount(ContactList.retrieveRecordCount(db, 1, this.getId(), true));
            contactDependency.setCanDelete(true);
            if (contactDependency.getCount() > 0) {
                ContactList contactList = new ContactList();
                contactList.setOrgId(this.orgId);
                contactList.setIncludeEnabledUsersOnly(true);
                contactList.buildList(db);
                for (Contact contact : contactList) {
                    if (RecipientList.retrieveRecordCount(db, 2, contact.getId()) <= 0) continue;
                    contactDependency.setCanDelete(false);
                    break;
                }
                for (Contact contact : contactList) {
                    contact.checkUserAccount(db);
                    if (!contact.hasAccount()) continue;
                    contactDependency.setCanDelete(false);
                    this.setHasPortalUsers(true);
                    break;
                }
            }
            dependencyList.add(contactDependency);
            Dependency relationshipDependency = new Dependency();
            relationshipDependency.setName("relationships");
            RelationshipList thisList = new RelationshipList();
            thisList.setCategoryIdMapsFrom(42420034);
            thisList.setObjectIdMapsFrom(this.getOrgId());
            thisList.setBuildDualMappings(true);
            thisList.buildList(db);
            relationshipDependency.setCount(thisList.getNumberOfRelationships());
            relationshipDependency.setCanDelete(true);
            dependencyList.add(relationshipDependency);
            Dependency revenueDependency = new Dependency();
            revenueDependency.setName("revenue");
            revenueDependency.setCount(RevenueList.retrieveRecordCount(db, 1, this.getId()));
            revenueDependency.setCanDelete(true);
            dependencyList.add(revenueDependency);
            int oppCount = OpportunityList.retrieveRecordCount(db, 1, this.getId());
            if (oppCount > 0) {
                this.setHasOpportunities(true);
            }
            Dependency oppDependency = new Dependency();
            oppDependency.setName("opportunities");
            oppDependency.setCount(oppCount);
            oppDependency.setCanDelete(false);
            dependencyList.add(oppDependency);
            Dependency scDependency = new Dependency();
            scDependency.setName("contracts");
            scDependency.setCount(ServiceContractList.retrieveRecordCount(db, 1, this.getId()));
            scDependency.setCanDelete(true);
            dependencyList.add(scDependency);
            Dependency assetDependency = new Dependency();
            assetDependency.setName("assets");
            assetDependency.setCount(AssetList.retrieveRecordCount(db, 1, this.getId()));
            assetDependency.setCanDelete(true);
            dependencyList.add(assetDependency);
            Dependency ticDependency = new Dependency();
            ticDependency.setName("tickets");
            ticDependency.setCount(TicketList.retrieveRecordCount(db, 1, this.getId()));
            ticDependency.setCanDelete(true);
            dependencyList.add(ticDependency);
            Dependency docDependency = new Dependency();
            docDependency.setName("documents");
            docDependency.setCount(FileItemList.retrieveRecordCount((Connection)db, (int)1, (int)this.getId()));
            docDependency.setCanDelete(true);
            dependencyList.add(docDependency);
            Dependency quoteDependency = new Dependency();
            quoteDependency.setName("quotes");
            quoteDependency.setCount(QuoteList.retrieveRecordCount(db, 1, this.getId()));
            quoteDependency.setCanDelete(true);
            dependencyList.add(quoteDependency);
            Dependency folderDependency = new Dependency();
            folderDependency.setName("folders");
            folderDependency.setCount(CustomFieldRecordList.retrieveRecordCount(db, 1, this.getId()));
            folderDependency.setCanDelete(true);
            dependencyList.add(folderDependency);
            Dependency planWorkDependency = new Dependency();
            planWorkDependency.setName("actionplanworks");
            planWorkDependency.setCount(ActionPlanWorkList.retrieveRecordCount(db, 1, this.getId()));
            planWorkDependency.setCanDelete(true);
            dependencyList.add(planWorkDependency);
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public void buildRevenueYTD(Connection db, int year, int type, int ownerId) throws SQLException {
        ResultSet rs;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT SUM(rv.amount) AS s FROM revenue rv WHERE rv.org_id = ? AND rv.year = ? AND rv.owner = ? ");
        if (type > 0) {
            sql.append("AND rv.type = ? ");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int i = 0;
        pst.setInt(++i, this.orgId);
        pst.setInt(++i, year);
        pst.setInt(++i, ownerId);
        if (type > 0) {
            pst.setInt(++i, type);
        }
        if ((rs = pst.executeQuery()).next()) {
            this.setYTD(rs.getDouble("s"));
        }
        rs.close();
        pst.close();
    }

    public void setTypeListToTypes(Connection db) throws SQLException {
        for (String tmpId : this.typeList) {
            this.types.add(new LookupElement(db, Integer.parseInt(tmpId), "lookup_account_types"));
        }
    }

    public void buildTypes(Connection db) throws SQLException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        PreparedStatement pst = db.prepareStatement("SELECT atl.type_id FROM account_type_levels atl WHERE atl.org_id = ? ORDER BY atl." + DatabaseUtils.addQuotes(db, "level") + " ");
        pst.setInt(1, this.getId());
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            list.add(new Integer(rs.getInt("type_id")));
        }
        rs.close();
        pst.close();
        Iterator li = list.iterator();
        while (li.hasNext()) {
            int thisTypeId = (Integer)li.next();
            this.types.add(new LookupElement(db, thisTypeId, "lookup_account_types"));
        }
    }

    public boolean insertType(Connection db, int type_id, int level) throws SQLException {
        if (this.orgId == -1) {
            throw new SQLException("No Organization ID Specified");
        }
        String sql = "INSERT INTO account_type_levels (org_id, type_id, " + DatabaseUtils.addQuotes(db, "level") + ") " + "VALUES (?, ?, ?) ";
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(++i, this.getOrgId());
        pst.setInt(++i, type_id);
        pst.setInt(++i, level);
        pst.execute();
        pst.close();
        return true;
    }

    public boolean resetType(Connection db) throws SQLException {
        if (this.getOrgId() == -1) {
            throw new SQLException("Organization ID not specified");
        }
        int i = 0;
        PreparedStatement pst = db.prepareStatement("DELETE FROM account_type_levels WHERE org_id = ? ");
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public boolean disable(Connection db) throws SQLException {
        if (this.getOrgId() == -1) {
            throw new SQLException("Organization ID not specified");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        boolean success = false;
        sql.append("UPDATE organization set enabled = ? WHERE org_id = ? ");
        sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setBoolean(++i, false);
        pst.setInt(++i, this.orgId);
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        int resultCount = pst.executeUpdate();
        pst.close();
        if (resultCount == 1) {
            success = true;
        }
        return success;
    }

    public boolean enable(Connection db) throws SQLException {
        if (this.getOrgId() == -1) {
            throw new SQLException("Organization ID not specified");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        boolean success = false;
        sql.append("UPDATE organization SET enabled = ? WHERE org_id = ? ");
        sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setBoolean(++i, true);
        pst.setInt(++i, this.orgId);
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        int resultCount = pst.executeUpdate();
        pst.close();
        if (resultCount == 1) {
            success = true;
        }
        return success;
    }

    public boolean checkIfExists(Connection db, String checkName) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        String sqlSelect = "SELECT name, org_id FROM organization WHERE " + DatabaseUtils.toLowerCase(db) + "(organization.name) = ? ";
        int i = 0;
        pst = db.prepareStatement(sqlSelect);
        pst.setString(++i, checkName.toLowerCase());
        rs = pst.executeQuery();
        if (rs.next()) {
            this.setDuplicateId(rs.getInt("org_id"));
            rs.close();
            pst.close();
            return true;
        }
        rs.close();
        pst.close();
        return false;
    }

    public static int lookupAccount(Connection db, String lookupName, int importId, int siteId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int lookupId = -1;
        String sqlSelect = "SELECT org_id FROM organization o WHERE " + DatabaseUtils.toLowerCase(db) + "(o.name) = ? " + "AND (o.status_id IS NULL OR o.status_id = ? OR (o.status_id = ? AND o.import_id = ?) ) " + "AND " + (siteId > -1 ? "o.site_id = ? " : "o.site_id IS NULL") + " " + "AND o.trashed_date IS NULL " + "AND o.enabled = ? ";
        int i = 0;
        pst = db.prepareStatement(sqlSelect);
        pst.setString(++i, lookupName.toLowerCase());
        pst.setInt(++i, 7);
        pst.setInt(++i, 6);
        pst.setInt(++i, importId);
        if (siteId > -1) {
            pst.setInt(++i, siteId);
        }
        pst.setBoolean(++i, true);
        rs = pst.executeQuery();
        if (rs.next()) {
            lookupId = rs.getInt("org_id");
        }
        rs.close();
        pst.close();
        return lookupId;
    }

    public static int lookupAccount(Connection db, String first, String middle, String last, int importId, int siteId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int lookupId = -1;
        String sqlSelect = "SELECT org_id FROM organization o WHERE " + DatabaseUtils.toLowerCase(db) + "(o.namefirst) = ? " + "AND " + DatabaseUtils.toLowerCase(db) + "(o.namemiddle) = ? " + "AND " + DatabaseUtils.toLowerCase(db) + "(o.namelast) = ? " + "AND (o.status_id IS NULL OR o.status_id = ? OR (o.status_id = ? AND o.import_id = ?) ) " + "AND " + (siteId > -1 ? "o.site_id = ? " : "o.site_id IS NULL") + " " + "AND o.trashed_date IS NULL " + "AND o.enabled = ? ";
        int i = 0;
        pst = db.prepareStatement(sqlSelect);
        pst.setString(++i, first != null ? first.toLowerCase() : (String)null);
        pst.setString(++i, middle != null ? middle.toLowerCase() : (String)null);
        pst.setString(++i, last != null ? last.toLowerCase() : (String)null);
        pst.setInt(++i, 7);
        pst.setInt(++i, 6);
        pst.setInt(++i, importId);
        if (siteId > -1) {
            pst.setInt(++i, siteId);
        }
        pst.setBoolean(++i, true);
        rs = pst.executeQuery();
        if (rs.next()) {
            lookupId = rs.getInt("org_id");
        }
        rs.close();
        pst.close();
        return lookupId;
    }

    public static int getOrganizationSiteId(Connection db, int tmpOrgId) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int organizationSiteId = -1;
        String sqlSelect = "SELECT site_id FROM organization WHERE org_id = ? ";
        int i = 0;
        pst = db.prepareStatement(sqlSelect);
        pst.setInt(++i, tmpOrgId);
        rs = pst.executeQuery();
        if (rs.next()) {
            organizationSiteId = DatabaseUtils.getInt(rs, "site_id");
        }
        rs.close();
        pst.close();
        return organizationSiteId;
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        boolean doCommit = false;
        try {
            this.modifiedBy = this.enteredBy;
            if (this.stageId == -1) {
                LookupList stageList = new LookupList();
                stageList.tableName = "lookup_account_stage";
                stageList.setShowDisabledFlag(false);
                stageList.buildList(db);
                if (stageList.getFirstEnabledElement() > 0) {
                    this.stageId = stageList.getFirstEnabledElement();
                }
            }
            if (doCommit = db.getAutoCommit()) {
                db.setAutoCommit(false);
            }
            this.orgId = DatabaseUtils.getNextSeq(db, "organization_org_id_seq");
            sql.append("INSERT INTO organization (name, industry_temp_code, url, miner_only, owner, duplicate_id, notes, employees, revenue, ticker_symbol, account_number, namesalutation, namefirst, namelast, namemiddle, trashed_date, segment_id,  direct_bill, account_size,  sub_segment_id, site_id, source, rating, potential, duns_type, duns_number, business_name_two, year_started, sic_code, sic_description, ");
            if (this.orgId > -1) {
                sql.append("org_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.statusId > -1) {
                sql.append("status_id, ");
            }
            if (this.stageId > -1) {
                sql.append("stage_id, ");
            }
            if (this.importId > -1) {
                sql.append("import_id, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("enteredBy, modifiedBy) ");
            sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,");
            sql.append("?,?,?,?,?,?,");
            if (this.orgId > -1) {
                sql.append("?,");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.statusId > -1) {
                sql.append("?, ");
            }
            if (this.stageId > -1) {
                sql.append("?, ");
            }
            if (this.importId > -1) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setString(++i, this.getName());
            pst.setInt(++i, this.getIndustry());
            pst.setString(++i, this.getUrl());
            pst.setBoolean(++i, this.getMinerOnly());
            DatabaseUtils.setInt(pst, ++i, this.getOwner());
            pst.setInt(++i, this.getDuplicateId());
            pst.setString(++i, this.getNotes());
            DatabaseUtils.setInt(pst, ++i, this.getEmployees());
            pst.setDouble(++i, this.getRevenue());
            pst.setString(++i, this.getTicker());
            pst.setString(++i, this.getAccountNumber());
            pst.setString(++i, this.getNameSalutation());
            pst.setString(++i, this.getNameFirst());
            pst.setString(++i, this.getNameLast());
            pst.setString(++i, this.getNameMiddle());
            DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
            DatabaseUtils.setInt(pst, ++i, this.getSegmentId());
            pst.setBoolean(++i, this.getDirectBill());
            DatabaseUtils.setInt(pst, ++i, this.getAccountSize());
            DatabaseUtils.setInt(pst, ++i, this.getSubSegmentId());
            DatabaseUtils.setInt(pst, ++i, this.getSiteId());
            DatabaseUtils.setInt(pst, ++i, this.getSource());
            DatabaseUtils.setInt(pst, ++i, this.getRating());
            pst.setDouble(++i, this.getPotential());
            pst.setString(++i, this.getDunsType());
            pst.setString(++i, this.getDunsNumber());
            pst.setString(++i, this.getBusinessNameTwo());
            DatabaseUtils.setInt(pst, ++i, this.getYearStarted());
            DatabaseUtils.setInt(pst, ++i, this.getSicCode());
            pst.setString(++i, this.getSicDescription());
            if (this.orgId > -1) {
                pst.setInt(++i, this.orgId);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.statusId > -1) {
                pst.setInt(++i, this.getStatusId());
            }
            if (this.stageId > -1) {
                pst.setInt(++i, this.getStageId());
            }
            if (this.importId > -1) {
                pst.setInt(++i, this.getImportId());
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.getModifiedBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.orgId = DatabaseUtils.getCurrVal(db, "organization_org_id_seq", this.orgId);
            if (this.insertPrimaryContact && this.nameLast != null && !"".equals(this.nameLast)) {
                this.primaryContact.setOrgId(this.orgId);
                this.primaryContact.setOrgName(this.getName());
                boolean contactInserted = ObjectValidator.validate(null, db, (Object)this.primaryContact);
                if (contactInserted) {
                    contactInserted = this.primaryContact.insert(db);
                }
                if (!contactInserted) {
                    throw new SQLException("Contact could not be inserted");
                }
            }
            for (OrganizationPhoneNumber thisPhoneNumber : this.phoneNumberList) {
                thisPhoneNumber.process(db, this.orgId, this.getEnteredBy(), this.getModifiedBy());
            }
            for (OrganizationAddress thisAddress : this.getAddressList()) {
                thisAddress.process(db, this.orgId, this.getEnteredBy(), this.getModifiedBy());
            }
            for (OrganizationEmailAddress thisEmailAddress : this.emailAddressList) {
                thisEmailAddress.process(db, this.orgId, this.getEnteredBy(), this.getModifiedBy());
            }
            this.update(db, true);
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int i = -1;
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            i = this.update(db, false);
            for (OrganizationPhoneNumber thisPhoneNumber : this.phoneNumberList) {
                thisPhoneNumber.process(db, this.getOrgId(), this.getEnteredBy(), this.getModifiedBy());
            }
            for (OrganizationAddress thisAddress : this.getAddressList()) {
                thisAddress.process(db, this.getOrgId(), this.getEnteredBy(), this.getModifiedBy());
            }
            for (OrganizationEmailAddress thisEmailAddress : this.emailAddressList) {
                thisEmailAddress.process(db, this.getOrgId(), this.getEnteredBy(), this.getModifiedBy());
            }
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return i;
    }

    public boolean reassign(Connection db, int newOwner) throws SQLException {
        int result = -1;
        this.setOwner(newOwner);
        result = this.update(db);
        return result != -1;
    }

    public void populatePrimaryContact() {
        this.primaryContact = new Contact();
        this.primaryContact.setNameFirst(this.getNameFirst());
        this.primaryContact.setNameMiddle(this.getNameMiddle());
        this.primaryContact.setOrgId(this.getOrgId());
        this.primaryContact.setEnteredBy(this.getEnteredBy());
        this.primaryContact.setModifiedBy(this.getModifiedBy());
        this.primaryContact.setOwner(this.getOwner());
        this.primaryContact.setNameLast(this.getNameLast());
        this.primaryContact.setOrgName(this.getName());
        this.primaryContact.setPrimaryContact(true);
        this.primaryContact.setTitle(this.getAccountNumber());
        this.primaryContact.setListSalutation(this.getListSalutation());
    }

    public void populateRegularContact() {
        this.primaryContact = new Contact();
        this.primaryContact.setNameFirst(this.getNameFirst());
        this.primaryContact.setNameMiddle(this.getNameMiddle());
        this.primaryContact.setOrgId(this.getOrgId());
        this.primaryContact.setEnteredBy(this.getEnteredBy());
        this.primaryContact.setModifiedBy(this.getModifiedBy());
        this.primaryContact.setOwner(this.getOwner());
        this.primaryContact.setNameLast(this.getNameLast());
        this.primaryContact.setOrgName(this.getName());
        this.primaryContact.setPrimaryContact(false);
        this.primaryContact.setTitle(this.getAccountNumber());
        this.primaryContact.setListSalutation(this.getListSalutation());
    }

    public void updatePrimaryContact() {
        this.primaryContact.setNameFirst(this.getNameFirst());
        this.primaryContact.setNameLast(this.getNameLast());
        this.primaryContact.setNameMiddle(this.getNameMiddle());
        this.primaryContact.setModifiedBy(this.getModifiedBy());
        this.primaryContact.setOwner(this.getOwner());
        this.primaryContact.setOrgName(this.getName());
    }

    public void populatePrimaryContact(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT contact_id FROM contact WHERE org_id = ? AND primary_contact = ? ");
        pst.setInt(1, this.getOrgId());
        pst.setBoolean(2, true);
        ResultSet rs = pst.executeQuery();
        int tmpContactId = -1;
        if (rs.next()) {
            tmpContactId = rs.getInt("contact_id");
        }
        rs.close();
        pst.close();
        if (tmpContactId != -1) {
            this.primaryContact = new Contact();
            this.primaryContact.setBuildDetails(true);
            this.primaryContact.queryRecord(db, tmpContactId);
        }
    }

    public int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE organization SET name = ?, industry_temp_code = ?, url = ?, notes= ?, ");
        if (!override) {
            sql.append("modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
        }
        sql.append("modifiedby = ?, employees = ?, revenue = ?, ticker_symbol = ?, account_number = ?, ");
        if (this.owner > -1) {
            sql.append("owner = ?, ");
        }
        sql.append("duplicate_id = ?, contract_end = ?, contract_end_timezone = ?, alertdate = ?, alertdate_timezone=?, alert = ?, namesalutation = ?, namefirst = ?, namemiddle = ?, namelast = ?, trashed_date = ?, segment_id = ?, direct_bill = ?, account_size = ?, site_id = ?, sub_segment_id = ?, source = ?, rating = ?, potential = ?, duns_type = ?, duns_number = ?, business_name_two = ?, year_started = ?, sic_code = ?, sic_description = ?, ");
        sql.append("stage_id = ? ");
        sql.append("WHERE org_id = ? ");
        if (!override) {
            sql.append("AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
        }
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.name);
        pst.setInt(++i, this.industry);
        pst.setString(++i, this.url);
        pst.setString(++i, this.notes);
        pst.setInt(++i, this.getModifiedBy());
        DatabaseUtils.setInt(pst, ++i, this.employees);
        pst.setDouble(++i, this.revenue);
        pst.setString(++i, this.ticker);
        pst.setString(++i, this.accountNumber);
        if (this.owner > -1) {
            pst.setInt(++i, this.getOwner());
        }
        pst.setInt(++i, this.getDuplicateId());
        DatabaseUtils.setTimestamp(pst, ++i, this.getContractEndDate());
        pst.setString(++i, this.getContractEndDateTimeZone());
        DatabaseUtils.setTimestamp(pst, ++i, this.getAlertDate());
        pst.setString(++i, this.getAlertDateTimeZone());
        pst.setString(++i, this.alertText);
        pst.setString(++i, this.getNameSalutation());
        pst.setString(++i, this.nameFirst);
        pst.setString(++i, this.nameMiddle);
        pst.setString(++i, this.nameLast);
        DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
        DatabaseUtils.setInt(pst, ++i, this.segmentId);
        pst.setBoolean(++i, this.directBill);
        DatabaseUtils.setInt(pst, ++i, this.accountSize);
        DatabaseUtils.setInt(pst, ++i, this.siteId);
        DatabaseUtils.setInt(pst, ++i, this.subSegmentId);
        DatabaseUtils.setInt(pst, ++i, this.getSource());
        DatabaseUtils.setInt(pst, ++i, this.getRating());
        pst.setDouble(++i, this.getPotential());
        pst.setString(++i, this.getDunsType());
        pst.setString(++i, this.getDunsNumber());
        pst.setString(++i, this.getBusinessNameTwo());
        DatabaseUtils.setInt(pst, ++i, this.getYearStarted());
        DatabaseUtils.setInt(pst, ++i, this.getSicCode());
        pst.setString(++i, this.getSicDescription());
        DatabaseUtils.setInt(pst, ++i, this.stageId);
        pst.setInt(++i, this.orgId);
        if (!override && this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        resultCount = pst.executeUpdate();
        pst.close();
        pst = db.prepareStatement("UPDATE contact SET org_name = ? WHERE org_id = ? AND org_name NOT LIKE ? ");
        pst.setString(1, this.name);
        pst.setInt(2, this.orgId);
        pst.setString(3, this.name);
        pst.executeUpdate();
        pst.close();
        if (!this.getMinerOnly() && this.typeList != null) {
            this.resetType(db);
            int lvlcount = 0;
            for (int k = 0; k < this.typeList.size(); ++k) {
                String val = (String)this.typeList.get(k);
                if (val != null && !val.equals("") && !val.equals("-1")) {
                    int type_id = Integer.parseInt((String)this.typeList.get(k));
                    this.insertType(db, type_id, ++lvlcount);
                    continue;
                }
                --lvlcount;
            }
        }
        return resultCount;
    }

    public static void renameMyCompany(Connection db, String newName) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE organization SET name = ? WHERE org_id = 0 ");
        pst.setString(1, newName);
        pst.execute();
        pst.close();
    }

    public boolean delete(Connection db, ActionContext context, String baseFilePath) throws SQLException {
        if (this.getOrgId() == -1) {
            throw new SQLException("Organization ID not specified.");
        }
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            RelationshipList thisList = new RelationshipList();
            thisList.setCategoryIdMapsFrom(42420034);
            thisList.setObjectIdMapsFrom(this.getOrgId());
            thisList.setBuildDualMappings(true);
            thisList.buildList(db);
            thisList.delete(db);
            TicketList ticketList = new TicketList();
            ticketList.setOrgId(this.getOrgId());
            ticketList.buildList(db);
            ticketList.delete(db, baseFilePath);
            ticketList = null;
            ticketList = new TicketList();
            ticketList.setOrgId(this.getOrgId());
            ticketList.setIncludeOnlyTrashed(true);
            ticketList.buildList(db);
            ticketList.delete(db, baseFilePath);
            ticketList = null;
            AssetList assetList = new AssetList();
            assetList.setOrgId(this.getOrgId());
            assetList.buildList(db);
            assetList.delete(db, baseFilePath);
            assetList = null;
            assetList = new AssetList();
            assetList.setOrgId(this.getOrgId());
            assetList.setIncludeOnlyTrashed(true);
            assetList.buildList(db);
            assetList.delete(db, baseFilePath);
            assetList = null;
            ServiceContractList scList = new ServiceContractList();
            scList.setOrgId(this.getOrgId());
            scList.buildList(db);
            scList.delete(db, baseFilePath);
            scList = null;
            scList = new ServiceContractList();
            scList.setOrgId(this.getOrgId());
            scList.setIncludeOnlyTrashed(true);
            scList.buildList(db);
            scList.delete(db, baseFilePath);
            scList = null;
            if (this.documentDelete) {
                FileItemList fileList = new FileItemList();
                fileList.setLinkModuleId(1);
                fileList.setLinkItemId(this.getOrgId());
                fileList.buildList(db);
                fileList.delete(db, this.getFileLibraryPath(baseFilePath, "accounts"));
                fileList = null;
            }
            CustomFieldRecordList folderList = new CustomFieldRecordList();
            folderList.setLinkModuleId(1);
            folderList.setLinkItemId(this.getOrgId());
            folderList.buildList(db);
            folderList.delete(db);
            folderList = null;
            if (this.revenueDelete) {
                RevenueList revenueList = new RevenueList();
                revenueList.setOrgId(this.getOrgId());
                revenueList.buildList(db);
                revenueList.delete(db);
                revenueList = null;
            }
            CallList callList = new CallList();
            callList.setOrgId(this.getOrgId());
            callList.buildList(db);
            callList.delete(db);
            callList = null;
            QuoteList quotes = new QuoteList();
            quotes.setOrgId(this.getOrgId());
            quotes.setDeleteAllQuotes(true);
            quotes.buildList(db);
            quotes.delete(db);
            quotes = null;
            ProjectUtils.removeAccounts((Connection)db, (int)this.getOrgId());
            if (this.forceDelete) {
                OpportunityHeaderList opportunityList = new OpportunityHeaderList();
                opportunityList.setOrgId(this.getOrgId());
                opportunityList.buildList(db);
                opportunityList.delete(db, context, baseFilePath);
                opportunityList = new OpportunityHeaderList();
                opportunityList.setOrgId(this.getOrgId());
                opportunityList.setIncludeOnlyTrashed(true);
                opportunityList.buildList(db);
                opportunityList.delete(db, context, baseFilePath);
            }
            if (this.contactDelete) {
                ContactList contactList = new ContactList();
                contactList.setOrgId(this.getOrgId());
                contactList.buildList(db);
                contactList.delete(db, baseFilePath, this.forceDelete);
                contactList = null;
                contactList = new ContactList();
                contactList.setOrgId(this.getOrgId());
                contactList.setIncludeEnabled(0);
                contactList.buildList(db);
                contactList.delete(db, baseFilePath, this.forceDelete);
                contactList = null;
                contactList = new ContactList();
                contactList.setOrgId(this.getOrgId());
                contactList.setIncludeOnlyTrashed(true);
                contactList.buildList(db);
                contactList.delete(db, baseFilePath, this.forceDelete);
                contactList = null;
                contactList = new ContactList();
                contactList.setImportId(this.getImportId());
                contactList.setOrgId(this.getOrgId());
                contactList.setIncludeAllSites(true);
                contactList.setExcludeUnapprovedContacts(false);
                contactList.buildList(db);
                contactList.delete(db, baseFilePath, this.forceDelete);
            }
            ActionPlanWorkList planWorkList = new ActionPlanWorkList();
            planWorkList.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 42420034));
            planWorkList.setSiteId(this.getSiteId());
            planWorkList.setLinkItemId(this.getOrgId());
            planWorkList.buildList(db);
            planWorkList.delete(db);
            OrganizationHistoryList history = new OrganizationHistoryList();
            history.setOrgId(this.getOrgId());
            history.buildList(db);
            history.delete(db);
            this.resetType(db);
            Statement st = db.createStatement();
            st.executeUpdate("DELETE FROM organization_phone WHERE org_id = " + this.getOrgId());
            st.executeUpdate("DELETE FROM organization_emailaddress WHERE org_id = " + this.getOrgId());
            st.executeUpdate("DELETE FROM organization_address WHERE org_id = " + this.getOrgId());
            st.executeUpdate("DELETE FROM organization WHERE org_id = " + this.getOrgId());
            st.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void deleteMinerOnly(Connection db) throws SQLException {
        if (this.getOrgId() == -1) {
            throw new SQLException("The Organization could not be found.");
        }
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            Statement st = db.createStatement();
            st.executeUpdate("DELETE FROM news WHERE org_id = " + this.getOrgId());
            st.close();
            PreparedStatement pst = db.prepareStatement("DELETE FROM organization WHERE org_id = ? AND miner_only = ? ");
            pst.setInt(1, this.getOrgId());
            pst.setBoolean(2, true);
            pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public static int updateImportStatus(Connection db, int importId, int status) throws SQLException {
        int count = 0;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            String sql = "UPDATE organization SET status_id = ? WHERE import_id = ? ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setInt(++i, status);
            pst.setInt(++i, importId);
            count = pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return count;
    }

    public boolean updateStatus(Connection db, ActionContext context, boolean toTrash, int tmpUserId) throws SQLException {
        int count = 0;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE organization SET trashed_date = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + "modifiedby = ? " + "WHERE org_id = ? ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (toTrash) {
                DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
            } else {
                DatabaseUtils.setTimestamp(pst, ++i, null);
            }
            pst.setInt(++i, tmpUserId);
            pst.setInt(++i, this.getId());
            count = pst.executeUpdate();
            pst.close();
            OrganizationHistoryList historyList = new OrganizationHistoryList();
            historyList.setOrgId(this.getOrgId());
            historyList.setDefaultFilters(true);
            historyList.setShowDisabledWithEnabled(true);
            historyList.buildList(db);
            historyList.disableNotesInHistory(db, !toTrash);
            RelationshipList thisList = new RelationshipList();
            thisList.setCategoryIdMapsFrom(42420034);
            thisList.setObjectIdMapsFrom(this.getOrgId());
            thisList.setBuildDualMappings(true);
            thisList.buildList(db);
            thisList.updateStatus(db, toTrash, tmpUserId);
            ContactList contactList = new ContactList();
            contactList.setShowTrashedAndNormal(true);
            contactList.setOrgId(this.getId());
            contactList.buildList(db);
            for (Contact contact : contactList) {
                OpportunityHeaderList oppList = new OpportunityHeaderList();
                if (!toTrash) {
                    oppList.setIncludeOnlyTrashed(true);
                }
                oppList.setContactId(contact.getId());
                oppList.buildList(db);
                oppList.updateStatus(db, context, toTrash, tmpUserId);
            }
            contactList = new ContactList();
            contactList.setOrgId(this.getId());
            if (!toTrash) {
                contactList.setIncludeOnlyTrashed(true);
            }
            contactList.buildList(db);
            contactList.updateStatus(db, context, toTrash, tmpUserId);
            CallList callList = new CallList();
            callList.setOrgId(this.getOrgId());
            if (!toTrash) {
                callList.setIncludeOnlyTrashed(true);
            }
            callList.buildList(db);
            callList.updateStatus(db, toTrash, tmpUserId);
            QuoteList quoteList = new QuoteList();
            quoteList.setOrgId(this.getId());
            if (!toTrash) {
                quoteList.setIncludeOnlyTrashed(true);
            }
            quoteList.buildList(db);
            quoteList.updateStatus(db, toTrash, tmpUserId);
            OpportunityList opportunityList = new OpportunityList();
            opportunityList.setOrgId(this.getId());
            if (!toTrash) {
                opportunityList.setIncludeOnlyTrashed(true);
            }
            opportunityList.buildList(db);
            opportunityList.updateStatus(db, context, toTrash, tmpUserId);
            AssetList assetList = new AssetList();
            assetList.setOrgId(this.getId());
            if (!toTrash) {
                assetList.setIncludeOnlyTrashed(true);
            }
            assetList.buildList(db);
            assetList.updateStatus(db, toTrash, tmpUserId);
            ServiceContractList serviceContractList = new ServiceContractList();
            serviceContractList.setOrgId(this.getId());
            if (!toTrash) {
                serviceContractList.setIncludeOnlyTrashed(true);
            }
            serviceContractList.buildList(db);
            serviceContractList.updateStatus(db, toTrash, tmpUserId);
            TicketList ticketList = new TicketList();
            ticketList.setOrgId(this.getId());
            if (!toTrash) {
                ticketList.setIncludeOnlyTrashed(true);
            }
            ticketList.buildList(db);
            ticketList.updateStatus(db, toTrash, tmpUserId);
            ActionPlanWorkList planWorkList = new ActionPlanWorkList();
            planWorkList.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 42420034));
            planWorkList.setIncludeAllSites(true);
            planWorkList.setLinkItemId(this.getOrgId());
            planWorkList.buildList(db);
            planWorkList.delete(db);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public static boolean deleteImportedRecords(Connection db, int thisImportId) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("DELETE FROM organization_emailaddress WHERE org_id IN (SELECT org_id from organization o where import_id = ? AND o.org_id = organization_emailaddress.org_id) ");
            pst.setInt(1, thisImportId);
            pst.executeUpdate();
            pst.close();
            pst = db.prepareStatement("DELETE FROM organization_phone WHERE org_id IN (SELECT org_id from organization o where import_id = ? AND o.org_id = organization_phone.org_id)");
            pst.setInt(1, thisImportId);
            pst.executeUpdate();
            pst.close();
            pst = db.prepareStatement("DELETE FROM organization_address WHERE org_id IN (SELECT org_id from organization o where import_id = ? AND o.org_id = organization_address.org_id) ");
            pst.setInt(1, thisImportId);
            pst.executeUpdate();
            pst.close();
            pst = db.prepareStatement("DELETE FROM organization WHERE import_id = ?");
            pst.setInt(1, thisImportId);
            pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean hasContacts(Connection db) throws SQLException {
        int recordCount = -1;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) as recordcount FROM contact WHERE org_id = ? ");
        pst.setInt(1, this.getOrgId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            recordCount = rs.getInt("recordCount");
        }
        rs.close();
        pst.close();
        return recordCount > 0;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("=================================================\r\n");
        out.append("Organization Name: " + this.getName() + "\r\n");
        out.append("ID: " + this.getOrgId() + "\r\n");
        return out.toString();
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setOrgId(rs.getInt("org_id"));
        this.name = rs.getString("name");
        this.accountNumber = rs.getString("account_number");
        this.url = rs.getString("url");
        this.revenue = rs.getDouble("revenue");
        this.employees = DatabaseUtils.getInt(rs, "employees");
        this.notes = rs.getString("notes");
        this.ticker = rs.getString("ticker_symbol");
        this.minerOnly = rs.getBoolean("miner_only");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enabled = rs.getBoolean("enabled");
        this.industry = rs.getInt("industry_temp_code");
        this.owner = DatabaseUtils.getInt(rs, "owner");
        this.stageId = DatabaseUtils.getInt(rs, "stage_id");
        this.duplicateId = rs.getInt("duplicate_id");
        this.contractEndDate = rs.getTimestamp("contract_end");
        this.alertDate = rs.getTimestamp("alertdate");
        this.alertText = rs.getString("alert");
        this.nameSalutation = rs.getString("namesalutation");
        this.nameLast = rs.getString("namelast");
        this.nameFirst = rs.getString("namefirst");
        this.nameMiddle = rs.getString("namemiddle");
        this.nameSuffix = rs.getString("namesuffix");
        this.importId = DatabaseUtils.getInt(rs, "import_id");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.alertDateTimeZone = rs.getString("alertdate_timezone");
        this.contractEndDateTimeZone = rs.getString("contract_end_timezone");
        this.trashedDate = rs.getTimestamp("trashed_date");
        this.source = DatabaseUtils.getInt(rs, "source");
        this.rating = DatabaseUtils.getInt(rs, "rating");
        this.potential = rs.getDouble("potential");
        this.segmentId = DatabaseUtils.getInt(rs, "segment_id");
        this.directBill = rs.getBoolean("direct_bill");
        this.accountSize = DatabaseUtils.getInt(rs, "account_size");
        this.subSegmentId = DatabaseUtils.getInt(rs, "sub_segment_id");
        this.siteId = DatabaseUtils.getInt(rs, "site_id");
        this.dunsType = rs.getString("duns_type");
        this.dunsNumber = rs.getString("duns_number");
        this.businessNameTwo = rs.getString("business_name_two");
        this.sicCode = DatabaseUtils.getInt(rs, "sic_code");
        this.yearStarted = DatabaseUtils.getInt(rs, "year_started");
        this.sicDescription = rs.getString("sic_description");
        this.ownerName = Contact.getNameLastFirst(rs.getString("o_namelast"), rs.getString("o_namefirst"));
        this.enteredByName = Contact.getNameLastFirst(rs.getString("eb_namelast"), rs.getString("eb_namefirst"));
        this.modifiedByName = Contact.getNameLastFirst(rs.getString("mb_namelast"), rs.getString("mb_namefirst"));
        this.industryName = rs.getString("industry_name");
        this.accountSizeName = rs.getString("account_size_name");
        this.city = rs.getString("o_city");
        this.state = rs.getString("o_state");
        this.postalCode = rs.getString("o_postalcode");
        this.county = rs.getString("o_county");
        this.stageName = rs.getString("stage_name");
    }

    public String getNameLastFirstMiddle() {
        StringBuffer out = new StringBuffer();
        if (this.nameLast != null && this.nameLast.trim().length() > 0) {
            out.append(this.nameLast);
        }
        if (this.nameFirst != null && this.nameFirst.trim().length() > 0) {
            if (this.nameLast.length() > 0) {
                out.append(", ");
            }
            out.append(this.nameFirst);
        }
        if (this.nameMiddle != null && this.nameMiddle.trim().length() > 0) {
            if (this.nameMiddle.length() > 0) {
                out.append(" ");
            }
            out.append(this.nameMiddle);
        }
        if (out.toString().length() == 0) {
            return null;
        }
        return out.toString().trim();
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("alertDate");
        thisList.add("contractEndDate");
        return thisList;
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("revenue");
        thisList.add("potential");
        return thisList;
    }

    public String generateWebcalEvent(TimeZone tz, Timestamp created, Timestamp alertDate, User user, String category, int type) {
        StringBuffer webcal = new StringBuffer();
        String CRLF = System.getProperty("line.separator");
        String description = "";
        if (this.name != null) {
            description = description + "Account: " + this.name;
        }
        if (user != null && user.getContact() != null) {
            description = description + "\\nOwner: " + user.getContact().getNameFirstLast();
        }
        webcal.append("BEGIN:VEVENT" + CRLF);
        if (type == 1) {
            webcal.append("UID:www.centriccrm.com-accounts-alerts-" + this.getOrgId() + CRLF);
        } else if (type == 2) {
            webcal.append("UID:www.centriccrm.com-accounts-contract-alerts-" + this.getOrgId() + CRLF);
        }
        if (created != null) {
            webcal.append("DTSTAMP:" + ICalendar.getDateTimeUTC((Timestamp)created) + CRLF);
        }
        if (this.entered != null) {
            webcal.append("CREATED:" + ICalendar.getDateTimeUTC((Timestamp)this.entered) + CRLF);
        }
        if (alertDate != null) {
            webcal.append("DTSTART;TZID=" + tz.getID() + ":" + ICalendar.getDateTime((TimeZone)tz, (Timestamp)alertDate) + CRLF);
        }
        if (type == 1) {
            if (this.alertText != null) {
                webcal.append(ICalendar.foldLine((String)("SUMMARY:" + ICalendar.parseNewLine((String)this.alertText))) + CRLF);
            }
        } else if (type == 2) {
            webcal.append("SUMMARY:Account Contract Expiry!" + CRLF);
        }
        if (description != null) {
            webcal.append(ICalendar.foldLine((String)("DESCRIPTION:" + ICalendar.parseNewLine((String)description))) + CRLF);
        }
        if (category != null) {
            webcal.append("CATEGORIES:" + category + CRLF);
        }
        webcal.append("END:VEVENT" + CRLF);
        return webcal.toString();
    }

    public static int countEmployees(Connection db, int id) throws SQLException {
        int result = -1;
        PreparedStatement pst = db.prepareStatement("SELECT employees FROM organization WHERE org_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            result = rs.getInt("employees");
        }
        rs.close();
        pst.close();
        return result;
    }

    public static void updateEmployeeCount(Connection db, int id, int employeeCount) throws SQLException {
        StringBuffer sql = new StringBuffer();
        if (employeeCount != -1) {
            sql.append("UPDATE organization SET employees = ? WHERE org_id = ? AND employees <> ? ");
        } else {
            sql.append("UPDATE organization SET employees = ? WHERE org_id = ? AND employees IS NOT NULL ");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, 1, employeeCount);
        pst.setInt(2, id);
        if (employeeCount != -1) {
            pst.setInt(3, employeeCount);
        }
        pst.executeUpdate();
        pst.close();
    }

    public boolean hasType(int typeId) {
        if (this.types != null) {
            for (LookupElement element : this.types) {
                if (element.getCode() != typeId) continue;
                return true;
            }
        }
        return false;
    }

    public DependencyList processResetToLeadDependencies(Connection db) throws SQLException {
        DependencyList dependencyList = new DependencyList();
        try {
            Dependency contactDependency = new Dependency();
            contactDependency.setName("contacts");
            ContactList contacts = new ContactList();
            contacts.setOrgId(this.getOrgId());
            contacts.setHasConversionDate(0);
            contacts.buildList(db);
            contactDependency.setCount(contacts.size());
            contactDependency.setCanDelete(false);
            dependencyList.add(contactDependency);
            Dependency relationshipDependency = new Dependency();
            relationshipDependency.setName("relationships");
            RelationshipList thisList = new RelationshipList();
            thisList.setCategoryIdMapsFrom(42420034);
            thisList.setObjectIdMapsFrom(this.getOrgId());
            thisList.setBuildDualMappings(true);
            thisList.buildList(db);
            relationshipDependency.setCount(thisList.getNumberOfRelationships());
            relationshipDependency.setCanDelete(true);
            dependencyList.add(relationshipDependency);
            Dependency revenueDependency = new Dependency();
            revenueDependency.setName("revenue");
            revenueDependency.setCount(RevenueList.retrieveRecordCount(db, 1, this.getId()));
            revenueDependency.setCanDelete(true);
            dependencyList.add(revenueDependency);
            int oppCount = OpportunityList.retrieveRecordCount(db, 1, this.getId());
            if (oppCount > 0) {
                this.setHasOpportunities(true);
            }
            Dependency oppDependency = new Dependency();
            oppDependency.setName("opportunities");
            oppDependency.setCount(oppCount);
            oppDependency.setCanDelete(false);
            dependencyList.add(oppDependency);
            Dependency scDependency = new Dependency();
            scDependency.setName("contracts");
            scDependency.setCount(ServiceContractList.retrieveRecordCount(db, 1, this.getId()));
            scDependency.setCanDelete(true);
            dependencyList.add(scDependency);
            Dependency assetDependency = new Dependency();
            assetDependency.setName("assets");
            assetDependency.setCount(AssetList.retrieveRecordCount(db, 1, this.getId()));
            assetDependency.setCanDelete(true);
            dependencyList.add(assetDependency);
            Dependency ticDependency = new Dependency();
            ticDependency.setName("tickets");
            ticDependency.setCount(TicketList.retrieveRecordCount(db, 1, this.getId()));
            ticDependency.setCanDelete(true);
            dependencyList.add(ticDependency);
            Dependency docDependency = new Dependency();
            docDependency.setName("documents");
            docDependency.setCount(FileItemList.retrieveRecordCount((Connection)db, (int)1, (int)this.getId()));
            docDependency.setCanDelete(true);
            dependencyList.add(docDependency);
            Dependency quoteDependency = new Dependency();
            quoteDependency.setName("quotes");
            quoteDependency.setCount(QuoteList.retrieveRecordCount(db, 1, this.getId()));
            quoteDependency.setCanDelete(true);
            dependencyList.add(quoteDependency);
            Dependency folderDependency = new Dependency();
            folderDependency.setName("folders");
            folderDependency.setCount(CustomFieldRecordList.retrieveRecordCount(db, 1, this.getId()));
            folderDependency.setCanDelete(true);
            dependencyList.add(folderDependency);
            Dependency planWorkDependency = new Dependency();
            planWorkDependency.setName("actionplanworks");
            planWorkDependency.setCount(ActionPlanWorkList.retrieveRecordCount(db, 1, this.getId()));
            planWorkDependency.setCanDelete(true);
            dependencyList.add(planWorkDependency);
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public int revertBackToLead(Connection db, ActionContext context, int userId) throws SQLException {
        boolean commit = true;
        int contactId = -1;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            ContactList leadAccountContacts = new ContactList();
            leadAccountContacts.setBuildDetails(true);
            leadAccountContacts.setOrgId(this.getOrgId());
            leadAccountContacts.setHasConversionDate(1);
            leadAccountContacts.setIncludeEnabled(-1);
            leadAccountContacts.buildList(db);
            contactId = leadAccountContacts.revertBackToLead(db, context, userId);
            this.updateStatus(db, context, true, userId);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return contactId;
    }

    public void updatePrimaryContact(Connection db, boolean create) throws SQLException {
        Contact primaryContact = new Contact();
        primaryContact.setBuildDetails(true);
        if (this.getPrimaryContactId() != -1) {
            primaryContact.queryRecord(db, this.getPrimaryContactId());
        } else if (this.getPrimaryContact() != null) {
            primaryContact.queryRecord(db, this.getPrimaryContact().getId());
        }
        if (primaryContact.getId() != -1) {
            primaryContact.setPrimaryContact(create);
            primaryContact.updatePrimaryContactInformation(db);
            if (create) {
                this.setNameFirst(primaryContact.getNameFirst());
                this.setNameLast(primaryContact.getNameLast());
                this.setNameMiddle(primaryContact.getNameMiddle());
                this.setName(this.getNameLastFirstMiddle());
            } else {
                this.setNameFirst(null);
                this.setNameMiddle(null);
                this.setNameLast(null);
            }
        }
    }

    static {
        if (System.getProperty("DEBUG") != null) {
            log.setLevel(Level.DEBUG);
        }
    }
}

