/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.aspcfs.modules.base.Address;
import org.aspcfs.utils.DatabaseUtils;

public class OrganizationAddress
extends Address {
    public OrganizationAddress() {
    }

    public OrganizationAddress(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public OrganizationAddress(Connection db, String addressId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(addressId));
    }

    public OrganizationAddress(Connection db, int addressId) throws SQLException {
        this.queryRecord(db, addressId);
    }

    public void queryRecord(Connection db, int addressId) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT c.address_id, c.org_id, c.address_type, c.addrline1, c.addrline1,  c.addrline2, c.addrline3, c.addrline4, c.city, c.state, c.country, c.postalcode, c.county, c.latitude, c.longitude, c.entered, c.enteredby, c.modified, c.modifiedby, c.primary_address, l.description FROM organization_address c, lookup_orgaddress_types l WHERE c.address_type = l.code AND address_id = " + addressId + " ");
        st = db.createStatement();
        rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        st.close();
        if (this.getId() == -1) {
            throw new SQLException("Address record not found.");
        }
    }

    public void process(Connection db, int orgId, int enteredBy, int modifiedBy) throws SQLException {
        if (this.getEnabled()) {
            if (this.getId() == -1) {
                this.setOrgId(orgId);
                this.setEnteredBy(enteredBy);
                this.setModifiedBy(modifiedBy);
                this.insert(db);
            } else {
                this.setModifiedBy(modifiedBy);
                this.update(db, modifiedBy);
            }
        } else {
            this.delete(db);
        }
    }

    public void insert(Connection db) throws SQLException {
        this.insert(db, this.getOrgId(), this.getEnteredBy());
    }

    public void insert(Connection db, int orgId, int enteredBy) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.setId(DatabaseUtils.getNextSeq(db, "organization_add_address_id_seq"));
        int id = this.getId();
        sql.append("INSERT INTO organization_address (org_id, address_type, addrline1, addrline2, addrline3, addrline4, city, state, postalcode, country, county, latitude, longitude, primary_address, ");
        if (id > -1) {
            sql.append("address_id, ");
        }
        if (this.getEntered() != null) {
            sql.append("entered, ");
        }
        if (this.getModified() != null) {
            sql.append("modified, ");
        }
        sql.append("enteredBy, modifiedBy ) ");
        sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,");
        if (id > -1) {
            sql.append("?,");
        }
        if (this.getEntered() != null) {
            sql.append("?, ");
        }
        if (this.getModified() != null) {
            sql.append("?, ");
        }
        sql.append("?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.getOrgId() > -1) {
            pst.setInt(++i, this.getOrgId());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getType() > -1) {
            pst.setInt(++i, this.getType());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getStreetAddressLine1());
        pst.setString(++i, this.getStreetAddressLine2());
        pst.setString(++i, this.getStreetAddressLine3());
        pst.setString(++i, this.getStreetAddressLine4());
        pst.setString(++i, this.getCity());
        pst.setString(++i, this.getState());
        pst.setString(++i, this.getZip());
        pst.setString(++i, this.getCountry());
        pst.setString(++i, this.getCounty());
        pst.setDouble(++i, this.getLatitude());
        pst.setDouble(++i, this.getLongitude());
        pst.setBoolean(++i, this.getPrimaryAddress());
        if (id > -1) {
            pst.setInt(++i, id);
        }
        if (this.getEntered() != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.setId(DatabaseUtils.getCurrVal(db, "organization_add_address_id_seq", id));
    }

    public void update(Connection db, int modifiedBy) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE organization_address SET address_type = ?, addrline1 = ?, addrline2 = ?, addrline3 = ?, addrline4 = ?, city = ?, state = ?, postalcode = ?, country = ?, county = ?, latitude = ?, longitude =? , primary_address = ?, modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE address_id = ? ");
        int i = 0;
        if (this.getType() > -1) {
            pst.setInt(++i, this.getType());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getStreetAddressLine1());
        pst.setString(++i, this.getStreetAddressLine2());
        pst.setString(++i, this.getStreetAddressLine3());
        pst.setString(++i, this.getStreetAddressLine4());
        pst.setString(++i, this.getCity());
        pst.setString(++i, this.getState());
        pst.setString(++i, this.getZip());
        pst.setString(++i, this.getCountry());
        pst.setString(++i, this.getCounty());
        pst.setDouble(++i, this.getLatitude());
        pst.setDouble(++i, this.getLongitude());
        pst.setBoolean(++i, this.getPrimaryAddress());
        pst.setInt(++i, modifiedBy);
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM organization_address WHERE address_id = ? ");
        int i = 0;
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }
}

