/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.aspcfs.modules.accounts.base.OrganizationAddress;
import org.aspcfs.modules.base.AddressList;
import org.aspcfs.utils.DatabaseUtils;

public class OrganizationAddressList
extends AddressList {
    private static Logger log = Logger.getLogger(OrganizationAddressList.class);
    public static final String tableName = "organization_address";
    public static final String uniqueField = "address_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public OrganizationAddressList() {
    }

    public OrganizationAddressList(HttpServletRequest request) {
        int i = 0;
        int primaryAddress = -1;
        if (request.getParameter("primaryAddress") != null) {
            primaryAddress = Integer.parseInt(request.getParameter("primaryAddress"));
        }
        while (request.getParameter("address" + ++i + "type") != null) {
            OrganizationAddress thisAddress = new OrganizationAddress();
            thisAddress.buildRecord(request, i);
            if (primaryAddress == i) {
                thisAddress.setPrimaryAddress(true);
            }
            if (!thisAddress.isValid()) continue;
            this.addElement(thisAddress);
        }
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT a.address_id, a.org_id, a.address_type, a.addrline1, a.addrline2, a.addrline3, a.city, a.state, a.country, a.postalcode, a.entered, a.enteredby, a.modified, a.modifiedby, a.primary_address, a.addrline4, a.county, a.latitude, a.longitude, l.code, l.description, l.default_item, l." + DatabaseUtils.addQuotes(db, "level") + ", l.enabled " + "FROM organization_address a, lookup_orgaddress_types l " + "WHERE a.address_type = l.code ");
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM organization_address a, lookup_orgaddress_types l WHERE a.address_type = l.code ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(city) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            if (this.pagedListInfo.getColumnToSortBy() != null && !this.pagedListInfo.getColumnToSortBy().equals("")) {
                sqlOrder.append("ORDER BY " + this.pagedListInfo.getColumnToSortBy() + ", city ");
                if (this.pagedListInfo.getSortOrder() != null && !this.pagedListInfo.getSortOrder().equals("")) {
                    sqlOrder.append(this.pagedListInfo.getSortOrder() + " ");
                }
            } else {
                sqlOrder.append("ORDER BY city ");
            }
            if (this.pagedListInfo.getItemsPerPage() > 0) {
                sqlOrder.append("LIMIT " + this.pagedListInfo.getItemsPerPage() + " ");
            }
            sqlOrder.append("OFFSET " + this.pagedListInfo.getCurrentOffset() + " ");
        }
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = DatabaseUtils.executeQuery(db, pst, log);
        while (rs.next()) {
            OrganizationAddress thisAddress = new OrganizationAddress(rs);
            this.addElement(thisAddress);
        }
        rs.close();
        pst.close();
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }

    static {
        if (System.getProperty("DEBUG") != null) {
            log.setLevel(Level.DEBUG);
        }
    }
}

