/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.aspcfs.modules.base.EmailAddress;
import org.aspcfs.utils.DatabaseUtils;

public class OrganizationEmailAddress
extends EmailAddress {
    public OrganizationEmailAddress() {
        this.isContact = false;
    }

    public OrganizationEmailAddress(ResultSet rs) throws SQLException {
        this.isContact = false;
        this.buildRecord(rs);
    }

    public OrganizationEmailAddress(Connection db, int emailAddressId) throws SQLException {
        this.queryRecord(db, emailAddressId);
    }

    public OrganizationEmailAddress(Connection db, String emailAddressId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(emailAddressId));
    }

    public void queryRecord(Connection db, int emailAddressId) throws SQLException {
        this.isContact = false;
        if (emailAddressId <= 0) {
            throw new SQLException("Valid Email Address ID specified.");
        }
        Statement st = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM organization_emailaddress c, lookup_orgemail_types l WHERE c.emailaddress_type = l.code AND emailaddress_id = " + emailAddressId + " ");
        st = db.createStatement();
        rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        st.close();
        if (this.getId() == -1) {
            throw new SQLException("Email record not found.");
        }
    }

    public void process(Connection db, int orgId, int enteredBy, int modifiedBy) throws SQLException {
        if (this.getEnabled()) {
            if (this.getId() == -1) {
                this.setOrgId(orgId);
                this.setEnteredBy(enteredBy);
                this.setModifiedBy(modifiedBy);
                this.insert(db);
            } else {
                this.setModifiedBy(modifiedBy);
                this.update(db, modifiedBy);
            }
        } else {
            this.delete(db);
        }
    }

    public void insert(Connection db) throws SQLException {
        this.insert(db, this.getOrgId(), this.getEnteredBy());
    }

    public void insert(Connection db, int orgId, int enteredBy) throws SQLException {
        StringBuffer sql = new StringBuffer();
        int id = DatabaseUtils.getNextSeq(db, "organization__emailaddress__seq");
        sql.append("INSERT INTO organization_emailaddress (org_id, emailaddress_type, email, primary_email, ");
        if (id > -1) {
            sql.append("emailaddress_id, ");
        }
        if (this.getEntered() != null) {
            sql.append("entered, ");
        }
        if (this.getModified() != null) {
            sql.append("modified, ");
        }
        sql.append("enteredBy, modifiedBy ) ");
        sql.append("VALUES (?, ?, ?, ?, ");
        if (id > -1) {
            sql.append("?,");
        }
        if (this.getEntered() != null) {
            sql.append("?, ");
        }
        if (this.getModified() != null) {
            sql.append("?, ");
        }
        sql.append("?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (orgId > -1) {
            pst.setInt(++i, this.getOrgId());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getType() > -1) {
            pst.setInt(++i, this.getType());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getEmail());
        pst.setBoolean(++i, this.getPrimaryEmail());
        if (id > -1) {
            pst.setInt(++i, id);
        }
        if (this.getEntered() != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.setId(DatabaseUtils.getCurrVal(db, "organization__emailaddress__seq", id));
    }

    public void update(Connection db, int modifiedBy) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE organization_emailaddress SET emailaddress_type = ?, email = ?, primary_email = ?, modifiedby = ?, modified = CURRENT_TIMESTAMP WHERE emailaddress_id = ? ");
        int i = 0;
        if (this.getType() > -1) {
            pst.setInt(++i, this.getType());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getEmail());
        pst.setBoolean(++i, this.getPrimaryEmail());
        pst.setInt(++i, modifiedBy);
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM organization_emailaddress WHERE emailaddress_id = ? ");
        int i = 0;
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }
}

