/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.accounts.base.OrganizationEmailAddress;
import org.aspcfs.modules.base.EmailAddressList;
import org.aspcfs.utils.DatabaseUtils;

public class OrganizationEmailAddressList
extends EmailAddressList {
    public static final String tableName = "organization_emailaddress";
    public static final String uniqueField = "emailaddress_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public OrganizationEmailAddressList() {
    }

    public OrganizationEmailAddressList(HttpServletRequest request) {
        int i = 0;
        int primaryEmail = -1;
        if (request.getParameter("primaryEmail") != null) {
            primaryEmail = Integer.parseInt(request.getParameter("primaryEmail"));
        }
        while (request.getParameter("email" + ++i + "type") != null) {
            OrganizationEmailAddress thisEmailAddress = new OrganizationEmailAddress();
            thisEmailAddress.buildRecord(request, i);
            if (primaryEmail == i) {
                thisEmailAddress.setPrimaryEmail(true);
            }
            if (!thisEmailAddress.isValid()) continue;
            this.addElement(thisEmailAddress);
        }
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT * FROM organization_emailaddress e, lookup_orgemail_types l WHERE e.emailaddress_type = l.code ");
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM organization_emailaddress e, lookup_orgemail_types l WHERE e.emailaddress_type = l.code ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(email) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            if (this.pagedListInfo.getColumnToSortBy() != null && !this.pagedListInfo.getColumnToSortBy().equals("")) {
                sqlOrder.append("ORDER BY " + this.pagedListInfo.getColumnToSortBy() + ", email ");
                if (this.pagedListInfo.getSortOrder() != null && !this.pagedListInfo.getSortOrder().equals("")) {
                    sqlOrder.append(this.pagedListInfo.getSortOrder() + " ");
                }
            } else {
                sqlOrder.append("ORDER BY email ");
            }
            if (this.pagedListInfo.getItemsPerPage() > 0) {
                sqlOrder.append("LIMIT " + this.pagedListInfo.getItemsPerPage() + " ");
            }
            sqlOrder.append("OFFSET " + this.pagedListInfo.getCurrentOffset() + " ");
        }
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            OrganizationEmailAddress thisEmailAddress = new OrganizationEmailAddress(rs);
            this.addElement(thisEmailAddress);
        }
        rs.close();
        pst.close();
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }
}

