/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;

public class OrganizationHistory
extends GenericBean {
    public static final int ACCOUNT = 1;
    public static final int CONTACT = 2;
    public static final int COMPLETE_ACTIVITY = 3;
    public static final int OPPORTUNITY = 4;
    public static final int QUOTE = 5;
    public static final int PROJECT = 6;
    public static final int SERVICE_CONTRACT = 7;
    public static final int ASSET = 8;
    public static final int TICKET = 9;
    public static final int ACCOUNT_DOCUMENT = 10;
    public static final int RELATIONSHIP = 11;
    public static final int NOTE = 12;
    public static final int CANCELED_ACTIVITY = 13;
    public static final int CFSNOTE = 14;
    public static final int CAMPAIGN = 15;
    public static final int TASK = 16;
    private int id = -1;
    private int contactId = -1;
    private int orgId = -1;
    private int linkObjectId = -1;
    private int linkItemId = -1;
    private String type = null;
    private String description = null;
    private String status = null;
    private boolean enabled = false;
    private int level = 10;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private String linkObjectName = null;
    private Contact contact = null;
    private boolean reset = false;
    private String nameLast = null;

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getContactId() {
        return this.contactId;
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public int getOrgId() {
        return this.orgId;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public int getLinkObjectId() {
        return this.linkObjectId;
    }

    public void setLinkObjectId(int tmp) {
        this.linkObjectId = tmp;
    }

    public void setLinkObjectId(String tmp) {
        this.linkObjectId = Integer.parseInt(tmp);
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setLinkItemId(String tmp) {
        this.linkItemId = Integer.parseInt(tmp);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String tmp) {
        this.type = tmp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String tmp) {
        this.status = tmp;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public String getLinkObjectName() {
        return this.linkObjectName;
    }

    public void setLinkObjectName(String tmp) {
        this.linkObjectName = tmp;
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact tmp) {
        this.contact = tmp;
    }

    public boolean getReset() {
        return this.reset;
    }

    public void setReset(boolean tmp) {
        this.reset = tmp;
    }

    public void setReset(String tmp) {
        this.reset = DatabaseUtils.parseBoolean(tmp);
    }

    public String getNameLast() {
        return this.nameLast;
    }

    public void setNameLast(String tmp) {
        this.nameLast = tmp;
    }

    public OrganizationHistory() {
    }

    public OrganizationHistory(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public OrganizationHistory(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Organization History ID");
        }
        StringBuffer sb = new StringBuffer("SELECT history.*, c.namelast AS namelast FROM history LEFT JOIN contact c ON (history.contact_id = c.contact_id) LEFT JOIN organization o ON (history.org_id = o.org_id) WHERE history_id = ? ");
        PreparedStatement pst = db.prepareStatement(sb.toString());
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Organization History Entry not found");
        }
        if (this.getContactId() != -1) {
            this.buildContactRecord(db);
        }
    }

    public boolean queryRecord(Connection db) throws SQLException {
        if (this.linkObjectId == -1 || this.linkItemId == -1) {
            throw new SQLException("Invalid Module Id or Item Id");
        }
        int i = 0;
        StringBuffer sb = new StringBuffer("SELECT history.*, c.namelast AS namelast FROM history LEFT JOIN contact c ON (history.contact_id = c.contact_id) LEFT JOIN organization o ON (history.org_id = o.org_id) WHERE link_object_id = ? AND link_item_id = ? ");
        if (this.contactId != -1) {
            sb.append("AND history.contact_id = ? AND history.org_id IS NULL ");
        } else if (this.orgId != -1) {
            sb.append("AND history.org_id = ? AND history.contact_id IS NULL ");
        }
        PreparedStatement pst = db.prepareStatement(sb.toString());
        pst.setInt(++i, this.linkObjectId);
        pst.setInt(++i, this.linkItemId);
        if (this.contactId != -1) {
            DatabaseUtils.setInt(pst, ++i, this.contactId);
        } else if (this.orgId != -1) {
            DatabaseUtils.setInt(pst, ++i, this.orgId);
        }
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        return this.id != -1;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("history_id"));
        this.contactId = DatabaseUtils.getInt(rs, "contact_id");
        this.orgId = DatabaseUtils.getInt(rs, "org_id");
        this.linkObjectId = DatabaseUtils.getInt(rs, "link_object_id");
        this.linkItemId = DatabaseUtils.getInt(rs, "link_item_id");
        this.level = DatabaseUtils.getInt(rs, "level");
        this.status = rs.getString("status");
        this.type = rs.getString("type");
        this.description = rs.getString("description");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.nameLast = rs.getString("namelast");
    }

    public String getModuleObjectName() {
        String result = null;
        switch (this.linkObjectId) {
            case 1: {
                result = "account";
                break;
            }
            case 3: {
                result = "completeActivity";
                break;
            }
            case 13: {
                result = "canceledActivity";
                break;
            }
            case 8: {
                result = "asset";
                break;
            }
            case 2: {
                result = "contact";
                break;
            }
            case 10: {
                result = "document";
                break;
            }
            case 4: {
                result = "opportunity";
                break;
            }
            case 6: {
                result = "project";
                break;
            }
            case 5: {
                result = "quote";
                break;
            }
            case 11: {
                result = "relationship";
                break;
            }
            case 7: {
                result = "serviceContract";
                break;
            }
            case 9: {
                result = "ticket";
                break;
            }
            case 12: {
                result = "note";
                break;
            }
            default: {
                result = "ticket";
            }
        }
        return result;
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "history_history_id_seq");
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO history ( " + (this.id > -1 ? "history_id, " : "") + "contact_id, org_id, link_object_id, link_item_id, " + DatabaseUtils.addQuotes(db, "level") + ", " + "status, " + DatabaseUtils.addQuotes(db, "type") + ", description, enabled, ");
        if (this.entered != null) {
            sql.append("entered, ");
        }
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("enteredBy, modifiedBy ) ");
        sql.append("VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?, ");
        if (this.entered != null) {
            sql.append("?, ");
        }
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("?, ?) ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        DatabaseUtils.setInt(pst, ++i, this.contactId);
        DatabaseUtils.setInt(pst, ++i, this.orgId);
        DatabaseUtils.setInt(pst, ++i, this.linkObjectId);
        DatabaseUtils.setInt(pst, ++i, this.linkItemId);
        pst.setInt(++i, this.level);
        pst.setString(++i, this.status);
        pst.setString(++i, this.type);
        pst.setString(++i, this.description);
        pst.setBoolean(++i, this.enabled);
        if (this.entered != null) {
            pst.setTimestamp(++i, this.entered);
        }
        if (this.modified != null) {
            pst.setTimestamp(++i, this.modified);
        }
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "history_history_id_seq", this.id);
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("Organization History ID was not specified");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE history SET description = ?, enabled = ?, " + DatabaseUtils.addQuotes(db, "level") + " = ?, " + DatabaseUtils.addQuotes(db, "type") + " = ?, ");
        if (this.reset) {
            sql.append("contact_id = ?, org_id = ?, ");
        }
        sql.append("modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
        sql.append("modifiedby = ? WHERE history_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getDescription());
        pst.setBoolean(++i, this.getEnabled());
        pst.setInt(++i, this.getLevel());
        pst.setString(++i, this.getType());
        if (this.reset) {
            DatabaseUtils.setInt(pst, ++i, this.getContactId());
            DatabaseUtils.setInt(pst, ++i, this.getOrgId());
        }
        DatabaseUtils.setInt(pst, ++i, this.getModifiedBy());
        DatabaseUtils.setInt(pst, ++i, this.id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public String getDescriptionHeader() {
        if (this.description.trim().length() > 100) {
            return this.description.substring(0, 100) + "...";
        }
        return this.getDescription();
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Organization History Id was not specified");
        }
        int recordCount = 0;
        PreparedStatement pst = db.prepareStatement("DELETE FROM history WHERE history_id = ? ");
        pst.setInt(1, this.id);
        recordCount = pst.executeUpdate();
        pst.close();
        return recordCount != 0;
    }

    public void buildContactRecord(Connection db) throws SQLException {
        this.contact = new Contact(db, this.getContactId());
    }

    public String getPermission(boolean modify) {
        String result = null;
        switch (this.linkObjectId) {
            case 3: {
                result = modify ? "accounts-accounts-contacts-calls-edit" : "accounts-accounts-contacts-calls-view";
                break;
            }
            case 13: {
                result = modify ? "accounts-accounts-contacts-calls-edit" : "accounts-accounts-contacts-calls-view";
                break;
            }
            case 8: {
                result = modify ? "accounts-assets-edit" : "accounts-assets-view";
                break;
            }
            case 10: {
                result = modify ? "accounts-accounts-documents-edit" : "accounts-accounts-documents-view";
                break;
            }
            case 4: {
                result = modify ? "accounts-accounts-opportunities-edit" : "accounts-accounts-opportunities-view";
                break;
            }
            case 6: {
                result = modify ? "accounts-projects-view" : "accounts-projects-view";
                break;
            }
            case 5: {
                result = modify ? "accounts-quotes-edit" : "accounts-quotes-view";
                break;
            }
            case 11: {
                result = modify ? "m" : "accounts-accounts-relationships-view";
                break;
            }
            case 7: {
                result = modify ? "accounts-service-contracts-edit" : "accounts-service-contracts-view";
                break;
            }
            case 9: {
                result = modify ? "accounts-accounts-tickets-edit" : "accounts-accounts-tickets-view";
                break;
            }
            case 16: {
                result = modify ? "myhomepage-tasks-edit" : "myhomepage-tasks-view";
                break;
            }
            case 12: {
                result = modify ? "accounts-accounts-history-edit" : "v";
                break;
            }
            case 14: {
                result = modify ? "m" : "myhomepage-inbox-view";
                break;
            }
            case 15: {
                result = modify ? "m" : "accounts-accounts-contacts-messages-view";
                break;
            }
            default: {
                result = modify ? "m" : "v";
            }
        }
        return result;
    }

    public String getDeletePermission() {
        if (this.getLinkObjectId() == 12) {
            return "accounts-accounts-history-delete";
        }
        return "can_not_delete";
    }

    public String getViewOrModifyOrDeletePermission() {
        String modify = this.getPermission(true);
        String view = this.getPermission(false);
        String delete = this.getDeletePermission();
        StringBuffer result = new StringBuffer("");
        if (view != null && !"".equals(view)) {
            result.append(view);
            if (modify != null && !"".equals(modify)) {
                result.append("," + modify);
            }
        } else if (modify != null && !"".equals(modify)) {
            result.append(modify);
        }
        if (delete != null && !"".equals(delete) && !"can_not_delete".equals(delete)) {
            if (!result.toString().equals("")) {
                result.append(",");
            }
            result.append(delete);
        }
        return result.toString();
    }
}

