/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.accounts.base.OrganizationHistory;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class OrganizationHistoryList
extends ArrayList
implements SyncableList {
    public static final String tableName = "ticket";
    public static final String uniqueField = "ticketid";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int contactId = -1;
    private int orgId = -1;
    private int level = -1;
    private boolean showDisabledWithEnabled = false;
    protected Date startDateRange = null;
    protected Date endDateRange = null;
    private boolean notes = false;
    private boolean activities = false;
    private boolean email = false;
    private boolean documents = false;
    private boolean quotes = false;
    private boolean opportunities = false;
    private boolean serviceContracts = false;
    private boolean tickets = false;
    private boolean tasks = false;
    private boolean relationships = false;
    private boolean assets = false;

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getOrgId() {
        return this.orgId;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public Date getStartDateRange() {
        return this.startDateRange;
    }

    public void setStartDateRange(Date tmp) {
        this.startDateRange = tmp;
    }

    public Date getEndDateRange() {
        return this.endDateRange;
    }

    public void setEndDateRange(Date tmp) {
        this.endDateRange = tmp;
    }

    public boolean getNotes() {
        return this.notes;
    }

    public void setNotes(boolean tmp) {
        this.notes = tmp;
    }

    public void setNotes(String tmp) {
        this.notes = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getActivities() {
        return this.activities;
    }

    public void setActivities(boolean tmp) {
        this.activities = tmp;
    }

    public void setActivities(String tmp) {
        this.activities = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getEmail() {
        return this.email;
    }

    public void setEmail(boolean tmp) {
        this.email = tmp;
    }

    public void setEmail(String tmp) {
        this.email = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getDocuments() {
        return this.documents;
    }

    public void setDocuments(boolean tmp) {
        this.documents = tmp;
    }

    public void setDocuments(String tmp) {
        this.documents = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getQuotes() {
        return this.quotes;
    }

    public void setQuotes(boolean tmp) {
        this.quotes = tmp;
    }

    public void setQuotes(String tmp) {
        this.quotes = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getOpportunities() {
        return this.opportunities;
    }

    public void setOpportunities(boolean tmp) {
        this.opportunities = tmp;
    }

    public void setOpportunities(String tmp) {
        this.opportunities = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getServiceContracts() {
        return this.serviceContracts;
    }

    public void setServiceContracts(boolean tmp) {
        this.serviceContracts = tmp;
    }

    public void setServiceContracts(String tmp) {
        this.serviceContracts = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getTickets() {
        return this.tickets;
    }

    public void setTickets(boolean tmp) {
        this.tickets = tmp;
    }

    public void setTickets(String tmp) {
        this.tickets = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getTasks() {
        return this.tasks;
    }

    public void setTasks(boolean tmp) {
        this.tasks = tmp;
    }

    public void setTasks(String tmp) {
        this.tasks = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getRelationships() {
        return this.relationships;
    }

    public void setRelationships(boolean tmp) {
        this.relationships = tmp;
    }

    public void setRelationships(String tmp) {
        this.relationships = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getAssets() {
        return this.assets;
    }

    public void setAssets(boolean tmp) {
        this.assets = tmp;
    }

    public void setAssets(String tmp) {
        this.assets = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getShowDisabledWithEnabled() {
        return this.showDisabledWithEnabled;
    }

    public void setShowDisabledWithEnabled(boolean tmp) {
        this.showDisabledWithEnabled = tmp;
    }

    public void setShowDisabledWithEnabled(String tmp) {
        this.showDisabledWithEnabled = DatabaseUtils.parseBoolean(tmp);
    }

    public int getContactId() {
        return this.contactId;
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM history LEFT JOIN contact c ON (history.contact_id = c.contact_id) LEFT JOIN organization o ON (history.org_id = o.org_id) WHERE history_id > 0 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(" + DatabaseUtils.addQuotes(db, "type") + ") < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("history.entered", "desc");
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY history.entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("history.*, c.namelast AS namelast FROM history LEFT JOIN contact c ON (history.contact_id = c.contact_id) LEFT JOIN organization o ON (history.org_id = o.org_id) WHERE history_id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            OrganizationHistory thisHistoryElement = new OrganizationHistory(rs);
            this.add(thisHistoryElement);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.id != -1) {
            sqlFilter.append("AND history.history_id = ? ");
        }
        if (this.orgId != -1) {
            sqlFilter.append("AND (history.org_id = ? OR history.contact_id IN (SELECT ct.contact_id FROM contact ct WHERE ct.org_id = ? )) ");
        }
        if (this.contactId != -1) {
            sqlFilter.append("AND history.contact_id = ? AND history.org_id IS NULL ");
        }
        if (this.level != -1) {
            sqlFilter.append("AND history." + DatabaseUtils.addQuotes(db, "level") + " > ? ");
        }
        if (this.startDateRange != null) {
            sqlFilter.append("AND history.event_date > ? ");
        }
        if (this.endDateRange != null) {
            sqlFilter.append("AND history.event_date < ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND history.entered > ? ");
            }
            sqlFilter.append("AND history.entered < ? ");
        }
        if (!this.notes) {
            sqlFilter.append("AND history.link_object_id NOT IN (?) ");
        }
        if (!this.activities) {
            sqlFilter.append("AND history.link_object_id NOT IN (?, ?) ");
        }
        if (!this.email) {
            sqlFilter.append("AND history.link_object_id NOT IN (?, ?) ");
        }
        if (!this.quotes) {
            sqlFilter.append("AND history.link_object_id NOT IN (?) ");
        }
        if (!this.opportunities) {
            sqlFilter.append("AND history.link_object_id NOT IN (?) ");
        }
        if (!this.serviceContracts) {
            sqlFilter.append("AND history.link_object_id NOT IN (?) ");
        }
        if (!this.tickets) {
            sqlFilter.append("AND history.link_object_id NOT IN (?) ");
        }
        if (!this.tasks) {
            sqlFilter.append("AND history.link_object_id NOT IN (?) ");
        }
        if (!this.documents) {
            sqlFilter.append("AND history.link_object_id NOT IN (?) ");
        }
        if (!this.relationships) {
            sqlFilter.append("AND history.link_object_id NOT IN (?) ");
        }
        if (!this.assets) {
            sqlFilter.append("AND history.link_object_id NOT IN (?) ");
        }
        if (!this.showDisabledWithEnabled) {
            sqlFilter.append("AND history.enabled = ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND history.modified > ? ");
            sqlFilter.append("AND history.entered < ? ");
            sqlFilter.append("AND history.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id != -1) {
            pst.setInt(++i, this.getId());
        }
        if (this.orgId != -1) {
            pst.setInt(++i, this.getOrgId());
            pst.setInt(++i, this.getOrgId());
        }
        if (this.contactId != -1) {
            pst.setInt(++i, this.getContactId());
        }
        if (this.level != -1) {
            pst.setInt(++i, this.getLevel());
        }
        if (this.startDateRange != null) {
            pst.setDate(++i, this.getStartDateRange());
        }
        if (this.endDateRange != null) {
            pst.setDate(++i, this.getEndDateRange());
        }
        if (!this.notes) {
            pst.setInt(++i, 12);
        }
        if (!this.activities) {
            pst.setInt(++i, 3);
            pst.setInt(++i, 13);
        }
        if (!this.email) {
            pst.setInt(++i, 14);
            pst.setInt(++i, 15);
        }
        if (!this.quotes) {
            pst.setInt(++i, 5);
        }
        if (!this.opportunities) {
            pst.setInt(++i, 4);
        }
        if (!this.serviceContracts) {
            pst.setInt(++i, 7);
        }
        if (!this.tickets) {
            pst.setInt(++i, 9);
        }
        if (!this.tasks) {
            pst.setInt(++i, 16);
        }
        if (!this.documents) {
            pst.setInt(++i, 10);
        }
        if (!this.relationships) {
            pst.setInt(++i, 11);
        }
        if (!this.assets) {
            pst.setInt(++i, 8);
        }
        if (!this.showDisabledWithEnabled) {
            pst.setBoolean(++i, true);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public void setDefaultFilters(boolean value) {
        this.notes = value;
        this.activities = value;
        this.email = value;
        this.documents = value;
        this.quotes = value;
        this.opportunities = value;
        this.serviceContracts = value;
        this.tickets = value;
        this.tasks = value;
        this.relationships = value;
        this.assets = value;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean result = false;
        for (OrganizationHistory history : this) {
            result = history.delete(db);
            if (result) continue;
            return false;
        }
        return result;
    }

    public void moveNotesToAccountHistory(Connection db, int orgId) throws SQLException {
        for (OrganizationHistory history : this) {
            history.setReset(true);
            history.setOrgId(orgId);
            history.setContactId(-1);
            history.update(db);
        }
    }

    public void disableNotesInHistory(Connection db, boolean value) throws SQLException {
        for (OrganizationHistory history : this) {
            history.setEnabled(value);
            history.update(db);
        }
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }
}

