/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.relationships.base.Relationship;
import org.aspcfs.modules.relationships.base.RelationshipList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class OrganizationList
extends Vector
implements SyncableList {
    private static Logger log = Logger.getLogger(OrganizationList.class);
    private static final long serialVersionUID = 2268314721560915731L;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    protected int includeEnabled = 1;
    public static final String tableName = "organization";
    public static final String uniqueField = "org_id";
    protected Timestamp lastAnchor = null;
    protected Timestamp nextAnchor = null;
    protected int syncType = -1;
    protected PagedListInfo pagedListInfo = null;
    protected Boolean minerOnly = null;
    protected int enteredBy = -1;
    protected String name = null;
    protected int ownerId = -1;
    protected int orgId = -1;
    protected String HtmlJsEvent = "";
    protected boolean showMyCompany = false;
    protected String ownerIdRange = null;
    protected String excludeIds = null;
    protected boolean hasAlertDate = false;
    protected boolean hasExpireDate = false;
    protected String accountNumber = null;
    protected int orgSiteId = -1;
    protected boolean includeOrganizationWithoutSite = false;
    protected int projectId = -1;
    private String city = null;
    private String state = null;
    private String country = null;
    protected String postalCode = null;
    protected String assetSerialNumber = null;
    protected int revenueType = 0;
    protected int revenueYear = -1;
    protected int revenueOwnerId = -1;
    protected boolean buildRevenueYTD = false;
    protected Timestamp alertRangeStart = null;
    protected Timestamp alertRangeEnd = null;
    protected Timestamp enteredSince = null;
    protected Timestamp enteredTo = null;
    protected int typeId = 0;
    protected String types = null;
    protected String accountSegment = null;
    protected int stageId = -1;
    private int importId = -1;
    private int statusId = -1;
    private boolean excludeUnapprovedAccounts = true;
    private Timestamp trashedDate = null;
    private boolean includeOnlyTrashed = false;
    private String firstName = null;
    private String lastName = null;
    private String contactPhoneNumber = null;
    private String contactCity = null;
    private String contactState = null;
    private String contactCountry = null;
    private boolean includeAllSites = false;

    public boolean isIncludeAllSites() {
        return this.includeAllSites;
    }

    public void setIncludeAllSites(boolean includeAllSites) {
        this.includeAllSites = includeAllSites;
    }

    public Timestamp getEnteredSince() {
        return this.enteredSince;
    }

    public void setEnteredSince(Timestamp tmp) {
        this.enteredSince = tmp;
    }

    public void setEnteredSince(String tmp) {
        this.enteredSince = DateUtils.parseTimestampString(tmp);
    }

    public Timestamp getEnteredTo() {
        return this.enteredTo;
    }

    public void setEnteredTo(Timestamp tmp) {
        this.enteredTo = tmp;
    }

    public void setEnteredTo(String tmp) {
        this.enteredTo = DateUtils.parseTimestampString(tmp);
    }

    public String getExcludeIds() {
        return this.excludeIds;
    }

    public void setExcludeIds(String tmp) {
        this.excludeIds = tmp;
    }

    public String getTypes() {
        return this.types;
    }

    public void setTypes(String tmp) {
        this.types = tmp;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = Integer.parseInt(typeId);
    }

    public void setAccountSegment(String tmp) {
        this.accountSegment = tmp;
    }

    public String getAccountSegment() {
        return this.accountSegment;
    }

    public void setStageId(int tmp) {
        this.stageId = tmp;
    }

    public void setStageId(String tmp) {
        this.stageId = tmp != null ? Integer.parseInt(tmp) : -1;
    }

    public int getStageId() {
        return this.stageId;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setMinerOnly(boolean tmp) {
        this.minerOnly = new Boolean(tmp);
    }

    public void setRevenueType(int tmp) {
        this.revenueType = tmp;
    }

    public void setRevenueYear(int tmp) {
        this.revenueYear = tmp;
    }

    public void setAlertRangeStart(Timestamp alertRangeStart) {
        this.alertRangeStart = alertRangeStart;
    }

    public void setAlertRangeEnd(Timestamp alertRangeEnd) {
        this.alertRangeEnd = alertRangeEnd;
    }

    public void setImportId(int tmp) {
        this.importId = tmp;
    }

    public void setExcludeUnapprovedAccounts(boolean tmp) {
        this.excludeUnapprovedAccounts = tmp;
    }

    public void setExcludeUnapprovedAccounts(String tmp) {
        this.excludeUnapprovedAccounts = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getExcludeUnapprovedAccounts() {
        return this.excludeUnapprovedAccounts;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public void setImportId(String tmp) {
        this.importId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setFirstName(String tmp) {
        this.firstName = tmp;
    }

    public void setLastName(String tmp) {
        this.lastName = tmp;
    }

    public void setContactPhoneNumber(String tmp) {
        this.contactPhoneNumber = tmp;
    }

    public void setContactCity(String tmp) {
        this.contactCity = tmp;
    }

    public void setContactState(String tmp) {
        this.contactState = tmp;
    }

    public String getContactCountry() {
        return this.contactCountry;
    }

    public void setContactCountry(String tmp) {
        this.contactCountry = tmp;
    }

    public String getContactOtherState() {
        return this.contactState;
    }

    public void setContactOtherState(String tmp) {
        this.contactState = tmp;
    }

    public int getImportId() {
        return this.importId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getContactPhoneNumber() {
        return this.contactPhoneNumber;
    }

    public String getContactCity() {
        return this.contactCity;
    }

    public String getContactState() {
        return this.contactState;
    }

    public int getRevenueType() {
        return this.revenueType;
    }

    public int getRevenueYear() {
        return this.revenueYear;
    }

    public int getIncludeEnabled() {
        return this.includeEnabled;
    }

    public void setIncludeEnabled(int includeEnabled) {
        this.includeEnabled = includeEnabled;
    }

    public void setShowMyCompany(boolean showMyCompany) {
        this.showMyCompany = showMyCompany;
    }

    public void setHasAlertDate(boolean hasAlertDate) {
        this.hasAlertDate = hasAlertDate;
    }

    public void setHtmlJsEvent(String HtmlJsEvent) {
        this.HtmlJsEvent = HtmlJsEvent;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = Integer.parseInt(projectId);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setOrgSiteId(int orgSiteId) {
        this.orgSiteId = orgSiteId;
    }

    public void setOrgSiteId(String orgSiteId) {
        this.orgSiteId = Integer.parseInt(orgSiteId);
    }

    public int getOrgSiteId() {
        return this.orgSiteId;
    }

    public void setIncludeOrganizationWithoutSite(boolean tmp) {
        this.includeOrganizationWithoutSite = tmp;
    }

    public void setIncludeOrganizationWithoutSite(String tmp) {
        this.includeOrganizationWithoutSite = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getIncludeOrganizationWithoutSite() {
        return this.includeOrganizationWithoutSite;
    }

    public boolean getBuildRevenueYTD() {
        return this.buildRevenueYTD;
    }

    public void setBuildRevenueYTD(boolean buildRevenueYTD) {
        this.buildRevenueYTD = buildRevenueYTD;
    }

    public void setOwnerIdRange(String tmp) {
        this.ownerIdRange = tmp;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setAccountName(String tmp) {
        this.name = tmp;
    }

    public int getRevenueOwnerId() {
        return this.revenueOwnerId;
    }

    public void setRevenueOwnerId(int revenueOwnerId) {
        this.revenueOwnerId = revenueOwnerId;
    }

    public void setHasExpireDate(boolean hasExpireDate) {
        this.hasExpireDate = hasExpireDate;
    }

    public void setOwnerId(int ownerId) {
        this.ownerId = ownerId;
    }

    public void setOwnerId(String tmp) {
        this.ownerId = Integer.parseInt(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public boolean getHasAlertDate() {
        return this.hasAlertDate;
    }

    public String getOwnerIdRange() {
        return this.ownerIdRange;
    }

    public boolean getHasExpireDate() {
        return this.hasExpireDate;
    }

    public boolean getShowMyCompany() {
        return this.showMyCompany;
    }

    public String getHtmlJsEvent() {
        return this.HtmlJsEvent;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String tmp) {
        this.postalCode = tmp;
    }

    public String getAccountPostalCode() {
        return this.postalCode;
    }

    public void setAccountPostalCode(String tmp) {
        this.postalCode = tmp;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String tmp) {
        this.city = tmp;
    }

    public String getAccountCity() {
        return this.city;
    }

    public void setAccountCity(String tmp) {
        this.city = tmp;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String tmp) {
        this.state = tmp;
    }

    public String getAccountState() {
        return this.state;
    }

    public void setAccountOtherState(String tmp) {
        this.state = tmp;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String tmp) {
        this.country = tmp;
    }

    public String getAccountCountry() {
        return this.country;
    }

    public void setAccountCountry(String tmp) {
        this.country = tmp;
    }

    public String getAssetSerialNumber() {
        return this.assetSerialNumber;
    }

    public void setAssetSerialNumber(String tmp) {
        this.assetSerialNumber = tmp;
    }

    public void setSearchText(String tmp) {
        this.name = tmp;
    }

    public String getSearchText() {
        return this.name;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect orgListSelect = new HtmlSelect();
        for (Organization thisOrg : this) {
            orgListSelect.addItem(thisOrg.getOrgId(), thisOrg.getName());
        }
        if (!this.getHtmlJsEvent().equals("")) {
            orgListSelect.setJsEvent(this.getHtmlJsEvent());
        }
        return orgListSelect.getHtml(selectName, defaultKey);
    }

    public String getHtmlSelectDefaultNone(SystemStatus thisSystem, String selectName) {
        return this.getHtmlSelectDefaultNone(thisSystem, selectName, -1);
    }

    public String getHtmlSelectDefaultNone(SystemStatus thisSystem, String selectName, int defaultKey) {
        HtmlSelect orgListSelect = new HtmlSelect();
        orgListSelect.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        for (Organization thisOrg : this) {
            orgListSelect.addItem(thisOrg.getOrgId(), thisOrg.getName());
        }
        if (!this.getHtmlJsEvent().equals("")) {
            orgListSelect.setJsEvent(this.getHtmlJsEvent());
        }
        return orgListSelect.getHtml(selectName, defaultKey);
    }

    public void select(Connection db) throws SQLException {
        this.buildList(db);
    }

    public HashMap queryRecordCount(Connection db, TimeZone timeZone, HashMap events) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlTail = new StringBuffer();
        String sqlDate = (this.hasAlertDate ? "alertdate" : "") + (this.hasExpireDate ? "contract_end" : "");
        this.createFilter(db, sqlFilter);
        sqlSelect.append("SELECT " + sqlDate + " AS " + DatabaseUtils.addQuotes(db, "date") + ", count(*) AS nocols " + "FROM organization o " + "WHERE o.org_id >= 0 ");
        sqlTail.append("GROUP BY " + sqlDate);
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlTail.toString());
        this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            String alertDate = DateUtils.getServerToUserDateString(timeZone, 3, rs.getTimestamp("date"));
            int thisCount = rs.getInt("nocols");
            if (events.containsKey(alertDate)) {
                int tmpCount = (Integer)events.get(alertDate);
                thisCount += tmpCount;
            }
            events.put(alertDate, new Integer(thisCount));
        }
        rs.close();
        pst.close();
        return events;
    }

    public void buildShortList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        this.createFilter(db, sqlFilter);
        sqlSelect.append("SELECT o.org_id, o.name, " + (this.hasAlertDate ? "o.alertdate, " : "") + (this.hasExpireDate ? "o.contract_end, " : "") + "o.alert, o.entered, o.enteredby, o.owner " + "FROM organization o " + "WHERE o.org_id >= 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString());
        this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            Organization thisOrg = new Organization();
            thisOrg.setOrgId(rs.getInt(uniqueField));
            thisOrg.setName(rs.getString("name"));
            if (this.hasAlertDate) {
                thisOrg.setAlertDate(rs.getTimestamp("alertdate"));
            }
            if (this.hasExpireDate) {
                thisOrg.setContractEndDate(rs.getTimestamp("contract_end"));
            }
            thisOrg.setAlertText(rs.getString("alert"));
            thisOrg.setEntered(rs.getTimestamp("entered"));
            thisOrg.setEnteredBy(rs.getInt("enteredby"));
            thisOrg.setOwner(rs.getInt("owner"));
            this.add(thisOrg);
        }
        rs.close();
        pst.close();
    }

    public void buildList(Connection db) throws SQLException {
        Statement pst = null;
        ResultSet rs = this.queryList(db, (PreparedStatement)pst);
        while (rs.next()) {
            Organization thisOrganization = this.getObject(rs);
            if (this.buildRevenueYTD && this.revenueYear > -1 && this.revenueOwnerId > -1) {
                thisOrganization.buildRevenueYTD(db, this.getRevenueYear(), this.getRevenueType(), this.getRevenueOwnerId());
                if (thisOrganization.getYTD() == 0.0) continue;
                this.add(thisOrganization);
                continue;
            }
            this.add(thisOrganization);
        }
        rs.close();
        if (pst != null) {
            pst.close();
        }
        this.buildResources(db);
    }

    public Organization getObject(ResultSet rs) throws SQLException {
        Organization thisOrganization = new Organization(rs);
        return thisOrganization;
    }

    public ResultSet queryList(Connection db, PreparedStatement pst) throws SQLException {
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM organization o WHERE o.org_id >= 0 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(o.name) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("o.name", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY o.name ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("o.*, ct_owner.namelast as o_namelast, ct_owner.namefirst as o_namefirst, ct_eb.namelast as eb_namelast, ct_eb.namefirst as eb_namefirst, ct_mb.namelast as mb_namelast, ct_mb.namefirst as mb_namefirst, i.description as industry_name, a.description AS account_size_name, oa.city as o_city, oa.state as o_state, oa.postalcode as o_postalcode, oa.county as o_county, ast.description as stage_name FROM organization o LEFT JOIN contact ct_owner ON (o.owner = ct_owner.user_id) LEFT JOIN contact ct_eb ON (o.enteredby = ct_eb.user_id) LEFT JOIN contact ct_mb ON (o.modifiedby = ct_mb.user_id) LEFT JOIN lookup_industry i ON (o.industry_temp_code = i.code) LEFT JOIN lookup_account_size a ON (o.account_size = a.code) LEFT JOIN organization_address oa ON (o.org_id = oa.org_id) LEFT JOIN lookup_account_stage ast ON (o.stage_id = ast.code) WHERE o.org_id >= 0 ");
        sqlFilter.append(" AND (oa.address_id IS NULL OR oa.address_id IN ( SELECT ora.address_id FROM organization_address ora WHERE ora.org_id = o.org_id AND ora.primary_address = ?) OR oa.address_id IN (SELECT MIN(ctodd.address_id) FROM organization_address ctodd WHERE ctodd.org_id = o.org_id AND  ctodd.org_id NOT IN (SELECT org_id FROM organization_address WHERE organization_address.primary_address = ?))) ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        pst.setBoolean(++items, true);
        pst.setBoolean(++items, true);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = DatabaseUtils.executeQuery(db, pst, log);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        return rs;
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.stageId > -1) {
            sqlFilter.append("AND o.stage_id = ? ");
        }
        if (this.minerOnly != null) {
            sqlFilter.append("AND miner_only = ? ");
        }
        if (this.enteredBy > -1) {
            sqlFilter.append("AND o.enteredby = ? ");
        }
        if (this.name != null) {
            if (this.name.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(o.name) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(o.name) = ? ");
            }
        }
        if (this.accountSegment != null) {
            if (this.accountSegment.indexOf("%") >= 0) {
                sqlFilter.append("AND o.segment_id in (SELECT code FROM lookup_segments WHERE " + DatabaseUtils.toLowerCase(db) + "(description) LIKE ? )");
            } else {
                sqlFilter.append("AND o.segment_id in (SELECT code FROM lookup_segments WHERE  " + DatabaseUtils.toLowerCase(db) + "(description) = ?  )");
            }
        }
        if (this.ownerId > -1) {
            sqlFilter.append("AND o.owner = ? ");
        }
        if (this.ownerIdRange != null) {
            sqlFilter.append("AND o.owner IN (" + this.ownerIdRange + ") ");
        }
        if (this.excludeIds != null) {
            sqlFilter.append("AND o.org_id NOT IN (" + this.excludeIds + ") ");
        }
        if (this.types != null) {
            sqlFilter.append("AND o.org_id IN (select atl.org_id from account_type_levels atl where atl.type_id IN (" + this.types + ")) ");
        }
        if (this.includeEnabled == 1 || this.includeEnabled == 0) {
            sqlFilter.append("AND o.enabled = ? ");
        }
        if (!this.showMyCompany) {
            sqlFilter.append("AND o.org_id != 0 ");
        }
        if (this.hasAlertDate) {
            sqlFilter.append("AND o.alertdate is not null ");
            if (this.alertRangeStart != null) {
                sqlFilter.append("AND o.alertdate >= ? ");
            }
            if (this.alertRangeEnd != null) {
                sqlFilter.append("AND o.alertdate < ? ");
            }
        }
        if (this.hasExpireDate) {
            sqlFilter.append("AND o.contract_end is not null ");
            if (this.alertRangeStart != null) {
                sqlFilter.append("AND o.contract_end >= ? ");
            }
            if (this.alertRangeEnd != null) {
                sqlFilter.append("AND o.contract_end <= ? ");
            }
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
        if (this.enteredSince != null) {
            sqlFilter.append("AND o.entered >= ? ");
        }
        if (this.enteredTo != null) {
            sqlFilter.append("AND o.entered <= ? ");
        }
        if (this.revenueOwnerId > -1) {
            sqlFilter.append("AND o.org_id in (SELECT org_id from revenue WHERE owner = ?) ");
        }
        if (this.accountNumber != null) {
            if (this.accountNumber.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(o.account_number) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(o.account_number) = ? ");
            }
        }
        if (this.orgSiteId != -1) {
            sqlFilter.append("AND ( o.site_id = ? ");
            if (this.includeOrganizationWithoutSite) {
                sqlFilter.append("OR o.site_id IS NULL ");
            }
            sqlFilter.append(")");
        }
        if (this.orgSiteId == -1 && this.includeOrganizationWithoutSite) {
            sqlFilter.append("AND o.site_id IS NULL ");
        }
        if (this.importId != -1) {
            sqlFilter.append("AND o.import_id = ? ");
        }
        if (this.statusId != -1) {
            sqlFilter.append("AND o.status_id = ? ");
        }
        if (this.firstName != null) {
            if (this.firstName.indexOf("%") >= 0) {
                sqlFilter.append("AND EXISTS (select contact_id from contact c where " + DatabaseUtils.toLowerCase(db) + "(c.namefirst) LIKE ? AND c.org_id = o.org_id) ");
            } else {
                sqlFilter.append("AND EXISTS (select contact_id from contact c where " + DatabaseUtils.toLowerCase(db) + "(c.namefirst) = ? AND c.org_id = o.org_id) ");
            }
        }
        if (this.lastName != null) {
            if (this.lastName.indexOf("%") >= 0) {
                sqlFilter.append("AND EXISTS (select contact_id from contact c where " + DatabaseUtils.toLowerCase(db) + "(c.namelast) LIKE ? AND c.org_id = o.org_id) ");
            } else {
                sqlFilter.append("AND EXISTS (select contact_id from contact c where " + DatabaseUtils.toLowerCase(db) + "(c.namelast) = ? AND c.org_id = o.org_id) ");
            }
        }
        if (this.contactPhoneNumber != null) {
            if (this.contactPhoneNumber.indexOf("%") >= 0) {
                sqlFilter.append("AND EXISTS (select contact_id from contact c where c.org_id = o.org_id AND c.contact_id IN (select cp.contact_id from contact_phone cp where " + DatabaseUtils.toLowerCase(db) + "(cp.number) LIKE ?)) ");
            } else {
                sqlFilter.append("AND EXISTS (select contact_id from contact c where c.org_id = o.org_id AND c.contact_id IN (select cp.contact_id from contact_phone cp where " + DatabaseUtils.toLowerCase(db) + "(cp.number) = ?)) ");
            }
        }
        if (this.contactCity != null && !"-1".equals(this.contactCity)) {
            if (this.contactCity.indexOf("%") >= 0) {
                sqlFilter.append("AND EXISTS (select contact_id from contact c where c.org_id = o.org_id AND c.contact_id IN (select ca.contact_id from contact_address ca where " + DatabaseUtils.toLowerCase(db) + "(ca.city) LIKE ?)) ");
            } else {
                sqlFilter.append("AND EXISTS (select contact_id from contact c where c.org_id = o.org_id AND c.contact_id IN (select ca.contact_id from contact_address ca where " + DatabaseUtils.toLowerCase(db) + "(ca.city) = ?)) ");
            }
        }
        if (this.contactState != null && !"-1".equals(this.contactState)) {
            if (this.contactState.indexOf("%") >= 0) {
                sqlFilter.append("AND EXISTS (select contact_id from contact c where c.org_id = o.org_id AND c.contact_id IN (select ca.contact_id from contact_address ca where " + DatabaseUtils.toLowerCase(db) + "(ca.state) LIKE ?)) ");
            } else {
                sqlFilter.append("AND EXISTS (select contact_id from contact c where c.org_id = o.org_id AND c.contact_id IN (select ca.contact_id from contact_address ca where " + DatabaseUtils.toLowerCase(db) + "(ca.state) = ?)) ");
            }
        }
        if (this.contactCountry != null && !"-1".equals(this.contactCountry)) {
            sqlFilter.append("AND EXISTS (select contact_id from contact c where c.org_id = o.org_id AND c.contact_id IN (select ca.contact_id from contact_address ca where " + DatabaseUtils.toLowerCase(db) + "(ca.country) = ?)) ");
        }
        if (this.excludeUnapprovedAccounts) {
            sqlFilter.append("AND (o.status_id IS NULL OR o.status_id = ?) ");
        }
        if (this.typeId > 0) {
            sqlFilter.append("AND o.org_id IN (select atl.org_id from account_type_levels atl where atl.type_id = ?) ");
        }
        if (this.orgId > 0) {
            sqlFilter.append("AND o.org_id = ? ");
        }
        if (this.projectId > 0) {
            sqlFilter.append("AND o.org_id IN (SELECT org_id FROM project_accounts WHERE project_id = ?) ");
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND o.trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND o.trashed_date = ? ");
        } else {
            sqlFilter.append("AND o.trashed_date IS NULL ");
        }
        if (this.postalCode != null) {
            if (this.postalCode.indexOf("%") >= 0) {
                sqlFilter.append("AND o.org_id IN (SELECT org_id FROM organization_address WHERE " + DatabaseUtils.toLowerCase(db, "postalcode") + " LIKE ? " + "AND postalcode IS NOT NULL) ");
            } else {
                sqlFilter.append("AND o.org_id IN (SELECT org_id FROM organization_address WHERE " + DatabaseUtils.toLowerCase(db, "postalcode") + " = ? " + "AND postalcode IS NOT NULL) ");
            }
        }
        if (this.city != null && !"-1".equals(this.city)) {
            if (this.city.indexOf("%") >= 0) {
                sqlFilter.append("AND o.org_id IN (SELECT org_id FROM organization_address WHERE " + DatabaseUtils.toLowerCase(db, "city") + " LIKE ? " + "AND city IS NOT NULL) ");
            } else {
                sqlFilter.append("AND o.org_id IN (SELECT org_id FROM organization_address WHERE " + DatabaseUtils.toLowerCase(db, "city") + " = ? " + "AND city IS NOT NULL) ");
            }
        }
        if (this.state != null && !"-1".equals(this.state)) {
            if (this.state.indexOf("%") >= 0) {
                sqlFilter.append("AND o.org_id IN (SELECT org_id FROM organization_address WHERE " + DatabaseUtils.toLowerCase(db, "state") + " LIKE ? " + "AND state IS NOT NULL) ");
            } else {
                sqlFilter.append("AND o.org_id IN (SELECT org_id FROM organization_address WHERE " + DatabaseUtils.toLowerCase(db, "state") + " = ? " + "AND state IS NOT NULL) ");
            }
        }
        if (this.country != null && !"-1".equals(this.country)) {
            sqlFilter.append("AND o.org_id IN (SELECT org_id FROM organization_address WHERE " + DatabaseUtils.toLowerCase(db, "country") + " = ? " + "AND country IS NOT NULL) ");
        }
        if (this.assetSerialNumber != null) {
            sqlFilter.append("AND o.org_id IN (SELECT a.account_id FROM asset a WHERE a.serial_number = ? AND a.trashed_date IS NULL) ");
        }
    }

    protected void buildResources(Connection db) throws SQLException {
        for (Organization thisOrganization : this) {
            thisOrganization.getPhoneNumberList().buildList(db);
            thisOrganization.getAddressList().buildList(db);
            thisOrganization.getEmailAddressList().buildList(db);
            if (thisOrganization.getNameLast() != null) {
                thisOrganization.populatePrimaryContact(db);
            }
            thisOrganization.buildTypes(db);
        }
    }

    public int reassignElements(Connection db, int newOwner) throws SQLException {
        int total = 0;
        for (Organization thisOrg : this) {
            if (!thisOrg.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    public int reassignElements(Connection db, int newOwner, int userId) throws SQLException {
        int total = 0;
        for (Organization thisOrg : this) {
            thisOrg.setModifiedBy(userId);
            if (!thisOrg.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.stageId > -1) {
            pst.setInt(++i, this.stageId);
        }
        if (this.minerOnly != null) {
            pst.setBoolean(++i, this.minerOnly);
        }
        if (this.enteredBy > -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.name != null) {
            pst.setString(++i, this.name.toLowerCase());
        }
        if (this.accountSegment != null) {
            pst.setString(++i, this.accountSegment.toLowerCase());
        }
        if (this.ownerId > -1) {
            pst.setInt(++i, this.ownerId);
        }
        if (this.includeEnabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.includeEnabled == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.hasAlertDate) {
            if (this.alertRangeStart != null) {
                pst.setTimestamp(++i, this.alertRangeStart);
            }
            if (this.alertRangeEnd != null) {
                pst.setTimestamp(++i, this.alertRangeEnd);
            }
        }
        if (this.hasExpireDate) {
            if (this.alertRangeStart != null) {
                pst.setTimestamp(++i, this.alertRangeStart);
            }
            if (this.alertRangeEnd != null) {
                pst.setTimestamp(++i, this.alertRangeEnd);
            }
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.enteredSince != null) {
            pst.setTimestamp(++i, this.enteredSince);
        }
        if (this.enteredTo != null) {
            pst.setTimestamp(++i, this.enteredTo);
        }
        if (this.revenueOwnerId > -1) {
            pst.setInt(++i, this.revenueOwnerId);
        }
        if (this.accountNumber != null) {
            pst.setString(++i, this.accountNumber.toLowerCase());
        }
        if (this.orgSiteId != -1) {
            pst.setInt(++i, this.orgSiteId);
        }
        if (this.importId != -1) {
            pst.setInt(++i, this.importId);
        }
        if (this.statusId != -1) {
            pst.setInt(++i, this.statusId);
        }
        if (this.firstName != null) {
            pst.setString(++i, this.firstName.toLowerCase());
        }
        if (this.lastName != null) {
            pst.setString(++i, this.lastName.toLowerCase());
        }
        if (this.contactPhoneNumber != null) {
            pst.setString(++i, this.contactPhoneNumber.toLowerCase());
        }
        if (this.contactCity != null && !"-1".equals(this.contactCity)) {
            pst.setString(++i, this.contactCity.toLowerCase());
        }
        if (this.contactState != null && !"-1".equals(this.contactState)) {
            pst.setString(++i, this.contactState.toLowerCase());
        }
        if (this.contactCountry != null && !"-1".equals(this.contactCountry)) {
            pst.setString(++i, this.contactCountry.toLowerCase());
        }
        if (this.excludeUnapprovedAccounts) {
            pst.setInt(++i, 7);
        }
        if (this.typeId > 0) {
            pst.setInt(++i, this.typeId);
        }
        if (this.orgId > 0) {
            pst.setInt(++i, this.orgId);
        }
        if (this.projectId > 0) {
            pst.setInt(++i, this.projectId);
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        if (this.postalCode != null) {
            pst.setString(++i, this.postalCode.toLowerCase());
        }
        if (this.city != null && !"-1".equals(this.city)) {
            pst.setString(++i, this.city.toLowerCase());
        }
        if (this.state != null && !"-1".equals(this.state)) {
            pst.setString(++i, this.state.toLowerCase());
        }
        if (this.country != null && !"-1".equals(this.country)) {
            pst.setString(++i, this.country.toLowerCase());
        }
        if (this.assetSerialNumber != null) {
            pst.setString(++i, this.assetSerialNumber);
        }
        return i;
    }

    public void delete(Connection db, ActionContext context, String baseFilePath, boolean forceDelete) throws SQLException {
        for (Organization thisOrganization : this) {
            thisOrganization.setContactDelete(true);
            thisOrganization.setRevenueDelete(true);
            thisOrganization.setDocumentDelete(true);
            thisOrganization.setForceDelete(forceDelete);
            thisOrganization.delete(db, context, baseFilePath);
        }
    }

    public static HashMap getParentAndLeafAccounts(Connection db, int typeId, boolean reciprocal) throws SQLException {
        HashMap<Integer, Integer> allAccounts = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> leafAccounts = new HashMap<Integer, Integer>();
        PreparedStatement pst = db.prepareStatement("SELECT org_id FROM organization WHERE trashed_date IS NULL ");
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            Integer accountId = new Integer(rs.getInt(uniqueField));
            allAccounts.put(accountId, accountId);
            leafAccounts.put(accountId, accountId);
        }
        rs.close();
        pst.close();
        RelationshipList thisList = new RelationshipList();
        thisList.setCategoryIdMapsFrom(42420034);
        thisList.setCategoryIdMapsTo(42420034);
        thisList.setTypeId(typeId);
        thisList.buildList(db);
        for (String relType : thisList.keySet()) {
            ArrayList tmpList = (ArrayList)thisList.get(relType);
            for (Relationship rel : tmpList) {
                if (allAccounts.get(new Integer(rel.getObjectIdMapsTo())) != null && reciprocal) {
                    allAccounts.remove(new Integer(rel.getObjectIdMapsTo()));
                } else if (allAccounts.get(new Integer(rel.getObjectIdMapsFrom())) != null && !reciprocal) {
                    allAccounts.remove(new Integer(rel.getObjectIdMapsFrom()));
                }
                if (leafAccounts.get(new Integer(rel.getObjectIdMapsFrom())) != null && reciprocal) {
                    leafAccounts.remove(new Integer(rel.getObjectIdMapsFrom()));
                    continue;
                }
                if (leafAccounts.get(new Integer(rel.getObjectIdMapsTo())) == null || reciprocal) continue;
                leafAccounts.remove(new Integer(rel.getObjectIdMapsTo()));
            }
        }
        HashMap<String, HashMap<Integer, Integer>> combinedAccounts = new HashMap<String, HashMap<Integer, Integer>>();
        combinedAccounts.put("parentNodes", allAccounts);
        combinedAccounts.put("leafNodes", leafAccounts);
        return combinedAccounts;
    }

    public static String buildParentNameHierarchy(Connection db, int childId, boolean skipName, HashMap existingAccounts) throws SQLException {
        Relationship rel;
        String relType;
        ArrayList tmpList;
        Iterator j;
        if (existingAccounts == null) {
            existingAccounts = new HashMap<String, Integer>();
        }
        StringBuffer parentName = new StringBuffer();
        RelationshipList thisList = new RelationshipList();
        thisList.setCategoryIdMapsFrom(42420034);
        thisList.setCategoryIdMapsTo(42420034);
        thisList.setObjectIdMapsFrom(childId);
        existingAccounts.put(String.valueOf(childId), new Integer(childId));
        thisList.setTypeId(1);
        thisList.buildList(db);
        Iterator iter = thisList.keySet().iterator();
        if (iter.hasNext() && (j = (tmpList = (ArrayList)thisList.get(relType = (String)iter.next())).iterator()).hasNext() && existingAccounts.get(String.valueOf((rel = (Relationship)((Object)j.next())).getObjectIdMapsTo())) == null) {
            parentName.append(OrganizationList.buildParentNameHierarchy(db, rel.getObjectIdMapsTo(), false, existingAccounts));
            if (!skipName) {
                parentName.append(", ");
            }
        }
        Organization org = new Organization(db, childId);
        if (!skipName) {
            parentName.append(org.getName());
        }
        return parentName.toString();
    }

    public Organization getOrgById(int id) {
        Organization result = null;
        for (Organization org : this) {
            if (org.getOrgId() != id) continue;
            result = org;
            break;
        }
        return result;
    }

    static {
        if (System.getProperty("DEBUG") != null) {
            log.setLevel(Level.DEBUG);
        }
    }
}

