/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.aspcfs.modules.base.PhoneNumber;
import org.aspcfs.utils.DatabaseUtils;

public class OrganizationPhoneNumber
extends PhoneNumber {
    public OrganizationPhoneNumber() {
    }

    public OrganizationPhoneNumber(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public OrganizationPhoneNumber(Connection db, String phoneNumberId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(phoneNumberId));
    }

    public OrganizationPhoneNumber(Connection db, int phoneNumberId) throws SQLException {
        this.queryRecord(db, phoneNumberId);
    }

    public void queryRecord(Connection db, int phoneNumberId) throws SQLException {
        if (phoneNumberId <= 0) {
            throw new SQLException("Invalid Phone Number ID specified.");
        }
        Statement st = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM organization_phone p, lookup_orgphone_types l WHERE p.phone_type = l.code AND phone_id = " + phoneNumberId + " ");
        st = db.createStatement();
        rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        st.close();
        if (this.getId() == -1) {
            throw new SQLException("Phone record not found.");
        }
    }

    public void process(Connection db, int orgId, int enteredBy, int modifiedBy) throws SQLException {
        if (this.getEnabled()) {
            if (this.getId() == -1) {
                this.setOrgId(orgId);
                this.setEnteredBy(enteredBy);
                this.setModifiedBy(modifiedBy);
                this.insert(db);
            } else {
                this.setModifiedBy(modifiedBy);
                this.update(db, modifiedBy);
            }
        } else {
            this.delete(db);
        }
    }

    public void insert(Connection db) throws SQLException {
        this.insert(db, this.getOrgId(), this.getEnteredBy());
    }

    public void insert(Connection db, int orgId, int enteredBy) throws SQLException {
        StringBuffer sql = new StringBuffer();
        int id = DatabaseUtils.getNextSeq(db, "organization_phone_phone_id_seq");
        sql.append("INSERT INTO organization_phone (org_id, phone_type, " + DatabaseUtils.addQuotes(db, "number") + ", extension, primary_number, ");
        if (id > -1) {
            sql.append("phone_id, ");
        }
        if (this.getEntered() != null) {
            sql.append("entered, ");
        }
        if (this.getModified() != null) {
            sql.append("modified, ");
        }
        sql.append("enteredBy, modifiedBy ) ");
        sql.append("VALUES (?, ?, ?, ?, ?, ");
        if (id > -1) {
            sql.append("?,");
        }
        if (this.getEntered() != null) {
            sql.append("?, ");
        }
        if (this.getModified() != null) {
            sql.append("?, ");
        }
        sql.append("?, ?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (orgId > -1) {
            pst.setInt(++i, this.getOrgId());
        } else {
            pst.setNull(++i, 4);
        }
        if (this.getType() > -1) {
            pst.setInt(++i, this.getType());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getNumber());
        pst.setString(++i, this.getExtension());
        pst.setBoolean(++i, this.getPrimaryNumber());
        if (id > -1) {
            pst.setInt(++i, id);
        }
        if (this.getEntered() != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        if (this.getModified() != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.setId(DatabaseUtils.getCurrVal(db, "organization_phone_phone_id_seq", id));
    }

    public void update(Connection db, int modifiedBy) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE organization_phone SET phone_type = ?, " + DatabaseUtils.addQuotes(db, "number") + " = ?, extension = ?, primary_number = ?, modifiedby = ?, " + "modified = CURRENT_TIMESTAMP " + "WHERE phone_id = ? ");
        int i = 0;
        if (this.getType() > -1) {
            pst.setInt(++i, this.getType());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setString(++i, this.getNumber());
        pst.setString(++i, this.getExtension());
        pst.setBoolean(++i, this.getPrimaryNumber());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM organization_phone WHERE phone_id = ? ");
        int i = 0;
        pst.setInt(++i, this.getId());
        pst.execute();
        pst.close();
    }

    public static ArrayList getUserIdParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("enteredBy");
        thisList.add("modifiedBy");
        return thisList;
    }
}

