/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import com.zeroio.iteam.base.FileItem;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldCategoryList;
import org.aspcfs.modules.base.CustomFieldGroup;
import org.aspcfs.modules.base.CustomFieldRecord;
import org.aspcfs.modules.base.CustomFieldRecordList;
import org.aspcfs.modules.base.Report;
import org.aspcfs.modules.base.ReportRow;

public class OrganizationReport
extends OrganizationList {
    protected Report rep = new Report();
    protected String delimiter = ",";
    protected String header = null;
    protected String tdFormat = "";
    protected String filePath = "";
    protected String filenameToUse = "";
    protected FileItem thisItem = new FileItem();
    protected String subject = "";
    protected int enteredBy = -1;
    protected int modifiedBy = -1;
    protected ArrayList criteria = null;
    String[] params = null;
    protected boolean includeFolders = false;
    protected int folderId = -1;

    public void setRep(Report tmp) {
        this.rep = tmp;
    }

    public void setDelimiter(String tmp) {
        this.delimiter = tmp;
    }

    public void setHeader(String tmp) {
        this.header = tmp;
    }

    public void setTdFormat(String tmp) {
        this.tdFormat = tmp;
    }

    public Report getRep() {
        return this.rep;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getHeader() {
        return this.header;
    }

    public String getTdFormat() {
        return this.tdFormat;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public FileItem getThisItem() {
        return this.thisItem;
    }

    public void setFilePath(String tmp) {
        this.filePath = tmp;
    }

    public void setThisItem(FileItem tmp) {
        this.thisItem = tmp;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public int getFolderId() {
        return this.folderId;
    }

    public void setFolderId(int folderId) {
        this.folderId = folderId;
    }

    public void setIncludeFolders(boolean includeFolders) {
        this.includeFolders = includeFolders;
    }

    public boolean getIncludeFolders() {
        return this.includeFolders;
    }

    public ArrayList getCriteria() {
        return this.criteria;
    }

    public void setCriteria(String[] criteriaString) {
        if (criteriaString != null) {
            this.params = criteriaString;
            this.criteria = new ArrayList<String>(Arrays.asList(this.params));
        } else {
            this.criteria = new ArrayList();
        }
    }

    public String[] getParams() {
        return this.params;
    }

    public void setParams(String[] params) {
        this.params = params;
    }

    public String getFilenameToUse() {
        return this.filenameToUse;
    }

    public void setFilenameToUse(String filenameToUse) {
        this.filenameToUse = filenameToUse;
    }

    public void buildReportBaseInfo() {
        this.rep.setDelimitedCharacter(this.delimiter);
        if (this.header != null) {
            this.rep.setHeader(this.header + ": " + this.subject);
        }
    }

    public void buildReportHeaders() {
        for (String param : this.criteria) {
            if (param.equals("id")) {
                this.rep.addColumn("Account ID");
            }
            if (param.equals("accountName")) {
                this.rep.addColumn("Account Name");
            }
            if (param.equals("accountNumber")) {
                this.rep.addColumn("Account No.");
            }
            if (param.equals("url")) {
                this.rep.addColumn("URL");
            }
            if (param.equals("stage")) {
                this.rep.addColumn("Stage");
            }
            if (param.equals("ticker")) {
                this.rep.addColumn("Ticker");
            }
            if (param.equals("employees")) {
                this.rep.addColumn("Employees");
            }
            if (param.equals("entered")) {
                this.rep.addColumn("Entered");
            }
            if (param.equals("enteredBy")) {
                this.rep.addColumn("Entered By");
            }
            if (param.equals("modified")) {
                this.rep.addColumn("Modified");
            }
            if (param.equals("modifiedBy")) {
                this.rep.addColumn("Modified By");
            }
            if (param.equals("owner")) {
                this.rep.addColumn("Owner");
            }
            if (param.equals("contractEndDate")) {
                this.rep.addColumn("Contract End Date");
            }
            if (param.equals("notes")) {
                this.rep.addColumn("Notes");
            }
            if (param.equals("businessname2")) {
                this.rep.addColumn("Business Name 2");
            }
            if (param.equals("street")) {
                this.rep.addColumn("Street");
            }
            if (param.equals("city")) {
                this.rep.addColumn("City");
            }
            if (param.equals("state")) {
                this.rep.addColumn("State");
            }
            if (param.equals("zip")) {
                this.rep.addColumn("Zip");
            }
            if (param.equals("country")) {
                this.rep.addColumn("Country");
            }
            if (param.equals("dunsnumber")) {
                this.rep.addColumn("DUNS Number");
            }
            if (param.equals("SICDesc")) {
                this.rep.addColumn("SIC Description");
            }
            if (param.equals("revenue")) {
                this.rep.addColumn("Revenue");
            }
            if (param.equals("yearstarted")) {
                this.rep.addColumn("Year Started");
            }
            if (param.equals("phone")) {
                this.rep.addColumn("Phone");
            }
            if (param.equals("latitude")) {
                this.rep.addColumn("Latitude");
            }
            if (param.equals("longitude")) {
                this.rep.addColumn("Longitude");
            }
            if (!param.equals("county")) continue;
            this.rep.addColumn("County");
        }
        if (this.includeFolders) {
            this.rep.addColumn("Folder Name");
            this.rep.addColumn("Record Name");
            this.rep.addColumn("Group Name");
            this.rep.addColumn("Field Name");
            this.rep.addColumn("Field Value");
            this.rep.addColumn("Entered");
            this.rep.addColumn("Modified");
        }
    }

    public void buildReportHeaders(Report passedReport) {
        for (String param : this.criteria) {
            if (param.equals("id")) {
                passedReport.addColumn("Account ID");
            }
            if (param.equals("accountName")) {
                passedReport.addColumn("Account Name");
            }
            if (param.equals("accountNumber")) {
                passedReport.addColumn("Account No.");
            }
            if (param.equals("stage")) {
                passedReport.addColumn("Stage");
            }
            if (param.equals("url")) {
                passedReport.addColumn("URL");
            }
            if (param.equals("ticker")) {
                passedReport.addColumn("Ticker");
            }
            if (param.equals("employees")) {
                passedReport.addColumn("Employees");
            }
            if (param.equals("entered")) {
                passedReport.addColumn("Entered");
            }
            if (param.equals("enteredBy")) {
                passedReport.addColumn("Entered By");
            }
            if (param.equals("modified")) {
                passedReport.addColumn("Modified");
            }
            if (param.equals("modifiedBy")) {
                passedReport.addColumn("Modified By");
            }
            if (param.equals("owner")) {
                passedReport.addColumn("Owner");
            }
            if (param.equals("contractEndDate")) {
                passedReport.addColumn("Contract End Date");
            }
            if (param.equals("notes")) {
                passedReport.addColumn("Notes");
            }
            if (param.equals("businessname2")) {
                passedReport.addColumn("Business Name 2");
            }
            if (param.equals("street")) {
                passedReport.addColumn("Street");
            }
            if (param.equals("city")) {
                passedReport.addColumn("City");
            }
            if (param.equals("state")) {
                passedReport.addColumn("State");
            }
            if (param.equals("zip")) {
                passedReport.addColumn("Zip");
            }
            if (param.equals("country")) {
                passedReport.addColumn("Country");
            }
            if (param.equals("dunsnumber")) {
                passedReport.addColumn("DUNS Number");
            }
            if (param.equals("SICDesc")) {
                passedReport.addColumn("SIC Description");
            }
            if (param.equals("revenue")) {
                passedReport.addColumn("Revenue");
            }
            if (param.equals("yearstarted")) {
                passedReport.addColumn("Year Started");
            }
            if (param.equals("phone")) {
                passedReport.addColumn("Phone");
            }
            if (param.equals("latitude")) {
                passedReport.addColumn("Latitude");
            }
            if (param.equals("longitude")) {
                passedReport.addColumn("Longitude");
            }
            if (!param.equals("county")) continue;
            passedReport.addColumn("county");
        }
    }

    public void buildReportData(Connection db) throws SQLException {
        this.buildList(db);
        CustomFieldCategoryList thisList = new CustomFieldCategoryList();
        CustomFieldCategory thisCat2 = null;
        CustomFieldGroup thisGroup2 = new CustomFieldGroup();
        if (this.includeFolders) {
            thisList.setLinkModuleId(1);
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(true);
            thisList.buildList(db);
        } else if (this.folderId > -1) {
            thisCat2 = new CustomFieldCategory(db, this.folderId);
            thisCat2.buildResources(db);
            for (CustomFieldGroup thisGroup2 : thisCat2) {
                thisGroup2.buildResources(db);
                Iterator fields = thisGroup2.iterator();
                if (!fields.hasNext()) continue;
                while (fields.hasNext()) {
                    CustomField thisField = (CustomField)fields.next();
                    this.rep.addColumn(thisField.getNameHtml());
                }
            }
        }
        for (Organization thisOrg : this) {
            Iterator fields;
            CustomFieldRecordList recordList;
            if (this.includeFolders) {
                recordList = new CustomFieldRecordList();
                thisGroup2 = new CustomFieldGroup();
                for (CustomFieldCategory thisCat2 : thisList) {
                    recordList = new CustomFieldRecordList();
                    recordList.setLinkModuleId(1);
                    recordList.setLinkItemId(thisOrg.getOrgId());
                    recordList.setCategoryId(thisCat2.getId());
                    recordList.buildList(db);
                    for (CustomFieldRecord thisRec : recordList) {
                        for (CustomFieldGroup thisGroup2 : thisCat2) {
                            thisGroup2.buildResources(db);
                            fields = thisGroup2.iterator();
                            if (!fields.hasNext()) continue;
                            while (fields.hasNext()) {
                                ReportRow thisRow = new ReportRow();
                                CustomField thisField = (CustomField)fields.next();
                                thisField.setRecordId(thisRec.getId());
                                thisField.buildResources(db);
                                this.addDataRow(thisRow, thisOrg);
                                thisRow.addCell(thisCat2.getName());
                                thisRow.addCell(thisCat2.getName() + " #" + thisRec.getId());
                                thisRow.addCell(thisGroup2.getName());
                                thisRow.addCell(thisField.getNameHtml());
                                thisRow.addCell(thisField.getValueHtml());
                                thisRow.addCell(thisRec.getEnteredString());
                                thisRow.addCell(thisRec.getModifiedDateTimeString());
                                this.rep.addRow(thisRow);
                            }
                        }
                    }
                }
                continue;
            }
            if (this.folderId > -1) {
                recordList = new CustomFieldRecordList();
                recordList.setLinkModuleId(1);
                recordList.setLinkItemId(thisOrg.getOrgId());
                recordList.setCategoryId(thisCat2.getId());
                recordList.buildList(db);
                Iterator rec = recordList.iterator();
                while (rec.hasNext()) {
                    CustomFieldRecord thisRec;
                    ReportRow thisRow = new ReportRow();
                    this.addDataRow(thisRow, thisOrg);
                    thisRec = (CustomFieldRecord)rec.next();
                    for (CustomFieldGroup thisGroup2 : thisCat2) {
                        thisGroup2.buildResources(db);
                        fields = thisGroup2.iterator();
                        if (!fields.hasNext()) continue;
                        while (fields.hasNext()) {
                            CustomField thisField = (CustomField)fields.next();
                            thisField.setRecordId(thisRec.getId());
                            thisField.buildResources(db);
                            thisRow.addCell(thisField.getValueHtml());
                        }
                    }
                    this.rep.addRow(thisRow);
                }
                continue;
            }
            ReportRow thisRow = new ReportRow();
            this.addDataRow(thisRow, thisOrg);
            this.rep.addRow(thisRow);
        }
    }

    public void addDataRow(ReportRow thisRow, Organization thisOrg) throws SQLException {
        for (String param : this.criteria) {
            if (param.equals("id")) {
                thisRow.addCell(thisOrg.getOrgId());
            }
            if (param.equals("accountName")) {
                thisRow.addCell(thisOrg.getName());
            }
            if (param.equals("accountNumber")) {
                thisRow.addCell(thisOrg.getAccountNumber());
            }
            if (param.equals("url")) {
                thisRow.addCell(thisOrg.getUrl());
            }
            if (param.equals("stage")) {
                thisRow.addCell(thisOrg.getStageName());
            }
            if (param.equals("ticker")) {
                thisRow.addCell(thisOrg.getTicker());
            }
            if (param.equals("employees")) {
                thisRow.addCell(thisOrg.getEmployees());
            }
            if (param.equals("entered")) {
                thisRow.addCell(thisOrg.getEnteredString());
            }
            if (param.equals("enteredBy")) {
                thisRow.addCell(thisOrg.getEnteredByName());
            }
            if (param.equals("modified")) {
                thisRow.addCell(thisOrg.getModifiedString());
            }
            if (param.equals("modifiedBy")) {
                thisRow.addCell(thisOrg.getModifiedByName());
            }
            if (param.equals("owner")) {
                thisRow.addCell(thisOrg.getOwnerName());
            }
            if (param.equals("contractEndDate")) {
                thisRow.addCell(thisOrg.getContractEndDateString());
            }
            if (param.equals("notes")) {
                thisRow.addCell(thisOrg.getNotes());
            }
            if (param.equals("businessname2")) {
                thisRow.addCell(thisOrg.getBusinessNameTwo());
            }
            if (param.equals("street")) {
                if (thisOrg.getPrimaryAddress() == null) {
                    thisRow.addCell("");
                } else {
                    thisRow.addCell(String.valueOf(thisOrg.getPrimaryAddress().getStreetAddressLine1()));
                }
            }
            if (param.equals("city")) {
                if (thisOrg.getPrimaryAddress() == null) {
                    thisRow.addCell("");
                } else {
                    thisRow.addCell(thisOrg.getPrimaryAddress().getCity());
                }
            }
            if (param.equals("state")) {
                if (thisOrg.getPrimaryAddress() == null) {
                    thisRow.addCell("");
                } else {
                    thisRow.addCell("-1".equals(thisOrg.getPrimaryAddress().getState()) ? "" : thisOrg.getPrimaryAddress().getState());
                }
            }
            if (param.equals("zip")) {
                if (thisOrg.getPrimaryAddress() == null) {
                    thisRow.addCell("");
                } else {
                    thisRow.addCell(thisOrg.getPrimaryAddress().getZip());
                }
            }
            if (param.equals("country")) {
                if (thisOrg.getPrimaryAddress() == null) {
                    thisRow.addCell("");
                } else {
                    thisRow.addCell("-1".equals(thisOrg.getPrimaryAddress().getCountry()) ? "" : thisOrg.getPrimaryAddress().getCountry());
                }
            }
            if (param.equals("dunsnumber")) {
                thisRow.addCell(thisOrg.getDunsNumber());
            }
            if (param.equals("SICDesc")) {
                thisRow.addCell(thisOrg.getSicDescription());
            }
            if (param.equals("revenue")) {
                thisRow.addCell(String.valueOf(thisOrg.getRevenue()));
            }
            if (param.equals("yearstarted")) {
                if (thisOrg.getYearStarted() == -1) {
                    thisRow.addCell("");
                } else {
                    thisRow.addCell(thisOrg.getYearStarted());
                }
            }
            if (param.equals("phone")) {
                thisRow.addCell(thisOrg.getPrimaryPhoneNumber());
            }
            if (param.equals("latitude")) {
                if (thisOrg.getPrimaryAddress() == null) {
                    thisRow.addCell("");
                } else if (thisOrg.getPrimaryAddress().getLatitude() == 0.0 && thisOrg.getPrimaryAddress().getLongitude() == 0.0) {
                    thisRow.addCell("");
                } else {
                    thisRow.addCell(String.valueOf(thisOrg.getPrimaryAddress().getLatitude()));
                }
            }
            if (param.equals("longitude")) {
                if (thisOrg.getPrimaryAddress() == null) {
                    thisRow.addCell("");
                } else if (thisOrg.getPrimaryAddress().getLatitude() == 0.0 && thisOrg.getPrimaryAddress().getLongitude() == 0.0) {
                    thisRow.addCell("");
                } else {
                    thisRow.addCell(String.valueOf(thisOrg.getPrimaryAddress().getLongitude()));
                }
            }
            if (!param.equals("county")) continue;
            if (thisOrg.getPrimaryAddress() == null) {
                thisRow.addCell("");
                continue;
            }
            if (thisOrg.getPrimaryAddress().getCounty() == null) {
                thisRow.addCell("");
                continue;
            }
            thisRow.addCell(String.valueOf(thisOrg.getPrimaryAddress().getCounty()));
        }
    }

    public void buildReportFull(Connection db) throws SQLException {
        this.buildReportBaseInfo();
        this.buildReportHeaders();
        this.buildReportData(db);
    }

    public boolean saveAndInsert(Connection db) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        this.filenameToUse = formatter.format(new Date());
        File f = new File(this.filePath);
        f.mkdirs();
        File fileLink = new File(this.filePath + this.filenameToUse + ".csv");
        this.rep.saveHtml(this.filePath + this.filenameToUse + ".html");
        this.rep.saveDelimited(this.filePath + this.filenameToUse + ".csv");
        this.thisItem.setLinkModuleId(10);
        this.thisItem.setLinkItemId(0);
        this.thisItem.setEnteredBy(this.enteredBy);
        this.thisItem.setModifiedBy(this.modifiedBy);
        this.thisItem.setSubject(this.subject);
        this.thisItem.setClientFilename("accountreport-" + this.filenameToUse + ".csv");
        this.thisItem.setFilename(this.filenameToUse);
        this.thisItem.setSize((int)fileLink.length());
        this.thisItem.insert(db);
        return true;
    }
}

