/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Hashtable;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.StringUtils;

public class Revenue
extends GenericBean {
    private int id = -1;
    private int orgId = -1;
    private int transactionId = -1;
    private int month = -1;
    private int year = 0;
    private double amount = 0.0;
    private int type = -1;
    private int owner = -1;
    private String description = "";
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private Timestamp entered = null;
    private String enteredByName = "";
    private String modifiedByName = "";
    private String ownerNameFirst = "";
    private String ownerNameLast = "";
    private String typeName = "";
    private String orgName = "";
    private boolean hasEnabledOwnerAccount = true;

    public Revenue() {
    }

    public Revenue(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Revenue(Connection db, String revenueId) throws SQLException {
        this.queryRecord(db, Integer.parseInt(revenueId));
    }

    public Revenue(Connection db, int revenueId) throws SQLException {
        this.queryRecord(db, revenueId);
    }

    public void queryRecord(Connection db, int revenueId) throws SQLException {
        if (revenueId == -1) {
            throw new SQLException("Revenue ID not specified.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT r.*, ct_eb.namelast as eb_namelast, ct_eb.namefirst as eb_namefirst, ct_mb.namelast as mb_namelast, ct_mb.namefirst as mb_namefirst, ct_own.namelast as own_namelast, ct_own.namefirst as own_namefirst, rt.description as typename, o.name as orgname FROM revenue r LEFT JOIN contact ct_eb ON (r.enteredby = ct_eb.user_id) LEFT JOIN contact ct_mb ON (r.modifiedby = ct_mb.user_id) LEFT JOIN contact ct_own ON (r.owner = ct_own.user_id) LEFT JOIN organization o ON (r.org_id = o.org_id) LEFT JOIN lookup_revenue_types rt ON (r." + DatabaseUtils.addQuotes(db, "type") + " = rt.code) " + "WHERE r.id = ? ");
        pst.setInt(1, revenueId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (revenueId == -1) {
            throw new SQLException("Revenue ID not found.");
        }
    }

    public String getEnteredString() {
        try {
            return DateFormat.getDateInstance(3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getEnteredDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getModifiedString() {
        try {
            return DateFormat.getDateInstance(3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getModifiedDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getAmountValue() {
        String toReturn = "";
        double value_2dp = (double)Math.round(this.amount * 100.0) / 100.0;
        toReturn = String.valueOf(value_2dp);
        if (toReturn.endsWith(".0")) {
            toReturn = toReturn.substring(0, toReturn.length() - 2);
        }
        try {
            if (Double.parseDouble(toReturn) == 0.0 || Integer.parseInt(toReturn) == 0) {
                toReturn = "";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (toReturn.indexOf(".") > 0 && toReturn.indexOf(".") == toReturn.length() - 2) {
            return toReturn + "0";
        }
        return toReturn;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public boolean getHasEnabledOwnerAccount() {
        return this.hasEnabledOwnerAccount;
    }

    public void setHasEnabledOwnerAccount(boolean hasEnabledOwnerAccount) {
        this.hasEnabledOwnerAccount = hasEnabledOwnerAccount;
    }

    public int getId() {
        return this.id;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public double getAmount() {
        return this.amount;
    }

    public String getDescription() {
        return this.description;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredByName() {
        return this.enteredByName;
    }

    public String getModifiedByName() {
        return this.modifiedByName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setTransactionId(int tmp) {
        this.transactionId = tmp;
    }

    public void setTransactionId(String tmp) {
        this.transactionId = Integer.parseInt(tmp);
    }

    public void setMonth(int tmp) {
        this.month = tmp;
    }

    public void setMonth(String tmp) {
        this.month = Integer.parseInt(tmp);
    }

    public void setYear(int tmp) {
        this.year = tmp;
    }

    public void setYear(String tmp) {
        this.year = Integer.parseInt(tmp);
    }

    public void setAmount(double tmp) {
        this.amount = tmp;
    }

    public void setAmount(String tmp) {
        tmp = StringUtils.replace(tmp, ",", "");
        tmp = StringUtils.replace(tmp, "$", "");
        this.amount = Double.parseDouble(tmp);
    }

    public String getMonthName() {
        String r = "";
        switch (this.month) {
            case 1: {
                r = "January";
                break;
            }
            case 2: {
                r = "February";
                break;
            }
            case 3: {
                r = "March";
                break;
            }
            case 4: {
                r = "April";
                break;
            }
            case 5: {
                r = "May";
                break;
            }
            case 6: {
                r = "June";
                break;
            }
            case 7: {
                r = "July";
                break;
            }
            case 8: {
                r = "August";
                break;
            }
            case 9: {
                r = "September";
                break;
            }
            case 10: {
                r = "October";
                break;
            }
            case 11: {
                r = "November";
                break;
            }
            case 12: {
                r = "December";
                break;
            }
        }
        return r;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEnteredByName(String tmp) {
        this.enteredByName = tmp;
    }

    public void setModifiedByName(String tmp) {
        this.modifiedByName = tmp;
    }

    public void setTypeName(String tmp) {
        this.typeName = tmp;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void setOwner(String tmp) {
        this.owner = Integer.parseInt(tmp);
    }

    public int getType() {
        return this.type;
    }

    public int getOwner() {
        return this.owner;
    }

    public void setOwnerNameFirst(String tmp) {
        this.ownerNameFirst = tmp;
    }

    public void setOwnerNameLast(String tmp) {
        this.ownerNameLast = tmp;
    }

    public String getOwnerNameFirst() {
        return this.ownerNameFirst;
    }

    public String getOwnerNameLast() {
        return this.ownerNameLast;
    }

    public void setEntered(String tmp) {
        this.entered = DateUtils.parseTimestampString(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DateUtils.parseTimestampString(tmp);
    }

    public String getOwnerName() {
        return Contact.getNameLastFirst(this.getOwnerNameLast(), this.getOwnerNameFirst());
    }

    public String getOwnerNameAbbr() {
        return this.getOwnerNameFirst().charAt(0) + ". " + this.getOwnerNameLast();
    }

    public boolean insert(Connection db, ActionContext context) throws SQLException {
        if (this.insert(db)) {
            this.invalidateUserData(context);
            return true;
        }
        return false;
    }

    public void checkEnabledOwnerAccount(Connection db) throws SQLException {
        if (this.getOwner() == -1) {
            throw new SQLException("ID not specified for lookup.");
        }
        PreparedStatement pst = db.prepareStatement("SELECT * FROM " + DatabaseUtils.addQuotes(db, "access") + " " + "WHERE user_id = ? AND enabled = ? ");
        pst.setInt(1, this.getOwner());
        pst.setBoolean(2, true);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.setHasEnabledOwnerAccount(true);
        } else {
            this.setHasEnabledOwnerAccount(false);
        }
        rs.close();
        pst.close();
    }

    public int update(Connection db, ActionContext context) throws SQLException {
        int oldId = -1;
        PreparedStatement pst = db.prepareStatement("SELECT owner FROM revenue WHERE id = ? ");
        pst.setInt(1, this.getId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            oldId = rs.getInt("owner");
        }
        rs.close();
        pst.close();
        int result = this.update(db);
        if (result == 1) {
            this.invalidateUserData(context);
            if (oldId != this.getOwner()) {
                this.invalidateUserData(context, oldId);
            }
        }
        return result;
    }

    public boolean delete(Connection db, ActionContext context) throws SQLException {
        if (this.delete(db)) {
            this.invalidateUserData(context);
            return true;
        }
        return false;
    }

    public boolean reassign(Connection db, int newOwner) throws SQLException {
        int result = -1;
        this.setOwner(newOwner);
        result = this.update(db);
        return result != -1;
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "revenue_id_seq");
        sql.append("INSERT INTO revenue (org_id, transaction_id, " + DatabaseUtils.addQuotes(db, "month") + ", " + DatabaseUtils.addQuotes(db, "year") + ", amount, " + DatabaseUtils.addQuotes(db, "type") + ", owner, description, ");
        if (this.id > -1) {
            sql.append("id, ");
        }
        if (this.entered != null) {
            sql.append("entered, ");
        }
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("enteredBy, modifiedBy ) ");
        sql.append("VALUES (?, ?, ?, ?, ?, ?, ?, ?, ");
        if (this.id > -1) {
            sql.append("?, ");
        }
        if (this.entered != null) {
            sql.append("?, ");
        }
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("?, ?) ");
        try {
            db.setAutoCommit(false);
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setInt(++i, this.orgId);
            pst.setInt(++i, this.transactionId);
            pst.setInt(++i, this.month);
            pst.setInt(++i, this.year);
            pst.setDouble(++i, this.amount);
            if (this.type > 0) {
                pst.setInt(++i, this.getType());
            } else {
                pst.setNull(++i, 4);
            }
            if (this.owner > 0) {
                pst.setInt(++i, this.getOwner());
            } else {
                pst.setNull(++i, 4);
            }
            pst.setString(++i, this.description);
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "revenue_id_seq", this.id);
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        PreparedStatement pst = null;
        pst = db.prepareStatement("DELETE FROM revenue WHERE id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    protected int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("Revenue ID was not specified");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE revenue SET " + DatabaseUtils.addQuotes(db, "month") + " = ?, " + DatabaseUtils.addQuotes(db, "year") + " = ?, amount = ?, owner = ?, description = ?, " + "" + DatabaseUtils.addQuotes(db, "type") + " = ?, " + "modified = CURRENT_TIMESTAMP, modifiedby = ? " + "WHERE id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.getMonth());
        pst.setInt(++i, this.getYear());
        pst.setDouble(++i, this.getAmount());
        pst.setInt(++i, this.getOwner());
        pst.setString(++i, this.getDescription());
        if (this.type > 0) {
            pst.setInt(++i, this.getType());
        } else {
            pst.setNull(++i, 4);
        }
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        try {
            db.setAutoCommit(false);
            resultCount = this.update(db, false);
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return resultCount;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.orgId = rs.getInt("org_id");
        this.transactionId = rs.getInt("transaction_id");
        this.month = rs.getInt("month");
        this.year = rs.getInt("year");
        this.amount = rs.getDouble("amount");
        this.type = rs.getInt("type");
        if (rs.wasNull()) {
            this.type = -1;
        }
        this.owner = rs.getInt("owner");
        if (rs.wasNull()) {
            this.owner = -1;
        }
        this.description = rs.getString("description");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enteredByName = Contact.getNameLastFirst(rs.getString("eb_namelast"), rs.getString("eb_namefirst"));
        this.modifiedByName = Contact.getNameLastFirst(rs.getString("mb_namelast"), rs.getString("mb_namefirst"));
        this.ownerNameFirst = rs.getString("own_namefirst");
        this.ownerNameLast = rs.getString("own_namelast");
        this.typeName = rs.getString("typename");
        this.orgName = rs.getString("orgname");
    }

    public void invalidateUserData(ActionContext context) {
        this.invalidateUserData(context, this.owner);
    }

    public void invalidateUserData(ActionContext context, int userId) {
        ConnectionElement ce = (ConnectionElement)context.getSession().getAttribute("ConnectionElement");
        SystemStatus systemStatus = (SystemStatus)((Hashtable)context.getServletContext().getAttribute("SystemStatus")).get(ce.getUrl());
        systemStatus.getHierarchyList().getUser(userId).setRevenueIsValid(false, true);
    }
}

