/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;

public class RevenueDetail
extends GenericBean {
    private int id = -1;
    private int revenueId = -1;
    private double amount = 0.0;
    private int type = -1;
    private int owner = -1;
    private String description = "";
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private Timestamp entered = null;
    private String enteredByName = "";
    private String modifiedByName = "";
    private String typeName = "";

    public RevenueDetail() {
    }

    public RevenueDetail(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public RevenueDetail(Connection db, String revenueDetailId) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT rd.*, ct_eb.namelast as eb_namelast, ct_eb.namefirst as eb_namefirst, ct_mb.namelast as mb_namelast, ct_mb.namefirst as mb_namefirst, rdt.description as typename FROM revenue_detail rd LEFT JOIN contact ct_eb ON (rd.enteredby = ct_eb.user_id) LEFT JOIN contact ct_mb ON (rd.modifiedby = ct_mb.user_id) LEFT JOIN lookup_revenuedetail_types rdt ON (rd." + DatabaseUtils.addQuotes(db, "type") + " = rdt.code) " + "WHERE rd.id > -1 ");
        if (revenueDetailId == null || revenueDetailId.equals("")) {
            throw new SQLException("Revenue Detail ID not specified.");
        }
        sql.append("AND rd.id = " + revenueDetailId + " ");
        st = db.createStatement();
        rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        st.close();
        if (this.id == -1) {
            throw new SQLException("Revenue Detail record not found.");
        }
    }

    public String getEnteredString() {
        try {
            return DateFormat.getDateInstance(3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getEnteredDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getModifiedString() {
        try {
            return DateFormat.getDateInstance(3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getModifiedDateTimeString() {
        try {
            return DateFormat.getDateTimeInstance(3, 3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public int getId() {
        return this.id;
    }

    public int getRevenueId() {
        return this.revenueId;
    }

    public double getAmount() {
        return this.amount;
    }

    public String getDescription() {
        return this.description;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredByName() {
        return this.enteredByName;
    }

    public String getModifiedByName() {
        return this.modifiedByName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setRevenueId(int tmp) {
        this.revenueId = tmp;
    }

    public void setRevenueId(String tmp) {
        this.revenueId = Integer.parseInt(tmp);
    }

    public void setAmount(double tmp) {
        this.amount = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEnteredByName(String tmp) {
        this.enteredByName = tmp;
    }

    public void setModifiedByName(String tmp) {
        this.modifiedByName = tmp;
    }

    public void setTypeName(String tmp) {
        this.typeName = tmp;
    }

    public int getType() {
        return this.type;
    }

    public int getOwner() {
        return this.owner;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "revenue_detail_id_seq");
        sql.append("INSERT INTO revenue_detail (" + (this.id > -1 ? "id, " : "") + "revenue_id, amount, " + DatabaseUtils.addQuotes(db, "type") + ", owner, description, enteredBy, modifiedBy) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?) ");
        try {
            db.setAutoCommit(false);
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.revenueId);
            pst.setDouble(++i, this.amount);
            pst.setInt(++i, this.type);
            pst.setInt(++i, this.owner);
            pst.setString(++i, this.description);
            pst.setInt(++i, this.enteredBy);
            pst.setInt(++i, this.modifiedBy);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "revenue_detail_id_seq", this.id);
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        Statement st = db.createStatement();
        st.executeUpdate("DELETE FROM revenue_detail WHERE id = " + this.getId());
        st.close();
        return true;
    }

    protected int update(Connection db, boolean override) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("Revenue Detail ID was not specified");
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE revenue SET amount = ?, owner = ?, description = ?, " + DatabaseUtils.addQuotes(db, "type") + " = ?, " + "modified = CURRENT_TIMESTAMP, modifiedby = ? " + "WHERE id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setDouble(++i, this.getAmount());
        pst.setInt(++i, this.getOwner());
        pst.setString(++i, this.getDescription());
        pst.setInt(++i, this.getType());
        pst.setInt(++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = -1;
        try {
            db.setAutoCommit(false);
            resultCount = this.update(db, false);
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return resultCount;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.revenueId = rs.getInt("revenue_id");
        this.amount = rs.getDouble("amount");
        this.type = rs.getInt("type");
        this.owner = rs.getInt("owner");
        this.description = rs.getString("description");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enteredByName = Contact.getNameLastFirst(rs.getString("eb_namelast"), rs.getString("eb_namefirst"));
        this.modifiedByName = Contact.getNameLastFirst(rs.getString("mb_namelast"), rs.getString("mb_namefirst"));
        this.typeName = rs.getString("typename");
    }
}

