/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import org.aspcfs.modules.accounts.base.Revenue;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class RevenueList
extends Vector {
    private int orgId = -1;
    private int type = 0;
    private String ownerIdRange = null;
    private int owner = -1;
    private int year = -1;
    public static final String tableName = "revenue";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM revenue r LEFT JOIN contact ct_eb ON (r.enteredby = ct_eb.user_id) LEFT JOIN contact ct_mb ON (r.modifiedby = ct_mb.user_id) LEFT JOIN contact ct_own ON (r.owner = ct_own.user_id) LEFT JOIN lookup_revenue_types rt ON (r." + DatabaseUtils.addQuotes(db, "type") + " = rt.code) " + "LEFT JOIN organization o ON (r.org_id = o.org_id) " + "WHERE r.id > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(r.description) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("r." + DatabaseUtils.addQuotes(db, "year") + ",r." + DatabaseUtils.addQuotes(db, "month") + "", "desc");
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY r." + DatabaseUtils.addQuotes(db, "year") + " desc,r." + DatabaseUtils.addQuotes(db, "month") + " desc ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("r.*, ct_eb.namelast as eb_namelast, ct_eb.namefirst as eb_namefirst, ct_mb.namelast as mb_namelast, ct_mb.namefirst as mb_namefirst, ct_own.namelast as own_namelast, ct_own.namefirst as own_namefirst, rt.description as typename, o.name as orgname FROM revenue r LEFT JOIN contact ct_eb ON (r.enteredby = ct_eb.user_id) LEFT JOIN contact ct_mb ON (r.modifiedby = ct_mb.user_id) LEFT JOIN contact ct_own ON (r.owner = ct_own.user_id) LEFT JOIN organization o ON (r.org_id = o.org_id) LEFT JOIN lookup_revenue_types rt ON (r." + DatabaseUtils.addQuotes(db, "type") + " = rt.code) " + "WHERE r.id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Revenue thisRevenue = new Revenue(rs);
            this.addElement(thisRevenue);
        }
        rs.close();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        for (Revenue thisRevenue : this) {
            thisRevenue.delete(db);
        }
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public void setOrgId(int orgId) {
        this.orgId = orgId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public String getOwnerIdRange() {
        return this.ownerIdRange;
    }

    public void setOwnerIdRange(String ownerIdRange) {
        this.ownerIdRange = ownerIdRange;
    }

    public int getOwner() {
        return this.owner;
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public int reassignElements(Connection db, int newOwner) throws SQLException {
        int total = 0;
        for (Revenue thisRevenue : this) {
            if (!thisRevenue.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    public int reassignElements(Connection db, int newOwner, int userId) throws SQLException {
        int total = 0;
        for (Revenue thisRevenue : this) {
            thisRevenue.setModifiedBy(userId);
            if (!thisRevenue.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    private void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.orgId != -1) {
            sqlFilter.append("AND r.org_id = ? ");
        }
        if (this.type > 0) {
            sqlFilter.append("AND r." + DatabaseUtils.addQuotes(db, "type") + " = ? ");
        }
        if (this.owner > -1) {
            sqlFilter.append("AND r.owner = ? ");
        }
        if (this.year > -1) {
            sqlFilter.append("AND r." + DatabaseUtils.addQuotes(db, "year") + " = ? ");
        }
        if (this.ownerIdRange != null) {
            sqlFilter.append("AND r.owner in (" + this.ownerIdRange + ") ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.orgId != -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.type > 0) {
            pst.setInt(++i, this.type);
        }
        if (this.owner > -1) {
            pst.setInt(++i, this.owner);
        }
        if (this.year > -1) {
            pst.setInt(++i, this.year);
        }
        return i;
    }

    public static int retrieveRecordCount(Connection db, int moduleId, int itemId) throws SQLException {
        ResultSet rs;
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(*) as itemcount FROM revenue r WHERE id > 0 ");
        if (moduleId == 1) {
            sql.append("AND r.org_id = ? ");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (moduleId == 1) {
            pst.setInt(1, itemId);
        }
        if ((rs = pst.executeQuery()).next()) {
            count = rs.getInt("itemcount");
        }
        rs.close();
        pst.close();
        return count;
    }
}

