/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.base;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.aspcfs.modules.accounts.base.RevenueType;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.LookupList;

public class RevenueTypeList
extends Vector {
    private String jsEvent = "";
    private int defaultKey = -1;
    private int size = 1;
    private boolean multiple = false;

    public RevenueTypeList() {
    }

    public RevenueTypeList(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public void setDefaultKey(int tmp) {
        this.defaultKey = tmp;
    }

    public void setDefaultKey(String tmp) {
        this.defaultKey = Integer.parseInt(tmp);
    }

    public int getSize() {
        return this.size;
    }

    public boolean getMultiple() {
        return this.multiple;
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public int getDefaultKey() {
        return this.defaultKey;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, this.defaultKey);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        LookupList revenueTypeSelect = new LookupList();
        revenueTypeSelect = this.getLookupList(selectName, defaultKey);
        return revenueTypeSelect.getHtmlSelect(selectName, defaultKey);
    }

    public LookupList getLookupList(String selectName, int defaultKey) {
        LookupList revenueTypeSelect = new LookupList();
        revenueTypeSelect.setJsEvent(this.jsEvent);
        revenueTypeSelect.setSelectSize(this.getSize());
        revenueTypeSelect.setMultiple(this.getMultiple());
        for (RevenueType thisRevenueType : this) {
            if (thisRevenueType.getEnabled()) {
                revenueTypeSelect.appendItem(thisRevenueType.getId(), thisRevenueType.getDescription());
                continue;
            }
            if (thisRevenueType.getEnabled() || thisRevenueType.getId() != defaultKey) continue;
            revenueTypeSelect.appendItem(thisRevenueType.getId(), thisRevenueType.getDescription() + " (X)");
        }
        return revenueTypeSelect;
    }

    public void addItem(int key, String name) {
        RevenueType thisRevenueType = new RevenueType();
        thisRevenueType.setId(key);
        thisRevenueType.setDescription(name);
        this.add(0, thisRevenueType);
    }

    public void buildList(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM lookup_revenue_types WHERE code > -1 ");
        sql.append("ORDER BY " + DatabaseUtils.addQuotes(db, "level") + ", description ");
        Statement st = db.createStatement();
        ResultSet rs = st.executeQuery(sql.toString());
        while (rs.next()) {
            RevenueType thisRevenueType = new RevenueType(rs);
            this.addElement(thisRevenueType);
        }
        rs.close();
        st.close();
    }
}

