/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.components;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.relationships.base.Relationship;
import org.aspcfs.modules.relationships.base.RelationshipList;

public class UpdateAccountEmployees
extends ObjectHookComponent
implements ComponentInterface {
    public String getDescription() {
        return "Update the parent account employee count.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        boolean result = false;
        Connection db = null;
        try {
            db = UpdateAccountEmployees.getConnection(context);
            HashMap combinedAccounts = OrganizationList.getParentAndLeafAccounts(db, 1, false);
            HashMap parentAccounts = (HashMap)combinedAccounts.get("parentNodes");
            HashMap leafAccounts = (HashMap)combinedAccounts.get("leafNodes");
            for (Integer account : parentAccounts.keySet()) {
                int totalEmployees = this.processTotalEmployees(db, leafAccounts, account, 1, false, new HashMap());
            }
            if (parentAccounts.size() > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
        }
        finally {
            UpdateAccountEmployees.freeConnection(context, db);
        }
        return result;
    }

    public int processTotalEmployees(Connection db, HashMap leafAccounts, int parentId, int typeId, boolean reciprocal, HashMap existingAccounts) throws SQLException {
        int parentEmployeeCount = -1;
        int actualEmployeeCount = Organization.countEmployees(db, parentId);
        RelationshipList thisList = new RelationshipList();
        thisList.setCategoryIdMapsFrom(42420034);
        thisList.setCategoryIdMapsTo(42420034);
        if (reciprocal) {
            thisList.setObjectIdMapsFrom(parentId);
        } else {
            thisList.setObjectIdMapsTo(parentId);
        }
        thisList.setTypeId(1);
        thisList.buildList(db);
        Iterator iter = thisList.keySet().iterator();
        if (iter.hasNext()) {
            parentEmployeeCount = 0;
        }
        while (iter.hasNext()) {
            String relType = (String)iter.next();
            ArrayList tmpList = (ArrayList)thisList.get(relType);
            for (Relationship rel : tmpList) {
                int childEmployeeCount = 0;
                if (existingAccounts.get(String.valueOf(rel.getObjectIdMapsFrom())) == null) {
                    childEmployeeCount = this.processTotalEmployees(db, leafAccounts, reciprocal ? rel.getObjectIdMapsTo() : rel.getObjectIdMapsFrom(), typeId, reciprocal, existingAccounts);
                }
                if (childEmployeeCount <= 0) continue;
                parentEmployeeCount += childEmployeeCount;
            }
        }
        if (actualEmployeeCount != parentEmployeeCount && leafAccounts.get(new Integer(parentId)) == null) {
            Organization.updateEmployeeCount(db, parentId, parentEmployeeCount);
            return parentEmployeeCount;
        }
        return actualEmployeeCount;
    }
}

