/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.webdav;

import com.zeroio.webdav.context.BaseWebdavContext;
import com.zeroio.webdav.context.ItemContext;
import com.zeroio.webdav.context.ModuleContext;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.naming.NamingException;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.contacts.base.Contact;

public class AccountsWebdavContext
extends BaseWebdavContext
implements ModuleContext {
    private static final String ACCOUNTS = "accounts";
    private int linkModuleId = 1;
    private String fileLibraryPath = null;
    private String permission = "accounts-view";
    private int userId = -1;

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public int getUserId() {
        return this.userId;
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public void setFileLibraryPath(String tmp) {
        this.fileLibraryPath = tmp;
    }

    public void setPermission(String tmp) {
        this.permission = tmp;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public String getFileLibraryPath() {
        return this.fileLibraryPath;
    }

    public String getPermission() {
        return this.permission;
    }

    public AccountsWebdavContext() {
    }

    public AccountsWebdavContext(String name, int linkModuleId) {
        this.contextName = name;
        this.linkModuleId = linkModuleId;
    }

    public void buildResources(SystemStatus thisSystem, Connection db, int userId, String fileLibraryPath) throws SQLException {
        this.fileLibraryPath = fileLibraryPath;
        this.userId = userId;
        this.bindings.clear();
        if (this.hasPermission(thisSystem, userId, "accounts-accounts-view")) {
            this.populateBindings(db);
        }
    }

    public void populateBindings(Connection db) throws SQLException {
        if (this.linkModuleId == -1) {
            throw new SQLException("Module ID not specified");
        }
        int siteId = this.getUserSiteId(db, this.userId);
        PreparedStatement pst = db.prepareStatement("SELECT org_id, name, namelast, namefirst, entered, modified FROM organization WHERE org_id > 0 " + (siteId != -1 ? "AND site_id = ? " : "") + "AND (status_id IS NULL OR status_id = 7) " + "AND enabled = ? " + "AND trashed_date IS NULL ");
        int i = 0;
        if (siteId != -1) {
            pst.setInt(++i, siteId);
        }
        pst.setBoolean(++i, true);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            ItemContext item = new ItemContext();
            if (rs.getString("namelast") != null && rs.getString("namefirst") != null) {
                item.setContextName(Contact.getNameFirstLast(rs.getString("namefirst"), rs.getString("namelast")));
            } else {
                item.setContextName(rs.getString("name"));
            }
            item.setLinkModuleId(this.linkModuleId);
            item.setLinkItemId(rs.getInt("org_id"));
            item.setPath(this.fileLibraryPath + ACCOUNTS + fs);
            item.setUserId(this.userId);
            item.setPermission("accounts-accounts-documents");
            this.bindings.put(item.getContextName(), item);
            Timestamp entered = rs.getTimestamp("entered");
            Timestamp modified = rs.getTimestamp("modified");
            this.buildProperties(item.getContextName(), entered, modified, new Integer(0));
        }
        rs.close();
        pst.close();
    }

    public boolean createSubcontext(SystemStatus thisSystem, Connection db, String folderName) throws SQLException, FileNotFoundException, NamingException {
        return false;
    }

    public boolean bind(SystemStatus thisSystem, Connection db, Object object) throws SQLException, NamingException {
        System.out.println("binding an object with Accounts context not allowed");
        throw new NamingException("Binding an object with Accounts context not allowed..");
    }

    public void unbind(SystemStatus thisSystem, Connection db, String contextName) throws SQLException, NamingException {
        System.out.println("Unbinding folder at accounts context not allowed....returning false");
        throw new NamingException("Unbinding at accounts context not allowed...");
    }
}

