/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.webservices;

import java.util.ArrayList;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationAddress;
import org.aspcfs.modules.accounts.base.OrganizationHistory;
import org.aspcfs.modules.accounts.base.OrganizationPhoneNumber;
import org.aspcfs.modules.accounts.webservices.beans.AccountFilters;
import org.aspcfs.modules.actionplans.base.ActionItemWorkNote;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkNote;
import org.aspcfs.modules.contacts.base.Call;
import org.aspcfs.modules.login.base.AuthenticationItem;
import org.aspcfs.modules.troubletickets.webservices.beans.WSTicketBean;
import org.aspcfs.utils.CRMConnection;

public class AccountServices {
    private CRMConnection crm = new CRMConnection();

    public void setAuthenticationInfo(AuthenticationItem auth) {
        this.crm.setUrl(auth.getUrl());
        this.crm.setId(auth.getId());
        this.crm.setSystemId(auth.getSystemId());
        this.crm.setClientId(auth.getClientId());
        this.crm.setUsername(auth.getUsername());
        this.crm.setCode(auth.getCode());
    }

    public Organization[] retrieveAccounts(AuthenticationItem in0, int in1) {
        AccountFilters filters = new AccountFilters();
        filters.setOwnerId(in1);
        return this.retrieveAccounts(in0, filters);
    }

    public Organization retrieveAccount(AuthenticationItem in0, AccountFilters in1) {
        Organization[] accounts = this.retrieveAccounts(in0, in1);
        if (accounts != null && accounts.length > 0) {
            return accounts[0];
        }
        return null;
    }

    public Organization[] retrieveAccounts(AuthenticationItem in0, AccountFilters in1) {
        try {
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("orgId");
            meta.add("name");
            meta.add("url");
            meta.add("notes");
            meta.add("industryName");
            meta.add("alertDate");
            meta.add("alertText");
            meta.add("revenue");
            meta.add("ticker");
            meta.add("accountNumber");
            meta.add("potential");
            meta.add("nameFirst");
            meta.add("nameMiddle");
            meta.add("nameLast");
            this.crm.setTransactionMeta(meta);
            DataRecord account = new DataRecord();
            account.setName("accountList");
            account.setAction("select");
            if (in1.getOrgId() != -1) {
                account.addField("orgId", in1.getOrgId());
            }
            if (in1.getOwnerId() != -1) {
                account.addField("ownerId", in1.getOwnerId());
            }
            if (in1.getAccountName() != null && !"".equals(in1.getAccountName().trim())) {
                account.addField("accountName", "%" + in1.getAccountName() + "%");
            }
            if (in1.getSince() != null) {
                account.addField("enteredSince", in1.getSince());
            }
            if (in1.getTo() != null) {
                account.addField("enteredTo", in1.getTo());
            }
            this.crm.save(account);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            Object[] objects = this.crm.getRecords("org.aspcfs.modules.accounts.base.Organization").toArray();
            Organization[] accounts = new Organization[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                accounts[i] = (Organization)((Object)objects[i]);
            }
            return accounts;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    public OrganizationAddress[] retrieveAccountAddresses(AuthenticationItem in0, int in1, String in2) {
        try {
            AccountFilters filters = new AccountFilters();
            filters.setOwnerId(in1);
            filters.setAccountName(in2);
            Organization account = this.retrieveAccount(in0, filters);
            if (account != null) {
                return this.retrieveAccountAddresses(in0, account.getOrgId());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return null;
    }

    public OrganizationPhoneNumber[] retrieveAccountPhoneNumbers(AuthenticationItem in0, int in1, String in2) {
        try {
            AccountFilters filters = new AccountFilters();
            filters.setOwnerId(in1);
            filters.setAccountName(in2);
            Organization account = this.retrieveAccount(in0, filters);
            if (account != null) {
                return this.retrieveAccountPhoneNumbers(in0, account.getOrgId());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return null;
    }

    public String[] getNotes(AuthenticationItem in0, int in1, String in2) {
        try {
            AccountFilters filters = new AccountFilters();
            filters.setOwnerId(in1);
            filters.setAccountName(in2);
            Organization account = this.retrieveAccount(in0, filters);
            if (account != null) {
                return this.getNotes(in0, account.getOrgId());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return null;
    }

    public Call[] getActivities(AuthenticationItem in0, int in1, String in2) {
        try {
            AccountFilters filters = new AccountFilters();
            filters.setOwnerId(in1);
            filters.setAccountName(in2);
            Organization account = this.retrieveAccount(in0, filters);
            if (account != null) {
                return this.getActivities(in0, account.getOrgId());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return null;
    }

    public WSTicketBean[] getTickets(AuthenticationItem in0, int in1, String in2) {
        try {
            AccountFilters filters = new AccountFilters();
            filters.setOwnerId(in1);
            filters.setAccountName(in2);
            Organization account = this.retrieveAccount(in0, filters);
            if (account != null) {
                return this.getTickets(in0, account.getOrgId());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return null;
    }

    public boolean addAccountPhoneNumber(AuthenticationItem in0, String in1, OrganizationPhoneNumber in2) {
        try {
            AccountFilters filters = new AccountFilters();
            filters.setAccountName(in1);
            Organization account = this.retrieveAccount(in0, filters);
            if (account != null) {
                in2.setOrgId(account.getOrgId());
                return this.addAccountPhoneNumber(in0, in2);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return false;
    }

    public boolean addAccountPhoneNumber(AuthenticationItem in0, OrganizationPhoneNumber in1) {
        try {
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("number");
            this.crm.setTransactionMeta(meta);
            if (in1.getNumber() != null && !"".equals(in1.getNumber().trim())) {
                DataRecord phoneData = new DataRecord();
                phoneData.setName("organizationPhoneNumber");
                phoneData.setAction("insert");
                phoneData.addField("orgId", in1.getOrgId());
                phoneData.addField("type", in1.getType());
                phoneData.addField("number", in1.getNumber());
                phoneData.addField("extension", in1.getExtension());
                phoneData.addField("enteredBy", in1.getEnteredBy());
                phoneData.addField("modifiedBy", in1.getModifiedBy());
                this.crm.save(phoneData);
            }
            this.crm.commit();
            if (System.getProperty("DEBUG") != null) {
                System.out.println("Response-> " + this.crm.getLastResponse());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return this.crm.getStatus() == 0;
    }

    private String[] getNotes(AuthenticationItem in0, int in1) {
        try {
            OrganizationHistory[] historyNotes = this.getHistoryNotes(in0, in1);
            ActionPlanWorkNote[] actionPlanNotes = this.getActionPlanNotes(in0, in1);
            ActionItemWorkNote[] actionItemNotes = this.getActionItemNotes(in0, in1);
            String[] notes = new String[historyNotes.length + actionPlanNotes.length + actionItemNotes.length];
            for (int i = 0; i < historyNotes.length; ++i) {
                notes[i] = historyNotes[i].getDescription();
            }
            for (int j = 0; j < actionPlanNotes.length; ++j) {
                notes[j + historyNotes.length] = actionPlanNotes[j].getDescription();
            }
            for (int k = 0; k < actionItemNotes.length; ++k) {
                notes[k + historyNotes.length + actionPlanNotes.length] = actionItemNotes[k].getDescription();
            }
            return notes;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    private OrganizationHistory[] getHistoryNotes(AuthenticationItem in0, int in1) {
        try {
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("description");
            this.crm.setTransactionMeta(meta);
            DataRecord notes = new DataRecord();
            notes.setName("accountHistoryList");
            notes.setAction("select");
            notes.addField("orgId", in1);
            notes.addField("notes", true);
            notes.addField("activities", true);
            notes.addField("documents", true);
            notes.addField("quotes", true);
            notes.addField("opportunities", true);
            notes.addField("serviceContracts", true);
            notes.addField("tickets", true);
            notes.addField("tasks", true);
            notes.addField("relationships", true);
            notes.addField("assets", true);
            this.crm.save(notes);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            Object[] objects = this.crm.getRecords("org.aspcfs.modules.accounts.base.OrganizationHistory").toArray();
            OrganizationHistory[] history = new OrganizationHistory[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                history[i] = (OrganizationHistory)((Object)objects[i]);
            }
            return history;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    private ActionPlanWorkNote[] getActionPlanNotes(AuthenticationItem in0, int in1) {
        try {
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("description");
            this.crm.setTransactionMeta(meta);
            DataRecord notes = new DataRecord();
            notes.setName("actionPlanWorkNoteList");
            notes.setAction("select");
            notes.addField("orgId", in1);
            this.crm.save(notes);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            Object[] objects = this.crm.getRecords("org.aspcfs.modules.actionplans.base.ActionPlanWorkNote").toArray();
            ActionPlanWorkNote[] planNotes = new ActionPlanWorkNote[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                planNotes[i] = (ActionPlanWorkNote)((Object)objects[i]);
            }
            return planNotes;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    private ActionItemWorkNote[] getActionItemNotes(AuthenticationItem in0, int in1) {
        try {
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("description");
            this.crm.setTransactionMeta(meta);
            DataRecord notes = new DataRecord();
            notes.setName("actionItemWorkNoteList");
            notes.setAction("select");
            notes.addField("orgId", in1);
            this.crm.save(notes);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            Object[] objects = this.crm.getRecords("org.aspcfs.modules.actionplans.base.ActionItemWorkNote").toArray();
            ActionItemWorkNote[] itemNotes = new ActionItemWorkNote[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                itemNotes[i] = (ActionItemWorkNote)((Object)objects[i]);
            }
            return itemNotes;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    private Call[] getActivities(AuthenticationItem in0, int in1) {
        try {
            Call[] pendingCalls = this.getPendingActivities(in0, in1);
            Call[] completedCalls = this.getCompletedActivities(in0, in1);
            Call[] calls = new Call[pendingCalls.length + completedCalls.length];
            for (int i = 0; i < pendingCalls.length; ++i) {
                calls[i] = pendingCalls[i];
            }
            for (int j = 0; j < completedCalls.length; ++j) {
                calls[j + pendingCalls.length] = completedCalls[j];
            }
            return calls;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    private Call[] getPendingActivities(AuthenticationItem in0, int in1) {
        return this.getActivities(in0, in1, 3);
    }

    private Call[] getCompletedActivities(AuthenticationItem in0, int in1) {
        return this.getActivities(in0, in1, 2);
    }

    private Call[] getActivities(AuthenticationItem in0, int in1, int in2) {
        try {
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("id");
            meta.add("orgId");
            meta.add("length");
            meta.add("subject");
            meta.add("notes");
            meta.add("callType");
            meta.add("alertDate");
            meta.add("followupNotes");
            meta.add("priorityString");
            this.crm.setTransactionMeta(meta);
            DataRecord calls = new DataRecord();
            calls.setName("callList");
            calls.setAction("select");
            calls.addField("orgId", in1);
            calls.addField("onlyPending", 2 != in2);
            calls.addField("onlyCompleted", 2 == in2);
            this.crm.save(calls);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            Object[] objects = this.crm.getRecords("org.aspcfs.modules.contacts.base.Call").toArray();
            Call[] callList = new Call[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                callList[i] = (Call)((Object)objects[i]);
            }
            return callList;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    private WSTicketBean[] getTickets(AuthenticationItem in0, int in1) {
        try {
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("id");
            meta.add("problem");
            meta.add("entered");
            meta.add("closed");
            meta.add("location");
            meta.add("cause");
            meta.add("estimatedResolutionDate");
            meta.add("resolutionDate");
            meta.add("companyName");
            meta.add("departmentName");
            meta.add("priorityName");
            meta.add("severityName");
            meta.add("categoryName");
            meta.add("sourceName");
            this.crm.setTransactionMeta(meta);
            DataRecord tickets = new DataRecord();
            tickets.setName("ticketList");
            tickets.setAction("select");
            tickets.addField("orgId", in1);
            this.crm.save(tickets);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            Object[] objects = this.crm.getRecords("org.aspcfs.modules.troubletickets.webservices.beans.WSTicketBean").toArray();
            WSTicketBean[] ticketList = new WSTicketBean[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                ticketList[i] = (WSTicketBean)((Object)objects[i]);
            }
            return ticketList;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    private OrganizationAddress[] retrieveAccountAddresses(AuthenticationItem in0, int in1) {
        try {
            int accountId = in1;
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("streetAddressLine1");
            meta.add("streetAddressLine2");
            meta.add("streetAddressLine3");
            meta.add("streetAddressLine4");
            meta.add("city");
            meta.add("state");
            meta.add("zip");
            meta.add("country");
            meta.add("typeName");
            meta.add("primaryAddress");
            this.crm.setTransactionMeta(meta);
            DataRecord account = new DataRecord();
            account.setName("organizationAddressList");
            account.setAction("select");
            account.addField("orgId", accountId);
            this.crm.save(account);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            Object[] objects = this.crm.getRecords("org.aspcfs.modules.accounts.base.OrganizationAddress").toArray();
            OrganizationAddress[] addresses = new OrganizationAddress[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                addresses[i] = (OrganizationAddress)objects[i];
            }
            return addresses;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    private OrganizationPhoneNumber[] retrieveAccountPhoneNumbers(AuthenticationItem in0, int in1) {
        try {
            int accountId = in1;
            this.setAuthenticationInfo(in0);
            this.crm.setAutoCommit(false);
            ArrayList<String> meta = new ArrayList<String>();
            meta.add("orgId");
            meta.add("number");
            meta.add("extension");
            meta.add("typeName");
            meta.add("primaryNumber");
            this.crm.setTransactionMeta(meta);
            DataRecord account = new DataRecord();
            account.setName("organizationPhoneNumberList");
            account.setAction("select");
            account.addField("orgId", accountId);
            this.crm.save(account);
            boolean result = this.crm.commit();
            System.out.println("RESPONSE: " + this.crm.getLastResponse());
            Object[] objects = this.crm.getRecords("org.aspcfs.modules.accounts.base.OrganizationPhoneNumber").toArray();
            OrganizationPhoneNumber[] phoneNumbers = new OrganizationPhoneNumber[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                phoneNumbers[i] = (OrganizationPhoneNumber)objects[i];
            }
            return phoneNumbers;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }
}

