/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionlist.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.webutils.FileDownload;
import java.net.SocketException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actionlist.base.ActionContact;
import org.aspcfs.modules.actionlist.base.ActionContactsList;
import org.aspcfs.modules.actionlist.base.ActionItemLog;
import org.aspcfs.modules.actionlist.base.ActionItemLogList;
import org.aspcfs.modules.actionlist.base.ActionList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.communications.base.ActiveSurvey;
import org.aspcfs.modules.communications.base.InstantCampaign;
import org.aspcfs.modules.communications.base.Message;
import org.aspcfs.modules.communications.base.SearchCriteriaList;
import org.aspcfs.modules.communications.base.SearchFieldList;
import org.aspcfs.modules.communications.base.SearchOperatorList;
import org.aspcfs.modules.communications.base.Survey;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.contacts.base.ContactTypeList;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class MyActionContacts
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-view")) {
            return "PermissionError";
        }
        return this.executeCommandList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String actionId = context.getRequest().getParameter("actionId");
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = String.valueOf(this.getUserId(context));
        }
        this.addModuleBean(context, "My Action Lists", "Action Contacts");
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("ContactActionListInfo");
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        PagedListInfo contactActionListInfo = this.getPagedListInfo(context, "ContactActionListInfo");
        contactActionListInfo.setLink("MyActionContacts.do?command=List&actionId=" + actionId);
        Connection db = null;
        try {
            db = this.getConnection(context);
            LookupList siteIdList = new LookupList(db, "lookup_site_id");
            siteIdList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteIdList);
            ActionContactsList thisList = new ActionContactsList();
            thisList.setPagedListInfo(contactActionListInfo);
            thisList.setActionId(Integer.parseInt(actionId));
            thisList.setBuildHistory(true);
            if (!"all".equals(contactActionListInfo.getListView())) {
                if ("complete".equals(contactActionListInfo.getListView())) {
                    thisList.setCompleteOnly(true);
                } else {
                    thisList.setInProgressOnly(true);
                }
            }
            thisList.buildList(db);
            context.getRequest().setAttribute("ActionContacts", (Object)thisList);
            ActionList actionList = new ActionList(db, Integer.parseInt(actionId));
            context.getRequest().setAttribute("ActionList", (Object)actionList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "ListOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrepare(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-add")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String actionId = context.getRequest().getParameter("actionId");
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = String.valueOf(this.getUserId(context));
        }
        ActionList actionList = null;
        this.addModuleBean(context, "My Action Lists", "Action Contacts");
        Connection db = null;
        SystemStatus thisSystem = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            SearchFieldList searchFieldList = new SearchFieldList();
            SearchOperatorList stringOperatorList = new SearchOperatorList();
            SearchOperatorList dateOperatorList = new SearchOperatorList();
            SearchOperatorList numberOperatorList = new SearchOperatorList();
            HtmlSelect contactSource = new HtmlSelect();
            contactSource.addItem(1, "My General Contacts");
            contactSource.addItem(2, "All General Contacts");
            contactSource.addItem(3, "All Account Contacts");
            context.getRequest().setAttribute("ContactSource", (Object)contactSource);
            ContactTypeList typeList = new ContactTypeList(db);
            LookupList ctl = typeList.getLookupList(this.getSystemStatus(context), "typeId", 0);
            ctl.setJsEvent("onChange = \"javascript:setText(document.searchForm.typeId)\"");
            context.getRequest().setAttribute("ContactTypeList", (Object)ctl);
            LookupList accountTypeList = new LookupList(db, "lookup_account_types");
            accountTypeList.setSelectSize(1);
            context.getRequest().setAttribute("AccountTypeList", (Object)accountTypeList);
            searchFieldList.buildFieldList(db);
            context.getRequest().setAttribute("SearchFieldList", (Object)searchFieldList);
            stringOperatorList.buildOperatorList(db, 0);
            context.getRequest().setAttribute("StringOperatorList", (Object)stringOperatorList);
            dateOperatorList.buildOperatorList(db, 1);
            context.getRequest().setAttribute("DateOperatorList", (Object)dateOperatorList);
            numberOperatorList.buildOperatorList(db, 2);
            context.getRequest().setAttribute("NumberOperatorList", (Object)numberOperatorList);
            LookupList siteValueList = new LookupList(db, "lookup_site_id");
            siteValueList.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteValueList);
            LookupList siteCriteriaList = new LookupList(db, "lookup_site_id");
            siteCriteriaList.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteCriteriaList", (Object)siteCriteriaList);
            if (actionId != null && !"-1".equals("actionId")) {
                actionList = new ActionList(db, Integer.parseInt(actionId));
                context.getRequest().setAttribute("ActionList", (Object)actionList);
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (context.getRequest().getParameter("actionSource") != null) {
                return "PrepareContactsOK";
            }
            return "PrepareOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-edit")) {
            return "PermissionError";
        }
        SearchCriteriaList thisSCL = null;
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        boolean isValid = false;
        HashMap<String, String> errors = new HashMap<String, String>();
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = String.valueOf(this.getUserId(context));
        }
        String criteria = context.getRequest().getParameter("searchCriteriaText");
        String actionId = context.getRequest().getParameter("actionId");
        this.addModuleBean(context, "My Action Lists", "Action Contacts");
        Connection db = null;
        if (criteria == null || "".equals(criteria)) {
            return "InsertOK";
        }
        try {
            if (criteria != null && !"".equals(criteria)) {
                thisSCL = new SearchCriteriaList(criteria);
                thisSCL.setGroupName("Action List");
                thisSCL.setEnteredBy(this.getUserId(context));
                thisSCL.setModifiedBy(this.getUserId(context));
                thisSCL.setOwner(this.getUserId(context));
                db = this.getConnection(context);
                thisSCL.buildRelatedResources(db);
                ContactList contacts = new ContactList();
                contacts.setScl(thisSCL, this.getUserId(context), this.getUserRange(context));
                contacts.setBuildDetails(true);
                contacts.setBuildTypes(false);
                contacts.setIncludeAllSites(true);
                AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 626030330);
                contacts.setGeneralContactAccessTypes(accessTypeList);
                contacts.buildList(db);
                ActionContactsList thisList = new ActionContactsList();
                thisList.setActionId(Integer.parseInt(actionId));
                thisList.setEnteredBy(this.getUserId(context));
                thisList.insert(db, contacts);
                context.getRequest().setAttribute("ActionContacts", (Object)thisList);
                isValid = true;
            } else {
                SystemStatus systemStatus = this.getSystemStatus(context);
                errors.put("criteriaError", systemStatus.getLabel("object.validation.criteriaNotDefined"));
                this.processErrors(context, errors);
            }
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (!isValid) {
            return this.executeCommandPrepare(context);
        }
        return "InsertOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "My Action Lists", "");
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = String.valueOf(this.getUserId(context));
        }
        String selectedContacts = context.getRequest().getParameter("selectedContacts");
        HashMap<String, String> errors = new HashMap<String, String>();
        if (selectedContacts == null || "".equals(selectedContacts.trim())) {
            SystemStatus systemStatus = this.getSystemStatus(context);
            errors.put("oneContactRequired", systemStatus.getLabel("object.validation.oneContactRequired"));
        }
        if (!errors.isEmpty()) {
            this.processErrors(context, errors);
            return this.executeCommandModify(context);
        }
        String actionId = context.getRequest().getParameter("actionId");
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            ActionContactsList thisList = new ActionContactsList();
            thisList.setActionId(Integer.parseInt(actionId));
            thisList.setEnteredBy(this.getUserId(context));
            thisList.update(db, selectedContacts);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return this.executeCommandList(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "My Action Lists", "");
        String actionId = context.getRequest().getParameter("actionId");
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = String.valueOf(this.getUserId(context));
        }
        boolean buildContacts = true;
        if ("false".equals(context.getRequest().getParameter("doBuild"))) {
            buildContacts = false;
        }
        HashMap<Integer, String> selectedList = null;
        Exception errorMessage = null;
        Connection db = null;
        try {
            if (buildContacts) {
                db = this.getConnection(context);
                selectedList = new HashMap<Integer, String>();
                ActionContactsList thisList = new ActionContactsList();
                thisList.setActionId(Integer.parseInt(actionId));
                thisList.buildList(db);
                for (ActionContact thisContact : thisList) {
                    selectedList.put(new Integer(thisContact.getLinkItemId()), "");
                }
                context.getSession().setAttribute("selectedContacts", selectedList);
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (buildContacts) {
                return "ModifyOK";
            }
            return "ModifyNoBuildOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    public String executeCommandAdd(ActionContext context) {
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = String.valueOf(this.getUserId(context));
        }
        if (!this.hasPermission(context, "myhomepage-action-lists-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "My Action Lists", "");
        return "PrepareOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewHistory(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-view")) {
            return "PermissionError";
        }
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = String.valueOf(this.getUserId(context));
        }
        this.addModuleBean(context, "My Action Lists", "");
        String itemId = context.getRequest().getParameter("itemId");
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            ActionItemLogList thisList = new ActionItemLogList();
            thisList.setItemId(Integer.parseInt(itemId));
            thisList.setBuildDetails(true);
            thisList.buildList(db);
            context.getRequest().setAttribute("History", (Object)thisList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "ViewHistoryOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    public String executeCommandProcessImage(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-edit")) {
            return "PermissionError";
        }
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = String.valueOf(this.getUserId(context));
        }
        boolean isValid = false;
        Connection db = null;
        int count = 0;
        String id = context.getRequest().getParameter("id");
        try {
            StringTokenizer st = new StringTokenizer(id, "|");
            String fileName = st.nextToken();
            String imageType = st.nextToken();
            int contactId = Integer.parseInt(st.nextToken());
            int status = Integer.parseInt(st.nextToken());
            db = this.getConnection(context);
            ActionContact thisContact = new ActionContact(db, contactId);
            isValid = this.validateObject(context, db, (Object)thisContact);
            if (isValid) {
                if (status == ActionContact.DONE) {
                    thisContact.updateStatus(db, true);
                } else {
                    thisContact.updateStatus(db, false);
                }
                this.freeConnection(context, db);
                if (count != -1) {
                    String filePath = context.getServletContext().getRealPath("/") + "images" + fs + fileName;
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setFullPath(filePath);
                    fileDownload.setDisplayName(fileName);
                    if (fileDownload.fileExists()) {
                        fileDownload.sendFile(context, "image/" + imageType);
                    } else {
                        System.err.println("Image-> Trying to send a file that does not exist");
                    }
                } else {
                    this.processErrors(context, thisContact.getErrors());
                }
            }
        }
        catch (SocketException se) {
            System.out.println("MyActionContacts -> ProcessImage : Download canceled or connection lost");
        }
        catch (Exception e) {
            this.freeConnection(context, db);
            System.out.println(e.toString());
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrepareMessage(ActionContext context) {
        if (!(this.hasPermission(context, "myhomepage-action-lists-edit") || this.hasPermission(context, "accounts-accounts-contact-updater-view") || this.hasPermission(context, "contacts-external-contact-updater-view"))) {
            return "PermissionError";
        }
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = String.valueOf(this.getUserId(context));
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        String msgId = context.getRequest().getParameter("messageId");
        String contactId = context.getRequest().getParameter("contactId");
        String bcc = context.getRequest().getParameter("bcc");
        String cc = context.getRequest().getParameter("cc");
        Message thisMessage = null;
        Exception errorMessage = null;
        Connection db = null;
        try {
            String orgId;
            String messageType;
            db = this.getConnection(context);
            Contact recipient = new Contact(db, Integer.parseInt(contactId));
            if (msgId != null && !"0".equals(msgId)) {
                thisMessage = new Message(db, Integer.parseInt(msgId));
                context.getRequest().setAttribute("Message", (Object)thisMessage);
            }
            if ("".equals(recipient.getPrimaryEmailAddress())) {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.contactNoEmail"));
            }
            if ((messageType = (String)context.getRequest().getAttribute("messageType")) == null || "".equals(messageType)) {
                messageType = context.getRequest().getParameter("messageType");
            }
            if (messageType != null && !"".equals(messageType)) {
                context.getRequest().setAttribute("messageType", (Object)messageType);
            }
            if ((orgId = context.getRequest().getParameter("orgId")) != null) {
                context.getRequest().setAttribute("orgId", (Object)orgId);
            }
            if (bcc != null && !"".equals(bcc)) {
                context.getRequest().setAttribute("bcc", (Object)bcc);
            }
            if (cc != null && !"".equals(cc)) {
                context.getRequest().setAttribute("cc", (Object)cc);
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return MyActionContacts.getReturn(context, "PrepareMessage");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSendMessage(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-edit")) {
            return "PermissionError";
        }
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = String.valueOf(this.getUserId(context));
        }
        String msgId = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        String actionId = context.getRequest().getParameter("actionId");
        String actionListId = context.getRequest().getParameter("actionListId");
        String bcc = context.getRequest().getParameter("bcc");
        String cc = context.getRequest().getParameter("cc");
        boolean messageSent = false;
        boolean activated = false;
        Message thisMessage = (Message)((Object)context.getFormBean());
        Connection db = null;
        Contact recipient = null;
        boolean isValid = true;
        InstantCampaign actionCampaign = new InstantCampaign();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            recipient = new Contact(db, contactId);
            ActionList actionList = new ActionList(db, Integer.parseInt(actionListId));
            if ("".equals(recipient.getPrimaryEmailAddress())) {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.contactNoEmail"));
                isValid = false;
            }
            if (isValid) {
                thisMessage.setDisableNameValidation(true);
                isValid = this.validateObject(context, db, (Object)thisMessage);
                if (isValid) {
                    if (msgId != null && !"".equals(msgId)) {
                        thisMessage.setModifiedBy(this.getUserId(context));
                        thisMessage.update(db);
                    } else {
                        LookupList list = systemStatus.getLookupList(db, "lookup_access_types");
                        thisMessage.setAccessType(list.getIdFromValue("Public"));
                        thisMessage.setModifiedBy(this.getUserId(context));
                        thisMessage.setEnteredBy(this.getUserId(context));
                    }
                }
                actionCampaign.setName(actionList.getDescription());
                actionCampaign.setEnteredBy(this.getUserId(context));
                actionCampaign.setModifiedBy(this.getUserId(context));
                actionCampaign.addRecipient(db, Integer.parseInt(contactId));
                actionCampaign.setActiveDateTimeZone(this.getUser(context, this.getUserId(context)).getTimeZone());
                actionCampaign.setMessage(thisMessage);
                if (bcc != null && !"".equals(bcc)) {
                    actionCampaign.setBcc(bcc);
                    context.getRequest().setAttribute("bcc", (Object)bcc);
                }
                if (cc != null && !"".equals(cc)) {
                    actionCampaign.setCc(cc);
                    context.getRequest().setAttribute("cc", (Object)cc);
                }
                boolean bl = isValid = this.validateObject(context, db, (Object)actionCampaign) && isValid;
                if (isValid) {
                    activated = actionCampaign.activate(db);
                }
                if (activated) {
                    ActionItemLog thisLog = new ActionItemLog();
                    thisLog.setEnteredBy(this.getUserId(context));
                    thisLog.setModifiedBy(this.getUserId(context));
                    thisLog.setItemId(Integer.parseInt(actionId));
                    thisLog.setLinkItemId(actionCampaign.getId());
                    thisLog.setType(51320031);
                    thisLog.insert(db);
                    messageSent = true;
                    actionCampaign.setContactList(actionCampaign.getRecipients());
                    this.processInsertHook(context, (Object)actionCampaign);
                    context.getRequest().setAttribute("Recipient", (Object)new Contact(db, Integer.parseInt(contactId)));
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (messageSent) {
            return MyActionContacts.getReturn(context, "SendMessage");
        }
        return this.executeCommandPrepareMessage(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSendAddressRequest(ActionContext context) {
        String messageType;
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = String.valueOf(this.getUserId(context));
        }
        if ((messageType = context.getRequest().getParameter("messageType")) != null && !"".equals(messageType)) {
            context.getRequest().setAttribute("messageType", (Object)messageType);
        }
        String msgId = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        boolean messageSent = false;
        boolean activated = false;
        String bcc = context.getRequest().getParameter("bcc");
        String cc = context.getRequest().getParameter("cc");
        Message thisMessage = (Message)((Object)context.getFormBean());
        Connection db = null;
        boolean isValid = false;
        InstantCampaign actionCampaign = new InstantCampaign();
        SystemStatus systemStatus = this.getSystemStatus(context);
        Contact contact = null;
        try {
            db = this.getConnection(context);
            contact = new Contact(db, Integer.parseInt(contactId));
            if (contact.getOrgId() != -1 && !this.hasPermission(context, "accounts-accounts-contact-updater-view")) {
                String string = "PermissionError";
                return string;
            }
            if (contact.getOrgId() == -1 && !this.hasPermission(context, "contacts-external-contact-updater-view")) {
                String string = "PermissionError";
                return string;
            }
            thisMessage.setDisableNameValidation(true);
            isValid = this.validateObject(context, db, (Object)thisMessage);
            if (isValid) {
                if (msgId != null && !"".equals(msgId)) {
                    thisMessage.setModifiedBy(this.getUserId(context));
                    thisMessage.update(db);
                } else {
                    LookupList list = systemStatus.getLookupList(db, "lookup_access_types");
                    thisMessage.setAccessType(list.getIdFromValue("Public"));
                    thisMessage.setModifiedBy(this.getUserId(context));
                    thisMessage.setEnteredBy(this.getUserId(context));
                }
            }
            actionCampaign.setName("Contact Information Update Request");
            actionCampaign.setEnteredBy(this.getUserId(context));
            actionCampaign.setModifiedBy(this.getUserId(context));
            actionCampaign.addRecipient(db, Integer.parseInt(contactId));
            actionCampaign.setMessage(thisMessage);
            if (bcc != null && !"".equals(bcc)) {
                actionCampaign.setBcc(bcc);
                context.getRequest().setAttribute("bcc", (Object)bcc);
            }
            if (cc != null && !"".equals(cc)) {
                actionCampaign.setCc(cc);
                context.getRequest().setAttribute("cc", (Object)cc);
            }
            boolean bl = isValid = this.validateObject(context, db, (Object)actionCampaign) && isValid;
            if (isValid) {
                activated = actionCampaign.activate(db);
            }
            if (activated) {
                int addressSurveyId = Survey.getAddressSurveyId(db);
                actionCampaign.setSurveyId(addressSurveyId);
                actionCampaign.setModifiedBy(this.getUserId(context));
                actionCampaign.setHasAddressRequest(true);
                actionCampaign.updateAddressRequest(db);
                Survey thisSurvey = new Survey(db, Survey.getAddressSurveyId(db));
                ActiveSurvey activeSurvey = new ActiveSurvey(thisSurvey);
                activeSurvey.setEnteredBy(this.getUserId(context));
                activeSurvey.setModifiedBy(this.getUserId(context));
                activeSurvey.setCampaignId(actionCampaign.getId());
                activeSurvey.insert(db);
                addressSurveyId = activeSurvey.getId();
                String serverName = RequestUtils.getServerUrl(context.getRequest());
                thisMessage.setMessageText(thisMessage.getMessageText() + "<br />" + "${server_name=" + serverName + "}" + "<br />" + "${contact_address=" + addressSurveyId + "}" + "<br />" + "${survey_url_address=" + addressSurveyId + "}");
                actionCampaign.updateInstantCampaignMessage(db, thisMessage);
                ContactList tempList = new ContactList();
                tempList.add(contact);
                actionCampaign.setContactList(tempList);
                this.processInsertHook(context, (Object)actionCampaign);
                messageSent = true;
                context.getRequest().setAttribute("Recipient", (Object)new Contact(db, Integer.parseInt(contactId)));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (messageSent) {
            return MyActionContacts.getReturn(context, "SendMessage");
        }
        return this.executeCommandPrepareMessage(context);
    }
}

