/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionlist.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actionlist.base.ActionContactsList;
import org.aspcfs.modules.actionlist.base.ActionList;
import org.aspcfs.modules.actionlist.base.ActionLists;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.SearchCriteriaList;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.PagedListInfo;

public final class MyActionLists
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-view")) {
            return "PermissionError";
        }
        return this.executeCommandList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        this.addModuleBean(context, "My Action Lists", "Action Lists");
        String linkModuleId = context.getRequest().getParameter("linkModuleId");
        String userId = context.getRequest().getParameter("viewUserId");
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (userId != null && !"".equals(userId)) {
            if (!this.hasAuthority(context, Integer.parseInt(userId))) {
                return "PermissionError";
            }
            if (!userId.equals("" + this.getUserId(context))) {
                context.getSession().setAttribute("viewUserId", (Object)userId);
                viewUserId = userId;
            } else {
                context.getSession().removeAttribute("viewUserId");
                viewUserId = "" + this.getUserId(context);
            }
        } else if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = "" + this.getUserId(context);
        }
        PagedListInfo actionListInfo = this.getPagedListInfo(context, "ActionListInfo");
        actionListInfo.setLink("MyActionLists.do?command=List&linkModuleId=" + linkModuleId + "&viewUserId=" + viewUserId);
        Connection db = null;
        try {
            db = this.getConnection(context);
            ActionLists thisList = new ActionLists();
            thisList.setPagedListInfo(actionListInfo);
            thisList.setLinkModuleId(Integer.parseInt(linkModuleId));
            thisList.setBuildDetails(true);
            thisList.setOwner(Integer.parseInt(viewUserId));
            if (!"all".equals(actionListInfo.getListView())) {
                if ("complete".equals(actionListInfo.getListView())) {
                    thisList.setCompleteOnly(true);
                } else {
                    thisList.setInProgressOnly(true);
                }
            }
            thisList.buildList(db);
            context.getRequest().setAttribute("ActionLists", (Object)thisList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "ListOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        this.addModuleBean(context, "My Action Lists", "");
        String actionId = context.getRequest().getParameter("id");
        Connection db = null;
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = "" + this.getUserId(context);
        }
        ActionList thisList = (ActionList)((Object)context.getFormBean());
        try {
            db = this.getConnection(context);
            thisList.queryRecord(db, Integer.parseInt(actionId));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "DetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-add")) {
            return "PermissionError";
        }
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = "" + this.getUserId(context);
        }
        context.getRequest().setAttribute("changeSite", (Object)"true");
        this.addModuleBean(context, "My Action Lists", "Add an Action List");
        return "PrepareAddOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        this.addModuleBean(context, "My Action Lists", "");
        String actionId = context.getRequest().getParameter("id");
        Connection db = null;
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = "" + this.getUserId(context);
        }
        ActionList thisList = (ActionList)((Object)context.getFormBean());
        try {
            db = this.getConnection(context);
            thisList.queryRecord(db, Integer.parseInt(actionId));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "PrepareModifyOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-add")) {
            return "PermissionError";
        }
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = "" + this.getUserId(context);
        }
        boolean recordInserted = false;
        int resultCount = 0;
        boolean isValid = false;
        HashMap<String, String> errors = new HashMap<String, String>();
        this.addModuleBean(context, "My Action Lists", "");
        ActionList thisList = (ActionList)((Object)context.getFormBean());
        thisList.setModifiedBy(this.getUserId(context));
        String action = thisList.getId() > 0 ? "modify" : "insert";
        String criteria = context.getRequest().getParameter("searchCriteriaText");
        Connection db = null;
        try {
            db = this.getConnection(context);
            if ("insert".equals(action)) {
                if (criteria != null && !"".equals(criteria)) {
                    thisList.setEnteredBy(this.getUserId(context));
                    isValid = this.validateObject(context, db, (Object)thisList);
                    if (isValid) {
                        recordInserted = thisList.insert(db);
                    }
                    if (recordInserted) {
                        SearchCriteriaList thisSCL = null;
                        thisSCL = new SearchCriteriaList(criteria);
                        thisSCL.setGroupName("Action List");
                        thisSCL.setEnteredBy(this.getUserId(context));
                        thisSCL.setModifiedBy(this.getUserId(context));
                        thisSCL.setOwner(this.getUserId(context));
                        thisSCL.buildRelatedResources(db);
                        ContactList contacts = new ContactList();
                        contacts.setScl(thisSCL, this.getUserId(context), this.getUserRange(context));
                        contacts.setBuildDetails(true);
                        contacts.setBuildTypes(false);
                        AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 626030330);
                        contacts.setGeneralContactAccessTypes(accessTypeList);
                        contacts.buildList(db);
                        ActionContactsList contactsList = new ActionContactsList();
                        contactsList.setActionId(thisList.getId());
                        contactsList.setEnteredBy(this.getUserId(context));
                        contactsList.insert(db, contacts);
                    }
                } else {
                    SystemStatus systemStatus = this.getSystemStatus(context);
                    errors.put("criteriaError", systemStatus.getLabel("object.validation.criteriaNotDefined"));
                    this.processErrors(context, errors);
                }
            } else {
                isValid = this.validateObject(context, db, (Object)thisList);
                if (isValid) {
                    resultCount = thisList.update(db);
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "InsertOK";
        }
        if (resultCount == 1) {
            return this.executeCommandList(context);
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-delete")) {
            return "PermissionError";
        }
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = "" + this.getUserId(context);
        }
        Connection db = null;
        this.addModuleBean(context, "My Action Lists", "");
        String actionId = context.getRequest().getParameter("id");
        String linkModuleId = context.getRequest().getParameter("linkModuleId");
        HtmlDialog htmlDialog = new HtmlDialog();
        ActionList thisList = (ActionList)((Object)context.getFormBean());
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisList.queryRecord(db, Integer.parseInt(actionId));
            DependencyList dependencies = thisList.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            if (dependencies.size() == 0) {
                htmlDialog.setShowAndConfirm(false);
                htmlDialog.setDeleteUrl("javascript:window.location.href='MyActionLists.do?command=Delete&id=" + actionId + "&linkModuleId=" + linkModuleId + "'");
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
                htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='MyActionLists.do?command=Delete&id=" + actionId + "&linkModuleId=" + linkModuleId + "'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-lists-delete")) {
            return "PermissionError";
        }
        String viewUserId = (String)context.getSession().getAttribute("viewUserId");
        if (viewUserId == null || "".equals(viewUserId)) {
            viewUserId = "" + this.getUserId(context);
        }
        Exception errorMessage = null;
        this.addModuleBean(context, "My Action Lists", "");
        String actionId = context.getRequest().getParameter("id");
        String linkModuleId = context.getRequest().getParameter("linkModuleId");
        Connection db = null;
        ActionList thisList = (ActionList)((Object)context.getFormBean());
        try {
            db = this.getConnection(context);
            thisList.queryRecord(db, Integer.parseInt(actionId));
            thisList.delete(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getRequest().setAttribute("refreshUrl", (Object)("MyActionLists.do?command=List&linkModuleId=" + linkModuleId));
            return "DeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    public String executeCommandGetSiteForUser(ActionContext context) {
        String userId = context.getRequest().getParameter("userId");
        String item = context.getRequest().getParameter("item");
        try {
            User user = this.getUser(context, Integer.parseInt(userId));
            context.getRequest().setAttribute("siteId", (Object)String.valueOf(user.getSiteId()));
            context.getRequest().setAttribute("item", (Object)item);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        return "GetSiteForUserOK";
    }
}

