/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionlist.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.aspcfs.modules.actionlist.base.ActionContact;
import org.aspcfs.modules.actionlist.base.ActionItem;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.utils.web.PagedListInfo;

public class ActionContactsList
extends ArrayList {
    private boolean buildHistory = false;
    private int actionId = -1;
    private int enteredBy = -1;
    private PagedListInfo pagedListInfo = null;
    private boolean completeOnly = false;
    private boolean inProgressOnly = false;
    private int displayOnlyDisabledContacts = -1;

    public void setBuildHistory(boolean buildHistory) {
        this.buildHistory = buildHistory;
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public void setEnteredBy(int enteredBy) {
        this.enteredBy = enteredBy;
    }

    public void setCompleteOnly(boolean completeOnly) {
        this.completeOnly = completeOnly;
    }

    public void setInProgressOnly(boolean inProgressOnly) {
        this.inProgressOnly = inProgressOnly;
    }

    public boolean getCompleteOnly() {
        return this.completeOnly;
    }

    public boolean getInProgressOnly() {
        return this.inProgressOnly;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getActionId() {
        return this.actionId;
    }

    public boolean getBuildHistory() {
        return this.buildHistory;
    }

    public int getDisplayOnlyDisabledContacts() {
        return this.displayOnlyDisabledContacts;
    }

    public void setDisplayOnlyDisabledContacts(int tmp) {
        this.displayOnlyDisabledContacts = tmp;
    }

    public void setDisplayOnlyDisabledContacts(String tmp) {
        this.displayOnlyDisabledContacts = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM action_item ai WHERE ai.item_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("ai.entered", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY ai.entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("ai.item_id, ai.action_id, ai.link_item_id, ai.completedate, ai.enteredby, ai.entered, ai.modifiedby, ai.modified, ai.enabled FROM action_item ai WHERE ai.item_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ActionContact thisContact = new ActionContact(rs);
            this.add(thisContact);
        }
        rs.close();
        pst.close();
        for (ActionContact thisContact : this) {
            thisContact.buildContact(db, thisContact.getLinkItemId());
            thisContact.buildMostRecentHistoryItem(db);
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.actionId != -1) {
            sqlFilter.append("AND ai.action_id  = ? ");
        }
        if (this.completeOnly) {
            sqlFilter.append("AND (ai.completedate IS NOT NULL) ");
        } else if (this.inProgressOnly) {
            sqlFilter.append("AND (ai.completedate IS NULL) ");
        }
        if (this.getDisplayOnlyDisabledContacts() == -1) {
            sqlFilter.append("AND ai.link_item_id NOT IN (SELECT contact_id FROM contact where enabled = ? OR trashed_date IS NOT NULL) ");
        } else if (this.getDisplayOnlyDisabledContacts() == 1) {
            sqlFilter.append("AND ai.link_item_id IN (SELECT contact_id FROM contact where enabled = ? OR trashed_date IS NOT NULL) ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.actionId != -1) {
            pst.setInt(++i, this.actionId);
        }
        if (this.getDisplayOnlyDisabledContacts() == -1) {
            pst.setBoolean(++i, false);
        } else if (this.getDisplayOnlyDisabledContacts() == 1) {
            pst.setBoolean(++i, false);
        }
        return i;
    }

    public void insert(Connection db, ContactList contactList) throws SQLException {
        for (Contact thisContact : contactList) {
            ActionItem actionContact = new ActionItem();
            actionContact.setEnteredBy(this.getEnteredBy());
            actionContact.setModifiedBy(this.getEnteredBy());
            actionContact.setActionId(this.getActionId());
            actionContact.setLinkItemId(thisContact.getId());
            if (!this.isContactOnList(db, thisContact.getId())) {
                actionContact.insert(db);
            }
            this.add(actionContact);
        }
    }

    public void update(Connection db, String contacts) throws SQLException {
        int i = 0;
        PreparedStatement pst = db.prepareStatement("DELETE FROM action_item_log WHERE item_id IN (SELECT item_id from action_item ai where ai.action_id = ? AND ai.link_item_id NOT IN (" + contacts + ") ) ");
        pst.setInt(++i, this.getActionId());
        pst.execute();
        pst.close();
        i = 0;
        pst = db.prepareStatement("DELETE FROM action_item WHERE action_id = ? AND link_item_id NOT IN (" + contacts + ") ");
        pst.setInt(++i, this.getActionId());
        pst.execute();
        pst.close();
        StringTokenizer tokens = new StringTokenizer(contacts, ",");
        while (tokens.hasMoreTokens()) {
            String contactId = tokens.nextToken();
            ActionItem actionContact = new ActionItem();
            if (this.isContactOnList(db, Integer.parseInt(contactId))) continue;
            actionContact.setEnteredBy(this.getEnteredBy());
            actionContact.setModifiedBy(this.getEnteredBy());
            actionContact.setActionId(this.getActionId());
            actionContact.setLinkItemId(Integer.parseInt(contactId));
            actionContact.insert(db);
        }
    }

    public boolean isContactOnList(Connection db, int contactId) throws SQLException {
        boolean onList = false;
        PreparedStatement pst = db.prepareStatement("SELECT item_id FROM action_item WHERE action_id = ? AND link_item_id = ? ");
        pst.setInt(1, this.getActionId());
        pst.setInt(2, contactId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            onList = true;
        }
        rs.close();
        pst.close();
        return onList;
    }
}

