/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionlist.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.utils.DatabaseUtils;

public class ActionItem
extends GenericBean {
    public static int DONE = 1;
    private int id = -1;
    private int actionId = -1;
    private int linkItemId = -1;
    private Timestamp completeDate = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private Timestamp entered = null;
    private boolean enabled = true;
    private boolean complete = false;

    public void setActionId(String tmp) {
        this.actionId = Integer.parseInt(tmp);
    }

    public void setLinkItemId(String tmp) {
        this.linkItemId = Integer.parseInt(tmp);
    }

    public void setCompleteDate(String tmp) {
        this.completeDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public ActionItem() {
    }

    public ActionItem(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public ActionItem(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public void setLinkItemId(int linkItemId) {
        this.linkItemId = linkItemId;
    }

    public void setEnteredBy(int enteredBy) {
        this.enteredBy = enteredBy;
    }

    public void setModifiedBy(int modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setModified(Timestamp modified) {
        this.modified = modified;
    }

    public void setEntered(Timestamp entered) {
        this.entered = entered;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void setComplete(String complete) {
        this.complete = DatabaseUtils.parseBoolean(complete);
    }

    public void setCompleteDate(Timestamp completeDate) {
        this.completeDate = completeDate;
    }

    public String getCompleteDateString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.completeDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public Timestamp getCompleteDate() {
        return this.completeDate;
    }

    public boolean getComplete() {
        return this.complete;
    }

    public int getId() {
        return this.id;
    }

    public int getActionId() {
        return this.actionId;
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public String getModifiedString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Id not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT ai.item_id, ai.action_id, ai.link_item_id, ai.completedate, ai.enteredby, ai.entered, ai.modifiedby, ai.modified, ai.enabled FROM action_item ai WHERE ai.item_id = ? ");
        int i = 0;
        pst.setInt(++i, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("ActionItem Id not found");
        }
    }

    public boolean insert(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            int i = 0;
            this.id = DatabaseUtils.getNextSeq(db, "action_item_code_seq");
            PreparedStatement pst = null;
            pst = db.prepareStatement("INSERT INTO action_item (" + (this.id > -1 ? "item_id," : "") + "action_id, link_item_id, enteredby, modifiedby, enabled) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ? ) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getActionId());
            pst.setInt(++i, this.getLinkItemId());
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.setBoolean(++i, this.getEnabled());
            pst.execute();
            this.id = DatabaseUtils.getCurrVal(db, "action_item_code_seq", this.id);
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int updateStatus(Connection db, boolean complete) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Id not specified");
        }
        int i = 0;
        int count = 0;
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("UPDATE action_item SET completedate = ? WHERE item_id = ? ");
            if (this.getCompleteDate() != null && complete) {
                pst.setTimestamp(++i, this.getCompleteDate());
            } else if (complete && this.getCompleteDate() == null) {
                pst.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
            } else {
                pst.setTimestamp(++i, null);
            }
            pst.setInt(++i, this.getId());
            count = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return count;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("item_id");
        this.actionId = rs.getInt("action_id");
        this.linkItemId = rs.getInt("link_item_id");
        this.completeDate = rs.getTimestamp("completedate");
        if (!rs.wasNull()) {
            this.complete = true;
        }
        this.enteredBy = rs.getInt("enteredby");
        this.entered = rs.getTimestamp("entered");
        this.modifiedBy = rs.getInt("modifiedby");
        this.modified = rs.getTimestamp("modified");
        this.enabled = rs.getBoolean("enabled");
    }
}

