/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionlist.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.modules.contacts.base.Call;
import org.aspcfs.modules.mycfs.base.CFSNote;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.tasks.base.Task;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.utils.DatabaseUtils;

public class ActionItemLog
extends GenericBean {
    private int id = -1;
    private int itemId = -1;
    private int linkItemId = -1;
    private int type = -1;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private String description = null;
    private Timestamp modified = null;
    private Timestamp entered = null;

    public void setItemId(String tmp) {
        this.itemId = Integer.parseInt(tmp);
    }

    public void setLinkItemId(String tmp) {
        this.linkItemId = Integer.parseInt(tmp);
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public ActionItemLog() {
    }

    public ActionItemLog(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public void setLinkItemId(int linkItemId) {
        this.linkItemId = linkItemId;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setEnteredBy(int enteredBy) {
        this.enteredBy = enteredBy;
    }

    public void setModifiedBy(int modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setModified(Timestamp modified) {
        this.modified = modified;
    }

    public void setEntered(Timestamp entered) {
        this.entered = entered;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getId() {
        return this.id;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        String tmp = null;
        switch (this.type) {
            case 42420031: {
                tmp = "Call";
                break;
            }
            case 42420030: {
                tmp = "Ticket";
                break;
            }
            case 42420033: {
                tmp = "Task";
                break;
            }
            case 42420032: {
                tmp = "Opp";
                break;
            }
            case 42420035: {
                tmp = "Message";
                break;
            }
            case 51320031: {
                tmp = "Message";
                break;
            }
        }
        return tmp;
    }

    public String getItemLink(int contactId) {
        String tmp = null;
        switch (this.type) {
            case 42420031: {
                tmp = "ExternalContactsCalls.do?command=Details&id=" + this.getLinkItemId() + "&contactId=" + contactId;
                break;
            }
            case 42420030: {
                tmp = "TroubleTickets.do?command=Details&id=" + this.getLinkItemId();
                break;
            }
            case 42420033: {
                tmp = "MyTasks.do?command=Modify&id=" + this.getLinkItemId();
                break;
            }
            case 42420032: {
                tmp = "ExternalContactsOpps.do?command=DetailsOpp&headerId=" + this.getLinkItemId() + "&contactId=" + contactId;
                break;
            }
            case 42420035: {
                tmp = "MyCFSInbox.do?command=CFSNoteDetails&id=" + this.getLinkItemId();
                break;
            }
            case 51320031: {
                tmp = "CampaignManager.do?command=Details&id=" + this.getLinkItemId();
                break;
            }
        }
        return tmp;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public void buildDescription(Connection db) throws SQLException {
        if (this.getType() == -1) {
            throw new SQLException("Type not specified");
        }
        switch (this.type) {
            case 42420031: {
                Call thisCall = new Call(db, this.getLinkItemId());
                this.description = thisCall.getSubject();
                break;
            }
            case 42420030: {
                Ticket thisTicket = new Ticket(db, this.getLinkItemId());
                this.description = thisTicket.getProblem();
                break;
            }
            case 42420033: {
                Task thisTask = new Task(db, this.getLinkItemId());
                this.description = thisTask.getDescription();
                break;
            }
            case 42420032: {
                OpportunityHeader thisOpp = new OpportunityHeader(db, this.getLinkItemId());
                this.description = thisOpp.getDescription();
                break;
            }
            case 42420035: {
                CFSNote thisNote = new CFSNote(db, this.getLinkItemId(), this.getEnteredBy(), "sent");
                this.description = thisNote.getSubject();
                break;
            }
            case 51320031: {
                Campaign thisCampaign = new Campaign(db, this.getLinkItemId());
                this.description = thisCampaign.getSubject();
                break;
            }
        }
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Id not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT al.log_id, al.item_id, al.link_item_id, al." + DatabaseUtils.addQuotes(db, "type") + ", " + "al.enteredby, al.entered, al.modifiedby, al.modified " + "FROM action_item_log al " + "WHERE log_id = ? ");
        int i = 0;
        pst.setInt(++i, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("ActionItem Id not found");
        }
    }

    public boolean insert(Connection db) throws SQLException {
        boolean doCommit = false;
        try {
            doCommit = db.getAutoCommit();
            if (doCommit) {
                db.setAutoCommit(false);
            }
            int i = 0;
            this.id = DatabaseUtils.getNextSeq(db, "action_item_log_code_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO action_item_log (" + (this.id > -1 ? "log_id, " : "") + "item_id, link_item_id, " + DatabaseUtils.addQuotes(db, "type") + ", enteredby, modifiedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ? ) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.getItemId());
            pst.setInt(++i, this.getLinkItemId());
            pst.setInt(++i, this.getType());
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            this.id = DatabaseUtils.getCurrVal(db, "action_item_log_code_seq", this.id);
            pst.close();
            i = 0;
            pst = db.prepareStatement("UPDATE action_item SET modified = CURRENT_TIMESTAMP, modifiedby = ? WHERE item_id = ? ");
            pst.setInt(++i, this.getModifiedBy());
            pst.setInt(++i, this.getItemId());
            pst.execute();
            pst.close();
            if (doCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (doCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (doCommit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID was not specified");
        }
        int recordCount = 0;
        PreparedStatement pst = db.prepareStatement("DELETE FROM action_item_log WHERE log_id = ? ");
        pst.setInt(1, this.id);
        recordCount = pst.executeUpdate();
        pst.close();
        return recordCount != 0;
    }

    public static boolean deleteLink(Connection db, int linkId, int thisType) throws SQLException {
        if (linkId == -1) {
            throw new SQLException("Link Id was not specified");
        }
        int recordCount = 0;
        PreparedStatement pst = db.prepareStatement("DELETE FROM action_item_log WHERE link_item_id = ? AND " + DatabaseUtils.addQuotes(db, "type") + " = ? ");
        pst.setInt(1, linkId);
        pst.setInt(2, thisType);
        recordCount = pst.executeUpdate();
        pst.close();
        return true;
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("log_id");
        this.itemId = rs.getInt("item_id");
        this.linkItemId = rs.getInt("link_item_id");
        this.type = rs.getInt("type");
        this.enteredBy = rs.getInt("enteredby");
        this.entered = rs.getTimestamp("entered");
        this.modifiedBy = rs.getInt("modifiedby");
        this.modified = rs.getTimestamp("modified");
    }
}

