/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionlist.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.actionlist.base.ActionItemLog;
import org.aspcfs.modules.actionlist.base.ActionList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ActionItemLogList
extends ArrayList {
    private int itemId = -1;
    private PagedListInfo pagedListInfo = null;
    private boolean buildDetails = false;

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public void setBuildDetails(boolean buildDetails) {
        this.buildDetails = buildDetails;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public int getItemId() {
        return this.itemId;
    }

    public boolean getBuildDetails() {
        return this.buildDetails;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM action_item_log al WHERE al.log_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo == null) {
            this.pagedListInfo = new PagedListInfo();
            this.pagedListInfo.setItemsPerPage(0);
        }
        pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        if (rs.next()) {
            int maxRecords = rs.getInt("recordcount");
            this.pagedListInfo.setMaxRecords(maxRecords);
        }
        rs.close();
        pst.close();
        this.pagedListInfo.setDefaultSort("al.entered", "DESC");
        this.pagedListInfo.appendSqlTail(db, sqlOrder);
        this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        sqlSelect.append("al.log_id, al.item_id, al.link_item_id, al." + DatabaseUtils.addQuotes(db, "type") + ", " + "al.enteredby, al.entered, al.modifiedby, al.modified " + "FROM action_item_log al " + "WHERE al.log_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ActionItemLog thisList = new ActionItemLog(rs);
            this.add(thisList);
        }
        rs.close();
        pst.close();
        if (this.buildDetails) {
            for (ActionItemLog thisLog : this) {
                thisLog.buildDescription(db);
            }
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.itemId > -1) {
            sqlFilter.append("AND (al.item_id = ?) ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.itemId > -1) {
            pst.setInt(++i, this.itemId);
        }
        return i;
    }

    public static ActionList isItemLinked(Connection db, int linkItemId, int type) throws SQLException {
        ActionList thisList = null;
        int actionListId = -1;
        PreparedStatement pst = db.prepareStatement("SELECT action_id FROM action_item ai, action_item_log al WHERE al.link_item_id = ? AND al." + DatabaseUtils.addQuotes(db, "type") + " = ? AND ai.item_id = al.item_id ");
        pst.setInt(1, linkItemId);
        pst.setInt(2, type);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            actionListId = rs.getInt("action_id");
        }
        rs.close();
        pst.close();
        if (actionListId > 0) {
            thisList = new ActionList();
            thisList.queryRecord(db, actionListId);
        }
        return thisList;
    }

    public static int getLinkedActionItemLogCount(Connection db, int linkItemId, int type) throws SQLException {
        int count = -1;
        PreparedStatement pst = db.prepareStatement("SELECT count(action_id) as numberOfLinkedItems FROM action_item ai, action_item_log al WHERE al.link_item_id = ? AND al." + DatabaseUtils.addQuotes(db, "type") + " = ? AND ai.item_id = al.item_id ");
        pst.setInt(1, linkItemId);
        pst.setInt(2, type);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            count = rs.getInt("numberOfLinkedItems");
        }
        rs.close();
        pst.close();
        return count;
    }
}

