/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionlist.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.DatabaseUtils;

public class ActionList
extends GenericBean {
    private int id = -1;
    private String description = null;
    private int owner = -1;
    private int ownerContactId = -1;
    private Timestamp completeDate = null;
    private boolean complete = false;
    private int linkModuleId = -1;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private Timestamp entered = null;
    private boolean enabled = true;
    private int total = 0;
    private int totalComplete = 0;

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public ActionList() {
    }

    public ActionList(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public ActionList(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setId(String id) {
        this.id = Integer.parseInt(id);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public void setOwner(String owner) {
        this.owner = Integer.parseInt(owner);
    }

    public void setCompleteDate(Timestamp completeDate) {
        this.completeDate = completeDate;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setTotalComplete(int totalComplete) {
        this.totalComplete = totalComplete;
    }

    public int getTotal() {
        return this.total;
    }

    public int getTotalComplete() {
        return this.totalComplete;
    }

    public String getCompleteDateString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.completeDate);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public void setLinkModuleId(int linkModuleId) {
        this.linkModuleId = linkModuleId;
    }

    public void setLinkModuleId(String linkModuleId) {
        this.linkModuleId = Integer.parseInt(linkModuleId);
    }

    public void setEnteredBy(int enteredBy) {
        this.enteredBy = enteredBy;
    }

    public void setModifiedBy(int modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public void setModified(Timestamp modified) {
        this.modified = modified;
    }

    public void setModified(String modified) {
        this.modified = DatabaseUtils.parseTimestamp(modified);
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void setComplete(String complete) {
        this.complete = DatabaseUtils.parseBoolean(complete);
    }

    public void setOwnerContactId(int ownerContactId) {
        this.ownerContactId = ownerContactId;
    }

    public void setOwnerContactId(String ownerContactId) {
        this.ownerContactId = Integer.parseInt(ownerContactId);
    }

    public int getOwnerContactId() {
        return this.ownerContactId;
    }

    public boolean getComplete() {
        return this.complete;
    }

    public String getModifiedString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.modified);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public void setEntered(Timestamp entered) {
        this.entered = entered;
    }

    public String getEnteredString() {
        String tmp = "";
        try {
            return DateFormat.getDateInstance(3).format(this.entered);
        }
        catch (NullPointerException nullPointerException) {
            return tmp;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = DatabaseUtils.parseBoolean(enabled);
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public int getOwner() {
        return this.owner;
    }

    public Timestamp getCompleteDate() {
        return this.completeDate;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean isOwnerValid(Connection db) throws SQLException {
        if (this.owner == -1 && this.ownerContactId != -1) {
            Contact thisContact = new Contact(db, this.ownerContactId);
            this.setOwner(thisContact.getUserId());
        }
        return this.owner != -1;
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Id not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT al.action_id, al.description, al.owner, al.completedate, al.link_module_id, al.enteredby, al.entered, al.modifiedby, al.modified, al.enabled FROM action_list al WHERE action_id = ? ");
        int i = 0;
        pst.setInt(++i, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Action ID not found");
        }
    }

    public boolean insert(Connection db) throws SQLException {
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            int i = 0;
            this.id = DatabaseUtils.getNextSeq(db, "action_list_code_seq");
            PreparedStatement pst = db.prepareStatement("INSERT INTO action_list (" + (this.id > -1 ? "action_id, " : "") + "description, owner, link_module_id, enteredby, modifiedby, enabled) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ? ) ");
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setString(++i, this.getDescription());
            pst.setInt(++i, this.getOwner());
            pst.setInt(++i, this.getLinkModuleId());
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.setBoolean(++i, this.getEnabled());
            pst.execute();
            this.id = DatabaseUtils.getCurrVal(db, "action_list_code_seq", this.id);
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int count = 0;
        if (this.id == -1) {
            throw new SQLException("Id not specified");
        }
        try {
            db.setAutoCommit(false);
            ActionList previousList = new ActionList(db, this.id);
            int i = 0;
            PreparedStatement pst = db.prepareStatement("UPDATE action_list SET modifiedby = ?, description = ?, modified = CURRENT_TIMESTAMP, completedate = ?, owner = ? WHERE action_id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? "));
            pst.setInt(++i, this.getModifiedBy());
            pst.setString(++i, this.getDescription());
            if (previousList.getCompleteDate() != null && this.getComplete()) {
                pst.setTimestamp(++i, previousList.getCompleteDate());
            } else if (this.getComplete() && previousList.getCompleteDate() == null) {
                pst.setTimestamp(++i, new Timestamp(System.currentTimeMillis()));
            } else {
                pst.setTimestamp(++i, null);
            }
            pst.setInt(++i, this.getOwner());
            pst.setInt(++i, this.id);
            if (this.getModified() != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            count = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return count;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Action Id not specified");
        }
        try {
            db.setAutoCommit(false);
            this.deleteRelationships(db);
            String sql = "DELETE from action_list WHERE action_id = ? ";
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public boolean deleteRelationships(Connection db) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("DELETE from action_item_log WHERE item_id IN (SELECT item_id from action_item where action_id = ? ) ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE from action_item WHERE action_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        ResultSet rs = null;
        DependencyList dependencyList = new DependencyList();
        try {
            int linkcount;
            int i = 0;
            PreparedStatement pst = db.prepareStatement("SELECT count(*) as total FROM action_item WHERE action_id = ? ");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (linkcount = rs.getInt("total")) != 0) {
                Dependency thisDependency = new Dependency();
                thisDependency.setName("items");
                thisDependency.setCount(linkcount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public void buildTotal(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Id not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT count(*) as total FROM action_item WHERE action_id = ? ");
        pst.setInt(1, this.getId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.total = rs.getInt("total");
        }
        rs.close();
        pst.close();
    }

    public void buildTotalComplete(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Id not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT count(*) as total_complete FROM action_item WHERE action_id = ? AND completedate IS NOT NULL ");
        pst.setInt(1, this.getId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.totalComplete = rs.getInt("total_complete");
        }
        rs.close();
        pst.close();
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("action_id");
        this.description = rs.getString("description");
        this.owner = rs.getInt("owner");
        this.completeDate = rs.getTimestamp("completedate");
        if (!rs.wasNull()) {
            this.complete = true;
        }
        this.linkModuleId = rs.getInt("link_module_id");
        this.enteredBy = rs.getInt("enteredby");
        this.entered = rs.getTimestamp("entered");
        this.modifiedBy = rs.getInt("modifiedby");
        this.modified = rs.getTimestamp("modified");
        this.enabled = rs.getBoolean("enabled");
    }

    public boolean reassign(Connection db, int newOwner) throws SQLException {
        int result = -1;
        this.setOwner(newOwner);
        result = this.update(db);
        return result != -1;
    }
}

