/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionlist.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.actionlist.base.ActionList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ActionLists
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int linkModuleId = -1;
    private int owner = -1;
    private boolean buildDetails = false;
    private boolean completeOnly = false;
    private boolean inProgressOnly = false;

    public void setLinkModuleId(int linkModuleId) {
        this.linkModuleId = linkModuleId;
    }

    public void setOwner(int owner) {
        this.owner = owner;
    }

    public void setPagedListInfo(PagedListInfo pagedListInfo) {
        this.pagedListInfo = pagedListInfo;
    }

    public void setBuildDetails(boolean buildDetails) {
        this.buildDetails = buildDetails;
    }

    public void setCompleteOnly(boolean completeOnly) {
        this.completeOnly = completeOnly;
    }

    public void setInProgressOnly(boolean inProgressOnly) {
        this.inProgressOnly = inProgressOnly;
    }

    public boolean getCompleteOnly() {
        return this.completeOnly;
    }

    public boolean getInProgressOnly() {
        return this.inProgressOnly;
    }

    public boolean getBuildDetails() {
        return this.buildDetails;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public int getOwner() {
        return this.owner;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM action_list al WHERE al.action_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo == null) {
            this.pagedListInfo = new PagedListInfo();
            this.pagedListInfo.setItemsPerPage(0);
        }
        pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        if (rs.next()) {
            int maxRecords = rs.getInt("recordcount");
            this.pagedListInfo.setMaxRecords(maxRecords);
        }
        rs.close();
        pst.close();
        if (!this.pagedListInfo.getCurrentLetter().equals("")) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(al.description) < ? ");
            items = this.prepareFilter(pst);
            pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
            rs = pst.executeQuery();
            if (rs.next()) {
                int offsetCount = rs.getInt("recordcount");
                this.pagedListInfo.setCurrentOffset(offsetCount);
            }
            rs.close();
            pst.close();
        }
        this.pagedListInfo.setDefaultSort("al.modified", "DESC");
        this.pagedListInfo.appendSqlTail(db, sqlOrder);
        this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        sqlSelect.append("al.* FROM action_list al WHERE al.action_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ActionList thisList = new ActionList(rs);
            this.add(thisList);
        }
        rs.close();
        pst.close();
        if (this.buildDetails) {
            for (ActionList thisList : this) {
                thisList.buildTotal(db);
                thisList.buildTotalComplete(db);
            }
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.linkModuleId > -1) {
            sqlFilter.append("AND (al.link_module_id = ?) ");
        }
        if (this.owner > -1) {
            sqlFilter.append("AND (al.owner = ?) ");
        }
        if (this.completeOnly) {
            sqlFilter.append("AND (al.completedate IS NOT NULL) ");
        } else if (this.inProgressOnly) {
            sqlFilter.append("AND (al.completedate IS NULL) ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.linkModuleId > -1) {
            pst.setInt(++i, this.linkModuleId);
        }
        if (this.owner > -1) {
            pst.setInt(++i, this.owner);
        }
        return i;
    }

    public int reassignElements(Connection db, int newOwner) throws SQLException {
        int total = 0;
        for (ActionList thisActionList : this) {
            if (!thisActionList.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }

    public int reassignElements(Connection db, int newOwner, int userId) throws SQLException {
        int total = 0;
        for (ActionList thisActionList : this) {
            thisActionList.setModifiedBy(userId);
            if (!thisActionList.reassign(db, newOwner)) continue;
            ++total;
        }
        return total;
    }
}

