/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.actionplans.base.ActionItemWork;
import org.aspcfs.modules.actionplans.base.ActionItemWorkNote;
import org.aspcfs.modules.actionplans.base.ActionItemWorkSelection;
import org.aspcfs.modules.actionplans.base.ActionItemWorkSelectionList;
import org.aspcfs.modules.actionplans.base.ActionPhaseWork;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkNote;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkNoteList;
import org.aspcfs.modules.actionplans.base.ActionStepLookupList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldRecord;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.relationships.base.Relationship;
import org.aspcfs.modules.relationships.base.RelationshipList;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.PrivateString;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.PagedListInfo;

public final class ActionPlans
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAttach(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String item = context.getRequest().getParameter("item");
            String itemId = context.getRequest().getParameter("itemId");
            ActionItemWork itemWork = new ActionItemWork(db, Integer.parseInt(itemId));
            if (item != null) {
                if ("contact".equals(item.trim())) {
                    String contactId = context.getRequest().getParameter("contactId");
                    itemWork.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 2));
                    itemWork.setLinkItemId(contactId);
                } else if ("opportunity".equals(item.trim())) {
                    String oppId = context.getRequest().getParameter("oppId");
                    itemWork.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 1011200517));
                    itemWork.setLinkItemId(oppId);
                } else if ("fileitem".equals(item.trim())) {
                    String fileId = context.getRequest().getParameter("fileId");
                    itemWork.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 42420034));
                    itemWork.setLinkItemId(fileId);
                } else if ("note".equals(item.trim())) {
                    String noteId = context.getRequest().getParameter("noteId");
                    itemWork.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 831200519));
                    itemWork.setLinkItemId(noteId);
                } else if ("selection".equals(item.trim())) {
                    String selectionId = context.getRequest().getParameter("selectionId");
                    itemWork.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 831200520));
                    itemWork.setLinkItemId(selectionId);
                } else if ("relation".equals(item.trim())) {
                    String relationId = context.getRequest().getParameter("relationId");
                    itemWork.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 110061020));
                    itemWork.setLinkItemId(relationId);
                } else if ("folder".equals(item.trim())) {
                    String recordId = context.getRequest().getParameter("recordId");
                    itemWork.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 42420034));
                    itemWork.setLinkItemId(recordId);
                }
            }
            itemWork.attach(db);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandResetFolderAttachment(ActionContext context) {
        Connection db = null;
        try {
            db = this.getConnection(context);
            String item = context.getRequest().getParameter("item");
            String itemId = context.getRequest().getParameter("itemId");
            String categoryId = context.getRequest().getParameter("categoryId");
            ActionItemWork itemWork = new ActionItemWork(db, Integer.parseInt(itemId));
            ActionPhaseWork phaseWork = new ActionPhaseWork(db, itemWork.getPhaseWorkId());
            ActionPlanWork planWork = new ActionPlanWork(db, phaseWork.getPlanWorkId());
            planWork.buildLinkedObject(db);
            itemWork.setPlanWork(planWork);
            itemWork.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 42420034));
            CustomFieldCategory category = new CustomFieldCategory(db, Integer.parseInt(categoryId));
            itemWork.setCustomFieldCategory(category);
            itemWork.deleteFolderAttachment(db);
            if (itemWork.getLinkItemId() != -1) {
                categoryId = String.valueOf(CustomFieldCategory.getIdFromRecord(db, itemWork.getLinkItemId()));
                category = new CustomFieldCategory(db, Integer.parseInt(categoryId));
                category.setRecordId(itemWork.getLinkItemId());
                category.setLinkModuleId(1);
                category.setLinkItemId(planWork.getOrganization().getOrgId());
                category.buildResources(db);
                CustomFieldRecord record = new CustomFieldRecord(db, itemWork.getLinkItemId());
                record.buildColumns(db, category);
                itemWork.setCustomFieldCategory(category);
                context.getRequest().setAttribute("Record", (Object)record);
                context.getRequest().setAttribute("actionItemWork", (Object)itemWork);
                String string = "ResetFolderAttachmentOK";
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReassign(ActionContext context) {
        Exception errorMessage = null;
        String returnStr = context.getRequest().getParameter("return");
        Connection db = null;
        boolean status = false;
        String userId = null;
        int prev = -1;
        User previous = null;
        User assigned = null;
        User manager = null;
        Contact previousContact = null;
        Contact assignedContact = null;
        Contact managerContact = null;
        ActionPlanWork planWork = new ActionPlanWork();
        try {
            db = this.getConnection(context);
            String actionPlanId = context.getRequest().getParameter("actionPlanId");
            userId = context.getRequest().getParameter("userId");
            planWork.setBuildPhaseWork(true);
            planWork.setBuildStepWork(true);
            planWork.setBuildLinkedObject(true);
            planWork.queryRecord(db, Integer.parseInt(actionPlanId));
            prev = planWork.getAssignedTo();
            if (userId != null && Integer.parseInt(userId) > 0) {
                status = planWork.reassign(db, Integer.parseInt(userId));
            }
            if (status) {
                context.getRequest().setAttribute("actionPlanId", (Object)String.valueOf(planWork.getId()));
                assigned = this.getUser(context, planWork.getAssignedTo());
                assignedContact = new Contact(db, assigned.getContactId());
                manager = this.getUser(context, planWork.getManagerId());
                managerContact = new Contact(db, manager.getContactId());
                previous = this.getUser(context, prev);
                previousContact = new Contact(db, previous.getContactId());
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (status && planWork.getId() > -1) {
            System.out.println("Process Emails....");
            try {
                String templateFile = ActionPlans.getDbNamePath(context) + "templates_" + this.getUserLanguage(context) + ".xml";
                if (!FileUtils.fileExists(templateFile)) {
                    templateFile = ActionPlans.getDbNamePath(context) + "templates_en_US.xml";
                }
                planWork.sendEmail(context, assignedContact, managerContact, previousContact, planWork.getOrganization().getName(), templateFile);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                context.getRequest().setAttribute("Error", (Object)e);
                return "SystemError";
            }
        }
        if (errorMessage == null) {
            if (returnStr != null && "list".equals(returnStr)) {
                return "ReassignListOK";
            }
            return "ReassignDetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandEnable(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String actionPlanId = context.getRequest().getParameter("actionPlanId");
            String enabled = context.getRequest().getParameter("enabled");
            ActionPlanWork planWork = new ActionPlanWork(db, Integer.parseInt(actionPlanId));
            if (enabled != null && "false".equals(enabled)) {
                planWork.setEnabled(false);
            } else {
                planWork.setEnabled(true);
            }
            planWork.update(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "EnableListOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmRevert(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            String planWorkId = context.getRequest().getParameter("actionPlanId");
            ActionPlanWork planWork = new ActionPlanWork(db, Integer.parseInt(planWorkId));
            planWork.buildPhaseWork(db);
            planWork.buildLinkedObject(db);
            DependencyList dependencies = planWork.getOrganization().processResetToLeadDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (planWork.getTicket() != null) {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.ticketActionPlansCanNotRevertAccounts", "Ticket Action Plans can not be used to rever the account contacts back to leads"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            } else if (!dependencies.canDelete()) {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.unableToRevertAccountsToLeads", "Unable to revert the account contacts back to leads due to the following dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("account.revertToLeadDependencies"));
                htmlDialog.addButton(systemStatus.getLabel("sales.revertBackToLead"), "javascript:window.location.href='MyActionPlans.do?command=RevertToLead&actionPlanId=" + planWorkId + "';");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close();");
            }
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ConfirmRevertOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRevertToLead(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String planWorkId = context.getRequest().getParameter("actionPlanId");
            ActionPlanWork planWork = new ActionPlanWork(db, Integer.parseInt(planWorkId));
            planWork.buildPhaseWork(db);
            planWork.buildLinkedObject(db);
            Organization orgDetails = planWork.getOrganization();
            ContactList orgContacts = new ContactList();
            orgContacts.setHasConversionDate(1);
            orgContacts.setOrgId(orgDetails.getOrgId());
            orgContacts.buildList(db);
            int contactId = orgDetails.revertBackToLead(db, context, this.getUserId(context));
            if (contactId != -1) {
                Contact contact = new Contact(db, contactId);
                context.getRequest().setAttribute("contact", (Object)contact);
                for (Contact thisContact : orgContacts) {
                    this.deleteRecentItem(context, (Object)thisContact);
                }
            }
            this.deleteRecentItem(context, (Object)orgDetails);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "RevertToLeadOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateGlobalStatus(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String itemId = context.getRequest().getParameter("stepId");
            String statusId = context.getRequest().getParameter("statusId");
            if (itemId != null && Integer.parseInt(itemId) > 0) {
                ActionItemWork itemWork = new ActionItemWork();
                itemWork.setBuildStep(true);
                itemWork.queryRecord(db, Integer.parseInt(itemId));
                if (itemWork.isComplete()) {
                    itemWork.setStatusId(-1);
                } else {
                    itemWork.setStatusId(2);
                }
                if (itemWork.getStartDate() == null) {
                    itemWork.setStartDate(new Timestamp(new Date().getTime()));
                }
                itemWork.setEndDate(new Timestamp(new Date().getTime()));
                itemWork.setModifiedBy(this.getUserId(context));
                itemWork.update(db);
            }
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "UpdateGlobalStatusDetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRevertStatus(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String itemId = context.getRequest().getParameter("stepId");
            String nextStepId = context.getRequest().getParameter("nextStepId");
            String statusId = context.getRequest().getParameter("statusId");
            if (itemId != null && Integer.parseInt(itemId) > 0) {
                ActionItemWork itemWork = new ActionItemWork();
                itemWork.setBuildStep(true);
                itemWork.queryRecord(db, Integer.parseInt(itemId));
                if (statusId != null && Integer.parseInt(statusId) > 0) {
                    itemWork.setStatusId(statusId);
                } else {
                    itemWork.setStatusId(-1);
                }
                itemWork.setModifiedBy(this.getUserId(context));
                ActionPhaseWork phaseWork = new ActionPhaseWork(db, itemWork.getPhaseWorkId());
                ActionPlanWork planWork = new ActionPlanWork(db, phaseWork.getPlanWorkId());
                itemWork.setPlanWork(planWork);
                if (nextStepId != null && Integer.parseInt(nextStepId) > 0) {
                    ActionItemWork nextItem = new ActionItemWork(db, Integer.parseInt(nextStepId));
                    itemWork.revertStatus(db, nextItem);
                } else {
                    itemWork.revertStatus(db, null);
                }
            }
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "RevertStatusDetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRestart(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String planWorkId = context.getRequest().getParameter("actionPlanId");
            ActionPlanWork planWork = new ActionPlanWork();
            planWork.setBuildPhaseWork(true);
            planWork.setBuildStepWork(true);
            planWork.queryRecord(db, Integer.parseInt(planWorkId));
            planWork.setModifiedBy(this.getUserId(context));
            planWork.restart(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "RestartDetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddNote(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            String itemId = context.getRequest().getParameter("actionStepWork");
            String orgId = context.getRequest().getParameter("orgId");
            if (orgId != null && !"".equals(orgId) && !"-1".equals(orgId)) {
                thisOrg = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("orgDetails", (Object)thisOrg);
            }
            ActionItemWorkNote thisNote = new ActionItemWorkNote();
            thisNote.setSubmitted(DateUtils.roundUpToNextFive(System.currentTimeMillis()));
            context.getRequest().setAttribute("actionItemWorkNote", (Object)thisNote);
            ActionItemWork itemWork = new ActionItemWork();
            itemWork.setBuildLinkedObject(true);
            itemWork.queryRecord(db, Integer.parseInt(itemId));
            context.getRequest().setAttribute("actionItemWork", (Object)itemWork);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "AddNoteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddSelection(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            String itemId = context.getRequest().getParameter("actionStepWork");
            String orgId = context.getRequest().getParameter("orgId");
            if (orgId != null && !"".equals(orgId) && !"-1".equals(orgId)) {
                thisOrg = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("orgDetails", (Object)thisOrg);
            }
            ActionItemWork itemWork = new ActionItemWork();
            itemWork.setBuildLinkedObject(true);
            itemWork.queryRecord(db, Integer.parseInt(itemId));
            context.getRequest().setAttribute("actionItemWork", (Object)itemWork);
            ActionStepLookupList itemList = new ActionStepLookupList();
            itemList.setStepId(itemWork.getActionStepId());
            itemList.buildList(db);
            context.getRequest().setAttribute("itemList", (Object)itemList);
            ActionItemWorkSelectionList selectionList = new ActionItemWorkSelectionList();
            selectionList.setItemWorkId(itemWork.getId());
            selectionList.buildList(db);
            context.getRequest().setAttribute("selectionList", (Object)selectionList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "AddSelectionOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddRelation(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Organization thisOrg = null;
        try {
            String prevSelection;
            RelationshipList existingList;
            String init;
            db = this.getConnection(context);
            String planWorkId = context.getRequest().getParameter("planWorkId");
            String itemId = context.getRequest().getParameter("actionStepWork");
            String orgId = context.getRequest().getParameter("orgId");
            if (orgId != null && !"".equals(orgId) && !"-1".equals(orgId)) {
                thisOrg = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("orgDetails", (Object)thisOrg);
            }
            ActionPlanWork planWork = new ActionPlanWork(db, Integer.parseInt(planWorkId));
            ActionItemWork itemWork = new ActionItemWork();
            itemWork.setPlanWork(planWork);
            itemWork.setBuildLinkedObject(true);
            itemWork.setBuildStep(true);
            itemWork.queryRecord(db, Integer.parseInt(itemId));
            context.getRequest().setAttribute("actionItemWork", (Object)itemWork);
            ArrayList accountTypes = itemWork.getStep().getAccountTypes();
            PagedListInfo stepRelationOrgListInfo = this.getPagedListInfo(context, "stepRelationOrgListInfo");
            stepRelationOrgListInfo.setLink("ActionPlans.do?command=AddRelation&planWorkId=" + planWorkId + "&actionStepWork=" + itemId + "&orgId=" + orgId);
            OrganizationList accounts = new OrganizationList();
            accounts.setTypes(StringUtils.getCommaSeparated(accountTypes));
            accounts.setPagedListInfo(stepRelationOrgListInfo);
            if (thisOrg != null) {
                if (thisOrg.getSiteId() == -1) {
                    accounts.setIncludeOrganizationWithoutSite(true);
                } else {
                    accounts.setOrgSiteId(thisOrg.getSiteId());
                }
                accounts.setExcludeIds(String.valueOf(thisOrg.getOrgId()));
            }
            accounts.buildList(db);
            context.getRequest().setAttribute("accounts", (Object)accounts);
            ArrayList<String> selectedList = (ArrayList<String>)context.getRequest().getAttribute("selectedList");
            if (selectedList == null || "true".equals(context.getRequest().getParameter("reset"))) {
                selectedList = new ArrayList<String>();
            }
            if ((init = context.getRequest().getParameter("init")) != null && "true".equals(init) && (existingList = itemWork.getRelationshipList()) != null) {
                existingList.getMappedObjectIds(selectedList, itemWork.getTargetRelationship());
            }
            if ((prevSelection = context.getRequest().getParameter("previousSelection")) != null) {
                StringTokenizer st = new StringTokenizer(prevSelection, "|");
                while (st.hasMoreTokens()) {
                    selectedList.add(String.valueOf(st.nextToken()));
                }
            }
            int rowCount = 1;
            while (context.getRequest().getParameter("hiddenItemId" + rowCount) != null) {
                int item = Integer.parseInt(context.getRequest().getParameter("hiddenItemId" + rowCount));
                if (context.getRequest().getParameter("item" + rowCount) != null) {
                    if (!selectedList.contains(String.valueOf(item))) {
                        selectedList.add(String.valueOf(item));
                    }
                } else {
                    selectedList.remove(String.valueOf(item));
                }
                ++rowCount;
            }
            context.getRequest().setAttribute("selectedList", selectedList);
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "AddRelationOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAttachRelation(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Object thisOrg = null;
        boolean isValid = false;
        try {
            db = this.getConnection(context);
            String planWorkId = context.getRequest().getParameter("planWorkId");
            String itemId = context.getRequest().getParameter("actionStepWork");
            String orgId = context.getRequest().getParameter("orgId");
            ActionPlanWork planWork = new ActionPlanWork(db, Integer.parseInt(planWorkId));
            ActionItemWork itemWork = new ActionItemWork();
            itemWork.setPlanWork(planWork);
            itemWork.setBuildLinkedObject(true);
            itemWork.setBuildStep(true);
            itemWork.queryRecord(db, Integer.parseInt(itemId));
            context.getRequest().setAttribute("actionItemWork", (Object)itemWork);
            ArrayList<String> finalSelection = new ArrayList<String>();
            String prevSelection = context.getRequest().getParameter("previousSelection");
            if (prevSelection != null) {
                StringTokenizer st = new StringTokenizer(prevSelection, "|");
                while (st.hasMoreTokens()) {
                    finalSelection.add(String.valueOf(st.nextToken()));
                }
            }
            int rowCount = 1;
            ArrayList displayList = new ArrayList();
            while (context.getRequest().getParameter("hiddenItemId" + rowCount) != null) {
                int item = Integer.parseInt(context.getRequest().getParameter("hiddenItemId" + rowCount));
                if (context.getRequest().getParameter("item" + rowCount) != null) {
                    if (!finalSelection.contains(String.valueOf(item))) {
                        finalSelection.add(String.valueOf(item));
                    }
                } else {
                    finalSelection.remove(String.valueOf(item));
                }
                ++rowCount;
            }
            RelationshipList existingList = itemWork.getRelationshipList();
            if (existingList != null) {
                Iterator current = existingList.keySet().iterator();
                while (current.hasNext()) {
                    ArrayList tempList = (ArrayList)existingList.get((String)current.next());
                    for (Relationship existingRelationship : tempList) {
                        if (existingRelationship.isPresent(finalSelection, itemWork.getTargetRelationship())) continue;
                        existingRelationship.delete(db);
                    }
                }
            }
            int relId = -1;
            if (finalSelection.size() > 0) {
                String relType = itemWork.getTargetRelationship();
                if (relType != null) {
                    for (String mapTo : finalSelection) {
                        Relationship relationship = new Relationship();
                        if (planWork.getLinkModuleId() == ActionPlan.getMapIdGivenConstantId(db, 42420034)) {
                            relationship.setCategoryIdMapsFrom(42420034);
                            relationship.setCategoryIdMapsTo(42420034);
                        }
                        relationship.setObjectIdMapsFrom(planWork.getLinkItemId());
                        relationship.setObjectIdMapsTo(Integer.parseInt(mapTo));
                        int typeId = -1;
                        if (relType.endsWith("_reciprocal")) {
                            relationship.setObjectIdMapsFrom(relationship.getObjectIdMapsTo());
                            relationship.setObjectIdMapsTo(planWork.getLinkItemId());
                            typeId = Integer.parseInt(relType.substring(0, relType.indexOf("_")));
                        } else {
                            typeId = Integer.parseInt(relType);
                        }
                        relationship.setTypeId(typeId);
                        RelationshipList thisList = new RelationshipList();
                        if (planWork.getLinkModuleId() == ActionPlan.getMapIdGivenConstantId(db, 42420034)) {
                            thisList.setCategoryIdMapsFrom(42420034);
                        }
                        thisList.setObjectIdMapsFrom(relationship.getObjectIdMapsFrom());
                        thisList.setTypeId(typeId);
                        thisList.buildList(db);
                        isValid = this.validateObject(context, db, (Object)relationship);
                        if (!isValid) continue;
                        relationship.setEnteredBy(this.getUserId(context));
                        relationship.setModifiedBy(this.getUserId(context));
                        if (planWork.getLinkModuleId() != ActionPlan.getMapIdGivenConstantId(db, 42420034)) continue;
                        if (thisList.checkDuplicateRelationship(db, relationship.getObjectIdMapsTo(), typeId, 42420034) == 0) {
                            relationship.insert(db);
                            relId = relationship.getId();
                            this.processInsertHook(context, (Object)relationship);
                            continue;
                        }
                        Relationship duplicate = thisList.getDuplicateRelation(db, relationship.getObjectIdMapsTo(), typeId, 42420034);
                        if (duplicate == null) continue;
                        relId = duplicate.getId();
                    }
                }
                RelationshipList relationshipList = new RelationshipList();
                if (planWork.getLinkModuleId() == ActionPlan.getMapIdGivenConstantId(db, 42420034)) {
                    relationshipList.setCategoryIdMapsFrom(42420034);
                }
                relationshipList.setObjectIdMapsFrom(planWork.getLinkItemId());
                relationshipList.setObjectIdMapsTo(-1);
                String targetRelationship = itemWork.getTargetRelationship();
                if (targetRelationship.endsWith("_reciprocal")) {
                    relationshipList.setObjectIdMapsTo(planWork.getLinkItemId());
                    relationshipList.setObjectIdMapsFrom(-1);
                    relationshipList.setTypeId(Integer.parseInt(targetRelationship.substring(0, targetRelationship.indexOf("_"))));
                } else {
                    relationshipList.setTypeId(Integer.parseInt(targetRelationship));
                }
                relationshipList.buildList(db);
                relationshipList.filterAccounts(itemWork.getStep().getAccountTypes());
                context.getRequest().setAttribute("display", (Object)relationshipList.getDisplayHtml());
            } else {
                context.getRequest().setAttribute("display", (Object)(itemWork.getLabel() != null ? itemWork.getLabel() : this.getSystemStatus(context).getLabel("actionPlans.addRelationships.text", "Add Relationship")));
                itemWork.resetAttachment(db);
            }
            context.getRequest().setAttribute("actionItemWork", (Object)itemWork);
            context.getRequest().setAttribute("status", (Object)"true");
            context.getRequest().setAttribute("linkRelation", (Object)String.valueOf(relId));
        }
        catch (Exception e) {
            errorMessage = e;
            e.printStackTrace(System.out);
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "AddRelationOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAttachNote(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            String itemId = context.getRequest().getParameter("itemWorkId");
            String orgId = context.getRequest().getParameter("orgId");
            String actionId = context.getRequest().getParameter("actionId");
            int count = Integer.parseInt(context.getRequest().getParameter("count"));
            if (orgId != null && !"".equals(orgId) && !"-1".equals(orgId)) {
                thisOrg = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("orgDetails", (Object)thisOrg);
            }
            ActionItemWork itemWork = new ActionItemWork();
            itemWork.setBuildLinkedObject(true);
            itemWork.queryRecord(db, Integer.parseInt(itemId));
            ActionItemWorkNote thisNote = (ActionItemWorkNote)((Object)context.getFormBean());
            boolean isValid = this.validateObject(context, db, (Object)thisNote);
            boolean recordStatus = false;
            if (isValid) {
                if (Integer.parseInt(actionId) == 110061035 && count > 0) {
                    itemWork.getNote().setDescription(thisNote.getDescription());
                    itemWork.getNote().setSubmitted(thisNote.getSubmitted());
                    itemWork.getNote().setSubmittedBy(this.getUserId(context));
                    recordStatus = itemWork.getNote().update(db);
                } else {
                    thisNote.setSubmittedBy(this.getUserId(context));
                    recordStatus = thisNote.insert(db);
                }
            }
            if (recordStatus) {
                context.getRequest().setAttribute("status", (Object)"true");
                itemWork.add(thisNote);
            }
            context.getRequest().setAttribute("actionItemWork", (Object)itemWork);
            context.getRequest().setAttribute("actionItemWorkNote", (Object)thisNote);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "AddNoteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAttachSelection(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Organization thisOrg = null;
        try {
            ActionItemWorkSelection thisItem2;
            db = this.getConnection(context);
            String itemId = context.getRequest().getParameter("itemWorkId");
            String orgId = context.getRequest().getParameter("orgId");
            if (orgId != null && !"".equals(orgId) && !"-1".equals(orgId)) {
                thisOrg = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("orgDetails", (Object)thisOrg);
            }
            ArrayList<String> newList = new ArrayList<String>();
            ArrayList<String> displayList = new ArrayList<String>();
            int rowCount = 1;
            String elementId = null;
            while (context.getRequest().getParameter("hiddenelementid" + rowCount) != null) {
                elementId = context.getRequest().getParameter("hiddenelementid" + rowCount);
                if (elementId != null && Integer.parseInt(elementId) > 0 && context.getRequest().getParameter("checkelement" + rowCount) != null) {
                    newList.add(elementId);
                    if (context.getRequest().getParameter("elementvalue" + rowCount) != null) {
                        displayList.add(context.getRequest().getParameter("elementvalue" + rowCount));
                    }
                }
                ++rowCount;
            }
            ActionItemWorkSelectionList compareList = new ActionItemWorkSelectionList();
            compareList.setItemWorkId(itemId);
            compareList.buildList(db);
            for (ActionItemWorkSelection thisItem2 : compareList) {
                if (thisItem2.hasValue(newList)) continue;
                thisItem2.delete(db);
            }
            thisItem2 = null;
            for (String param : newList) {
                if (compareList.hasSelection(Integer.parseInt(param))) continue;
                thisItem2 = new ActionItemWorkSelection();
                thisItem2.setItemWorkId(itemId);
                thisItem2.setSelection(param);
                thisItem2.insert(db);
            }
            ActionItemWork itemWork = new ActionItemWork(db, Integer.parseInt(itemId));
            context.getRequest().setAttribute("actionItemWork", (Object)itemWork);
            context.getRequest().setAttribute("status", (Object)"true");
            context.getRequest().setAttribute("display", (Object)StringUtils.getLineSeparated(displayList));
            context.getRequest().setAttribute("linkSelection", (Object)elementId);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "AddSelectionOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewNotes(ActionContext context) {
        Object errorMessage = null;
        Connection db = null;
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            String planWorkId = context.getRequest().getParameter("planWorkId");
            ActionPlanWork planWork = new ActionPlanWork(db, Integer.parseInt(planWorkId));
            planWork.setBuildLinkedObject(true);
            planWork.buildLinkedObject(db);
            context.getRequest().setAttribute("actionPlanWork", (Object)planWork);
            String orgId = context.getRequest().getParameter("orgId");
            if (orgId != null && !"".equals(orgId) && !"-1".equals(orgId)) {
                thisOrg = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("orgDetails", (Object)thisOrg);
            } else if (planWork.getOrganization() != null && planWork.getOrganization().getOrgId() != -1) {
                context.getRequest().setAttribute("orgDetails", (Object)planWork.getOrganization());
            }
            if (planWork.getLinkModuleId() == ActionPlan.getMapIdGivenConstantId(db, 912051329)) {
                context.getRequest().setAttribute("ticket", (Object)planWork.getTicket());
            }
            ActionPlanWorkNoteList noteList = new ActionPlanWorkNoteList();
            noteList.setPlanWorkId(planWorkId);
            noteList.buildList(db);
            context.getRequest().setAttribute("actionPlanWorkNoteList", (Object)noteList);
            ActionPlanWorkNote thisNote = new ActionPlanWorkNote();
            thisNote.setSubmitted(DateUtils.roundUpToNextFive(System.currentTimeMillis()));
            context.getRequest().setAttribute("actionPlanWorkNote", (Object)thisNote);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ViewNotesOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddNotes(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        Organization thisOrg = null;
        try {
            db = this.getConnection(context);
            String orgId = context.getRequest().getParameter("orgId");
            if (orgId != null && !"".equals(orgId) && !"-1".equals(orgId)) {
                thisOrg = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("orgDetails", (Object)thisOrg);
            }
            String planWorkId = context.getRequest().getParameter("planWorkId");
            ActionPlanWork planWork = new ActionPlanWork(db, Integer.parseInt(planWorkId));
            context.getRequest().setAttribute("actionPlanWork", (Object)planWork);
            ActionPlanWorkNote thisNote = (ActionPlanWorkNote)((Object)context.getFormBean());
            thisNote.setSubmittedBy(this.getUserId(context));
            boolean isValid = this.validateObject(context, db, (Object)thisNote);
            if (isValid) {
                thisNote.insert(db);
                thisNote = new ActionPlanWorkNote();
                thisNote.setSubmitted(DateUtils.roundUpToNextFive(System.currentTimeMillis()));
                context.getRequest().setAttribute("actionPlanWorkNote", (Object)thisNote);
            } else {
                context.getRequest().setAttribute("actionPlanWorkNote", (Object)thisNote);
            }
            ActionPlanWorkNoteList noteList = new ActionPlanWorkNoteList();
            noteList.setPlanWorkId(planWorkId);
            noteList.buildList(db);
            context.getRequest().setAttribute("actionPlanWorkNoteList", (Object)noteList);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "ViewNotesOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddRecipient(ActionContext context) {
        String actionItemId;
        Connection db = null;
        Contact contact = null;
        String actionPlanId = context.getRequest().getParameter("planWorkId");
        if (actionPlanId == null || "".equals(actionPlanId.trim())) {
            actionPlanId = (String)context.getRequest().getAttribute("planWorkId");
        }
        if ((actionItemId = context.getRequest().getParameter("actionItemId")) == null || "".equals(actionItemId.trim())) {
            actionItemId = (String)context.getRequest().getAttribute("actionItemId");
        }
        String contactId = context.getRequest().getParameter("contactId");
        String recipientAdded = (String)context.getRequest().getAttribute("recipientAdded");
        try {
            db = this.getConnection(context);
            ActionPlanWork planWork = new ActionPlanWork();
            planWork.queryRecord(db, Integer.parseInt(actionPlanId));
            context.getRequest().setAttribute("ActionPlanWork", (Object)planWork);
            ActionItemWork itemWork = new ActionItemWork();
            itemWork.setPlanWork(planWork);
            contact = new Contact(db, Integer.parseInt(contactId));
            context.getRequest().setAttribute("contact", (Object)contact);
            itemWork.queryRecord(db, Integer.parseInt(actionItemId));
            if (recipientAdded != null && "true".equals(recipientAdded.trim())) {
                itemWork.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 2));
                itemWork.setLinkItemId(contactId);
                itemWork.attach(db);
            }
            context.getRequest().setAttribute("actionItemWork", (Object)itemWork);
            String surveyKey = ActionPlans.getDbNamePath(context) + "keys" + fs + "survey2.key";
            PrivateString thisKey = new PrivateString(surveyKey);
            itemWork.buildStep(db);
            Campaign thisCampaign = new Campaign(db, itemWork.getStep().getCampaignId());
            Template template = new Template();
            template.setText(thisCampaign.getMessage());
            String value = template.getValue("surveyId");
            if (value != null) {
                String encryptedString = URLEncoder.encode(PrivateString.encrypt(thisKey.getKey(), "id=" + value + ",cid=" + contact.getId()), "UTF-8");
                context.getRequest().setAttribute("surveyURL", (Object)("ProcessSurvey.do?id=" + encryptedString));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AttachRecipientOK";
    }
}

