/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actionplans.base.ActionItemWork;
import org.aspcfs.modules.actionplans.base.ActionPhaseWork;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanList;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class MyActionPlans
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-view")) {
            return "PermissionError";
        }
        return this.executeCommandList(context);
    }

    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-view")) {
            return "PermissionError";
        }
        if (context.getSession().getAttribute("actionPlanWorkListView") == null) {
            context.getSession().setAttribute("actionPlanWorkListView", (Object)"planDashboardView");
            return this.executeCommandDashboard(context);
        }
        String view = context.getRequest().getParameter("planView");
        if (view != null && !"".equals(view)) {
            if ("planListView".equals(view)) {
                context.getSession().setAttribute("actionPlanWorkListView", (Object)"planListView");
                return this.executeCommandList(context);
            }
            if ("planDashboardView".equals(view)) {
                context.getSession().setAttribute("actionPlanWorkListView", (Object)"planDashboardView");
                return this.executeCommandDashboard(context);
            }
        }
        if (context.getSession().getAttribute("actionPlanWorkListView") != null && "planDashboardView".equals(view = (String)context.getSession().getAttribute("actionPlanWorkListView"))) {
            return this.executeCommandDashboard(context);
        }
        return this.executeCommandList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDashboard(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-view")) {
            return "PermissionError";
        }
        int idToUse = 0;
        User thisRec = null;
        int userId = this.getUserId(context);
        int overrideId = StringUtils.parseInt(context.getRequest().getParameter("oid"), -1);
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            overrideId = -1;
            context.getSession().removeAttribute("plansoverride");
            context.getSession().removeAttribute("plansothername");
            context.getSession().removeAttribute("planspreviousId");
        }
        if (overrideId < 0) {
            overrideId = context.getSession().getAttribute("plansoverride") != null ? StringUtils.parseInt((String)context.getSession().getAttribute("plansoverride"), -1) : userId;
        }
        Connection db = null;
        UserList shortChildList = new UserList();
        try {
            db = this.getConnection(context);
            idToUse = overrideId > 0 ? overrideId : this.getUserId(context);
            thisRec = this.getUser(context, idToUse);
            shortChildList = thisRec.getShortChildList();
            shortChildList = UserList.sortEnabledUsers(shortChildList, new UserList());
            context.getRequest().setAttribute("currentUser", (Object)thisRec);
            if (context.getRequest().getParameter("oid") != null && !"true".equals(context.getRequest().getParameter("reset"))) {
                context.getRequest().setAttribute("override", (Object)String.valueOf(idToUse));
                context.getRequest().setAttribute("othername", (Object)thisRec.getContact().getNameFull());
                context.getRequest().setAttribute("previousId", (Object)String.valueOf(thisRec.getManagerId()));
                context.getSession().setAttribute("plansoverride", (Object)String.valueOf(overrideId));
                context.getSession().setAttribute("plansothername", (Object)thisRec.getContact().getNameFull());
                context.getSession().setAttribute("planspreviousId", (Object)String.valueOf(thisRec.getManagerId()));
            }
            PagedListInfo dashboardListInfo = this.getPagedListInfo(context, "actionPlanWorkDashboardInfo");
            dashboardListInfo.setLink("MyActionPlans.do?command=Dashboard");
            if (!dashboardListInfo.hasListFilters()) {
                dashboardListInfo.addFilter(1, "my");
                dashboardListInfo.addFilter(2, "true");
            }
            ActionPlanList actionPlanList = new ActionPlanList();
            actionPlanList.setIncludeOnlyApproved(1);
            actionPlanList.setSiteId(thisRec.getSiteId());
            if (thisRec.getSiteId() == -1) {
                actionPlanList.setIncludeAllSites(true);
            }
            actionPlanList.setBuildPhases(true);
            actionPlanList.setJsEvent("onChange=\"javascript:updateGraph(this);\"");
            actionPlanList.buildList(db);
            context.getRequest().setAttribute("actionPlanList", (Object)actionPlanList);
            context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
            ActionPlan thisPlan = new ActionPlan();
            String planId = context.getRequest().getParameter("planId");
            if (planId != null && !"".equals(planId.trim())) {
                thisPlan.setBuildPhases(true);
                thisPlan.queryRecord(db, Integer.parseInt(planId));
                context.getSession().setAttribute("actionPlanId", (Object)planId);
            } else if ((String)context.getSession().getAttribute("actionPlanId") != null) {
                planId = (String)context.getSession().getAttribute("actionPlanId");
                if (!"".equals(planId.trim())) {
                    thisPlan.setBuildPhases(true);
                    thisPlan.queryRecord(db, Integer.parseInt(planId));
                }
            } else {
                thisPlan = actionPlanList.getPlan();
            }
            context.getRequest().setAttribute("actionPlan", (Object)thisPlan);
            if (thisPlan.getId() > -1) {
                HashMap userPhase = ActionPlanWork.buildUserPhaseMap(db, thisPlan.getId());
                for (User child : shortChildList) {
                    ActionPlanWork.adjustPhaseCount(userPhase, new ArrayList(child.getShortChildList()), child.getId());
                }
                context.getRequest().setAttribute("userPhaseMap", (Object)userPhase);
                ActionPlanWorkList planWorkList = new ActionPlanWorkList();
                planWorkList.setPagedListInfo(dashboardListInfo);
                dashboardListInfo.setSearchCriteria(planWorkList, context);
                planWorkList.setOwner(idToUse);
                planWorkList.setManager(idToUse);
                planWorkList.setCurrentStepOwner(idToUse);
                planWorkList.setAllMyPlans(true);
                if ("all".equals(dashboardListInfo.getFilterValue("listFilter1"))) {
                    planWorkList.setEnabled(-1);
                } else if ("true".equals(dashboardListInfo.getFilterValue("listFilter1"))) {
                    planWorkList.setEnabled(1);
                } else if ("false".equals(dashboardListInfo.getFilterValue("listFilter1"))) {
                    planWorkList.setEnabled(0);
                }
                planWorkList.setViewpoint(idToUse);
                planWorkList.setSiteId(thisRec.getSiteId());
                if (thisRec.getSiteId() == -1) {
                    planWorkList.setIncludeAllSites(true);
                }
                planWorkList.setBuildPhaseWork(true);
                planWorkList.setBuildStepWork(true);
                planWorkList.setBuildLinkedObject(true);
                planWorkList.buildList(db);
                context.getRequest().setAttribute("actionPlanWorkList", (Object)planWorkList);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("shortChildList", (Object)shortChildList);
        return "DashboardOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        PagedListInfo planWorkListInfo = this.getPagedListInfo(context, "actionPlanWorkListInfo");
        planWorkListInfo.setLink("MyActionPlans.do?command=List");
        if (!planWorkListInfo.hasListFilters()) {
            planWorkListInfo.addFilter(1, "myviewpoint");
            planWorkListInfo.addFilter(2, "true");
        }
        User user = this.getUser(context, this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            ActionPlanWorkList accountPlanWorkList = new ActionPlanWorkList();
            accountPlanWorkList.setPagedListInfo(planWorkListInfo);
            accountPlanWorkList.setSiteId(user.getSiteId());
            if (user.getSiteId() == -1) {
                accountPlanWorkList.setIncludeAllSites(true);
            }
            if ("myviewpoint".equals(planWorkListInfo.getFilterValue("listFilter1"))) {
                accountPlanWorkList.setViewpoint(this.getUserId(context));
            } else if ("my".equals(planWorkListInfo.getFilterValue("listFilter1"))) {
                accountPlanWorkList.setOwner(this.getUserId(context));
            } else if ("mymanaged".equals(planWorkListInfo.getFilterValue("listFilter1"))) {
                accountPlanWorkList.setManager(this.getUserId(context));
            } else if ("mywaiting".equals(planWorkListInfo.getFilterValue("listFilter1"))) {
                accountPlanWorkList.setCurrentStepOwner(this.getUserId(context));
            }
            if ("all".equals(planWorkListInfo.getFilterValue("listFilter2"))) {
                accountPlanWorkList.setEnabled(-1);
            } else if ("true".equals(planWorkListInfo.getFilterValue("listFilter2"))) {
                accountPlanWorkList.setEnabled(1);
            } else if ("false".equals(planWorkListInfo.getFilterValue("listFilter2"))) {
                accountPlanWorkList.setEnabled(0);
            }
            accountPlanWorkList.setBuildPhaseWork(true);
            accountPlanWorkList.setBuildStepWork(true);
            accountPlanWorkList.setBuildLinkedObject(true);
            accountPlanWorkList.buildList(db);
            context.getRequest().setAttribute("accountActionPlanWorkList", (Object)accountPlanWorkList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "ListOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String actionPlanId = context.getRequest().getParameter("actionPlanId");
            ActionPlanWork planWork = new ActionPlanWork();
            planWork.setBuildPhaseWork(true);
            planWork.setBuildGlobalPhases(0);
            planWork.setBuildStepWork(true);
            planWork.setBuildLinkedObject(true);
            planWork.queryRecord(db, Integer.parseInt(actionPlanId));
            planWork.buildStepLinks();
            context.getRequest().setAttribute("actionPlanWork", (Object)planWork);
            ActionPlanWork globalPlanWork = new ActionPlanWork();
            globalPlanWork.setBuildPhaseWork(true);
            globalPlanWork.setBuildGlobalPhases(1);
            globalPlanWork.setBuildStepWork(true);
            globalPlanWork.setBuildLinkedObject(true);
            globalPlanWork.queryRecord(db, Integer.parseInt(actionPlanId));
            context.getRequest().setAttribute("globalActionPlanWork", (Object)globalPlanWork);
            SystemStatus thisSystem = this.getSystemStatus(context);
            LookupList ratingLookup = thisSystem.getLookupList(db, "lookup_contact_rating");
            ratingLookup.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
            ratingLookup.setJsEvent("onChange=\"javascript:updateRating(this);\"");
            context.getRequest().setAttribute("ratingLookup", (Object)ratingLookup);
            context.getRequest().setAttribute("systemStatus", (Object)thisSystem);
            context.getRequest().setAttribute("objectName", (Object)ActionPlan.getDescriptionGivenConstantId(db, 912051336));
            context.getRequest().setAttribute("constants", (Object)ActionPlan.buildConstants(db));
            String notAttached = context.getRequest().getParameter("notAttached");
            if (notAttached != null && "true".equals(notAttached.trim())) {
                context.getRequest().setAttribute("actionWarning", (Object)thisSystem.getLabel("", "The recipient was not added to the active campaign"));
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "DetailsOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    public String executeCommandEnable(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-edit")) {
            return "PermissionError";
        }
        return "EnableOK";
    }

    public String executeCommandReassign(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-edit")) {
            return "PermissionError";
        }
        return "ReassignOK";
    }

    public String executeCommandAttach(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-edit")) {
            return "PermissionError";
        }
        return "AttachOK";
    }

    public String executeCommandResetFolderAttachment(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-delete")) {
            return "PermissionError";
        }
        return "ResetFolderAttachmentOK";
    }

    public String executeCommandViewNotes(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-edit")) {
            return "PermissionError";
        }
        return "ViewNotesOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyStatus(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus thisSystem = this.getSystemStatus(context);
            String itemId = context.getRequest().getParameter("itemId");
            ActionItemWork itemWork = new ActionItemWork(db, Integer.parseInt(itemId));
            itemWork.buildStep(db);
            context.getRequest().setAttribute("actionItemWork", (Object)itemWork);
            ActionItemWork nextItemWork = itemWork.getNextItem(db);
            if (nextItemWork == null) {
                nextItemWork = new ActionItemWork();
            } else {
                nextItemWork.buildStep(db);
                nextItemWork.buildLinkedObject(db);
            }
            context.getRequest().setAttribute("nextItemWork", (Object)nextItemWork);
            String planId = context.getRequest().getParameter("planId");
            ActionPlanWork planWork = new ActionPlanWork(db, Integer.parseInt(planId));
            UserList userList = new UserList();
            userList.add(thisSystem.getUser(planWork.getManagerId()));
            if (planWork.getManagerId() != planWork.getAssignedTo()) {
                userList.add(thisSystem.getUser(planWork.getAssignedTo()));
            }
            context.getRequest().setAttribute("ownerList", (Object)userList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "ModifyStatusOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateStatus(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean status = false;
        ActionItemWork itemWork = null;
        ActionPhaseWork phaseWork = null;
        ActionPhaseWork nextPhaseWork = null;
        ActionItemWork nextItem2 = null;
        ActionPlanWork planWork = null;
        ActionItemWork oldItem = null;
        boolean sendEmailForAllNewSteps = false;
        boolean sendEmailForNextStep = false;
        try {
            db = this.getConnection(context);
            String itemId = context.getRequest().getParameter("stepId");
            String nextStepId = context.getRequest().getParameter("nextStepId");
            String statusId = context.getRequest().getParameter("statusId");
            if (itemId != null && Integer.parseInt(itemId) > 0) {
                itemWork = new ActionItemWork();
                itemWork.setBuildStep(true);
                itemWork.queryRecord(db, Integer.parseInt(itemId));
                phaseWork = new ActionPhaseWork(db, itemWork.getPhaseWorkId());
                planWork = new ActionPlanWork(db, phaseWork.getPlanWorkId());
                planWork.setBuildLinkedObject(true);
                planWork.buildLinkedObject(db);
                itemWork.setPlanWork(planWork);
                oldItem = new ActionItemWork();
                oldItem.setPlanWork(planWork);
                oldItem.queryRecord(db, itemWork.getId());
                if (statusId != null && Integer.parseInt(statusId) > 0) {
                    itemWork.setStatusId(statusId);
                    itemWork.setModifiedBy(this.getUserId(context));
                }
                if (nextStepId != null && Integer.parseInt(nextStepId) > 0) {
                    nextItem2 = new ActionItemWork();
                    nextItem2.setBuildStep(true);
                    nextItem2.queryRecord(db, Integer.parseInt(nextStepId));
                    nextItem2.setPlanWork(planWork);
                    if (nextItem2.getPhaseWorkId() != itemWork.getPhaseWorkId()) {
                        nextPhaseWork = new ActionPhaseWork(db, nextItem2.getPhaseWorkId());
                        nextPhaseWork.setPlanWork(planWork);
                        nextPhaseWork.setBuildLinkedObject(true);
                        nextPhaseWork.buildPhaseObject(db);
                        nextPhaseWork.buildStepWork(db);
                        if (nextPhaseWork != null && nextPhaseWork.getPhase().getRandom() && nextPhaseWork.noStepComplete()) {
                            sendEmailForAllNewSteps = true;
                        }
                    }
                    status = itemWork.updateStatus(db, nextItem2);
                    this.processUpdateHook(context, (Object)oldItem, (Object)itemWork);
                    if (!sendEmailForAllNewSteps && nextItem2 != null) {
                        this.processUpdateHook(context, (Object)itemWork, (Object)nextItem2);
                    }
                } else {
                    status = itemWork.updateStatus(db, null);
                    phaseWork.setBuildStepWork(true);
                    phaseWork.setBuildPhase(true);
                    phaseWork.queryRecord(db, itemWork.getPhaseWorkId());
                    this.processUpdateHook(context, (Object)oldItem, (Object)itemWork);
                    nextPhaseWork = phaseWork.getNextPhase(db);
                    if (phaseWork.getPhase().getRandom() && phaseWork.allStepsComplete() && nextPhaseWork != null) {
                        nextPhaseWork.setPlanWork(planWork);
                        nextPhaseWork.setBuildLinkedObject(true);
                        nextPhaseWork.buildStepWork(db);
                        nextPhaseWork.buildPhaseObject(db);
                        if (nextPhaseWork.getPhase().getRandom() && nextPhaseWork.noStepComplete()) {
                            sendEmailForAllNewSteps = true;
                        } else if (!nextPhaseWork.getPhase().getRandom() && nextPhaseWork.noStepComplete() && nextPhaseWork.getItemWorkList().size() > 0) {
                            nextItem2 = (ActionItemWork)((Object)nextPhaseWork.getItemWorkList().get(0));
                            nextItem2.setPlanWork(planWork);
                            nextItem2.buildStep(db);
                            nextItem2.buildLinkedObject(db);
                            this.processUpdateHook(context, (Object)itemWork, (Object)nextItem2);
                        }
                    }
                }
            }
            if (sendEmailForAllNewSteps && nextPhaseWork != null && nextPhaseWork.getItemWorkList() != null) {
                for (ActionItemWork nextItem2 : nextPhaseWork.getItemWorkList()) {
                    nextItem2.setPlanWork(planWork);
                    nextItem2 = new ActionItemWork(db, nextItem2.getId());
                    nextItem2.buildStep(db);
                    nextItem2.buildLinkedObject(db);
                    this.processUpdateHook(context, (Object)itemWork, (Object)nextItem2);
                }
            }
            String returnUrl = context.getRequest().getParameter("returnUrl");
            context.getRequest().setAttribute("refreshUrl", (Object)returnUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if ("true".equals(context.getRequest().getParameter("popup"))) {
            return "UpdateStatusOK";
        }
        return this.executeCommandDetails(context);
    }

    public String executeCommandRevertStatus(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-edit")) {
            return "PermissionError";
        }
        return "RevertStatusOK";
    }

    public String executeCommandUpdateGlobalStatus(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-edit")) {
            return "PermissionError";
        }
        return "UpdateGlobalStatusOK";
    }

    public String executeCommandRestart(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-edit")) {
            return "PermissionError";
        }
        return "RestartOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateRating(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String planId = context.getRequest().getParameter("planId");
            String rating = context.getRequest().getParameter("rating");
            ActionPlanWork planWork = new ActionPlanWork();
            planWork.setBuildLinkedObject(true);
            planWork.queryRecord(db, Integer.parseInt(planId));
            planWork.updateRating(db, Integer.parseInt(rating));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "myhomepage-action-plans-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String planWorkId = context.getRequest().getParameter("actionPlanId");
            ActionPlanWork planWork = new ActionPlanWork(db, Integer.parseInt(planWorkId));
            planWork.buildPhaseWork(db);
            planWork.buildLinkedObject(db);
            planWork.delete(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandView(context);
    }

    public String executeCommandConfirmRevert(ActionContext context) {
        return "GoConfirmRevertOK";
    }

    public String executeCommandRevertToLead(ActionContext context) {
        return "GoRevertToLeadOK";
    }
}

