/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import com.darkhorseventures.framework.actions.ActionContext;
import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.FileItem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actionplans.base.ActionItemWorkList;
import org.aspcfs.modules.actionplans.base.ActionItemWorkNote;
import org.aspcfs.modules.actionplans.base.ActionItemWorkNoteList;
import org.aspcfs.modules.actionplans.base.ActionItemWorkSelectionList;
import org.aspcfs.modules.actionplans.base.ActionPhaseWork;
import org.aspcfs.modules.actionplans.base.ActionPhaseWorkList;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanEmail;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.modules.actionplans.base.ActionStep;
import org.aspcfs.modules.admin.base.Role;
import org.aspcfs.modules.admin.base.UserGroup;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.contacts.base.Call;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.relationships.base.RelationshipList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.UserUtils;
import org.aspcfs.utils.web.LookupList;

public class ActionItemWork
extends GenericBean {
    private int id = -1;
    private int phaseWorkId = -1;
    private int actionStepId = -1;
    private int statusId = -1;
    private int ownerId = -1;
    private Timestamp startDate = null;
    private Timestamp endDate = null;
    private int level = -1;
    private int linkModuleId = -1;
    private int linkItemId = -1;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private String stepDescription = null;
    protected int permissionType = -1;
    private int estimatedDuration = -1;
    private int parentId = -1;
    private int actionId = -1;
    private boolean allowSkipToHere = false;
    private boolean actionRequired = false;
    private String label = null;
    private String targetRelationship = null;
    private boolean allowUpdate = true;
    private boolean hasNext = false;
    private ActionItemWork nextStep = null;
    private boolean buildLinkedObject = false;
    private Contact contact = null;
    private OpportunityComponent component = null;
    private FileItem fileItem = null;
    private Call activity = null;
    private CustomFieldCategory customFieldCategory = null;
    private ActionItemWorkNote note = null;
    private ActionItemWorkNoteList noteList = null;
    private ActionItemWorkSelectionList selectionList = null;
    private RelationshipList relationshipList = null;
    private ActionStep step = null;
    private UserList groupUsers = null;
    private UserList roleUsers = null;
    private UserList departmentUsers = null;
    private String userGroupName = null;
    private String departmentName = null;
    private String roleName = null;
    private boolean buildStep = false;
    private int groupId = -1;
    private ActionPlanWork planWork = null;

    public boolean getAllowUpdate() {
        return this.allowUpdate;
    }

    public void setAllowUpdate(boolean tmp) {
        this.allowUpdate = tmp;
    }

    public void setAllowUpdate(String tmp) {
        this.allowUpdate = DatabaseUtils.parseBoolean(tmp);
    }

    public String getTargetRelationship() {
        return this.targetRelationship;
    }

    public void setTargetRelationship(String tmp) {
        this.targetRelationship = tmp;
    }

    public boolean getBuildStep() {
        return this.buildStep;
    }

    public void setBuildStep(boolean tmp) {
        this.buildStep = tmp;
    }

    public void setBuildStep(String tmp) {
        this.buildStep = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getActionRequired() {
        return this.actionRequired;
    }

    public void setActionRequired(boolean tmp) {
        this.actionRequired = tmp;
    }

    public void setActionRequired(String tmp) {
        this.actionRequired = DatabaseUtils.parseBoolean(tmp);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String tmp) {
        this.label = tmp;
    }

    public ActionItemWorkNote getNote() {
        return this.note;
    }

    public void setNote(ActionItemWorkNote tmp) {
        this.note = tmp;
    }

    public ActionItemWorkNoteList getNoteList() {
        return this.noteList;
    }

    public void setNoteList(ActionItemWorkNoteList tmp) {
        this.noteList = tmp;
    }

    public RelationshipList getRelationshipList() {
        return this.relationshipList;
    }

    public void setRelationshipList(RelationshipList tmp) {
        this.relationshipList = tmp;
    }

    public ActionItemWorkSelectionList getSelectionList() {
        return this.selectionList;
    }

    public void setSelectionList(ActionItemWorkSelectionList tmp) {
        this.selectionList = tmp;
    }

    public boolean getHasNext() {
        return this.hasNext;
    }

    public void setHasNext(boolean tmp) {
        this.hasNext = tmp;
    }

    public void setHasNext(String tmp) {
        this.hasNext = DatabaseUtils.parseBoolean(tmp);
    }

    public ActionItemWork getNextStep() {
        return this.nextStep;
    }

    public void setNextStep(ActionItemWork tmp) {
        this.nextStep = tmp;
    }

    public boolean getAllowSkipToHere() {
        return this.allowSkipToHere;
    }

    public void setAllowSkipToHere(boolean tmp) {
        this.allowSkipToHere = tmp;
    }

    public void setAllowSkipToHere(String tmp) {
        this.allowSkipToHere = DatabaseUtils.parseBoolean(tmp);
    }

    public int getPermissionType() {
        return this.permissionType;
    }

    public void setPermissionType(int tmp) {
        this.permissionType = tmp;
    }

    public void setPermissionType(String tmp) {
        this.permissionType = Integer.parseInt(tmp);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact tmp) {
        this.contact = tmp;
    }

    public OpportunityComponent getComponent() {
        return this.component;
    }

    public void setComponent(OpportunityComponent tmp) {
        this.component = tmp;
    }

    public FileItem getFileItem() {
        return this.fileItem;
    }

    public void setFileItem(FileItem tmp) {
        this.fileItem = tmp;
    }

    public Call getActivity() {
        return this.activity;
    }

    public void setActivity(Call tmp) {
        this.activity = tmp;
    }

    public CustomFieldCategory getCustomFieldCategory() {
        return this.customFieldCategory;
    }

    public void setCustomFieldCategory(CustomFieldCategory tmp) {
        this.customFieldCategory = tmp;
    }

    public boolean getBuildLinkedObject() {
        return this.buildLinkedObject;
    }

    public void setBuildLinkedObject(boolean tmp) {
        this.buildLinkedObject = tmp;
    }

    public void setBuildLinkedObject(String tmp) {
        this.buildLinkedObject = DatabaseUtils.parseBoolean(tmp);
    }

    public int getActionId() {
        return this.actionId;
    }

    public void setActionId(int tmp) {
        this.actionId = tmp;
    }

    public void setActionId(String tmp) {
        this.actionId = Integer.parseInt(tmp);
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public int getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public void setEstimatedDuration(int tmp) {
        this.estimatedDuration = tmp;
    }

    public void setEstimatedDuration(String tmp) {
        this.estimatedDuration = Integer.parseInt(tmp);
    }

    public String getStepDescription() {
        return this.stepDescription;
    }

    public void setStepDescription(String tmp) {
        this.stepDescription = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getPhaseWorkId() {
        return this.phaseWorkId;
    }

    public void setPhaseWorkId(int tmp) {
        this.phaseWorkId = tmp;
    }

    public void setPhaseWorkId(String tmp) {
        this.phaseWorkId = Integer.parseInt(tmp);
    }

    public int getActionStepId() {
        return this.actionStepId;
    }

    public void setActionStepId(int tmp) {
        this.actionStepId = tmp;
    }

    public void setActionStepId(String tmp) {
        this.actionStepId = Integer.parseInt(tmp);
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(int tmp) {
        this.ownerId = tmp;
    }

    public void setOwnerId(String tmp) {
        this.ownerId = Integer.parseInt(tmp);
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Timestamp tmp) {
        this.startDate = tmp;
    }

    public void setStartDate(String tmp) {
        this.startDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Timestamp tmp) {
        this.endDate = tmp;
    }

    public void setEndDate(String tmp) {
        this.endDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setLinkItemId(String tmp) {
        this.linkItemId = Integer.parseInt(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int tmp) {
        this.groupId = tmp;
    }

    public void setGroupId(String tmp) {
        this.groupId = Integer.parseInt(tmp);
    }

    public ActionPlanWork getPlanWork() {
        return this.planWork;
    }

    public void setPlanWork(ActionPlanWork tmp) {
        this.planWork = tmp;
    }

    public ActionItemWork() {
    }

    public ActionItemWork(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ActionItemWork(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public ActionItemWork(Connection db, int linkModuleId, int linkItemId) throws SQLException {
        if (linkModuleId == -1) {
            throw new SQLException("Invalid ModuleId Specified");
        }
        if (linkItemId == -1) {
            throw new SQLException("Invalid Item Id Specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT item_work_id FROM action_item_work WHERE link_module_id = ? AND link_item_id = ? ");
        pst.setInt(1, linkModuleId);
        pst.setInt(2, linkItemId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.id = rs.getInt("item_work_id");
        }
        rs.close();
        pst.close();
        this.queryRecord(db, this.id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Action Item Work ID");
        }
        PreparedStatement pst = db.prepareStatement("SELECT aiw.*, acs.description, acs.estimated_duration, acs.parent_id, acs.action_id, acs.permission_type, acs.allow_skip_to_here, acs.action_required, acs.label, acs.target_relationship, acs.allow_update FROM action_item_work aiw LEFT JOIN action_step acs ON (aiw.action_step_id = acs.step_id) LEFT JOIN action_phase_work apw ON (aiw.phase_work_id = apw.phase_work_id) WHERE aiw.item_work_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.buildStep) {
            this.buildStep(db);
        }
        if (this.buildLinkedObject) {
            this.buildLinkedObject(db);
        }
        if (this.getId() == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    public void buildStep(Connection db) throws SQLException {
        this.step = new ActionStep(db, this.getActionStepId());
    }

    public void buildUserLists(Connection db) throws SQLException {
        switch (this.step.getPermissionType()) {
            case 2: {
                this.roleUsers = new UserList();
                this.roleUsers.setRoleId(this.step.getRoleId());
                this.roleUsers.buildList(db);
                Role role = new Role(db, this.step.getRoleId());
                this.setRoleName(role.getRole());
                break;
            }
            case 3: {
                this.departmentUsers = new UserList();
                this.departmentUsers.setDepartment(this.step.getDepartmentId());
                this.departmentUsers.buildList(db);
                LookupList list = new LookupList(db, "lookup_department");
                this.setDepartmentName(list.getSelectedValue(this.step.getDepartmentId()));
                break;
            }
            case 7: {
                this.groupUsers = new UserList();
                ActionPhaseWork phaseWork = new ActionPhaseWork(db, this.getPhaseWorkId());
                if (this.getPlanWork() == null) {
                    this.planWork = new ActionPlanWork();
                    this.planWork.setBuildLinkedObject(true);
                    this.planWork.queryRecord(db, phaseWork.getPlanWorkId());
                }
                if (this.planWork.getLinkModuleId() == ActionPlan.getMapIdGivenConstantId(db, 2) || this.planWork.getLinkModuleId() == ActionPlan.getMapIdGivenConstantId(db, 42420034) || this.planWork.getLinkModuleId() != ActionPlan.getMapIdGivenConstantId(db, 912051329)) break;
                if (this.planWork.getTicket() == null || this.planWork.getTicket().getId() <= 0) {
                    this.planWork.buildLinkedObject(db);
                }
                if (this.planWork.getTicket().getUserGroupId() == -1) break;
                this.groupUsers.setUserGroupId(this.planWork.getTicket().getUserGroupId());
                this.groupUsers.buildList(db);
                UserGroup group = new UserGroup(db, this.planWork.getTicket().getUserGroupId());
                this.setUserGroupName(group.getName());
                break;
            }
            case 8: {
                this.groupUsers = new UserList();
                if (this.step.getUserGroupId() == -1) break;
                this.groupUsers.setUserGroupId(this.step.getUserGroupId());
                this.groupUsers.buildList(db);
                this.setUserGroupName(this.step.getUserGroupName());
                break;
            }
            case 5: {
                this.departmentUsers = new UserList();
                this.departmentUsers.setManagerId(this.getOwnerId());
                this.departmentUsers.setEnabled(1);
                this.departmentUsers.buildList(db);
                this.setDepartmentName("");
                break;
            }
            case 4: {
                this.setDepartmentName("");
                break;
            }
        }
    }

    public boolean userHasPermission(int userId, HttpServletRequest request) {
        boolean result = false;
        switch (this.step.getPermissionType()) {
            case 2: {
                result = this.roleUsers != null && this.roleUsers.getUser(userId) != null;
                break;
            }
            case 3: {
                result = this.departmentUsers != null && this.departmentUsers.getUser(userId) != null;
                break;
            }
            case 7: {
                result = this.groupUsers != null && this.groupUsers.getUser(userId) != null;
                break;
            }
            case 8: {
                result = this.groupUsers != null && this.groupUsers.getUser(userId) != null;
                break;
            }
            case 0: {
                result = userId == this.planWork.getManagerId();
                break;
            }
            case 4: {
                result = this.getOwnerId() == userId || UserUtils.getUserIdRange(request).indexOf(String.valueOf(this.getOwnerId())) != -1;
                break;
            }
            case 5: {
                result = this.departmentUsers != null && this.departmentUsers.getUser(userId) != null || this.getOwnerId() == userId;
                break;
            }
            case 6: {
                result = userId == this.getOwnerId() || userId == this.planWork.getManagerId();
                break;
            }
            case -1: {
                result = this.getOwnerId() == userId;
                break;
            }
            default: {
                boolean bl = result = this.getOwnerId() == userId;
            }
        }
        if (this.step.getAllowSkipToHere() && userId == this.planWork.getManagerId()) {
            result = true;
        }
        return result;
    }

    public void buildLinkedObject(Connection db) throws SQLException {
        this.step = new ActionStep(db, this.getActionStepId());
        if (this.getRoleName() == null && this.getDepartmentName() == null && this.getUserGroupName() == null) {
            this.buildUserLists(db);
        }
        if (this.linkItemId > -1) {
            switch (this.actionId) {
                case 110061039: {
                    this.contact = new Contact(db, this.linkItemId);
                    break;
                }
                case 302061653: {
                    this.contact = new Contact(db, this.linkItemId);
                    break;
                }
                case 110061030: {
                    this.component = new OpportunityComponent(db, this.linkItemId);
                    break;
                }
                case 110061031: {
                    this.fileItem = new FileItem(db, this.linkItemId);
                    break;
                }
                case 110061032: {
                    this.activity = new Call(db, this.linkItemId);
                    break;
                }
                case 110061033: {
                    int categoryId = CustomFieldCategory.getIdFromRecord(db, this.linkItemId);
                    if (categoryId == -1) break;
                    this.customFieldCategory = new CustomFieldCategory(db, categoryId);
                    this.customFieldCategory.setLinkModuleId(1);
                    if (this.getPlanWork() == null || this.getPlanWork().getLinkItemId() == -1) break;
                    this.customFieldCategory.setLinkItemId(this.getPlanWork().getLinkItemId());
                    this.customFieldCategory.setRecordId(this.linkItemId);
                    this.customFieldCategory.setBuildResources(true);
                    this.customFieldCategory.buildResources(db);
                    break;
                }
                case 110061035: {
                    this.note = new ActionItemWorkNote(db, this.linkItemId);
                    break;
                }
                case 110061036: {
                    this.note = new ActionItemWorkNote(db, this.linkItemId);
                    this.noteList = new ActionItemWorkNoteList();
                    this.noteList.setItemWorkId(this.id);
                    this.noteList.buildList(db);
                    break;
                }
                case 110061037: {
                    this.selectionList = new ActionItemWorkSelectionList();
                    this.selectionList.setItemWorkId(this.id);
                    this.selectionList.buildList(db);
                    break;
                }
                case 110061040: {
                    this.relationshipList = new RelationshipList();
                    if (this.planWork == null) break;
                    if (this.planWork.getLinkModuleId() == ActionPlan.getMapIdGivenConstantId(db, 42420034)) {
                        this.relationshipList.setCategoryIdMapsFrom(42420034);
                    }
                    this.relationshipList.setObjectIdMapsFrom(this.planWork.getLinkItemId());
                    this.relationshipList.setObjectIdMapsTo(-1);
                    if (this.targetRelationship.endsWith("_reciprocal")) {
                        this.relationshipList.setObjectIdMapsTo(this.planWork.getLinkItemId());
                        this.relationshipList.setObjectIdMapsFrom(-1);
                        this.relationshipList.setTypeId(Integer.parseInt(this.targetRelationship.substring(0, this.targetRelationship.indexOf("_"))));
                    } else {
                        this.relationshipList.setTypeId(Integer.parseInt(this.targetRelationship));
                    }
                    this.relationshipList.buildList(db);
                    if (this.step == null) {
                        this.buildStep(db);
                    }
                    this.relationshipList.filterAccounts(this.step.getAccountTypes());
                }
            }
        }
    }

    public void resetAttachment(Connection db) throws SQLException {
        this.linkModuleId = -1;
        this.linkItemId = -1;
        PreparedStatement pst = db.prepareStatement("UPDATE action_item_work SET link_module_id = ?, link_item_id = ? WHERE item_work_id = ? ");
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.linkModuleId);
        DatabaseUtils.setInt(pst, ++i, this.linkItemId);
        pst.setInt(++i, this.getId());
        pst.executeUpdate();
        pst.close();
    }

    public void add(ActionItemWorkNote thisNote) {
        if (this.actionId == 110061035) {
            this.setNote(thisNote);
        } else if (this.actionId == 110061036) {
            if (this.noteList == null) {
                this.noteList = new ActionItemWorkNoteList();
            }
            this.noteList.add(thisNote);
        }
    }

    public boolean isCurrent() {
        ActionPhaseWork phaseWork;
        boolean result;
        boolean bl = result = this.startDate != null && this.endDate == null && this.statusId != 1;
        if (this.getPlanWork() != null && this.getPlanWork().getPhaseWorkList() != null && (phaseWork = this.getPlanWork().getPhaseWorkList().getPhaseWorkById(this.getPhaseWorkId())) != null && phaseWork.getPhase() != null && phaseWork.getPhase().getRandom() && phaseWork.getItemWorkList() != null && phaseWork.getItemWorkList().size() > 0 && !phaseWork.allStepsComplete()) {
            result = false;
        }
        return result;
    }

    public boolean isCurrentSkip() {
        ActionItemWork nextItem;
        for (nextItem = this.nextStep; nextItem != null && !nextItem.allowsUpdate(); nextItem = nextItem.getNextStep()) {
        }
        if (nextItem == null) {
            return true;
        }
        return nextItem != null && nextItem.isCurrent();
    }

    public boolean isPrevious() {
        if (this.isCurrent()) {
            return false;
        }
        if (this.hasNext) {
            ActionPhaseWork nextPhaseWork;
            if (this.nextStep != null && !this.nextStep.allowsUpdate() && this.isCurrentSkip()) {
                return true;
            }
            if (this.nextStep != null && this.nextStep.isCurrent()) {
                return true;
            }
            if (this.nextStep != null && this.nextStep.getPlanWork() != null && this.getPlanWork().getPhaseWorkList() != null && (nextPhaseWork = this.nextStep.getPlanWork().getPhaseWorkList().getPhaseWorkById(this.nextStep.getPhaseWorkId())) != null && nextPhaseWork.getPhase() != null && nextPhaseWork.getPhase().getRandom() && nextPhaseWork.getItemWorkList() != null && nextPhaseWork.getItemWorkList().size() > 0 && nextPhaseWork.noStepComplete()) {
                return true;
            }
        } else if (this.hasStatus()) {
            return true;
        }
        return false;
    }

    public void attach(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Action Item Work ID not specified");
        }
        if (this.linkModuleId == -1) {
            throw new SQLException("Link Module ID not specified");
        }
        if (this.linkItemId == -1) {
            throw new SQLException("Link Item ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("UPDATE action_item_work SET link_module_id = ?, link_item_id = ? WHERE item_work_id = ? ");
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.linkModuleId);
        DatabaseUtils.setInt(pst, ++i, this.linkItemId);
        pst.setInt(++i, this.id);
        pst.executeUpdate();
        pst.close();
    }

    public void deleteFolderAttachment(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Action Item Work ID not specified");
        }
        if (this.linkModuleId == -1) {
            throw new SQLException("Link Module ID not specified");
        }
        int newRecordId = -1;
        String sql = "SELECT MAX(record_id) AS record_id FROM custom_field_record cfr WHERE cfr.link_module_id = ? AND cfr.link_item_id = ? AND cfr.category_id = ? ";
        PreparedStatement pst = db.prepareStatement(sql);
        pst.setInt(1, 1);
        pst.setInt(2, this.planWork.getOrganization().getOrgId());
        pst.setInt(3, this.customFieldCategory.getId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            newRecordId = DatabaseUtils.getInt(rs, "record_id");
        }
        rs.close();
        pst.close();
        pst = db.prepareStatement("UPDATE action_item_work SET link_item_id = ? " + (newRecordId == -1 ? ", link_module_id = ? " : "") + "WHERE item_work_id = ? ");
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, newRecordId);
        if (newRecordId == -1) {
            DatabaseUtils.setInt(pst, ++i, -1);
        }
        pst.setInt(++i, this.id);
        pst.executeUpdate();
        pst.close();
        this.setLinkItemId(newRecordId);
    }

    public void reassign(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Action Item Work ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("UPDATE action_item_work SET owner = ? WHERE item_work_id = ? ");
        int i = 0;
        pst.setInt(++i, this.ownerId);
        pst.setInt(++i, this.id);
        pst.executeUpdate();
        pst.close();
    }

    public boolean isComplete() {
        return this.statusId == 2;
    }

    public boolean hasStatus() {
        return this.statusId == 2 || this.statusId == 1 || this.statusId == 0;
    }

    public boolean update(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE action_item_work SET status_id = ?, start_date = ?, end_date = ?, owner = ? WHERE item_work_id = ? ");
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.statusId);
        DatabaseUtils.setTimestamp(pst, ++i, this.startDate);
        DatabaseUtils.setTimestamp(pst, ++i, this.endDate);
        DatabaseUtils.setInt(pst, ++i, this.ownerId);
        pst.setInt(++i, this.id);
        pst.executeUpdate();
        pst.close();
        return true;
    }

    public boolean updateAttachment(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE action_item_work SET link_item_id = ?, link_module_id = ? WHERE item_work_id = ? ");
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.linkItemId);
        DatabaseUtils.setInt(pst, ++i, this.linkModuleId);
        pst.setInt(++i, this.id);
        pst.executeUpdate();
        pst.close();
        return true;
    }

    public boolean updateStatus(Connection db) throws SQLException {
        boolean commit = false;
        boolean count = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.update(db);
            ActionPhaseWork phaseWork = new ActionPhaseWork();
            phaseWork.setBuildStepWork(true);
            phaseWork.queryRecord(db, this.getPhaseWorkId());
            ActionPlanWork planWork = null;
            planWork = this.getPlanWork() != null ? this.getPlanWork() : new ActionPlanWork(db, phaseWork.getPlanWorkId());
            planWork.setModifiedBy(this.getModifiedBy());
            if (this.allowSkipToHere) {
                ActionItemWorkList actionPlanSteps = new ActionItemWorkList();
                actionPlanSteps.setPlanWorkId(planWork.getId());
                actionPlanSteps.buildList(db);
                ActionItemWorkList skippedSteps = this.getSkippedSteps(actionPlanSteps);
                if (this.getPlanWork() == null || this.getPlanWork().getPhaseWorkList() == null || this.getPlanWork().getPhaseWorkList().size() == 0) {
                    planWork.setBuildPhaseWork(true);
                    planWork.buildPhaseWork(db);
                    this.setPlanWork(planWork);
                }
                this.removeGlobalSteps(skippedSteps);
                skippedSteps.updateStatus(db, 1);
                planWork.setCurrentPhaseId(phaseWork.getActionPhaseId());
            }
            phaseWork = new ActionPhaseWork();
            phaseWork.setBuildPhase(true);
            phaseWork.setBuildLinkedObject(true);
            phaseWork.setBuildStepWork(true);
            phaseWork.setPlanWork(planWork);
            phaseWork.queryRecord(db, this.getPhaseWorkId());
            if (phaseWork.allStepsComplete()) {
                phaseWork.setStatusId(this.statusId);
                phaseWork.setModifiedBy(this.modifiedBy);
                phaseWork.setEndDate(new Timestamp(new Date().getTime()));
                phaseWork.update(db);
                ActionPhaseWork nextPhase = phaseWork.getNextPhase(db);
                if (nextPhase == null) {
                    planWork.setCurrentPhaseId(-1);
                } else {
                    nextPhase.setModifiedBy(this.modifiedBy);
                    nextPhase.setStartDate(new Timestamp(new Date().getTime()));
                    nextPhase.update(db);
                    nextPhase.setPlanWork(planWork);
                    nextPhase.buildStepWork(db);
                    nextPhase.buildPhaseObject(db);
                    if (nextPhase.getPhase().getRandom()) {
                        nextPhase.buildStepWork(db);
                        nextPhase.startRandomPhase(db);
                    }
                    if (phaseWork.getPhase().getRandom() && !nextPhase.getPhase().getRandom() && nextPhase.getItemWorkList() != null && nextPhase.getItemWorkList().size() > 0) {
                        ActionItemWork nextStep = (ActionItemWork)((Object)nextPhase.getItemWorkList().get(0));
                        nextStep.setStartDate(new Timestamp(new Date().getTime()));
                        nextStep.setPlanWork(planWork);
                        nextStep.updateStatus(db);
                    }
                    planWork.setCurrentPhaseId(nextPhase.getActionPhaseId());
                }
            }
            planWork.update(db);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean updateStatus(Connection db, ActionItemWork nextStep) throws SQLException {
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            if (this.allowSkipToHere) {
                this.setStartDate(new Timestamp(new Date().getTime()));
            }
            this.setEndDate(new Timestamp(new Date().getTime()));
            this.updateStatus(db);
            if (nextStep != null) {
                nextStep.setStartDate(new Timestamp(new Date().getTime()));
                nextStep.setPlanWork(this.getPlanWork());
                if (!nextStep.allowsUpdate()) {
                    ActionItemWorkList actionPlanSteps = new ActionItemWorkList();
                    actionPlanSteps.setPlanWorkId(this.planWork.getId());
                    actionPlanSteps.buildList(db);
                    ActionItemWorkList jumpSteps = this.getJumpedSteps(actionPlanSteps);
                    jumpSteps.updateStatus(db, 0);
                    ActionItemWork currentStep = this.getNextCurrentItem(actionPlanSteps);
                    if (currentStep != null) {
                        currentStep.setStartDate(new Timestamp(new Date().getTime()));
                        currentStep.setPlanWork(this.getPlanWork());
                        currentStep.updateStatus(db);
                        ActionPhaseWork currentPhase = new ActionPhaseWork(db, currentStep.getPhaseWorkId());
                        this.getPlanWork().setCurrentPhaseId(currentPhase.getActionPhaseId());
                        this.getPlanWork().update(db);
                    }
                } else {
                    nextStep.updateStatus(db);
                }
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void revertStatus(Connection db) throws SQLException {
        boolean commit = false;
        boolean allStepsComplete = false;
        boolean completedOneSkippedStep = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            ActionPhaseWork phaseWork = new ActionPhaseWork();
            phaseWork.setBuildStepWork(true);
            phaseWork.setBuildPhase(true);
            phaseWork.queryRecord(db, this.getPhaseWorkId());
            allStepsComplete = phaseWork.allStepsComplete();
            PreparedStatement pst = db.prepareStatement("UPDATE action_item_work SET status_id = ?, start_date = ?, end_date = ? WHERE item_work_id = ? ");
            int i = 0;
            DatabaseUtils.setInt(pst, ++i, this.statusId);
            DatabaseUtils.setTimestamp(pst, ++i, this.startDate);
            DatabaseUtils.setTimestamp(pst, ++i, this.endDate);
            pst.setInt(++i, this.id);
            pst.executeUpdate();
            pst.close();
            phaseWork = new ActionPhaseWork();
            phaseWork.setBuildStepWork(true);
            phaseWork.setBuildPhase(true);
            phaseWork.queryRecord(db, this.getPhaseWorkId());
            ActionPlanWork planWork = null;
            if (this.getPlanWork() != null) {
                this.getPlanWork().setBuildPhaseWork(true);
                this.getPlanWork().buildPhaseWork(db);
                planWork = this.getPlanWork();
            } else {
                planWork = new ActionPlanWork(db, phaseWork.getPlanWorkId());
                planWork.setBuildPhaseWork(true);
                planWork.buildPhaseWork(db);
                this.setPlanWork(planWork);
            }
            planWork.setModifiedBy(this.getModifiedBy());
            if (this.allowSkipToHere) {
                ActionItemWorkList actionPlanSteps = new ActionItemWorkList();
                actionPlanSteps.setPlanWorkId(planWork.getId());
                actionPlanSteps.buildList(db);
                ActionItemWorkList skippedSteps = this.getAlreadySkippedSteps(actionPlanSteps, true);
                skippedSteps.revertStatus(db, -1);
                ActionPhaseWorkList skippedPhases = new ActionPhaseWorkList();
                skippedPhases.setPhaseWorks(skippedSteps.getPhaseWorks(db));
                skippedPhases.reset(db);
                if (skippedSteps != null && skippedSteps.size() > 0) {
                    ActionItemWork previousStep = (ActionItemWork)((Object)skippedSteps.get(skippedSteps.size() - 1));
                    if (previousStep.getStartDate() == null) {
                        previousStep.setStartDate(new Timestamp(new Date().getTime()));
                    }
                    previousStep.revertStatus(db, null);
                    this.setStartDate((Timestamp)null);
                    this.update(db);
                    ActionPhaseWork previousPhaseWork = new ActionPhaseWork();
                    previousPhaseWork.setBuildPhase(true);
                    previousPhaseWork.setBuildStepWork(true);
                    previousPhaseWork.setBuildLinkedObject(true);
                    previousPhaseWork.queryRecord(db, previousStep.getPhaseWorkId());
                    previousPhaseWork.setStartDate(new Timestamp(new Date().getTime()));
                    previousPhaseWork.setEndDate((Timestamp)null);
                    previousPhaseWork.update(db);
                    planWork.setCurrentPhaseId(previousPhaseWork.getActionPhaseId());
                    if (previousPhaseWork.getPhase().getRandom()) {
                        previousPhaseWork.getItemWorkList().startRandomSteps(db);
                    }
                    planWork.update(db);
                } else {
                    completedOneSkippedStep = true;
                }
            }
            if (allStepsComplete) {
                if (!this.allowSkipToHere || completedOneSkippedStep) {
                    planWork.setCurrentPhaseId(phaseWork.getActionPhaseId());
                }
                planWork.update(db);
                ActionPhaseWork nextPhase = phaseWork.getNextPhase(db);
                if (nextPhase != null && nextPhase.getId() != -1) {
                    nextPhase.setBuildStepWork(true);
                    nextPhase.setBuildPhase(true);
                    nextPhase.queryRecord(db, nextPhase.getId());
                    boolean changedNextPhase = false;
                    if (nextPhase.getStartDate() != null) {
                        changedNextPhase = true;
                        nextPhase.setStartDate((Timestamp)null);
                        nextPhase.update(db);
                        if (nextPhase.getPhase().getRandom()) {
                            nextPhase.buildStepWork(db);
                            nextPhase.getItemWorkList().reset(db);
                        } else if (!nextPhase.getPhase().getRandom()) {
                            ActionItemWork item = (ActionItemWork)((Object)nextPhase.getItemWorkList().get(0));
                            item.setStartDate((Timestamp)null);
                            item.setStatusId(-1);
                            item.update(db);
                        }
                    }
                }
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public void revertStatus(Connection db, ActionItemWork nextStep) throws SQLException {
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            String nullStr = null;
            this.setEndDate(nullStr);
            this.setStatusId(-1);
            this.revertStatus(db);
            if (nextStep != null) {
                nextStep.setStartDate(nullStr);
                if (!nextStep.allowsUpdate()) {
                    ActionItemWorkList actionPlanSteps = new ActionItemWorkList();
                    actionPlanSteps.setPlanWorkId(this.planWork.getId());
                    actionPlanSteps.buildList(db);
                    ActionItemWorkList jumpSteps = this.getJumpedSteps(actionPlanSteps);
                    jumpSteps.reset(db);
                    ActionItemWork currentStep = this.getNextCurrentItem(actionPlanSteps);
                    if (currentStep != null) {
                        currentStep.setStartDate(nullStr);
                        currentStep.revertStatus(db);
                    }
                } else {
                    nextStep.revertStatus(db);
                }
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public void delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            ActionItemWorkNoteList notes = new ActionItemWorkNoteList();
            notes.setItemWorkId(this.id);
            notes.buildList(db);
            notes.delete(db);
            ActionItemWorkSelectionList selections = new ActionItemWorkSelectionList();
            selections.setItemWorkId(this.id);
            selections.buildList(db);
            selections.delete(db);
            Statement st = db.createStatement();
            st.executeUpdate("DELETE FROM action_item_work WHERE item_work_id = " + this.getId());
            st.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("item_work_id");
        this.phaseWorkId = rs.getInt("phase_work_id");
        this.actionStepId = rs.getInt("action_step_id");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.ownerId = rs.getInt("owner");
        this.linkModuleId = DatabaseUtils.getInt(rs, "link_module_id");
        this.linkItemId = DatabaseUtils.getInt(rs, "link_item_id");
        this.startDate = rs.getTimestamp("start_date");
        this.endDate = rs.getTimestamp("end_date");
        this.level = rs.getInt("level");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.stepDescription = rs.getString("description");
        this.permissionType = DatabaseUtils.getInt(rs, "permission_type");
        this.estimatedDuration = DatabaseUtils.getInt(rs, "estimated_duration", 0);
        this.parentId = DatabaseUtils.getInt(rs, "parent_id", 0);
        this.actionId = DatabaseUtils.getInt(rs, "action_id");
        this.allowSkipToHere = rs.getBoolean("allow_skip_to_here");
        this.actionRequired = rs.getBoolean("action_required");
        this.label = rs.getString("label");
        this.targetRelationship = rs.getString("target_relationship");
        this.allowUpdate = rs.getBoolean("allow_update");
    }

    public boolean insert(Connection db) throws SQLException {
        this.level = this.retrieveNextLevel(db);
        this.id = DatabaseUtils.getNextSeq(db, "action_item_work_item_work_id_seq");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO action_item_work (" + (this.id > -1 ? "item_work_id, " : "") + "phase_work_id, action_step_id, status_id, owner, ");
        if (this.startDate != null) {
            sql.append("start_date, ");
        }
        if (this.endDate != null) {
            sql.append("end_date, ");
        }
        sql.append("" + DatabaseUtils.addQuotes(db, "level") + ", link_module_id, link_item_id, ");
        if (this.entered != null) {
            sql.append("entered, ");
        }
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("enteredby, modifiedby ) ");
        sql.append("VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ");
        if (this.startDate != null) {
            sql.append("?, ");
        }
        if (this.endDate != null) {
            sql.append("?, ");
        }
        sql.append("?, ?, ?, ");
        if (this.entered != null) {
            sql.append("?, ");
        }
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("?, ? ) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.getPhaseWorkId());
        pst.setInt(++i, this.getActionStepId());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        DatabaseUtils.setInt(pst, ++i, this.getOwnerId());
        if (this.startDate != null) {
            pst.setTimestamp(++i, this.startDate);
        }
        if (this.endDate != null) {
            pst.setTimestamp(++i, this.endDate);
        }
        pst.setInt(++i, this.getLevel());
        DatabaseUtils.setInt(pst, ++i, this.getLinkModuleId());
        DatabaseUtils.setInt(pst, ++i, this.getLinkItemId());
        if (this.entered != null) {
            pst.setTimestamp(++i, this.entered);
        }
        if (this.modified != null) {
            pst.setTimestamp(++i, this.modified);
        }
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "action_item_work_item_work_id_seq", this.id);
        return true;
    }

    public boolean hasAttachment() {
        return this.linkModuleId != -1;
    }

    public String getStatusGraphicTag(SystemStatus systemStatus) {
        if (this.statusId == 2) {
            return "<img border=\"0\" src=\"images/box-checked.gif\" align=\"absmiddle\" alt=\"" + StringUtils.toHtml(systemStatus.getLabel("actionPlan.completed")) + "\">";
        }
        if (this.statusId == 1) {
            return "<img border=\"0\" src=\"images/box-closed.gif\" align=\"absmiddle\" alt=\"" + StringUtils.toHtml(systemStatus.getLabel("actionPlan.skipped")) + "\">";
        }
        return "<img border=\"0\" src=\"images/box.gif\" align=\"absmiddle\">";
    }

    public ActionItemWork getNextItem(Connection db) throws SQLException {
        if (this.getId() == -1) {
            new SQLException("Action Item Work ID not specified");
        }
        ActionPhaseWork currentPhase = new ActionPhaseWork(db, this.getPhaseWorkId());
        ActionItemWorkList itemWorkList = new ActionItemWorkList();
        itemWorkList.setPhaseWorkId(this.phaseWorkId);
        itemWorkList.buildList(db);
        Iterator i = itemWorkList.iterator();
        while (i.hasNext()) {
            ActionItemWork thisItem = (ActionItemWork)((Object)i.next());
            if (thisItem.getId() != this.getId() || !i.hasNext()) continue;
            return (ActionItemWork)((Object)i.next());
        }
        ActionPhaseWorkList phaseWorkList = new ActionPhaseWorkList();
        phaseWorkList.setPlanWorkId(currentPhase.getPlanWorkId());
        phaseWorkList.buildList(db);
        Iterator j = phaseWorkList.iterator();
        while (j.hasNext()) {
            ActionPhaseWork thisPhase = (ActionPhaseWork)((Object)j.next());
            if (thisPhase.getId() != currentPhase.getId() || !j.hasNext()) continue;
            ActionPhaseWork nextPhase = (ActionPhaseWork)((Object)j.next());
            nextPhase.buildStepWork(db);
            if (nextPhase.getItemWorkList().size() <= 0) continue;
            return (ActionItemWork)((Object)nextPhase.getItemWorkList().get(0));
        }
        return null;
    }

    private ActionItemWorkList getSkippedSteps(ActionItemWorkList actionPlanSteps) {
        ActionItemWork itemWork;
        ActionItemWorkList skippedSteps = new ActionItemWorkList();
        Iterator i = actionPlanSteps.iterator();
        while (i.hasNext() && (itemWork = (ActionItemWork)((Object)i.next())).getId() != this.getId()) {
            if (itemWork.getEndDate() != null || itemWork.getStatusId() != -1) continue;
            skippedSteps.add(itemWork);
        }
        return skippedSteps;
    }

    private void removeGlobalSteps(ActionItemWorkList skippedSteps) {
        Iterator i = skippedSteps.iterator();
        while (i.hasNext()) {
            ActionItemWork itemWork = (ActionItemWork)((Object)i.next());
            if (!this.planWork.getPhaseWorkList().getPhaseWorkById(itemWork.getPhaseWorkId()).isGlobal()) continue;
            i.remove();
        }
    }

    private ActionItemWorkList getJumpedSteps(ActionItemWorkList actionPlanSteps) {
        ActionItemWork itemWork;
        ActionItemWorkList jumpedSteps = new ActionItemWorkList();
        Iterator i = actionPlanSteps.iterator();
        while (i.hasNext() && (itemWork = (ActionItemWork)((Object)i.next())).getId() != this.getId()) {
        }
        while (i.hasNext() && !(itemWork = (ActionItemWork)((Object)i.next())).allowsUpdate()) {
            jumpedSteps.add(itemWork);
        }
        return jumpedSteps;
    }

    private ActionItemWork getNextCurrentItem(ActionItemWorkList actionPlanSteps) {
        ActionItemWork itemWork = null;
        Iterator i = actionPlanSteps.iterator();
        while (i.hasNext() && (itemWork = (ActionItemWork)((Object)i.next())).getId() != this.getId()) {
        }
        while (i.hasNext() && !(itemWork = (ActionItemWork)((Object)i.next())).allowsUpdate()) {
        }
        return itemWork;
    }

    private ActionItemWorkList getAlreadySkippedSteps(ActionItemWorkList actionPlanSteps) {
        ActionItemWorkList skippedSteps = new ActionItemWorkList();
        int startingId = -1;
        for (ActionItemWork itemWork : actionPlanSteps) {
            if (startingId == -1 && itemWork.getEndDate() != null && itemWork.getStatusId() == 1) {
                startingId = itemWork.getId();
                if (this.getPlanWork().getPhaseWorkList().getPhaseWorkById(itemWork.getPhaseWorkId()).getPhase().getRandom()) {
                    // empty if block
                }
            } else if (startingId != -1 && itemWork.getEndDate() != null && itemWork.getId() != this.getId() && itemWork.getStatusId() != 1) {
                startingId = -1;
            }
            if (itemWork.getId() != this.getId() && startingId != -1) {
                if (itemWork.getEndDate() == null || itemWork.getStatusId() != 1) continue;
                skippedSteps.add(itemWork);
                continue;
            }
            if (itemWork.getId() != this.getId() && startingId == -1 && skippedSteps.size() > 0) {
                skippedSteps = new ActionItemWorkList();
                continue;
            }
            if (itemWork.getId() != this.getId()) continue;
            break;
        }
        return skippedSteps;
    }

    private ActionItemWorkList getAlreadySkippedSteps(ActionItemWorkList actionPlanSteps, boolean includesRandom) {
        ActionItemWorkList skippedSteps = new ActionItemWorkList();
        boolean canContinue = true;
        for (int i = actionPlanSteps.getIndexById(this.getId()); i > -1 && canContinue; --i) {
            ActionItemWork itemWork = (ActionItemWork)((Object)actionPlanSteps.get(i));
            if (itemWork.getStatusId() == 2 && !this.getPlanWork().getPhaseWorkList().getPhaseWorkById(itemWork.getPhaseWorkId()).getPhase().getGlobal()) {
                canContinue = false;
                if (this.getPlanWork().getPhaseWorkList().getPhaseWorkById(itemWork.getPhaseWorkId()).getPhase().getRandom()) {
                    boolean counter = false;
                    if (i >= 1) {
                        int j = 0;
                        boolean flag = true;
                        j = 0;
                        while (flag) {
                            ActionItemWork randomWork = (ActionItemWork)((Object)actionPlanSteps.get(i - j));
                            boolean bl = flag = itemWork.getPhaseWorkId() == randomWork.getPhaseWorkId();
                            if (randomWork.getStatusId() == 1 && flag) {
                                skippedSteps.add(randomWork);
                            }
                            if (randomWork.getParentId() == 0) {
                                flag = false;
                            }
                            ++j;
                        }
                        return skippedSteps;
                    }
                    return skippedSteps;
                }
                return skippedSteps;
            }
            if (itemWork.getStatusId() != 1) continue;
            skippedSteps.add(itemWork);
        }
        return skippedSteps;
    }

    public boolean isLastStep(Connection db) throws SQLException {
        if (this.getId() == -1) {
            new SQLException("Action Item Work ID not specified");
        }
        ActionItemWorkList itemWorkList = new ActionItemWorkList();
        itemWorkList.setPhaseWorkId(this.phaseWorkId);
        itemWorkList.buildList(db);
        Iterator i = itemWorkList.iterator();
        while (i.hasNext()) {
            ActionItemWork thisItem = (ActionItemWork)((Object)i.next());
            if (thisItem.getId() != this.getId() || !i.hasNext()) continue;
            return false;
        }
        return true;
    }

    private int retrieveNextLevel(Connection db) throws SQLException {
        int returnLevel = 0;
        PreparedStatement pst = db.prepareStatement("SELECT MAX(" + DatabaseUtils.addQuotes(db, "level") + ") AS levelcount " + "FROM action_item_work " + "WHERE phase_work_id = ? ");
        pst.setInt(1, this.phaseWorkId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            returnLevel = rs.getInt("levelcount");
            if (rs.wasNull()) {
                returnLevel = 0;
            }
        }
        rs.close();
        pst.close();
        return ++returnLevel;
    }

    public boolean sendEmail(ActionContext context, ActionPlanWork actionPlan, Contact next, String stepName, String template) throws Exception {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        ActionPlanEmail planEmail = new ActionPlanEmail(template, actionPlan, next, stepName, context);
        SMTPMessage mail = new SMTPMessage();
        mail.setHost(prefs.get("MAILSERVER"));
        mail.setFrom(prefs.get("EMAILADDRESS"));
        mail.addReplyTo(prefs.get("EMAILADDRESS"));
        mail.setType("text/html");
        mail.setSubject(planEmail.getSubject());
        mail.setBody(planEmail.getBody());
        if (next.getPrimaryEmailAddress() != null && !"".equals(next.getPrimaryEmailAddress())) {
            mail.addTo(next.getPrimaryEmailAddress());
            System.out.println("ADDING: " + next.getPrimaryEmailAddress());
        }
        if (mail.send() == 2) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ActionPlanWork -> Send error: " + mail.getErrorMsg() + "\n");
            }
        } else if (System.getProperty("DEBUG") != null) {
            System.out.println("ActionPlanWork -> Sending message...");
        }
        return true;
    }

    public boolean sendEmail(ActionContext context, ActionPlanWork actionPlan, Contact next, String stepName, String template, String stepCompletion) throws Exception {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
        ActionPlanEmail planEmail = new ActionPlanEmail(template, actionPlan, next, stepName, context, stepCompletion);
        SMTPMessage mail = new SMTPMessage();
        mail.setHost(prefs.get("MAILSERVER"));
        mail.setFrom(prefs.get("EMAILADDRESS"));
        mail.addReplyTo(prefs.get("EMAILADDRESS"));
        mail.setType("text/html");
        mail.setSubject(planEmail.getSubject());
        mail.setBody(planEmail.getBody());
        if (next.getPrimaryEmailAddress() != null && !"".equals(next.getPrimaryEmailAddress())) {
            mail.addTo(next.getPrimaryEmailAddress());
            System.out.println("ADDING: " + next.getPrimaryEmailAddress());
        }
        if (mail.send() == 2) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ActionPlanWork -> Send error: " + mail.getErrorMsg() + "\n");
            }
        } else if (System.getProperty("DEBUG") != null) {
            System.out.println("ActionPlanWork -> Sending message...");
        }
        return true;
    }

    public ActionStep getStep() {
        return this.step;
    }

    public void setStep(ActionStep tmp) {
        this.step = tmp;
    }

    public UserList getGroupUsers() {
        return this.groupUsers;
    }

    public void setGroupUsers(UserList tmp) {
        this.groupUsers = tmp;
    }

    public UserList getRoleUsers() {
        return this.roleUsers;
    }

    public void setRoleUsers(UserList tmp) {
        this.roleUsers = tmp;
    }

    public UserList getDepartmentUsers() {
        return this.departmentUsers;
    }

    public void setDepartmentUsers(UserList tmp) {
        this.departmentUsers = tmp;
    }

    public String getUserGroupName() {
        return this.userGroupName;
    }

    public void setUserGroupName(String tmp) {
        this.userGroupName = tmp;
    }

    public String getDepartmentName() {
        return this.departmentName;
    }

    public void setDepartmentName(String tmp) {
        this.departmentName = tmp;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String tmp) {
        this.roleName = tmp;
    }

    public boolean allowsUpdate() {
        return this.allowUpdate;
    }
}

