/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.aspcfs.modules.actionplans.base.ActionItemWork;
import org.aspcfs.modules.actionplans.base.ActionPhaseWork;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ActionItemWorkList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int phaseWorkId = -1;
    private int planWorkId = -1;
    private boolean buildLinkedObject = false;
    private int actionStepId = -1;
    private boolean buildStep = false;
    private ActionPlanWork planWork = null;
    private int linkModuleId = -1;
    private int linkItemId = -1;
    private boolean isCurrent = false;
    public static final String tableName = "action_item_work";
    public static final String uniqueField = "item_work_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public boolean getBuildStep() {
        return this.buildStep;
    }

    public void setBuildStep(boolean tmp) {
        this.buildStep = tmp;
    }

    public void setBuildStep(String tmp) {
        this.buildStep = DatabaseUtils.parseBoolean(tmp);
    }

    public int getPlanWorkId() {
        return this.planWorkId;
    }

    public void setPlanWorkId(int tmp) {
        this.planWorkId = tmp;
    }

    public void setPlanWorkId(String tmp) {
        this.planWorkId = Integer.parseInt(tmp);
    }

    public boolean getBuildLinkedObject() {
        return this.buildLinkedObject;
    }

    public void setBuildLinkedObject(boolean tmp) {
        this.buildLinkedObject = tmp;
    }

    public void setBuildLinkedObject(String tmp) {
        this.buildLinkedObject = DatabaseUtils.parseBoolean(tmp);
    }

    public int getPhaseWorkId() {
        return this.phaseWorkId;
    }

    public void setPhaseWorkId(int tmp) {
        this.phaseWorkId = tmp;
    }

    public void setPhaseWorkId(String tmp) {
        this.phaseWorkId = Integer.parseInt(tmp);
    }

    public int getActionStepId() {
        return this.actionStepId;
    }

    public void setActionStepId(int tmp) {
        this.actionStepId = tmp;
    }

    public void setActionStepId(String tmp) {
        this.actionStepId = Integer.parseInt(tmp);
    }

    public ActionPlanWork getPlanWork() {
        return this.planWork;
    }

    public void setPlanWork(ActionPlanWork tmp) {
        this.planWork = tmp;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public int getLinkItemId() {
        return this.linkItemId;
    }

    public void setLinkItemId(int tmp) {
        this.linkItemId = tmp;
    }

    public void setLinkItemId(String tmp) {
        this.linkItemId = Integer.parseInt(tmp);
    }

    public boolean getIsCurrent() {
        return this.isCurrent;
    }

    public void setIsCurrent(boolean tmp) {
        this.isCurrent = tmp;
    }

    public void setIsCurrent(String tmp) {
        this.isCurrent = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM action_item_work aiw LEFT JOIN action_step acs ON (aiw.action_step_id = acs.step_id) LEFT JOIN action_phase_work apw ON (aiw.phase_work_id = apw.phase_work_id) WHERE aiw.item_work_id > 0 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(acs.description) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("acs.description", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY apw." + DatabaseUtils.addQuotes(db, "level") + ", aiw." + DatabaseUtils.addQuotes(db, "level") + ", acs.description ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append(" SELECT ");
        }
        sqlSelect.append("aiw.*, acs.description, acs.estimated_duration, acs.parent_id, acs.action_id, acs.permission_type, acs.allow_skip_to_here, acs.action_required, acs.label, acs.target_relationship, acs.allow_update FROM action_item_work aiw LEFT JOIN action_step acs ON (aiw.action_step_id = acs.step_id) LEFT JOIN action_phase_work apw ON (aiw.phase_work_id = apw.phase_work_id) WHERE aiw.item_work_id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ActionItemWork actionItemWork = new ActionItemWork(rs);
            actionItemWork.setPlanWork(this.planWork);
            this.add(actionItemWork);
        }
        rs.close();
        pst.close();
        if (this.buildLinkedObject || this.buildStep) {
            for (ActionItemWork thisItem : this) {
                thisItem.setPlanWork(this.planWork);
                if (this.buildLinkedObject) {
                    thisItem.buildLinkedObject(db);
                }
                if (!this.getBuildStep()) continue;
                thisItem.setBuildStep(true);
                thisItem.buildStep(db);
            }
        }
    }

    public void delete(Connection db) throws SQLException {
        for (ActionItemWork thisItem : this) {
            thisItem.setPlanWork(this.getPlanWork());
            thisItem.delete(db);
        }
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.phaseWorkId > -1) {
            sqlFilter.append("AND aiw.phase_work_id = ? ");
        }
        if (this.planWorkId > -1) {
            sqlFilter.append("AND aiw.phase_work_id IN (SELECT phase_work_id FROM action_phase_work WHERE plan_work_id = ? ) ");
        }
        if (this.actionStepId != -1) {
            sqlFilter.append("AND aiw.action_step_id = ? ");
        }
        if (this.linkModuleId != -1) {
            sqlFilter.append("AND aiw.link_module_id = ? ");
        }
        if (this.linkItemId != -1) {
            sqlFilter.append("AND aiw.link_item_id = ? ");
        }
        if (this.isCurrent) {
            sqlFilter.append("AND aiw.start_date IS NOT NULL AND aiw.end_date IS NOT NULL AND aiw.status_id IS NULL ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.phaseWorkId > -1) {
            pst.setInt(++i, this.phaseWorkId);
        }
        if (this.planWorkId > -1) {
            pst.setInt(++i, this.planWorkId);
        }
        if (this.actionStepId != -1) {
            pst.setInt(++i, this.actionStepId);
        }
        if (this.linkModuleId != -1) {
            pst.setInt(++i, this.linkModuleId);
        }
        if (this.linkItemId != -1) {
            pst.setInt(++i, this.linkItemId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public void updateStatus(Connection db, int status) throws SQLException {
        for (ActionItemWork thisItem : this) {
            thisItem.setStatusId(status);
            if (thisItem.getStartDate() == null) {
                thisItem.setStartDate(new Timestamp(new Date().getTime()));
            }
            if (thisItem.getEndDate() == null) {
                thisItem.setEndDate(new Timestamp(new Date().getTime()));
            }
            thisItem.updateStatus(db);
        }
    }

    public void revertStatus(Connection db, int status) throws SQLException {
        for (ActionItemWork thisItem : this) {
            thisItem.setStatusId(status);
            thisItem.setStartDate((Timestamp)null);
            thisItem.setEndDate((Timestamp)null);
            thisItem.updateStatus(db);
        }
    }

    public HashMap getPhaseWorks(Connection db) throws SQLException {
        HashMap<Integer, ActionPhaseWork> map = new HashMap<Integer, ActionPhaseWork>();
        for (ActionItemWork thisItem : this) {
            if (map.get(new Integer(thisItem.getPhaseWorkId())) != null) continue;
            ActionPhaseWork phaseWork = new ActionPhaseWork();
            phaseWork.setBuildPhase(true);
            phaseWork.queryRecord(db, thisItem.getPhaseWorkId());
            map.put(new Integer(phaseWork.getId()), phaseWork);
        }
        return map;
    }

    public void reset(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE action_item_work SET start_date = ?, end_date = ?, status_id = ? WHERE item_work_id = ? ");
        for (ActionItemWork itemWork : this) {
            pst.setNull(1, 91);
            pst.setNull(2, 91);
            pst.setNull(3, 4);
            pst.setInt(4, itemWork.getId());
            pst.executeUpdate();
        }
        pst.close();
    }

    public void startRandomSteps(Connection db) throws SQLException {
        for (ActionItemWork thisItem : this) {
            if (thisItem.getStartDate() != null) continue;
            thisItem.setStartDate(new Timestamp(new Date().getTime()));
            thisItem.setStatusId(-1);
            thisItem.update(db);
        }
    }

    public void resetAttachment(Connection db) throws SQLException {
        for (ActionItemWork thisItem : this) {
            if (thisItem.getLinkItemId() == -1) continue;
            thisItem.setLinkItemId(-1);
            thisItem.updateAttachment(db);
        }
    }

    public int getIndexById(int itemId) {
        int result = -1;
        for (ActionItemWork thisItem : this) {
            if (thisItem.getId() != itemId) continue;
            result = this.indexOf((Object)thisItem);
            break;
        }
        return result;
    }
}

