/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.utils.DatabaseUtils;

public class ActionItemWorkNote
extends GenericBean {
    private int id = -1;
    private int itemWorkId = -1;
    private String description = null;
    private Timestamp submitted = null;
    private int submittedBy = -1;

    public int getSubmittedBy() {
        return this.submittedBy;
    }

    public void setSubmittedBy(int tmp) {
        this.submittedBy = tmp;
    }

    public void setSubmittedBy(String tmp) {
        this.submittedBy = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getItemWorkId() {
        return this.itemWorkId;
    }

    public void setItemWorkId(int tmp) {
        this.itemWorkId = tmp;
    }

    public void setItemWorkId(String tmp) {
        this.itemWorkId = Integer.parseInt(tmp);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public Timestamp getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Timestamp tmp) {
        this.submitted = tmp;
    }

    public void setSubmitted(String tmp) {
        this.submitted = DatabaseUtils.parseTimestamp(tmp);
    }

    public ActionItemWorkNote() {
    }

    public ActionItemWorkNote(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ActionItemWorkNote(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Action Item Work Note ID specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT aiwn.* FROM action_item_work_notes aiwn WHERE aiwn.note_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("note_id");
        this.itemWorkId = rs.getInt("item_work_id");
        this.description = rs.getString("description");
        this.submitted = rs.getTimestamp("submitted");
        this.submittedBy = rs.getInt("submittedby");
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "action_item_work_notes_note_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO action_item_work_notes (" + (this.id > -1 ? "note_id, " : "") + "item_work_id, description, submitted, submittedby) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.itemWorkId);
        pst.setString(++i, this.description);
        DatabaseUtils.setTimestamp(pst, ++i, this.submitted);
        pst.setInt(++i, this.submittedBy);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "action_item_work_notes_note_id_seq", this.id);
        return true;
    }

    public boolean update(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("UPDATE action_item_work_notes SET item_work_id = ?, description = ?, submitted = ?, submittedby = ? WHERE note_id = ? ");
        int i = 0;
        pst.setInt(++i, this.itemWorkId);
        pst.setString(++i, this.description);
        DatabaseUtils.setTimestamp(pst, ++i, this.submitted);
        pst.setInt(++i, this.submittedBy);
        pst.setInt(++i, this.id);
        pst.executeUpdate();
        pst.close();
        return true;
    }

    public void delete(Connection db) throws SQLException {
        Statement st = db.createStatement();
        st.executeUpdate("DELETE FROM action_item_work_notes WHERE note_id = " + this.getId());
        st.close();
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("submitted");
        return thisList;
    }
}

