/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.utils.DatabaseUtils;

public class ActionItemWorkSelection
extends GenericBean {
    private int id = -1;
    private int itemWorkId = -1;
    private int selection = -1;
    private String description = null;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public int getSelection() {
        return this.selection;
    }

    public void setSelection(int tmp) {
        this.selection = tmp;
    }

    public void setSelection(String tmp) {
        this.selection = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getItemWorkId() {
        return this.itemWorkId;
    }

    public void setItemWorkId(int tmp) {
        this.itemWorkId = tmp;
    }

    public void setItemWorkId(String tmp) {
        this.itemWorkId = Integer.parseInt(tmp);
    }

    public ActionItemWorkSelection() {
    }

    public ActionItemWorkSelection(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ActionItemWorkSelection(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Action Item Work Selection ID specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT aiws.*, asl.description FROM action_item_work_selection aiws LEFT JOIN action_step_lookup asl ON (aiws.selection = asl.code) WHERE aiws.selection_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("selection_id");
        this.itemWorkId = rs.getInt("item_work_id");
        this.selection = rs.getInt("selection");
        this.description = rs.getString("description");
    }

    public boolean insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "action_item_work_selection_selection_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO action_item_work_selection (" + (this.id > -1 ? "selection_id, " : "") + "item_work_id, selection) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.itemWorkId);
        pst.setInt(++i, this.selection);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "action_item_work_selection_selection_id_seq", this.id);
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            int i = 0;
            PreparedStatement pst = db.prepareStatement("UPDATE action_item_work SET link_item_id = ? WHERE link_module_id = ? AND link_item_id = ? ");
            DatabaseUtils.setInt(pst, ++i, -1);
            pst.setInt(++i, 831200520);
            pst.setInt(++i, this.getId());
            pst.executeUpdate();
            pst.close();
            pst = db.prepareStatement("DELETE FROM action_item_work_selection WHERE selection_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean hasValue(ArrayList newList) {
        for (String param : newList) {
            if (Integer.parseInt(param) != this.getSelection()) continue;
            return true;
        }
        return false;
    }
}

