/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspcfs.modules.actionplans.base.ActionItemWorkSelection;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ActionItemWorkSelectionList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int itemWorkId = -1;
    public static final String tableName = "action_item_work_selection";
    public static final String uniqueField = "selection_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getItemWorkId() {
        return this.itemWorkId;
    }

    public void setItemWorkId(int tmp) {
        this.itemWorkId = tmp;
    }

    public void setItemWorkId(String tmp) {
        this.itemWorkId = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM action_item_work_selection aiws LEFT JOIN action_step_lookup asl ON (aiws.selection = asl.code) WHERE aiws.selection_id > 0 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(asl.description) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("asl.description", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY asl.description ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append(" SELECT ");
        }
        sqlSelect.append("aiws.*, asl.description FROM action_item_work_selection aiws LEFT JOIN action_step_lookup asl ON (aiws.selection = asl.code) WHERE aiws.selection_id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ActionItemWorkSelection thisSelection = new ActionItemWorkSelection(rs);
            this.add(thisSelection);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.itemWorkId > -1) {
            sqlFilter.append("AND aiws.item_work_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.itemWorkId != -1) {
            pst.setInt(++i, this.itemWorkId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public boolean hasSelection(int id) {
        for (ActionItemWorkSelection thisItem : this) {
            if (thisItem.getSelection() != id) continue;
            return true;
        }
        return false;
    }

    public String getDisplayHtml() {
        StringBuffer sb = new StringBuffer();
        Iterator j = this.iterator();
        while (j.hasNext()) {
            ActionItemWorkSelection thisItem = (ActionItemWorkSelection)((Object)j.next());
            if (j.hasNext()) {
                sb.append(thisItem.getDescription() + "\r\n");
                continue;
            }
            sb.append(thisItem.getDescription());
        }
        return sb.toString().trim();
    }

    public void delete(Connection db) throws SQLException {
        for (ActionItemWorkSelection thisSelection : this) {
            thisSelection.delete(db);
        }
    }
}

