/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspcfs.modules.actionplans.base.ActionPhaseList;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionStep;
import org.aspcfs.modules.actionplans.base.ActionStepList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.utils.DatabaseUtils;

public class ActionPhase
extends GenericBean {
    protected int id = -1;
    protected int parentId = -1;
    protected int planId = -1;
    protected String name = null;
    protected String description = null;
    protected boolean enabled = false;
    protected boolean random = false;
    protected boolean global = false;
    protected Timestamp entered = null;
    protected boolean buildSteps = false;
    protected ActionStepList steps = new ActionStepList();
    protected ActionPhaseList phaseList = new ActionPhaseList();
    protected boolean buildCompletePhaseList = false;

    public ActionPhase() {
    }

    public ActionPhase(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ActionPhase(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Action Plan ID");
        }
        StringBuffer sb = new StringBuffer(" SELECT aph.*  FROM action_phase aph  WHERE aph.phase_id = ? ");
        PreparedStatement pst = db.prepareStatement(sb.toString());
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        if (this.buildSteps) {
            this.buildSteps(db);
        }
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("phase_id"));
        this.parentId = DatabaseUtils.getInt(rs, "parent_id", 0);
        this.planId = DatabaseUtils.getInt(rs, "plan_id");
        this.name = rs.getString("phase_name");
        this.description = rs.getString("description");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.random = rs.getBoolean("random");
        this.global = rs.getBoolean("global");
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "action_phase_phase_id_seq");
            sql.append("INSERT INTO action_phase ( plan_id, phase_name, description, ");
            if (this.parentId > 0) {
                sql.append("parent_id, ");
            }
            if (this.id > -1) {
                sql.append("phase_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            sql.append(" enabled, random, " + DatabaseUtils.addQuotes(db, "global") + ")");
            sql.append(" VALUES (?, ?, ?, ");
            if (this.parentId > 0) {
                sql.append("?, ");
            }
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("?, ?, ? )");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.getPlanId());
            pst.setString(++i, this.getName());
            pst.setString(++i, this.getDescription());
            if (this.parentId > 0) {
                DatabaseUtils.setInt(pst, ++i, this.parentId > 0 ? this.parentId : -1);
            }
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.getEntered());
            }
            pst.setBoolean(++i, this.getEnabled());
            pst.setBoolean(++i, this.getRandom());
            pst.setBoolean(++i, this.getGlobal());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "action_phase_phase_id_seq", this.id);
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE action_phase  SET parent_id = ?,  plan_id = ?,  phase_name = ?,  description = ?,  enabled = ?,  random = ?,  " + DatabaseUtils.addQuotes(db, "global") + " = ? " + " WHERE phase_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getParentId() == 0 ? -1 : this.getParentId());
        DatabaseUtils.setInt(pst, ++i, this.getPlanId());
        pst.setString(++i, this.getName());
        pst.setString(++i, this.getDescription());
        pst.setBoolean(++i, this.getEnabled());
        pst.setBoolean(++i, this.getRandom());
        pst.setBoolean(++i, this.getGlobal());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean delete(Connection db) throws SQLException {
        this.queryRecord(db, this.getId());
        this.buildSteps(db);
        this.steps.delete(db);
        int childPhaseId = ActionPhase.getPhaseIdGivenParentId(db, this.getId());
        ActionPhase childPhase = null;
        if (childPhaseId != -1) {
            childPhase = new ActionPhase(db, childPhaseId);
        }
        if (childPhase != null) {
            if (this.getParentId() != -1 && this.getParentId() != 0) {
                childPhase.setParentId(this.getParentId());
            } else {
                childPhase.setParentId(-1);
            }
            childPhase.update(db);
        }
        PreparedStatement pst = db.prepareStatement("DELETE FROM action_phase WHERE phase_id = ? ");
        pst.setInt(1, this.getId());
        boolean result = pst.execute();
        pst.close();
        return result;
    }

    public int updateSteps(Connection db) throws SQLException {
        int result = -1;
        for (ActionStep step : this.steps) {
            result += step.update(db);
        }
        return result;
    }

    public void buildSteps(Connection db) throws SQLException {
        this.steps = new ActionStepList();
        this.steps.setPhaseId(this.getId());
        this.steps.buildList(db);
        this.steps = this.steps.reorder();
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("entered");
        return thisList;
    }

    public void buildPhaseList(Connection db) throws SQLException {
        this.phaseList = new ActionPhaseList();
        this.phaseList.setParentId(this.getId());
        this.phaseList.setBuildSteps(this.getBuildSteps());
        this.phaseList.setBuildCompletePhaseList(this.getBuildCompletePhaseList());
        this.phaseList.buildList(db);
    }

    public boolean setAfterPhaseId(Connection db, String previousPhaseIdString, boolean addingPhase) throws SQLException {
        int nextPhaseId = -1;
        if (previousPhaseIdString == null || "".equals(previousPhaseIdString) || "-1".equals(previousPhaseIdString)) {
            return true;
        }
        ActionPhase previousPhase = new ActionPhase(db, Integer.parseInt(previousPhaseIdString));
        ActionPhase nextPhase = null;
        nextPhaseId = ActionPhase.getPhaseIdGivenParentId(db, previousPhase.getId());
        if (nextPhaseId != -1) {
            nextPhase = new ActionPhase(db, nextPhaseId);
        }
        if (!addingPhase) {
            if (this.getParentId() == 0 || this.getParentId() == -1) {
                previousPhase.setParentId(-1);
            } else {
                previousPhase.setParentId(this.getParentId());
            }
            previousPhase.update(db);
        }
        if (nextPhaseId != -1) {
            nextPhase.setParentId(this.getId());
            nextPhase.update(db);
        }
        this.setParentId(previousPhase.getId());
        this.update(db);
        return true;
    }

    public boolean setBeforePhaseId(Connection db, String nextPhaseIdString, boolean addingPhase) throws SQLException {
        boolean result = false;
        int earlierNextPhaseId = -1;
        if (nextPhaseIdString == null || "".equals(nextPhaseIdString) || "-1".equals(nextPhaseIdString)) {
            return true;
        }
        int nextPhaseId = Integer.parseInt(nextPhaseIdString);
        ActionPhase earlierNextPhase = null;
        ActionPhase nextPhase = new ActionPhase(db, nextPhaseId);
        if (!addingPhase && (earlierNextPhaseId = ActionPhase.getPhaseIdGivenParentId(db, this.getId())) != -1) {
            earlierNextPhase = new ActionPhase(db, earlierNextPhaseId);
        }
        if (nextPhase.getParentId() == 0 || nextPhase.getParentId() == -1) {
            this.setParentId(-1);
        } else {
            this.setParentId(nextPhase.getParentId());
        }
        this.update(db);
        nextPhase.setParentId(this.getId());
        nextPhase.update(db);
        if (earlierNextPhase != null) {
            earlierNextPhase.setParentId(nextPhase.getId());
            earlierNextPhase.update(db);
        }
        return true;
    }

    public static int getPhaseIdGivenParentId(Connection db, int parentId) throws SQLException {
        int result = -1;
        PreparedStatement pst = db.prepareStatement("SELECT phase_id FROM action_phase WHERE parent_id = ?");
        DatabaseUtils.setInt(pst, 1, parentId > 0 ? parentId : -1);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            result = DatabaseUtils.getInt(rs, "phase_id");
        }
        rs.close();
        pst.close();
        return result;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        Dependency thisDependency;
        int recordCount;
        if (this.getId() == -1) {
            throw new SQLException("Phase ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int i = 0;
        try {
            i = 0;
            pst = db.prepareStatement(" SELECT count(*) as recordcount  FROM action_phase_work  WHERE action_phase_id = ?");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (recordCount = rs.getInt("recordcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("actionPhaseRecords");
                thisDependency.setCount(recordCount);
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            i = 0;
            pst = db.prepareStatement(" SELECT count(*) as recordcount  FROM action_step  WHERE phase_id = ?");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (recordCount = rs.getInt("recordcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("actionSteps");
                thisDependency.setCount(recordCount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public int getLastStep() {
        if (this.steps != null && this.steps.size() > 0) {
            return this.steps.getLastStepId();
        }
        return -1;
    }

    public boolean isCurrent(ActionPlan actionPlan) {
        ActionPhase currentPhase = actionPlan.getCurrentPhase();
        if (currentPhase != null) {
            return currentPhase.getId() == this.getId();
        }
        return false;
    }

    public boolean beforeCurrent(ActionPlan actionPlan) {
        ActionPhase thisPhase;
        boolean before = false;
        Iterator i = actionPlan.getPhases().iterator();
        while (i.hasNext() && !(thisPhase = (ActionPhase)((Object)i.next())).isCurrent(actionPlan)) {
            if (thisPhase.getId() != this.getId()) continue;
            before = true;
            break;
        }
        return before;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Name == " + this.getName());
        str.append(".....id == " + this.getId());
        str.append(".....random? == " + this.getRandom());
        str.append(".....tparentId == " + this.getParentId());
        str.append(".....planId == " + this.getPlanId());
        return str.toString();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public int getPlanId() {
        return this.planId;
    }

    public void setPlanId(int tmp) {
        this.planId = tmp;
    }

    public void setPlanId(String tmp) {
        this.planId = Integer.parseInt(tmp);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public boolean getBuildSteps() {
        return this.buildSteps;
    }

    public void setBuildSteps(boolean tmp) {
        this.buildSteps = tmp;
    }

    public void setBuildSteps(String tmp) {
        this.buildSteps = DatabaseUtils.parseBoolean(tmp);
    }

    public ActionStepList getSteps() {
        return this.steps;
    }

    public void setSteps(ActionStepList tmp) {
        this.steps = tmp;
    }

    public ActionPhaseList getPhaseList() {
        return this.phaseList;
    }

    public void setPhaseList(ActionPhaseList tmp) {
        this.phaseList = tmp;
    }

    public boolean getBuildCompletePhaseList() {
        return this.buildCompletePhaseList;
    }

    public void setBuildCompletePhaseList(boolean tmp) {
        this.buildCompletePhaseList = tmp;
    }

    public void setBuildCompletePhaseList(String tmp) {
        this.buildCompletePhaseList = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getRandom() {
        return this.random;
    }

    public boolean getGlobal() {
        return this.global;
    }

    public void setGlobal(boolean tmp) {
        this.global = tmp;
    }

    public void setGlobal(String tmp) {
        this.global = DatabaseUtils.parseBoolean(tmp);
    }

    public void setRandom(boolean tmp) {
        this.random = tmp;
    }

    public void setRandom(String tmp) {
        this.random = DatabaseUtils.parseBoolean(tmp);
    }
}

