/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.actionplans.base.ActionPhase;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class ActionPhaseList
extends ArrayList {
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int parentId = -1;
    private int planId = -1;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private boolean buildSteps = false;
    protected boolean buildCompletePhaseList = false;
    public static final String tableName = "action_phase";
    public static final String uniqueField = "phase_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM action_phase aph  WHERE aph.phase_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("aph.entered", null);
            boolean flag = true;
            sqlOrder.append("ORDER BY aph.entered" + (this.pagedListInfo.getSortOrder() != null ? " DESC " : " "));
        } else {
            sqlOrder.append("ORDER BY aph.entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" aph.*  FROM action_phase aph  WHERE aph.phase_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ActionPhase thisPlan = new ActionPhase(rs);
            this.add(thisPlan);
        }
        rs.close();
        pst.close();
        if (this.buildSteps) {
            this.buildSteps(db);
        }
    }

    protected void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.id > -1) {
            sqlFilter.append("AND aph.phase_id = ? ");
        }
        if (this.parentId == 0) {
            sqlFilter.append("AND aph.parent_id IS NULL ");
        } else if (this.parentId != -1) {
            sqlFilter.append("AND aph.parent_id = ? ");
        }
        if (this.planId > -1) {
            sqlFilter.append("AND aph.plan_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.parentId > 0) {
            DatabaseUtils.setInt(pst, ++i, this.parentId);
        }
        if (this.planId > -1) {
            pst.setInt(++i, this.planId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean result = false;
        for (ActionPhase phase : this) {
            result = phase.delete(db) && result;
        }
        return result;
    }

    public void buildSteps(Connection db) throws SQLException {
        for (ActionPhase phase : this) {
            phase.buildSteps(db);
        }
    }

    public int getStepsSize() {
        int result = 0;
        for (ActionPhase phase : this) {
            result += phase.getSteps().size();
        }
        return result;
    }

    public HtmlSelect getHtmlSelectObject() {
        HtmlSelect actionPhaseListSelect = new HtmlSelect();
        for (ActionPhase thisPhase : this) {
            actionPhaseListSelect.addItem(thisPhase.getId(), thisPhase.getName());
        }
        return actionPhaseListSelect;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect actionPhaseListSelect = new HtmlSelect();
        for (ActionPhase thisPhase : this) {
            actionPhaseListSelect.addItem(thisPhase.getId(), thisPhase.getName());
        }
        return actionPhaseListSelect.getHtml(selectName, defaultKey);
    }

    public int getLastPhaseId() {
        int result = -1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ActionPhase thisPhase = (ActionPhase)((Object)i.next());
            if (i.hasNext()) continue;
            result = thisPhase.getId();
        }
        return result;
    }

    public boolean hasUserGroupStep() {
        for (ActionPhase phase : this) {
            if (phase.getSteps() == null || !phase.getSteps().hasUserGroupStep()) continue;
            return true;
        }
        return false;
    }

    public ActionPhaseList reorder() {
        HashMap positionMap = this.getPhaseIdsAsHashMap();
        HashMap phases = this.getPhasesByParentAsHashMap();
        ActionPhaseList reorderedList = new ActionPhaseList();
        reorderedList.setPlanId(this.getPlanId());
        String tempPhaseId = "0";
        for (int i = 0; i < this.size(); ++i) {
            ActionPhase thisPhase = (ActionPhase)((Object)phases.get(tempPhaseId));
            if (thisPhase == null) continue;
            tempPhaseId = (String)positionMap.get(tempPhaseId);
            reorderedList.add(thisPhase);
        }
        return reorderedList;
    }

    public String printArray(ArrayList list) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            str.append("\nActionPhaseList:: list[" + i + "] = " + list.get(i));
        }
        return str.toString();
    }

    public HashMap getPhaseIdsAsHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ActionPhase phase : this) {
            map.put(String.valueOf(phase.getParentId()), String.valueOf(phase.getId()));
        }
        return map;
    }

    public HashMap getPhasesByParentAsHashMap() {
        HashMap<String, ActionPhase> map = new HashMap<String, ActionPhase>();
        for (ActionPhase phase : this) {
            map.put(String.valueOf(phase.getParentId()), phase);
        }
        return map;
    }

    public HashMap getPhasesAsHashMap() {
        HashMap<String, ActionPhase> map = new HashMap<String, ActionPhase>();
        for (ActionPhase phase : this) {
            map.put(String.valueOf(phase.getId()), phase);
        }
        return map;
    }

    public HashMap getPhaseParentsAsHashMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iter = this.iterator();
        int i = 1;
        while (iter.hasNext()) {
            ActionPhase phase = (ActionPhase)((Object)iter.next());
            map.put(String.valueOf(phase.getId()), String.valueOf(i));
            ++i;
        }
        return map;
    }

    public ActionPhase getPhaseById(int id) {
        ActionPhase result = null;
        for (ActionPhase phase : this) {
            if (phase.getId() != id) continue;
            result = phase;
            break;
        }
        return result;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public int getPlanId() {
        return this.planId;
    }

    public void setPlanId(int tmp) {
        this.planId = tmp;
    }

    public void setPlanId(String tmp) {
        this.planId = Integer.parseInt(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public boolean getBuildSteps() {
        return this.buildSteps;
    }

    public void setBuildSteps(boolean tmp) {
        this.buildSteps = tmp;
    }

    public void setBuildSteps(String tmp) {
        this.buildSteps = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildCompletePhaseList() {
        return this.buildCompletePhaseList;
    }

    public void setBuildCompletePhaseList(boolean tmp) {
        this.buildCompletePhaseList = tmp;
    }

    public void setBuildCompletePhaseList(String tmp) {
        this.buildCompletePhaseList = DatabaseUtils.parseBoolean(tmp);
    }
}

