/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.actionplans.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.actionplans.base.ActionItemWork;
import org.aspcfs.modules.actionplans.base.ActionItemWorkList;
import org.aspcfs.modules.actionplans.base.ActionPhase;
import org.aspcfs.modules.actionplans.base.ActionPhaseWorkList;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.modules.actionplans.base.ActionStep;
import org.aspcfs.utils.DatabaseUtils;

public class ActionPhaseWork
extends GenericBean {
    private int id = -1;
    private int planWorkId = -1;
    private int actionPhaseId = -1;
    private int statusId = -1;
    private Timestamp startDate = null;
    private Timestamp endDate = null;
    private int level = -1;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private String phaseName = null;
    private String phaseDescription = null;
    private int parentId = -1;
    private boolean global = false;
    private int assignedTo = -1;
    private int managerId = -1;
    private boolean buildStepWork = false;
    private boolean buildLinkedObject = false;
    private ActionItemWorkList itemWorkList = null;
    private ActionPhase phase = null;
    private boolean buildPhase = false;
    private ActionPlanWork planWork = null;
    private boolean buildCurrentStepsOnly = false;

    public int getManagerId() {
        return this.managerId;
    }

    public void setManagerId(int tmp) {
        this.managerId = tmp;
    }

    public void setManagerId(String tmp) {
        this.managerId = Integer.parseInt(tmp);
    }

    public int getAssignedTo() {
        return this.assignedTo;
    }

    public boolean getGlobal() {
        return this.global;
    }

    public void setGlobal(boolean tmp) {
        this.global = tmp;
    }

    public void setGlobal(String tmp) {
        this.global = DatabaseUtils.parseBoolean(tmp);
    }

    public void setAssignedTo(int tmp) {
        this.assignedTo = tmp;
    }

    public void setAssignedTo(String tmp) {
        this.assignedTo = Integer.parseInt(tmp);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public boolean getBuildLinkedObject() {
        return this.buildLinkedObject;
    }

    public void setBuildLinkedObject(boolean tmp) {
        this.buildLinkedObject = tmp;
    }

    public void setBuildLinkedObject(String tmp) {
        this.buildLinkedObject = DatabaseUtils.parseBoolean(tmp);
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setPhaseName(String tmp) {
        this.phaseName = tmp;
    }

    public String getPhaseDescription() {
        return this.phaseDescription;
    }

    public void setPhaseDescription(String tmp) {
        this.phaseDescription = tmp;
    }

    public boolean getBuildStepWork() {
        return this.buildStepWork;
    }

    public void setBuildStepWork(boolean tmp) {
        this.buildStepWork = tmp;
    }

    public void setBuildStepWork(String tmp) {
        this.buildStepWork = DatabaseUtils.parseBoolean(tmp);
    }

    public ActionItemWorkList getItemWorkList() {
        return this.itemWorkList;
    }

    public void setItemWorkList(ActionItemWorkList tmp) {
        this.itemWorkList = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getPlanWorkId() {
        return this.planWorkId;
    }

    public void setPlanWorkId(int tmp) {
        this.planWorkId = tmp;
    }

    public void setPlanWorkId(String tmp) {
        this.planWorkId = Integer.parseInt(tmp);
    }

    public int getActionPhaseId() {
        return this.actionPhaseId;
    }

    public void setActionPhaseId(int tmp) {
        this.actionPhaseId = tmp;
    }

    public void setActionPhaseId(String tmp) {
        this.actionPhaseId = Integer.parseInt(tmp);
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Timestamp tmp) {
        this.startDate = tmp;
    }

    public void setStartDate(String tmp) {
        this.startDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Timestamp tmp) {
        this.endDate = tmp;
    }

    public void setEndDate(String tmp) {
        this.endDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public ActionPhase getPhase() {
        return this.phase;
    }

    public void setPhase(ActionPhase tmp) {
        this.phase = tmp;
    }

    public boolean getBuildPhase() {
        return this.buildPhase;
    }

    public void setBuildPhase(boolean tmp) {
        this.buildPhase = tmp;
    }

    public void setBuildPhase(String tmp) {
        this.buildPhase = DatabaseUtils.parseBoolean(tmp);
    }

    public ActionPlanWork getPlanWork() {
        return this.planWork;
    }

    public void setPlanWork(ActionPlanWork tmp) {
        this.planWork = tmp;
    }

    public boolean getBuildCurrentStepsOnly() {
        return this.buildCurrentStepsOnly;
    }

    public void setBuildCurrentStepsOnly(boolean tmp) {
        this.buildCurrentStepsOnly = tmp;
    }

    public void setBuildCurrentStepsOnly(String tmp) {
        this.buildCurrentStepsOnly = DatabaseUtils.parseBoolean(tmp);
    }

    public ActionPhaseWork() {
    }

    public ActionPhaseWork(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ActionPhaseWork(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Action Phase Work ID");
        }
        PreparedStatement pst = db.prepareStatement("SELECT apw.*, ap.phase_name, ap.description, ap.parent_id, ap." + DatabaseUtils.addQuotes(db, "global") + " " + "FROM action_phase_work apw " + "LEFT JOIN action_phase ap ON (apw.action_phase_id = ap.phase_id) " + "WHERE apw.phase_work_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.buildStepWork) {
            this.buildStepWork(db);
        }
        if (this.buildPhase) {
            this.buildPhaseObject(db);
        }
        if (this.getId() == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
    }

    public void buildStepWork(Connection db) throws SQLException {
        this.itemWorkList = new ActionItemWorkList();
        this.itemWorkList.setPhaseWorkId(this.id);
        this.itemWorkList.setBuildLinkedObject(this.buildLinkedObject);
        this.itemWorkList.setBuildStep(true);
        this.itemWorkList.setPlanWork(this.planWork);
        this.itemWorkList.buildList(db);
    }

    public void buildCurrentSteps(Connection db) throws SQLException {
        this.itemWorkList = new ActionItemWorkList();
        this.itemWorkList.setPhaseWorkId(this.id);
        this.itemWorkList.setBuildLinkedObject(true);
        this.itemWorkList.setBuildStep(true);
        this.itemWorkList.setPlanWork(this.planWork);
        this.itemWorkList.buildList(db);
    }

    public void startRandomPhase(Connection db) throws SQLException {
        if (this.itemWorkList != null && this.itemWorkList.size() > 0) {
            this.itemWorkList.startRandomSteps(db);
        }
    }

    public void buildPhaseObject(Connection db) throws SQLException {
        this.phase = new ActionPhase();
        this.phase.setBuildSteps(true);
        this.phase.queryRecord(db, this.getActionPhaseId());
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("phase_work_id");
        this.planWorkId = rs.getInt("plan_work_id");
        this.actionPhaseId = rs.getInt("action_phase_id");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.startDate = rs.getTimestamp("start_date");
        this.endDate = rs.getTimestamp("end_date");
        this.level = rs.getInt("level");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.parentId = DatabaseUtils.getInt(rs, "parent_id", 0);
        this.phaseName = rs.getString("phase_name");
        this.phaseDescription = rs.getString("description");
        this.global = rs.getBoolean("global");
    }

    public boolean insert(Connection db) throws SQLException {
        if (this.level != 0) {
            this.level = this.retrieveNextLevel(db);
        }
        this.id = DatabaseUtils.getNextSeq(db, "action_phase_work_phase_work_id_seq");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO action_phase_work (" + (this.id > -1 ? "phase_work_id, " : "") + "plan_work_id, action_phase_id, ");
        if (this.startDate != null) {
            sql.append("start_date, ");
        }
        if (this.endDate != null) {
            sql.append("end_date, ");
        }
        sql.append("" + DatabaseUtils.addQuotes(db, "level") + ", ");
        if (this.entered != null) {
            sql.append("entered, ");
        }
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("enteredby, modifiedby, status_id ) ");
        sql.append("VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ");
        if (this.startDate != null) {
            sql.append("?, ");
        }
        if (this.endDate != null) {
            sql.append("?, ");
        }
        sql.append("?, ");
        if (this.entered != null) {
            sql.append("?, ");
        }
        if (this.modified != null) {
            sql.append("?, ");
        }
        sql.append("?, ?, ? ) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.getPlanWorkId());
        pst.setInt(++i, this.getActionPhaseId());
        if (this.startDate != null) {
            pst.setTimestamp(++i, this.startDate);
        }
        if (this.endDate != null) {
            pst.setTimestamp(++i, this.endDate);
        }
        pst.setInt(++i, this.level);
        if (this.entered != null) {
            pst.setTimestamp(++i, this.entered);
        }
        if (this.modified != null) {
            pst.setTimestamp(++i, this.modified);
        }
        pst.setInt(++i, this.getEnteredBy());
        pst.setInt(++i, this.getModifiedBy());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "action_phase_work_phase_work_id_seq", this.id);
        return true;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean insert(Connection db, ActionPlan actionPlan, ActionPhase actionPhase) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            if (actionPhase.isGlobal()) {
                this.level = 0;
            } else if (actionPhase.isCurrent(actionPlan)) {
                this.setStartDate(new Timestamp(new Date().getTime()));
            } else if (actionPhase.beforeCurrent(actionPlan)) {
                this.setStartDate(new Timestamp(new Date().getTime()));
                this.setEndDate(new Timestamp(new Date().getTime()));
            }
            this.insert(db);
            this.buildPhaseObject(db);
            for (ActionStep actionStep : actionPhase.getSteps()) {
                ActionItemWork itemWork = new ActionItemWork();
                itemWork.setPhaseWorkId(this.getId());
                itemWork.setActionStepId(actionStep.getId());
                if (actionStep.getPermissionType() == 0) {
                    itemWork.setOwnerId(this.getManagerId());
                } else if (actionStep.getPermissionType() == 1 || actionStep.getPermissionType() == 4 || actionStep.getPermissionType() == 5) {
                    itemWork.setOwnerId(this.getAssignedTo());
                } else {
                    itemWork.setOwnerId(this.getAssignedTo());
                }
                itemWork.setEnteredBy(this.getEnteredBy());
                itemWork.setModifiedBy(this.getModifiedBy());
                if (!actionPhase.isGlobal()) {
                    if (actionPhase.getRandom()) {
                        if (actionPhase.isCurrent(actionPlan)) {
                            itemWork.setStartDate(new Timestamp(new Date().getTime()));
                        }
                    } else if (actionPhase.isCurrent(actionPlan)) {
                        if (actionStep.isCurrent(actionPlan)) {
                            itemWork.setStartDate(new Timestamp(new Date().getTime()));
                        } else if (actionStep.beforeCurrent(actionPlan)) {
                            itemWork.setStartDate(new Timestamp(new Date().getTime()));
                            itemWork.setEndDate(new Timestamp(new Date().getTime()));
                            itemWork.setStatusId(0);
                        }
                    } else if (actionPhase.beforeCurrent(actionPlan)) {
                        itemWork.setStartDate(new Timestamp(new Date().getTime()));
                        itemWork.setEndDate(new Timestamp(new Date().getTime()));
                        itemWork.setStatusId(0);
                    }
                }
                itemWork.insert(db);
            }
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException("ActionPhaseWork: " + e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public void update(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE action_phase_work ");
        sql.append("SET status_id = ?, ");
        sql.append("start_date = ?, ");
        sql.append("end_date = ?, ");
        sql.append("modifiedby = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + " ");
        sql.append("WHERE phase_work_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        int i = 0;
        DatabaseUtils.setInt(pst, ++i, this.statusId);
        DatabaseUtils.setTimestamp(pst, ++i, this.startDate);
        DatabaseUtils.setTimestamp(pst, ++i, this.endDate);
        pst.setInt(++i, this.modifiedBy);
        pst.setInt(++i, this.id);
        pst.executeUpdate();
        pst.close();
    }

    public void delete(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            ActionItemWorkList items = new ActionItemWorkList();
            items.setPhaseWorkId(this.id);
            items.buildList(db);
            items.setPlanWork(this.getPlanWork());
            items.delete(db);
            PreparedStatement pst = db.prepareStatement("DELETE FROM action_phase_work WHERE phase_work_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public boolean isSkipped() {
        return this.statusId == 1;
    }

    public boolean isCurrent() {
        if (this.isSkipped()) {
            return false;
        }
        for (ActionItemWork itemWork : this.itemWorkList) {
            if (itemWork.getStartDate() == null || itemWork.getEndDate() != null) continue;
            return true;
        }
        return false;
    }

    public ActionItemWork getCurrentStep() {
        for (ActionItemWork itemWork : this.itemWorkList) {
            if (!itemWork.isCurrent()) continue;
            return itemWork;
        }
        return null;
    }

    public int getDaysInPhase() {
        if (this.startDate != null) {
            if (this.endDate != null) {
                float ageCheck = (this.endDate.getTime() - this.startDate.getTime()) / 3600000L;
                int totalHours = Math.round(ageCheck);
                return Math.round(totalHours / 24);
            }
            float ageCheck = (Calendar.getInstance().getTimeInMillis() - this.startDate.getTime()) / 3600000L;
            int totalHours = Math.round(ageCheck);
            return Math.round(totalHours / 24);
        }
        return 0;
    }

    public ActionPhaseWork getNextPhase(Connection db) throws SQLException {
        ActionPhaseWorkList phaseWorkList = new ActionPhaseWorkList();
        phaseWorkList.setPlanWorkId(this.planWorkId);
        phaseWorkList.buildList(db);
        Iterator j = phaseWorkList.iterator();
        while (j.hasNext()) {
            ActionPhaseWork thisPhase = (ActionPhaseWork)((Object)j.next());
            if (thisPhase.getId() != this.getId() || !j.hasNext()) continue;
            return (ActionPhaseWork)((Object)j.next());
        }
        return null;
    }

    public ActionPhaseWork getPreviousPhase(Connection db) throws SQLException {
        ActionPhaseWorkList phaseWorkList = new ActionPhaseWorkList();
        phaseWorkList.setPlanWorkId(this.planWorkId);
        phaseWorkList.buildList(db);
        Iterator j = phaseWorkList.iterator();
        ActionPhaseWork previousPhase = null;
        while (j.hasNext()) {
            ActionPhaseWork thisPhase = (ActionPhaseWork)((Object)j.next());
            if (thisPhase.getId() == this.getId()) {
                return previousPhase;
            }
            previousPhase = thisPhase;
        }
        return null;
    }

    private int retrieveNextLevel(Connection db) throws SQLException {
        int returnLevel = 0;
        PreparedStatement pst = db.prepareStatement("SELECT MAX(" + DatabaseUtils.addQuotes(db, "level") + ") as levelcount " + "FROM action_phase_work " + "WHERE plan_work_id = ? ");
        pst.setInt(1, this.planWorkId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            returnLevel = rs.getInt("levelcount");
            if (rs.wasNull()) {
                returnLevel = 0;
            }
        }
        rs.close();
        pst.close();
        return ++returnLevel;
    }

    public boolean allStepsComplete() {
        boolean result = true;
        if (this.itemWorkList != null && this.itemWorkList.size() > 0) {
            for (ActionItemWork item : this.itemWorkList) {
                if (item.hasStatus()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean requiresUserAttention(int userId, HttpServletRequest request) {
        boolean result = false;
        if (!this.getPhase().getRandom()) {
            return this.getCurrentStep().userHasPermission(userId, request);
        }
        if (this.itemWorkList != null && this.itemWorkList.size() > 0) {
            for (ActionItemWork item : this.itemWorkList) {
                if (item.hasStatus() || !item.userHasPermission(userId, request)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean noStepComplete() {
        boolean result = true;
        if (this.itemWorkList != null && this.itemWorkList.size() > 0) {
            for (ActionItemWork item : this.itemWorkList) {
                if (!item.hasStatus()) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

